/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase;

import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.BaseDatabaseErrorHandler;
import com.intellij.database.dialects.DatabaseFixFactory;
import com.intellij.database.dialects.postgresbase.PgBaseUrlCheckingInterceptor;
import com.intellij.database.remote.jdbc.SQLExceptionWithProperties;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PgBaseErrorHandler
extends BaseDatabaseErrorHandler {
    @NotNull
    protected ErrorInfo getErrorInfo(@NotNull Project project, @Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
        if (project == null) {
            PgBaseErrorHandler.$$$reportNull$$$0(0);
        }
        if (original == null) {
            PgBaseErrorHandler.$$$reportNull$$$0(1);
        }
        if (cause == null) {
            PgBaseErrorHandler.$$$reportNull$$$0(2);
        }
        if ("99999".equals(PgBaseErrorHandler.getSqlState((Throwable)cause)) && dataSource != null && PgBaseUrlCheckingInterceptor.canFixUrl((DatabaseConnectionPoint)dataSource)) {
            return new PgBaseUrlCheckingInterceptor.UrlMissingSlashInfo(dataSource, original, cause, project);
        }
        if (PgBouncerNoPreparedStatements.detect(dataSource, cause)) {
            return new PgBouncerNoPreparedStatements(dataSource, original, cause);
        }
        ErrorInfo errorInfo = super.getErrorInfo(project, dataSource, original, cause);
        if (errorInfo == null) {
            PgBaseErrorHandler.$$$reportNull$$$0(3);
        }
        return errorInfo;
    }

    public int getErrorOffset(@NotNull Project project, @NotNull ErrorInfo errorInfo, @NotNull String queryText) {
        Map properties;
        if (project == null) {
            PgBaseErrorHandler.$$$reportNull$$$0(4);
        }
        if (errorInfo == null) {
            PgBaseErrorHandler.$$$reportNull$$$0(5);
        }
        if (queryText == null) {
            PgBaseErrorHandler.$$$reportNull$$$0(6);
        }
        if ((properties = PgBaseErrorHandler.getProperties((Throwable)errorInfo.getOriginalThrowable())) == null) {
            return -1;
        }
        Integer position = (Integer)SQLExceptionWithProperties.POSITION.get(properties);
        if (position == null) {
            return -1;
        }
        BaseDatabaseErrorHandler.OffsetInfo offsetInfo = new BaseDatabaseErrorHandler.OffsetInfoBuilder(errorInfo.getMessage(), null).defaultColumn(position.intValue()).build();
        return PgBaseErrorHandler.getOffsetImpl((BaseDatabaseErrorHandler.OffsetInfo)offsetInfo, (String)queryText, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/postgresbase/PgBaseErrorHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/postgresbase/PgBaseErrorHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getErrorInfo";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getErrorOffset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static class PgBouncerNoPreparedStatements
    extends BaseDatabaseErrorHandler.DatabaseErrorInfo {
        private static boolean detect(@Nullable LocalDataSource dataSource, @NotNull Throwable cause) {
            if (cause == null) {
                PgBouncerNoPreparedStatements.$$$reportNull$$$0(0);
            }
            if (!"26000".equals(PgBaseErrorHandler.getSqlState((Throwable)cause)) || dataSource == null) {
                return false;
            }
            if (dataSource.isRewriteBounds() || PgBouncerNoPreparedStatements.getDriverProperty(dataSource, "prepareThreshold") != null) {
                return false;
            }
            return PgBaseErrorHandler.getMessage((Throwable)cause).contains("\"S_");
        }

        private static String getDriverProperty(@NotNull LocalDataSource dataSource, String prop) {
            String v;
            if (dataSource == null) {
                PgBouncerNoPreparedStatements.$$$reportNull$$$0(1);
            }
            if ((v = (String)dataSource.getDriverProperties().get(prop)) != null) {
                return v;
            }
            DatabaseDriver driver = dataSource.getDatabaseDriver();
            return driver == null ? null : (String)driver.getDriverProperties().get(prop);
        }

        private PgBouncerNoPreparedStatements(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                PgBouncerNoPreparedStatements.$$$reportNull$$$0(2);
            }
            if (cause == null) {
                PgBouncerNoPreparedStatements.$$$reportNull$$$0(3);
            }
            super(dataSource, original, cause);
        }

        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                PgBouncerNoPreparedStatements.$$$reportNull$$$0(4);
            }
            if (fixes == null) {
                PgBouncerNoPreparedStatements.$$$reportNull$$$0(5);
            }
            PgBouncerNoPreparedStatements.appendGenericMessage((Throwable)this.myOriginal, (StringBuilder)sb);
            LocalDataSource dataSource = this.getDataSource();
            DatabaseFixFactory ff = DatabaseFixFactory.getInstance();
            if (ff != null) {
                fixes.add(ff.setDriverProperty(dataSource, "Set `prepareThreshold=0` if you have pg_bouncer", "prepareThreshold", "0"));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/postgresbase/PgBaseErrorHandler$PgBouncerNoPreparedStatements";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "detect";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getDriverProperty";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

