/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl.io;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u001aH\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0000\u001aP\u0010\u000b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0000\u001a\u0016\u0010\u0010\u001a\u00020\u0011*\u00020\u00012\b\b\u0002\u0010\u0012\u001a\u00020\u000fH\u0000\"\u000e\u0010\u000e\u001a\u00020\u000fX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"resizeKeepingAspectRatio", "Ljava/awt/image/BufferedImage;", "maxSize", "", "resultImageType", "interpolation", "", "renderingQuality", "antialiasing", "observer", "Ljava/awt/image/ImageObserver;", "resize", "width", "height", "DEFAULT_IMG_FORMAT", "", "toByteArray", "", "format", "core"})
public final class ImageKt {
    @NotNull
    public static final String DEFAULT_IMG_FORMAT = "png";

    @NotNull
    public static final BufferedImage resizeKeepingAspectRatio(@NotNull BufferedImage $this$resizeKeepingAspectRatio, int maxSize, int resultImageType, @NotNull Object interpolation, @NotNull Object renderingQuality, @NotNull Object antialiasing, @Nullable ImageObserver observer) {
        Intrinsics.checkNotNullParameter((Object)$this$resizeKeepingAspectRatio, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)interpolation, (String)"interpolation");
        Intrinsics.checkNotNullParameter((Object)renderingQuality, (String)"renderingQuality");
        Intrinsics.checkNotNullParameter((Object)antialiasing, (String)"antialiasing");
        double aspectRatio = (double)$this$resizeKeepingAspectRatio.getWidth() / (double)$this$resizeKeepingAspectRatio.getHeight();
        int size = Math.min(maxSize, Math.max($this$resizeKeepingAspectRatio.getWidth(), $this$resizeKeepingAspectRatio.getHeight()));
        Pair pair = $this$resizeKeepingAspectRatio.getWidth() > $this$resizeKeepingAspectRatio.getHeight() ? new Pair((Object)size, (Object)((int)((double)size / aspectRatio))) : new Pair((Object)((int)((double)size * aspectRatio)), (Object)size);
        int nWidth = ((Number)pair.component1()).intValue();
        int nHeight = ((Number)pair.component2()).intValue();
        return ImageKt.resize($this$resizeKeepingAspectRatio, nWidth, nHeight, resultImageType, interpolation, renderingQuality, antialiasing, observer);
    }

    public static /* synthetic */ BufferedImage resizeKeepingAspectRatio$default(BufferedImage bufferedImage, int n, int n2, Object object, Object object2, Object object3, ImageObserver imageObserver, int n3, Object object4) {
        if ((n3 & 2) != 0) {
            n2 = 2;
        }
        if ((n3 & 4) != 0) {
            object = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
        }
        if ((n3 & 8) != 0) {
            object2 = RenderingHints.VALUE_RENDER_QUALITY;
        }
        if ((n3 & 0x10) != 0) {
            object3 = RenderingHints.VALUE_ANTIALIAS_ON;
        }
        if ((n3 & 0x20) != 0) {
            imageObserver = null;
        }
        return ImageKt.resizeKeepingAspectRatio(bufferedImage, n, n2, object, object2, object3, imageObserver);
    }

    @NotNull
    public static final BufferedImage resize(@NotNull BufferedImage $this$resize, int width, int height, int resultImageType, @NotNull Object interpolation, @NotNull Object renderingQuality, @NotNull Object antialiasing, @Nullable ImageObserver observer) {
        Intrinsics.checkNotNullParameter((Object)$this$resize, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)interpolation, (String)"interpolation");
        Intrinsics.checkNotNullParameter((Object)renderingQuality, (String)"renderingQuality");
        Intrinsics.checkNotNullParameter((Object)antialiasing, (String)"antialiasing");
        BufferedImage resized = new BufferedImage(width, height, resultImageType);
        Graphics2D graphics2D = resized.createGraphics();
        Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"createGraphics(...)");
        Graphics2D g = graphics2D;
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, interpolation);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, renderingQuality);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiasing);
        g.drawImage($this$resize, 0, 0, width, height, observer);
        g.dispose();
        return resized;
    }

    public static /* synthetic */ BufferedImage resize$default(BufferedImage bufferedImage, int n, int n2, int n3, Object object, Object object2, Object object3, ImageObserver imageObserver, int n4, Object object4) {
        if ((n4 & 4) != 0) {
            n3 = 2;
        }
        if ((n4 & 8) != 0) {
            object = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
        }
        if ((n4 & 0x10) != 0) {
            object2 = RenderingHints.VALUE_RENDER_QUALITY;
        }
        if ((n4 & 0x20) != 0) {
            object3 = RenderingHints.VALUE_ANTIALIAS_ON;
        }
        if ((n4 & 0x40) != 0) {
            imageObserver = null;
        }
        return ImageKt.resize(bufferedImage, n, n2, n3, object, object2, object3, imageObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] toByteArray(@NotNull BufferedImage $this$toByteArray, @NotNull String format) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)$this$toByteArray, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream bos = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            ImageIO.write((RenderedImage)$this$toByteArray, format, bos);
            byArray = bos.toByteArray();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"use(...)");
        return byArray;
    }

    public static /* synthetic */ byte[] toByteArray$default(BufferedImage bufferedImage, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = DEFAULT_IMG_FORMAT;
        }
        return ImageKt.toByteArray(bufferedImage, string);
    }
}

