/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001aE\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u0002\"\b\b\u0001\u0010\u0001*\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u0002H\u0002\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\bH\u0001\u00a2\u0006\u0002\u0010\t\u001a)\u0010\n\u001a\u0002H\u0002\"\b\b\u0000\u0010\u0002*\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0001\u00a2\u0006\u0002\u0010\u000b\u001a-\u0010\n\u001a\u0002H\u0002\"\b\b\u0000\u0010\u0002*\u00020\u0003*\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0001\u00a2\u0006\u0004\b\f\u0010\u000b\u001a\u0012\u0010\n\u001a\u00020\r*\b\u0012\u0004\u0012\u00020\r0\u0004H\u0001\u001a\u0012\u0010\n\u001a\u00020\r*\b\u0012\u0004\u0012\u00020\r0\u000eH\u0001\u001a\u0012\u0010\n\u001a\u00020\u000f*\b\u0012\u0004\u0012\u00020\u000f0\u0004H\u0001\u001a\u0012\u0010\n\u001a\u00020\u000f*\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0001\u00a8\u0006\u0010"}, d2={"sumOf", "R", "T", "", "", "type", "Lkotlin/reflect/KType;", "selector", "Lkotlin/Function1;", "(Ljava/lang/Iterable;Lkotlin/reflect/KType;Lkotlin/jvm/functions/Function1;)Ljava/lang/Number;", "sum", "(Ljava/lang/Iterable;Lkotlin/reflect/KType;)Ljava/lang/Number;", "sumNullableT", "Ljava/math/BigDecimal;", "Lkotlin/sequences/Sequence;", "Ljava/math/BigInteger;", "core"})
@SourceDebugExtension(value={"SMAP\nsum.kt\nKotlin\n*S Kotlin\n*F\n+ 1 sum.kt\norg/jetbrains/kotlinx/dataframe/math/SumKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n1#2:134\n1557#3:135\n1628#3,3:136\n*S KotlinDebug\n*F\n+ 1 sum.kt\norg/jetbrains/kotlinx/dataframe/math/SumKt\n*L\n62#1:135\n62#1:136,3\n*E\n"})
public final class SumKt {
    /*
     * WARNING - void declaration
     */
    @PublishedApi
    @NotNull
    public static final <T, R extends Number> R sumOf(@NotNull Iterable<? extends T> $this$sumOf, @NotNull KType type, @NotNull Function1<? super T, ? extends R> selector) {
        Number number;
        Intrinsics.checkNotNullParameter($this$sumOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        if (type.isMarkedNullable()) {
            Iterable seq = SequencesKt.asIterable((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence($this$sumOf), selector));
            return (R)SumKt.sum(seq, type);
        }
        KClassifier kClassifier = type.getClassifier();
        if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            Iterable<T> iterable = $this$sumOf;
            Function1 function1 = (Function1)TypeIntrinsics.beforeCheckcastToFunctionOfArity(selector, (int)1);
            double d = 0.0;
            for (T t : iterable) {
                d += ((Number)function1.invoke(t)).doubleValue();
            }
            number = d;
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            Iterable<T> iterable = $this$sumOf;
            double d = 0.0;
            Iterator<T> iterator2 = iterable.iterator();
            while (iterator2.hasNext()) {
                void it;
                T t;
                T t2 = t = iterator2.next();
                double d2 = d;
                boolean bl = false;
                double d3 = ((Number)((Function1)TypeIntrinsics.beforeCheckcastToFunctionOfArity(selector, (int)1)).invoke((Object)it)).floatValue();
                d = d2 + d3;
            }
            number = Float.valueOf((float)d);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            Iterable<T> iterable = $this$sumOf;
            Function1 function1 = (Function1)TypeIntrinsics.beforeCheckcastToFunctionOfArity(selector, (int)1);
            int n = 0;
            for (T t : iterable) {
                n += ((Number)function1.invoke(t)).intValue();
            }
            number = n;
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            Iterable<T> iterable = $this$sumOf;
            int n = 0;
            Iterator<T> iterator3 = iterable.iterator();
            while (iterator3.hasNext()) {
                void it;
                T t;
                T t3 = t = iterator3.next();
                int n2 = n;
                boolean bl = false;
                short s = ((Number)((Function1)TypeIntrinsics.beforeCheckcastToFunctionOfArity(selector, (int)1)).invoke((Object)it)).shortValue();
                n = n2 + s;
            }
            number = (short)n;
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            Iterable<T> iterable = $this$sumOf;
            int n = 0;
            Iterator<T> iterator4 = iterable.iterator();
            while (iterator4.hasNext()) {
                T t;
                T it = t = iterator4.next();
                int n3 = n;
                boolean bl = false;
                byte by2 = ((Number)((Function1)TypeIntrinsics.beforeCheckcastToFunctionOfArity(selector, (int)1)).invoke(it)).byteValue();
                n = n3 + by2;
            }
            number = (byte)n;
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            Iterable<T> iterable = $this$sumOf;
            Function1 function1 = (Function1)TypeIntrinsics.beforeCheckcastToFunctionOfArity(selector, (int)1);
            long l = 0L;
            for (T bl : iterable) {
                l += ((Number)function1.invoke(bl)).longValue();
            }
            number = l;
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(BigDecimal.class))) {
            Iterable<T> iterable = $this$sumOf;
            Function1 function1 = (Function1)TypeIntrinsics.beforeCheckcastToFunctionOfArity(selector, (int)1);
            BigDecimal bigDecimal = BigDecimal.valueOf(0L);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
            BigDecimal bigDecimal2 = bigDecimal;
            for (T t : iterable) {
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2.add((BigDecimal)function1.invoke(t)), (String)"add(...)");
            }
            BigDecimal bigDecimal3 = bigDecimal2;
            Intrinsics.checkNotNull((Object)bigDecimal3, (String)"null cannot be cast to non-null type R of org.jetbrains.kotlinx.dataframe.math.SumKt.sumOf");
            number = bigDecimal3;
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(BigInteger.class))) {
            Iterable<T> iterable = $this$sumOf;
            Function1 function1 = (Function1)TypeIntrinsics.beforeCheckcastToFunctionOfArity(selector, (int)1);
            BigInteger bigInteger = BigInteger.valueOf(0L);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
            BigInteger bigInteger2 = bigInteger;
            for (T t : iterable) {
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger2.add((BigInteger)function1.invoke(t)), (String)"add(...)");
            }
            BigInteger bigInteger3 = bigInteger2;
            Intrinsics.checkNotNull((Object)bigInteger3, (String)"null cannot be cast to non-null type R of org.jetbrains.kotlinx.dataframe.math.SumKt.sumOf");
            number = bigInteger3;
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Number.class))) {
            Iterable<T> iterable = $this$sumOf;
            double d = 0.0;
            Iterator<T> iterator5 = iterable.iterator();
            while (iterator5.hasNext()) {
                void it;
                T t;
                T bl = t = iterator5.next();
                double d4 = d;
                boolean bl2 = false;
                double d5 = ((Number)((Function1)TypeIntrinsics.beforeCheckcastToFunctionOfArity(selector, (int)1)).invoke((Object)it)).doubleValue();
                d = d4 + d5;
            }
            number = d;
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Void.class))) {
            number = 0.0;
        } else {
            throw new IllegalArgumentException("sumOf is not supported for " + type);
        }
        return (R)number;
    }

    /*
     * WARNING - void declaration
     */
    @PublishedApi
    @NotNull
    public static final <T extends Number> T sum(@NotNull Iterable<? extends T> $this$sum, @NotNull KType type) {
        Number number;
        Intrinsics.checkNotNullParameter($this$sum, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        KClassifier kClassifier = type.getClassifier();
        if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            number = CollectionsKt.sumOfDouble($this$sum);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            number = Float.valueOf(CollectionsKt.sumOfFloat($this$sum));
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            number = CollectionsKt.sumOfInt($this$sum);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            number = (short)CollectionsKt.sumOfShort($this$sum);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            number = (byte)CollectionsKt.sumOfByte($this$sum);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            number = CollectionsKt.sumOfLong($this$sum);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(BigDecimal.class))) {
            BigDecimal bigDecimal = SumKt.sum($this$sum);
            Intrinsics.checkNotNull((Object)bigDecimal, (String)"null cannot be cast to non-null type T of org.jetbrains.kotlinx.dataframe.math.SumKt.sum");
            number = bigDecimal;
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(BigInteger.class))) {
            BigInteger bigInteger = SumKt.sum($this$sum);
            Intrinsics.checkNotNull((Object)bigInteger, (String)"null cannot be cast to non-null type T of org.jetbrains.kotlinx.dataframe.math.SumKt.sum");
            number = bigInteger;
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Number.class))) {
            void $this$mapTo$iv$iv;
            Iterable<? extends T> $this$map$iv = $this$sum;
            boolean $i$f$map = false;
            Iterable<? extends T> iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Number number2 = (Number)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.doubleValue());
            }
            number = CollectionsKt.sumOfDouble((Iterable)((List)destination$iv$iv));
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Void.class))) {
            number = 0.0;
        } else {
            throw new IllegalArgumentException("sum is not supported for " + type);
        }
        return (T)number;
    }

    @JvmName(name="sumNullableT")
    @PublishedApi
    @NotNull
    public static final <T extends Number> T sumNullableT(@NotNull Iterable<? extends T> $this$sum, @NotNull KType type) {
        Number number;
        Intrinsics.checkNotNullParameter($this$sum, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        KClassifier kClassifier = type.getClassifier();
        if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            number = SequencesKt.sumOfDouble((Sequence)SequencesKt.filterNotNull((Sequence)CollectionsKt.asSequence($this$sum)));
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            number = Float.valueOf(SequencesKt.sumOfFloat((Sequence)SequencesKt.filterNotNull((Sequence)CollectionsKt.asSequence($this$sum))));
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            number = SequencesKt.sumOfInt((Sequence)SequencesKt.filterNotNull((Sequence)CollectionsKt.asSequence($this$sum)));
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            number = (short)SequencesKt.sumOfShort((Sequence)SequencesKt.filterNotNull((Sequence)CollectionsKt.asSequence($this$sum)));
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            number = (byte)SequencesKt.sumOfShort((Sequence)SequencesKt.filterNotNull((Sequence)CollectionsKt.asSequence($this$sum)));
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            number = SequencesKt.sumOfLong((Sequence)SequencesKt.filterNotNull((Sequence)CollectionsKt.asSequence($this$sum)));
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(BigDecimal.class))) {
            BigDecimal bigDecimal = SumKt.sum((Sequence<? extends BigDecimal>)SequencesKt.filterNotNull((Sequence)CollectionsKt.asSequence($this$sum)));
            Intrinsics.checkNotNull((Object)bigDecimal, (String)"null cannot be cast to non-null type T of org.jetbrains.kotlinx.dataframe.math.SumKt.sum");
            number = bigDecimal;
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(BigInteger.class))) {
            BigInteger bigInteger = SumKt.sum((Sequence<? extends BigInteger>)SequencesKt.filterNotNull((Sequence)CollectionsKt.asSequence($this$sum)));
            Intrinsics.checkNotNull((Object)bigInteger, (String)"null cannot be cast to non-null type T of org.jetbrains.kotlinx.dataframe.math.SumKt.sum");
            number = bigInteger;
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Number.class))) {
            number = SequencesKt.sumOfDouble((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNotNull((Sequence)CollectionsKt.asSequence($this$sum)), SumKt::sum$lambda$5));
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Void.class))) {
            number = 0.0;
        } else {
            throw new IllegalArgumentException("sum is not supported for " + type);
        }
        return (T)number;
    }

    @PublishedApi
    @NotNull
    public static final BigDecimal sum(@NotNull Iterable<? extends BigDecimal> $this$sum) {
        Intrinsics.checkNotNullParameter($this$sum, (String)"<this>");
        BigDecimal bigDecimal = BigDecimal.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"ZERO");
        BigDecimal sum2 = bigDecimal;
        for (BigDecimal bigDecimal2 : $this$sum) {
            Intrinsics.checkNotNullExpressionValue((Object)sum2.add(bigDecimal2), (String)"add(...)");
        }
        return sum2;
    }

    @PublishedApi
    @NotNull
    public static final BigDecimal sum(@NotNull Sequence<? extends BigDecimal> $this$sum) {
        Intrinsics.checkNotNullParameter($this$sum, (String)"<this>");
        BigDecimal bigDecimal = BigDecimal.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"ZERO");
        BigDecimal sum2 = bigDecimal;
        for (BigDecimal element : $this$sum) {
            Intrinsics.checkNotNullExpressionValue((Object)sum2.add(element), (String)"add(...)");
        }
        return sum2;
    }

    @PublishedApi
    @NotNull
    public static final BigInteger sum(@NotNull Iterable<? extends BigInteger> $this$sum) {
        Intrinsics.checkNotNullParameter($this$sum, (String)"<this>");
        BigInteger bigInteger = BigInteger.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"ZERO");
        BigInteger sum2 = bigInteger;
        for (BigInteger bigInteger2 : $this$sum) {
            Intrinsics.checkNotNullExpressionValue((Object)sum2.add(bigInteger2), (String)"add(...)");
        }
        return sum2;
    }

    @PublishedApi
    @NotNull
    public static final BigInteger sum(@NotNull Sequence<? extends BigInteger> $this$sum) {
        Intrinsics.checkNotNullParameter($this$sum, (String)"<this>");
        BigInteger bigInteger = BigInteger.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"ZERO");
        BigInteger sum2 = bigInteger;
        for (BigInteger element : $this$sum) {
            Intrinsics.checkNotNullExpressionValue((Object)sum2.add(element), (String)"add(...)");
        }
        return sum2;
    }

    private static final double sum$lambda$5(Number it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.doubleValue();
    }
}

