/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.ruff.codeinsight;

import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.documentation.DocumentationResult;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.python.ruff.RuffRuleInfo;
import com.intellij.python.ruff.RuffUtil;
import com.intellij.python.ruff.codeinsight.RuffDocumentationUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\r\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/python/ruff/codeinsight/RuffRuleDocumentationTarget;", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "ruleInfo", "Lcom/intellij/python/ruff/RuffRuleInfo;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/python/ruff/RuffRuleInfo;Lcom/intellij/openapi/project/Project;)V", "createPointer", "Lcom/intellij/model/Pointer;", "computePresentation", "Lcom/intellij/platform/backend/presentation/TargetPresentation;", "computeDocumentationHint", "", "Lorg/jetbrains/annotations/Nls;", "computeDocumentation", "Lcom/intellij/platform/backend/documentation/DocumentationResult;", "intellij.python.ruff"})
public final class RuffRuleDocumentationTarget
implements DocumentationTarget {
    @NotNull
    private final RuffRuleInfo ruleInfo;
    @NotNull
    private final Project project;

    public RuffRuleDocumentationTarget(@NotNull RuffRuleInfo ruleInfo, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)ruleInfo, (String)"ruleInfo");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.ruleInfo = ruleInfo;
        this.project = project;
    }

    @NotNull
    public Pointer<? extends DocumentationTarget> createPointer() {
        Pointer pointer = Pointer.hardPointer((Object)this);
        Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"hardPointer(...)");
        return pointer;
    }

    @NotNull
    public TargetPresentation computePresentation() {
        TargetPresentation targetPresentation = TargetPresentation.Companion.builder(this.ruleInfo.getCode()).icon(RuffUtil.INSTANCE.getDefaultRuffIcon()).presentableText(this.ruleInfo.getCode() + ": " + this.ruleInfo.getName()).presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"presentation(...)");
        return targetPresentation;
    }

    @NotNull
    public String computeDocumentationHint() {
        return RuffDocumentationUtil.INSTANCE.formatRuleDocumentationHint(this.ruleInfo);
    }

    @NotNull
    public DocumentationResult computeDocumentation() {
        String html = RuffDocumentationUtil.INSTANCE.formatRuleDocumentation(this.ruleInfo, this.project);
        return (DocumentationResult)DocumentationResult.Companion.documentation(html);
    }
}

