/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.toolwindow.preview;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.packageChecker.model.ModuleModel;
import com.intellij.packageChecker.model.Package;
import com.intellij.packageChecker.model.Vulnerability;
import com.intellij.packageChecker.service.Malicious;
import com.intellij.packageChecker.service.PackageChecker;
import com.intellij.packageChecker.service.PackageCheckerDisposable;
import com.intellij.packageChecker.service.PackageStatus;
import com.intellij.packageChecker.service.Unchecked;
import com.intellij.packageChecker.service.Vulnerable;
import com.intellij.packageChecker.toolwindow.ModuleWithPackage;
import com.intellij.packageChecker.toolwindow.preview.PackageTitlePanel;
import com.intellij.packageChecker.toolwindow.preview.TextDescriptionRenderer;
import com.intellij.packageChecker.toolwindow.preview.VulnerabilityPanels;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharingStarted;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B5\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J*\u0010\u001d\u001a\u00020\u000e2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\"2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u001bH\u0002J\b\u0010$\u001a\u00020\u000eH\u0002J\b\u0010%\u001a\u00020\u000eH\u0002J\b\u0010&\u001a\u00020'H\u0016J \u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020)H\u0016J \u0010.\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020)H\u0016J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u000200H\u0016J\b\u00102\u001a\u00020\u000eH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0018\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/packageChecker/toolwindow/preview/PackagePreviewPanel;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "Ljavax/swing/Scrollable;", "Lcom/intellij/openapi/Disposable;", "Lkotlinx/coroutines/CoroutineScope;", "selectedPackageStateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/packageChecker/toolwindow/ModuleWithPackage;", "project", "Lcom/intellij/openapi/project/Project;", "parentContext", "Lkotlin/coroutines/CoroutineContext;", "updatePreviewPanel", "Lkotlinx/coroutines/channels/ReceiveChannel;", "", "<init>", "(Lkotlinx/coroutines/flow/MutableStateFlow;Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/CoroutineContext;Lkotlinx/coroutines/channels/ReceiveChannel;)V", "coroutineContext", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "listPanel", "Ljavax/swing/JPanel;", "packageTitle", "Lcom/intellij/packageChecker/toolwindow/preview/PackageTitlePanel;", "pkgStatus", "Lkotlinx/coroutines/flow/StateFlow;", "Lkotlin/Pair;", "Lcom/intellij/packageChecker/model/ModuleModel;", "Lcom/intellij/packageChecker/service/PackageStatus;", "renderVulnerabilityList", "vulnerabilities", "", "Lcom/intellij/packageChecker/model/Vulnerability;", "pkg", "Lcom/intellij/packageChecker/model/Package;", "module", "clear", "scrollToStart", "getPreferredScrollableViewportSize", "Ljava/awt/Dimension;", "getScrollableUnitIncrement", "", "visibleRect", "Ljava/awt/Rectangle;", "orientation", "direction", "getScrollableBlockIncrement", "getScrollableTracksViewportWidth", "", "getScrollableTracksViewportHeight", "dispose", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nPackagePreviewPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackagePreviewPanel.kt\ncom/intellij/packageChecker/toolwindow/preview/PackagePreviewPanel\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,119:1\n30#2,2:120\n*S KotlinDebug\n*F\n+ 1 PackagePreviewPanel.kt\ncom/intellij/packageChecker/toolwindow/preview/PackagePreviewPanel\n*L\n41#1:120,2\n*E\n"})
public final class PackagePreviewPanel
extends SimpleToolWindowPanel
implements Scrollable,
Disposable,
CoroutineScope {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineContext coroutineContext;
    @NotNull
    private JPanel listPanel;
    @NotNull
    private PackageTitlePanel packageTitle;
    @NotNull
    private final StateFlow<Pair<ModuleModel, PackageStatus>> pkgStatus;

    public PackagePreviewPanel(@NotNull MutableStateFlow<ModuleWithPackage> selectedPackageStateFlow, @NotNull Project project, @NotNull CoroutineContext parentContext, @NotNull ReceiveChannel<Unit> updatePreviewPanel) {
        Intrinsics.checkNotNullParameter(selectedPackageStateFlow, (String)"selectedPackageStateFlow");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentContext, (String)"parentContext");
        Intrinsics.checkNotNullParameter(updatePreviewPanel, (String)"updatePreviewPanel");
        super(true);
        this.project = project;
        this.coroutineContext = parentContext.plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)).plus((CoroutineContext)new CoroutineName("PackageChecker.PackagePreviewPanel"));
        this.listPanel = new JPanel();
        this.packageTitle = new PackageTitlePanel(this.project, null, null, new TextDescriptionRenderer(this.listPanel));
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<PackageChecker> serviceClass$iv = PackageChecker.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.pkgStatus = FlowKt.stateIn((Flow)FlowKt.flowCombine((Flow)((Flow)selectedPackageStateFlow), (Flow)((Flow)((PackageChecker)object).getVulnerabilitiesFlow()), (Function3)((Function3)new Function3<ModuleWithPackage, Map<Package, ? extends PackageStatus>, Continuation<? super Pair<? extends ModuleModel, ? extends PackageStatus>>, Object>(null){
            int label;
            /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                ModuleWithPackage moduleWithPackage = (ModuleWithPackage)this.L$0;
                Map map2 = (Map)this.L$1;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Pair pair;
                        void moduleWithPackage2;
                        ResultKt.throwOnFailure((Object)$result);
                        void v0 = moduleWithPackage2;
                        if (v0 != null) {
                            void statuses;
                            void it = v0;
                            boolean bl = false;
                            ModuleModel moduleModel = moduleWithPackage2.getModule();
                            void var6_6 = statuses;
                            Object object = var6_6.get(moduleWithPackage2.getPkg());
                            if (object == null) {
                                ModuleModel moduleModel2 = moduleModel;
                                boolean bl2 = false;
                                object = new Unchecked(moduleWithPackage2.getPkg());
                                moduleModel = moduleModel2;
                            }
                            pair = TuplesKt.to((Object)moduleModel, object);
                        } else {
                            pair = null;
                        }
                        return pair;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(ModuleWithPackage p1, Map<Package, ? extends PackageStatus> p2, Continuation<? super Pair<? extends ModuleModel, ? extends PackageStatus>> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p1;
                var4_4.L$1 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)this, (SharingStarted)SharingStarted.Companion.getEagerly(), null);
        Disposer.register((Disposable)PackageCheckerDisposable.Companion.getInstance(this.project), (Disposable)this);
        FlowKt.launchIn((Flow)FlowKt.onEach((Flow)FlowKt.debounce((Flow)FlowKt.receiveAsFlow(updatePreviewPanel), (long)100L), (Function2)((Function2)new Function2<Unit, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ PackagePreviewPanel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        ThreadingAssertions.assertBackgroundThread();
                        this.this$0.clear();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Unit p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)this);
        BuildersKt.launch$default((CoroutineScope)this, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ PackagePreviewPanel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)FlowKt.onEach((Flow)((Flow)this.this$0.pkgStatus), (Function2)((Function2)new Function2<Pair<? extends ModuleModel, ? extends PackageStatus>, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ PackagePreviewPanel this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                Pair pair = (Pair)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void it;
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.this$0.clear();
                                        if (it != null) {
                                            void var3_3 = it;
                                            ModuleModel module = (ModuleModel)var3_3.component1();
                                            PackageStatus packageStatus = (PackageStatus)var3_3.component2();
                                            this.this$0.packageTitle.setPackageStatusAndUpdateSafeVersion(packageStatus, module);
                                            if (packageStatus instanceof Vulnerable) {
                                                this.this$0.renderVulnerabilityList(((Vulnerable)packageStatus).getVulnerablePackage().getVulnerabilities(), packageStatus.getPkg(), module);
                                            } else if (packageStatus instanceof Malicious) {
                                                PackagePreviewPanel.renderVulnerabilityList$default(this.this$0, ((Malicious)packageStatus).getMaliciousPackage().getVulnerablePackage().getVulnerabilities(), packageStatus.getPkg(), null, 4, null);
                                            }
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(Pair<? extends ModuleModel, ? extends PackageStatus> p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        })), (Function2)((Function2)new Function2<Pair<? extends ModuleModel, ? extends PackageStatus>, Continuation<? super Unit>, Object>(null){
                            int label;

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(Pair<? extends ModuleModel, ? extends PackageStatus> p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.packageTitle), "North");
        this.add(this.listPanel, "Center");
        this.packageTitle.setFocusable(true);
        this.listPanel.setFocusable(true);
        this.listPanel.setLayout(new BoxLayout(this.listPanel, 1));
        this.revalidate();
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    private final void renderVulnerabilityList(List<Vulnerability> vulnerabilities, Package pkg, ModuleModel module) {
        this.listPanel.add((Component)((Object)new VulnerabilityPanels(vulnerabilities, pkg, this.project, module)));
        this.revalidate();
        this.scrollToStart();
    }

    static /* synthetic */ void renderVulnerabilityList$default(PackagePreviewPanel packagePreviewPanel, List list, Package package_, ModuleModel moduleModel, int n, Object object) {
        if ((n & 4) != 0) {
            moduleModel = null;
        }
        packagePreviewPanel.renderVulnerabilityList(list, package_, moduleModel);
    }

    private final void clear() {
        this.packageTitle.setPackageStatusAndUpdateSafeVersion(null, null);
        this.listPanel.removeAll();
        this.revalidate();
    }

    private final void scrollToStart() {
        this.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        this.revalidate();
    }

    @Override
    @NotNull
    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = this.getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
        return dimension;
    }

    @Override
    public int getScrollableUnitIncrement(@NotNull Rectangle visibleRect, int orientation, int direction) {
        Intrinsics.checkNotNullParameter((Object)visibleRect, (String)"visibleRect");
        return 10;
    }

    @Override
    public int getScrollableBlockIncrement(@NotNull Rectangle visibleRect, int orientation, int direction) {
        Intrinsics.checkNotNullParameter((Object)visibleRect, (String)"visibleRect");
        return 100;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public void dispose() {
        JobKt.cancel$default((CoroutineContext)this.getCoroutineContext(), null, (int)1, null);
    }
}

