/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.javascript.JSBuiltInTypeEngineEvaluation;
import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.actionscript.psi.ActionScriptPsiImplUtil;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSNumberParser;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ProjectFileIndexSupport;
import com.intellij.lang.javascript.StubIndexSupport;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.flow.FlowJSAnnotation;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.JSIndexKeys;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSElvisOwner;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedExpression;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeOwner;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSWithStatement;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptParameterImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.impl.JSDefinitionExpressionImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitFunctionImpl;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSReadonlyArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.evaluable.JSReferenceType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.rhino.ScriptRuntime;
import com.intellij.lang.typescript.BasicTypeScriptElementTypes;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.QualifiedName;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.Hash;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSPsiImplUtils {
    public static final String CONSTRUCTS_PROPERTY_NAME = "construct";
    @NonNls
    private static final String ARRAY_ELEMENT_TYPE_ANNOTATION_NAME = "ArrayElementType";
    public static final com.intellij.util.Function<JSFunctionItem, JSFunctionWithSubstitutor> TO_FUNCTION_WITH_SUBSTITUTOR = fun -> new JSFunctionWithSubstitutor((JSFunctionItem)fun, JSTypeSubstitutor.EMPTY);
    public static final Function<JSFunctionItem, Collection<JSFunctionWithSubstitutor>> TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR = fun -> fun == null ? ContainerUtil.emptyList() : ContainerUtil.createMaybeSingletonList((Object)new JSFunctionWithSubstitutor((JSFunctionItem)fun, JSTypeSubstitutor.EMPTY));
    @NonNls
    public static final String HAS_OWN_PROPERTY = "hasOwnProperty";
    private static final Pattern ourQuotedQualifiedNamePartPattern = Pattern.compile("[^.\"']+|\"([^\"\\\\]|\\\\.)*\"|'([^'\\\\]|\\\\.)*'");
    public static final Hash.Strategy<JSQualifiedNamedElement> QUALIFIED_NAME_HASHING_STRATEGY = new Hash.Strategy<JSQualifiedNamedElement>(){

        public int hashCode(@Nullable JSQualifiedNamedElement object) {
            return object == null || object.getQualifiedName() == null ? 0 : object.getQualifiedName().hashCode();
        }

        public boolean equals(@Nullable JSQualifiedNamedElement o1, @Nullable JSQualifiedNamedElement o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            return Objects.equals(o1.getQualifiedName(), o2.getQualifiedName());
        }
    };
    private static final TokenSet FUNCTION_NAME_PREFIX_KEYWORDS = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.FUNCTION_KEYWORD, JSTokenTypes.GET_KEYWORD, JSTokenTypes.SET_KEYWORD});
    private static final TokenSet VARIABLE_NAME_PREFIX_KEYWORDS = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.VAR_KEYWORD, JSTokenTypes.LET_KEYWORD, JSTokenTypes.CONST_KEYWORD});
    private static final TokenSet OBJECT_LITERAL_EXPRESSION_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{JSElementTypes.OBJECT_LITERAL_EXPRESSION});
    private static final TokenSet FIND_CONSTRUCTS_STOP_AT = TokenSet.orSet((TokenSet[])new TokenSet[]{JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS, OBJECT_LITERAL_EXPRESSION_TOKEN_SET});

    @Nullable
    public static JSType getTypeFromElement(@Nullable PsiElement typePsi, JSElement element) {
        if (typePsi == null) {
            return null;
        }
        if (typePsi instanceof JSTypeDeclaration) {
            return ((JSTypeDeclaration)typePsi).getJSType();
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)element, true);
        JSType type = JSTypeParser.createType(typePsi.getProject(), typePsi.getText(), typeSource);
        if (type instanceof JSArrayType && ((JSArrayType)type).isPrimitive()) {
            String arrayType;
            JSAttributeListOwner attributeListOwner;
            JSAttributeList attributeList;
            String elementType;
            PsiComment psiComment = null;
            PsiElement el = typePsi.getPrevSibling();
            if (el instanceof PsiWhiteSpace) {
                el = el.getPrevSibling();
            }
            if (el instanceof PsiComment) {
                psiComment = (PsiComment)el;
            }
            if (psiComment != null && !(psiComment instanceof JSDocComment) && !(elementType = JSDocumentationUtils.unwrapCommentDelimiters(psiComment.getText()).trim()).isEmpty()) {
                return JSPsiImplUtils.getNonPrimitiveArrayOrSelf(typePsi.getProject(), typeSource, type, elementType);
            }
            if (element instanceof JSAttributeListOwner && (attributeList = (attributeListOwner = (JSAttributeListOwner)element).getAttributeList()) != null && (arrayType = JSPsiImplUtils.getArrayElementTypeFromAnnotation(attributeList)) != null && !arrayType.isEmpty()) {
                return JSPsiImplUtils.getNonPrimitiveArrayOrSelf(typePsi.getProject(), typeSource, type, arrayType);
            }
        }
        return type;
    }

    private static JSType getNonPrimitiveArrayOrSelf(Project project, JSTypeSource typeSource, JSType type, String elementType) {
        JSType baseType = JSTypeParser.createType(project, elementType, typeSource);
        if (type instanceof JSArrayType && !((JSArrayType)type).isReadonly()) {
            return new JSArrayTypeImpl(baseType, typeSource);
        }
        if (type instanceof JSArrayType && ((JSArrayType)type).isReadonly()) {
            return new JSReadonlyArrayTypeImpl(baseType, typeSource);
        }
        return baseType;
    }

    @Nullable
    public static JSType getTypeFromDeclaration(JSElement element) {
        return JSPsiImplUtils.getTypeFromElement(JSPsiImplUtils.getTypeElementFromDeclarationIncludingAS(element), element);
    }

    @Nullable
    public static PsiElement getTypeElementFromDeclarationIncludingAS(JSElement element) {
        return DialectDetector.isActionScript((PsiElement)element) ? ActionScriptPsiImplUtil.getTypeElementFromDeclaration(element) : JSPsiImplUtils.getTypeElementFromDeclaration(element);
    }

    @Nullable
    public static JSTypeDeclaration getTypeElementFromDeclaration(JSElement element) {
        if (element instanceof StubBasedPsiElementBase) {
            return JSPsiImplUtils.getStubOrPsiTypeElement((StubBasedPsiElementBase)element);
        }
        return (JSTypeDeclaration)PsiTreeUtil.getChildOfType((PsiElement)element, JSTypeDeclaration.class);
    }

    @Nullable
    public static JSTypeDeclaration getStubOrPsiTypeElement(@NotNull StubBasedPsiElementBase<?> element) {
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(0);
        }
        return (JSTypeDeclaration)ArrayUtil.getFirstElement((Object[])((JSTypeDeclaration[])element.getStubOrPsiChildren(JSExtendedLanguagesTokenSetProvider.TYPESCRIPT_OR_ES6_TYPES, JSTypeDeclaration.ARRAY_FACTORY)));
    }

    @Nullable
    public static String getArrayElementTypeFromAnnotation(JSAttributeList attributeList) {
        String type = JSPsiImplUtils.getTypeFromAnnotationParameter(attributeList, ARRAY_ELEMENT_TYPE_ANNOTATION_NAME, null);
        return type != null ? type : JSPsiImplUtils.getTypeFromAnnotationParameter(attributeList, ARRAY_ELEMENT_TYPE_ANNOTATION_NAME, "elementType");
    }

    @Nullable
    public static JSPackageStatement findPackageStatement(JSFile file) {
        PsiElement[] statements;
        JSPackageStatement packageStatement = null;
        for (PsiElement statement : statements = JSStubBasedPsiTreeUtil.getChildrenByType(file, JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS)) {
            if (!(statement instanceof JSPackageStatement)) continue;
            packageStatement = (JSPackageStatement)statement;
            break;
        }
        return packageStatement;
    }

    @Nullable
    public static JSClass findClass(JSFile file) {
        JSQualifiedNamedElement element = JSPsiImplUtils.findQualifiedElement(file);
        return element instanceof JSClass ? (JSClass)element : null;
    }

    @Nullable
    public static JSQualifiedNamedElement findQualifiedElement(JSFile file) {
        JSNamedElement mainDeclaredElement = ActionScriptResolveUtil.findMainDeclaredElement((PsiFileImpl)file);
        return mainDeclaredElement instanceof JSQualifiedNamedElement ? (JSQualifiedNamedElement)mainDeclaredElement : null;
    }

    @NotNull
    public static PsiElement findTopLevelNavigatableElement(@NotNull JSQualifiedNamedElement jsClass) {
        if (jsClass == null) {
            JSPsiImplUtils.$$$reportNull$$$0(1);
        }
        if (DumbService.getInstance((Project)jsClass.getProject()).isDumb()) {
            JSQualifiedNamedElement jSQualifiedNamedElement = jsClass;
            if (jSQualifiedNamedElement == null) {
                JSPsiImplUtils.$$$reportNull$$$0(2);
            }
            return jSQualifiedNamedElement;
        }
        PsiElement sourceElement = JSPsiImplUtils.findTopLevelNavigatableElementWithSource(jsClass, null);
        if (sourceElement != null) {
            PsiElement psiElement = sourceElement;
            if (psiElement == null) {
                JSPsiImplUtils.$$$reportNull$$$0(3);
            }
            return psiElement;
        }
        JSQualifiedNamedElement jSQualifiedNamedElement = jsClass;
        if (jSQualifiedNamedElement == null) {
            JSPsiImplUtils.$$$reportNull$$$0(4);
        }
        return jSQualifiedNamedElement;
    }

    @Nullable
    public static PsiElement findTopLevelNavigatableElementWithSource(@NotNull JSQualifiedNamedElement jsClass, @Nullable Consumer<? super JSQualifiedNamedElement> candidatesConsumer) {
        ProjectFileIndexSupport fileIndex;
        PsiFile containingFile;
        VirtualFile vFile;
        if (jsClass == null) {
            JSPsiImplUtils.$$$reportNull$$$0(5);
        }
        if (candidatesConsumer != null) {
            candidatesConsumer.consume((Object)jsClass);
        }
        VirtualFile virtualFile = vFile = (containingFile = jsClass.getContainingFile()) == null ? null : containingFile.getVirtualFile();
        if (vFile != null && ((fileIndex = ProjectFileIndexSupport.getInstance(jsClass.getProject())).isInSourceContent(vFile) || fileIndex.isInLibrarySource(vFile))) {
            return jsClass;
        }
        PsiElement sourceElement = JSPsiImplUtils.findNavigatableElementForLibraryClass(jsClass);
        if (sourceElement != null) {
            return sourceElement;
        }
        GlobalSearchScope searchScope = JSResolveUtil.getResolveScope((PsiElement)jsClass);
        String qName = jsClass.getQualifiedName();
        if (qName == null) {
            return null;
        }
        Collection<JSQualifiedNamedElement> candidates = StubIndexSupport.getInstance().getElements(JSIndexKeys.JS_QUALIFIED_ELEMENT_INDEX_KEY, qName, jsClass.getProject(), searchScope, JSQualifiedNamedElement.class);
        Iterator<JSQualifiedNamedElement> i = candidates.iterator();
        while (i.hasNext()) {
            if (qName.equals(i.next().getQualifiedName())) continue;
            i.remove();
        }
        for (JSQualifiedNamedElement candidate : candidates) {
            PsiElement candidateSourceElement;
            if (candidate == jsClass) continue;
            if (candidatesConsumer != null) {
                candidatesConsumer.consume((Object)candidate);
            }
            if ((candidateSourceElement = JSPsiImplUtils.findNavigatableElementForLibraryClass(candidate)) == null) continue;
            return candidateSourceElement;
        }
        return null;
    }

    @Nullable
    private static PsiElement findNavigatableElementForLibraryClass(JSQualifiedNamedElement jsClass) {
        return ProjectFileIndexSupport.getInstance(jsClass.getProject()).findNavigatableElementForLibraryClass(jsClass, (Function1<? super VirtualFile, ? extends PsiElement>)((Function1)source -> {
            PsiFile psiSource = jsClass.getManager().findFile(source);
            if (psiSource instanceof JSFile) {
                JSPackageStatement statement = JSPsiImplUtils.findPackageStatement((JSFile)psiSource);
                if (statement != null) {
                    for (JSSourceElement el : statement.getStatements()) {
                        if (el.getClass() == jsClass.getClass() && Objects.equals(jsClass.getName(), el.getName())) {
                            return el;
                        }
                        if (!(jsClass instanceof JSVariable) || !(el instanceof JSNamespaceDeclaration) || !Objects.equals(jsClass.getQualifiedName(), ((JSNamespaceDeclaration)el).getQualifiedName())) continue;
                        return el;
                    }
                }
                return psiSource;
            }
            return null;
        }), (Function1<? super VirtualFile, ? extends PsiElement>)((Function1)source -> {
            PsiFile psiSource = jsClass.getManager().findFile(source);
            if (psiSource instanceof XmlFile) {
                return XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)psiSource);
            }
            return null;
        }));
    }

    @Nullable
    public static JSQualifiedName getNamespace(@NotNull JSNamedElement element) {
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(6);
        }
        JSQualifiedName result = JSPsiImplUtils.getPrefixFromName(element);
        JSNamespace namespaceFromParent = JSPsiImplUtils.getNamespaceFromParent(element);
        if (namespaceFromParent != null && !namespaceFromParent.isLocal()) {
            result = JSQualifiedNameImpl.concat(namespaceFromParent.getQualifiedName(), result);
        }
        return result;
    }

    @Nullable
    public static JSQualifiedName getNamespaceFromJSNamespace(@NotNull JSElementBase elementBase) {
        JSNamespace namespace;
        if (elementBase == null) {
            JSPsiImplUtils.$$$reportNull$$$0(7);
        }
        return (namespace = elementBase.getJSNamespace()).isLocal() ? null : namespace.getQualifiedName();
    }

    @Nullable
    public static JSNamespace getJSNamespaceFromInitializedElement(@NotNull JSExpression expression) {
        JSQualifiedNamedElement baseElement;
        if (expression == null) {
            JSPsiImplUtils.$$$reportNull$$$0(8);
        }
        return (baseElement = JSPsiImplUtils.getInitializedElement(expression)) != null && !CommonJSUtil.isModuleExportsAssigmentTarget(baseElement) ? baseElement.getJSNamespace() : null;
    }

    @Nullable
    public static JSQualifiedName getPrefixFromName(@NotNull JSNamedElement element) {
        PsiElement nameIdentifier;
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(9);
        }
        String name = (nameIdentifier = element.getNameIdentifier()) != null ? nameIdentifier.getText() : null;
        JSQualifiedName result = null;
        if (name != null && StringUtil.containsChar((String)name, (char)'.')) {
            Matcher matcher = ourQuotedQualifiedNamePartPattern.matcher(name);
            while (matcher.find()) {
                result = JSQualifiedNameImpl.create(matcher.group(0), result);
            }
            if (result != null) {
                result = result.getParent();
            }
        }
        return result;
    }

    @Nullable
    public static JSNamespace getNamespaceFromParent(@NotNull JSNamedElement element) {
        PsiElement responsibleParent;
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(10);
        }
        if ((responsibleParent = element.getParent()) instanceof JSVarStatement) {
            responsibleParent = responsibleParent.getParent();
        }
        if (responsibleParent instanceof JSPackageStatement || responsibleParent instanceof TypeScriptModule || responsibleParent instanceof JSClass && !DialectDetector.isActionScript(responsibleParent)) {
            return JSNamedTypeFactory.buildProvidedNamespace((JSQualifiedNamedElement)responsibleParent, true, null);
        }
        return null;
    }

    @Nullable
    public static String buildQualifiedNameFromNamespaceAndName(JSQualifiedNamedElement element) {
        Object result = element.getName();
        if (result == null) {
            return null;
        }
        JSQualifiedName namespace = element.getNamespace();
        if (namespace != null) {
            result = namespace.getQualifiedName() + "." + (String)result;
        }
        return result;
    }

    @Nullable
    public static JSQualifiedName buildNamespaceFromQualifiedName(@NotNull JSQualifiedNamedElement element) {
        String qualifiedName;
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(11);
        }
        if ((qualifiedName = element.getQualifiedName()) == null) {
            return null;
        }
        Matcher matcher = ourQuotedQualifiedNamePartPattern.matcher(qualifiedName);
        JSQualifiedName result = null;
        while (matcher.find()) {
            result = JSQualifiedNameImpl.create(matcher.group(0), result);
        }
        return result != null ? result.getParent() : null;
    }

    @Nullable
    public static ASTNode findAnnotationAttributeValueNode(ASTNode node) {
        ASTNode valueNode = node.findChildByType(JSTokenTypes.STRING_LITERAL);
        if (valueNode == null) {
            valueNode = node.findChildByType(JSTokenTypes.SINGLE_QUOTE_STRING_LITERAL);
        }
        if (valueNode == null) {
            ASTNode next;
            ASTNode eqNode = node.findChildByType(JSTokenTypes.EQ);
            ASTNode aSTNode = next = eqNode == null ? null : eqNode.getTreeNext();
            while (next != null && next.getElementType() == JSTokenTypes.WHITE_SPACE) {
                next = next.getTreeNext();
            }
            valueNode = next;
        }
        return valueNode;
    }

    @Nullable
    public static String getTypeFromAnnotationParameter(@NotNull JSAttributeList attributeList, @NotNull String annotationName, @Nullable String annotationParameter) {
        if (attributeList == null) {
            JSPsiImplUtils.$$$reportNull$$$0(12);
        }
        if (annotationName == null) {
            JSPsiImplUtils.$$$reportNull$$$0(13);
        }
        String arrayType = null;
        JSAttribute[] byName = attributeList.getAttributesByName(annotationName);
        if (byName.length > 0) {
            JSAttributeNameValuePair jsAttributeNameValuePair = byName[0].getValueByName(annotationParameter);
            arrayType = jsAttributeNameValuePair != null ? jsAttributeNameValuePair.getSimpleValue() : null;
        }
        return arrayType;
    }

    public static boolean isTheSameClass(PsiElement typeSource, JSQualifiedNamedElement jsClass) {
        boolean sameQNames;
        if (typeSource == jsClass) {
            return true;
        }
        if (!(typeSource instanceof JSClass) || !(jsClass instanceof JSClass)) {
            return false;
        }
        String qName = ((JSClass)typeSource).getQualifiedName();
        boolean bl = sameQNames = qName != null && qName.equals(jsClass.getQualifiedName());
        if (!sameQNames) {
            return false;
        }
        typeSource = typeSource.getNavigationElement();
        jsClass = (JSClass)jsClass.getNavigationElement();
        VirtualFile virtualFile1 = PsiUtilCore.getVirtualFile((PsiElement)typeSource);
        VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile((PsiElement)jsClass);
        if (virtualFile1 == null || virtualFile2 == null) {
            return false;
        }
        if (Comparing.equal((Object)virtualFile1, (Object)virtualFile2)) {
            return true;
        }
        PsiFile psiFile1 = typeSource.getContainingFile().getOriginalFile();
        PsiFile psiFile2 = jsClass.getContainingFile().getOriginalFile();
        if (JSResolveUtil.isFromPredefinedFile(psiFile1) || JSResolveUtil.isFromPredefinedFile(psiFile2) || !virtualFile1.isValid() || !virtualFile2.isValid()) {
            return true;
        }
        VirtualFile parent1 = virtualFile1.getParent();
        VirtualFile parent2 = virtualFile2.getParent();
        if (parent1 == null || parent2 == null) {
            return true;
        }
        ProjectFileIndexSupport index = ProjectFileIndexSupport.getInstance(jsClass.getProject());
        boolean parent1InModule = index.isInContent(parent1);
        boolean parent2InModule = index.isInContent(parent2);
        if (parent1InModule && parent2InModule) {
            return false;
        }
        return !(!parent1InModule && !index.isInLibrary(parent1) || !parent2InModule && !index.isInLibrary(parent2));
    }

    public static void doRenameParentDirectoryIfNeeded(VirtualFile file, String name, Object requestor) throws IOException {
        VirtualFile directory;
        VirtualFile virtualFile = directory = file.isDirectory() ? file : file.getParent();
        if (!name.equals(directory.getName())) {
            directory.rename(requestor, name);
        }
    }

    @Nullable
    public static String getQNameForMove(@NotNull PsiElement targetElement, PsiElement elementToBind) {
        if (targetElement == null) {
            JSPsiImplUtils.$$$reportNull$$$0(14);
        }
        Project project = targetElement.getProject();
        if (elementToBind instanceof PsiDirectoryContainer) {
            PsiDirectory[] directories = ((PsiDirectoryContainer)elementToBind).getDirectories(targetElement.getResolveScope());
            return directories.length > 0 ? JSResolveUtil.getExpectedPackageNameFromFile(directories[0].getVirtualFile(), project) : null;
        }
        String qName = null;
        if (elementToBind instanceof PsiFile) {
            String newName = ((PsiNamedElement)elementToBind).getName();
            assert (newName != null);
            int index = newName.lastIndexOf(46);
            if (index != -1) {
                newName = newName.substring(0, index);
            }
            VirtualFile elementToBindFile = elementToBind.getContainingFile().getVirtualFile();
            String packageName = JSResolveUtil.getExpectedPackageNameFromFile(elementToBindFile, project);
            qName = ActionScriptResolveUtil.buildQualifiedName(packageName, newName);
        } else if (elementToBind instanceof JSQualifiedNamedElement && JSUtils.getMemberContainingClass(elementToBind) == null) {
            qName = ((JSQualifiedNamedElement)elementToBind).getQualifiedName();
        }
        if (qName != null && targetElement instanceof JSReferenceExpression) {
            String targetElementPackageName;
            if (targetElement.getContainingFile() instanceof JSFile && PsiTreeUtil.getParentOfType((PsiElement)targetElement, JSPackageStatement.class) == null && JSResolveUtil.getXmlBackedClass((JSFile)targetElement.getContainingFile()) == null) {
                targetElementPackageName = "";
            } else {
                JSExpression qualifier = ((JSReferenceExpression)targetElement).getQualifier();
                String string = targetElementPackageName = qualifier != null ? qualifier.getText() : JSResolveUtil.getExpectedPackageNameFromFile(targetElement.getContainingFile().getVirtualFile(), project);
            }
            if (!JSPsiImplUtils.differentPackageName(targetElementPackageName, StringUtil.getPackageName((String)qName))) {
                return null;
            }
        }
        return qName;
    }

    public static boolean differentPackageName(String s, String expectedPackageNameFromFile) {
        boolean sIsEmpty = JSPsiImplUtils.isEmpty(s);
        boolean expectedIsEmpty = JSPsiImplUtils.isEmpty(expectedPackageNameFromFile);
        return sIsEmpty && !expectedIsEmpty || !sIsEmpty && (expectedIsEmpty || !s.equals(expectedPackageNameFromFile));
    }

    public static boolean isEmpty(String expectedPackageNameFromFile) {
        return expectedPackageNameFromFile == null || expectedPackageNameFromFile.isEmpty();
    }

    public static boolean containsEquivalent(Collection<? extends PsiElement> array, PsiElement element) {
        for (PsiElement psiElement : array) {
            if (!psiElement.isEquivalentTo(element)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsEquivalent(PsiElement[] array, PsiElement element) {
        return JSPsiImplUtils.containsEquivalent(Arrays.asList(array), element);
    }

    @Nullable
    public static ASTNode findNameIdentifierOfFunction(@NotNull ASTNode node) {
        if (node == null) {
            JSPsiImplUtils.$$$reportNull$$$0(15);
        }
        return JSPsiImplUtils.findNameIdentifierOfFunction(node, false);
    }

    public static boolean parensAroundArrowFunctionParametersRequired(@NotNull JSParameterList parameterList, @NotNull JSFunction function) {
        if (parameterList == null) {
            JSPsiImplUtils.$$$reportNull$$$0(16);
        }
        if (function == null) {
            JSPsiImplUtils.$$$reportNull$$$0(17);
        }
        if (function.getReturnTypeElement() != null) {
            return true;
        }
        JSParameterListElement[] parameters = parameterList.getParameters();
        if (parameters.length != 1) {
            return true;
        }
        JSParameterListElement singleParam = parameters[0];
        return singleParam instanceof JSDestructuringParameter || singleParam.isRest() || singleParam.getTypeElement() != null || singleParam instanceof JSVariable && singleParam.hasInitializer() || singleParam instanceof TypeScriptParameterImpl && ((TypeScriptParameterImpl)singleParam).isDeclaredOptional() || ContainerUtil.or((Object[])parameterList.getChildren(), child -> child instanceof JSDocComment);
    }

    public static boolean parensAroundArrowFunctionBodyRequired(@Nullable JSExpression body) {
        if (body == null) {
            return false;
        }
        PsiElement deepestFirst = PsiTreeUtil.getDeepestFirst((PsiElement)body);
        return deepestFirst.getNode().getElementType() == JSTokenTypes.LBRACE;
    }

    public static void processTopLevelComment(@NotNull PsiFile file, @NotNull Processor<? super PsiComment> isAcceptable) {
        if (file == null) {
            JSPsiImplUtils.$$$reportNull$$$0(18);
        }
        if (isAcceptable == null) {
            JSPsiImplUtils.$$$reportNull$$$0(19);
        }
        SyntaxTraverser elements = (SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)file).expand(e -> !(e instanceof JSDocComment));
        for (PsiElement element : elements) {
            IElementType elementType;
            if (element instanceof PsiComment) {
                if (isAcceptable.process((Object)((PsiComment)element))) continue;
                return;
            }
            if (!(element instanceof LeafElement) || element instanceof PsiWhiteSpace || JSTokenTypes.STRING_LITERALS.contains(elementType = ((LeafElement)element).getElementType()) || elementType == JSTokenTypes.SEMICOLON) continue;
            return;
        }
    }

    public static boolean isRuntimeUnqualifiedRefExpression(@Nullable PsiElement parent) {
        return parent instanceof JSReferenceExpression && ((JSReferenceExpression)parent).getQualifier() == null && !JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)parent);
    }

    public static boolean isArgumentOfCallWithName(@NotNull JSExpression argument, int argumentIndex, String ... components) {
        PsiElement argumentList;
        if (argument == null) {
            JSPsiImplUtils.$$$reportNull$$$0(20);
        }
        if (!((argumentList = JSUtils.getParentSkipParentheses((PsiElement)argument)) instanceof JSArgumentList)) {
            return false;
        }
        PsiElement callExpression = argumentList.getParent();
        if (!(callExpression instanceof JSCallExpression)) {
            return false;
        }
        JSExpression methodExpression = ((JSCallExpression)callExpression).getMethodExpression();
        if (!(methodExpression instanceof JSReferenceExpression) || !JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, components)) {
            return false;
        }
        if (argumentIndex >= 0) {
            JSArgumentList list = (JSArgumentList)argumentList;
            JSExpression[] arguments = list.getArguments();
            if (argumentIndex + list.getFirstArgumentIndex() >= arguments.length || arguments[argumentIndex + list.getFirstArgumentIndex()] != argument) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static PsiElement getLastLeafChild(@NotNull PsiElement element) {
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(21);
        }
        PsiElement prev = element;
        while (element != null) {
            prev = element;
            element = element.getLastChild();
        }
        PsiElement psiElement = prev;
        if (psiElement == null) {
            JSPsiImplUtils.$$$reportNull$$$0(22);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement getFirstLeafChild(@NotNull PsiElement element) {
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(23);
        }
        PsiElement prev = element;
        while (element != null) {
            prev = element;
            element = element.getFirstChild();
        }
        PsiElement psiElement = prev;
        if (psiElement == null) {
            JSPsiImplUtils.$$$reportNull$$$0(24);
        }
        return psiElement;
    }

    public static boolean isConst(@NotNull PsiElement variable) {
        if (variable == null) {
            JSPsiImplUtils.$$$reportNull$$$0(25);
        }
        return JSPsiImplUtils.variableDeclaredWith(variable, JSVarStatement.VarKeyword.CONST);
    }

    public static boolean isLet(@NotNull PsiElement variable) {
        if (variable == null) {
            JSPsiImplUtils.$$$reportNull$$$0(26);
        }
        return JSPsiImplUtils.variableDeclaredWith(variable, JSVarStatement.VarKeyword.LET);
    }

    public static boolean isVar(@NotNull PsiElement variable) {
        if (variable == null) {
            JSPsiImplUtils.$$$reportNull$$$0(27);
        }
        return JSPsiImplUtils.variableDeclaredWith(variable, JSVarStatement.VarKeyword.VAR);
    }

    private static boolean variableDeclaredWith(@NotNull PsiElement element, @NotNull JSVarStatement.VarKeyword keyword) {
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(28);
        }
        if (keyword == null) {
            JSPsiImplUtils.$$$reportNull$$$0(29);
        }
        if (!(element instanceof JSVariable)) {
            return false;
        }
        JSVariable variable = (JSVariable)element;
        JSVarStatement statement = variable.getStatement();
        return statement != null && statement.getVarKeyword() == keyword;
    }

    @NotNull
    public static TokenSet getIdentifiers(@Nullable DialectOptionHolder dialect) {
        if (dialect != null) {
            if (dialect.isECMA4) {
                TokenSet tokenSet = JSKeywordSets.AS_IDENTIFIER_TOKENS_SET;
                if (tokenSet == null) {
                    JSPsiImplUtils.$$$reportNull$$$0(30);
                }
                return tokenSet;
            }
            if (dialect.isTypeScript) {
                TokenSet tokenSet = JSKeywordSets.TS_IDENTIFIERS_TOKENS_SET;
                if (tokenSet == null) {
                    JSPsiImplUtils.$$$reportNull$$$0(31);
                }
                return tokenSet;
            }
            if (dialect.isJavaScript()) {
                TokenSet tokenSet = JSKeywordSets.JS_IDENTIFIER_TOKENS_SET;
                if (tokenSet == null) {
                    JSPsiImplUtils.$$$reportNull$$$0(32);
                }
                return tokenSet;
            }
        }
        TokenSet tokenSet = JSKeywordSets.IDENTIFIER_TOKENS_SET;
        if (tokenSet == null) {
            JSPsiImplUtils.$$$reportNull$$$0(33);
        }
        return tokenSet;
    }

    public static boolean isReturnedFromFunction(@NotNull JSExpression expression) {
        PsiElement parent;
        if (expression == null) {
            JSPsiImplUtils.$$$reportNull$$$0(34);
        }
        return (parent = JSUtils.getParentSkipParentheses((PsiElement)expression)) instanceof JSReturnStatement || parent instanceof JSFunction;
    }

    @Nullable
    public static ASTNode findNameIdentifierOfFunction(@NotNull ASTNode node, boolean onlyAfterMarkerKeyword) {
        if (node == null) {
            JSPsiImplUtils.$$$reportNull$$$0(35);
        }
        return JSPsiImplUtils.findNameIdentifierOf(node, onlyAfterMarkerKeyword, NamedEntityKind.Function);
    }

    @Nullable
    public static ASTNode findFallbackNameIdentifierOfVariable(@NotNull ASTNode node) {
        if (node == null) {
            JSPsiImplUtils.$$$reportNull$$$0(36);
        }
        return JSPsiImplUtils.findNameIdentifierOf(node, false, NamedEntityKind.Variable);
    }

    @Nullable
    public static ASTNode findNameIdentifierOf(@NotNull ASTNode node, boolean onlyAfterMarkerKeyword, NamedEntityKind entityKind) {
        if (node == null) {
            JSPsiImplUtils.$$$reportNull$$$0(37);
        }
        if (entityKind != NamedEntityKind.Function && entityKind != NamedEntityKind.Variable) {
            throw new UnsupportedOperationException("Unknown entity kind: " + String.valueOf((Object)entityKind));
        }
        TokenSet prefixKeywords = entityKind == NamedEntityKind.Function ? FUNCTION_NAME_PREFIX_KEYWORDS : VARIABLE_NAME_PREFIX_KEYWORDS;
        ASTNode computed = node.findChildByType(JSElementTypes.COMPUTED_NAME);
        if (computed != null && DialectDetector.isES6(node.getPsi()) && (!onlyAfterMarkerKeyword || TreeUtil.findSiblingBackward((ASTNode)computed.getTreePrev(), (TokenSet)prefixKeywords) != null)) {
            return null;
        }
        if (entityKind != NamedEntityKind.Function) {
            ASTNode child = node.findChildByType(JSKeywordSets.PROPERTY_NAMES);
            if (child != null && TreeUtil.findSiblingBackward((ASTNode)child.getTreePrev(), (TokenSet)prefixKeywords) == null) {
                return child;
            }
            return null;
        }
        for (ASTNode candidate = node.findChildByType(BasicTypeScriptElementTypes.PARAMETER_LISTS); candidate != null; candidate = candidate.getTreePrev()) {
            if (!JSKeywordSets.PROPERTY_NAMES.contains(candidate.getElementType())) continue;
            if (onlyAfterMarkerKeyword && TreeUtil.findSiblingBackward((ASTNode)candidate.getTreePrev(), (TokenSet)prefixKeywords) == null) {
                return null;
            }
            return candidate;
        }
        return null;
    }

    @Nullable
    private static ASTNode getComputedNameOf(ASTNode myNode, boolean onlyAfterMarkerKeyword, NamedEntityKind entityKind) {
        if (entityKind != NamedEntityKind.Function && entityKind != NamedEntityKind.Variable) {
            throw new UnsupportedOperationException("Unknown entity kind: " + String.valueOf((Object)entityKind));
        }
        TokenSet prefixKeywords = entityKind == NamedEntityKind.Function ? FUNCTION_NAME_PREFIX_KEYWORDS : VARIABLE_NAME_PREFIX_KEYWORDS;
        ASTNode computed = myNode.findChildByType(JSElementTypes.COMPUTED_NAME);
        if (computed != null && DialectDetector.isES6(myNode.getPsi()) && (!onlyAfterMarkerKeyword || TreeUtil.findSiblingBackward((ASTNode)computed.getTreePrev(), (TokenSet)prefixKeywords) != null)) {
            return computed;
        }
        return null;
    }

    @Nullable
    public static ASTNode getComputedNameOfFunction(ASTNode myNode, boolean onlyAfterMarkerKeyword) {
        return JSPsiImplUtils.getComputedNameOf(myNode, onlyAfterMarkerKeyword, NamedEntityKind.Function);
    }

    @Nullable
    public static ASTNode getComputedNameOfVariable(ASTNode myNode, boolean onlyAfterMarkerKeyword) {
        return JSPsiImplUtils.getComputedNameOf(myNode, onlyAfterMarkerKeyword, NamedEntityKind.Variable);
    }

    public static boolean isFunctionNameReference(JSFunction function, PsiElement elt) {
        return function.getNameIdentifier() == elt || function instanceof JSFunctionExpression && ((JSFunctionExpression)function).getOwnNameIdentifier() == elt;
    }

    public static void deleteFromTree(PsiElement element) {
        PsiComment docComment = JSDocumentationUtils.findDocComment(element);
        element.getNode().getTreeParent().removeChild(element.getNode());
        if (docComment != null && docComment.getNode().getElementType() == JSElementTypes.DOC_COMMENT && docComment.isValid()) {
            docComment.delete();
        }
    }

    public static boolean isArrowFunction(@Nullable JSFunction function) {
        return JSPsiImplUtils.getFunctionArrowNode(function) != null;
    }

    @Nullable
    public static ASTNode getFunctionArrowNode(@Nullable JSFunction function) {
        if (!(function instanceof JSFunctionExpression)) {
            return null;
        }
        ASTNode node = function.getNode();
        ASTNode firstChild = node.getFirstChildNode();
        if (firstChild != null && firstChild.getElementType() == JSTokenTypes.FUNCTION_KEYWORD) {
            return null;
        }
        return node.findChildByType(JSTokenTypes.ARROWS);
    }

    @Deprecated
    @ApiStatus.Internal
    @Nullable
    public static JSExpression tryGetArrowFunctionReturnExpression(@Nullable JSFunction function) {
        return function != null ? JSPsiImplUtils.getReturnedExpressionIfShorthandArrowFunction(function) : null;
    }

    @Nullable
    public static JSExpression getReturnedExpressionIfShorthandArrowFunction(@NotNull JSFunction function) {
        if (function == null) {
            JSPsiImplUtils.$$$reportNull$$$0(38);
        }
        if (!function.isArrowFunction()) {
            return null;
        }
        ASTNode expressionNode = function.getNode().findChildByType(JSExtendedLanguagesTokenSetProvider.EXPRESSIONS);
        return expressionNode != null ? (JSExpression)expressionNode.getPsi() : null;
    }

    public static boolean isShorthandArrowFunction(@NotNull JSFunction element) {
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(39);
        }
        return JSPsiImplUtils.getReturnedExpressionIfShorthandArrowFunction(element) != null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static JSElement getFunctionBody(@Nullable JSFunction function) {
        if (function == null) {
            return null;
        }
        JSBlockStatement blockBody = function.getBlock();
        if (blockBody != null) {
            return blockBody;
        }
        return JSPsiImplUtils.getReturnedExpressionIfShorthandArrowFunction(function);
    }

    @Nullable
    public static JSExpression getReturnedExpressionIfSingle(@NotNull JSFunction function) {
        PsiElement lastStatement;
        JSExpression arrowFunctionReturnExpression;
        if (function == null) {
            JSPsiImplUtils.$$$reportNull$$$0(40);
        }
        if ((arrowFunctionReturnExpression = JSPsiImplUtils.getReturnedExpressionIfShorthandArrowFunction(function)) != null) {
            return arrowFunctionReturnExpression;
        }
        JSBlockStatement block = function.getBlock();
        PsiElement psiElement = lastStatement = block == null ? null : block.getLastChild();
        while (lastStatement != null && !(lastStatement instanceof JSStatement)) {
            lastStatement = lastStatement.getPrevSibling();
        }
        if (!(lastStatement instanceof JSReturnStatement)) {
            return null;
        }
        Collection returnedExpressions = JSStubBasedPsiTreeUtil.findReturnedExpressions(function, JSExpression.class);
        return returnedExpressions.size() == 1 ? (JSExpression)ContainerUtil.getFirstItem(returnedExpressions) : null;
    }

    @Nullable
    public static PsiElement getNonParenthesizeParent(@NotNull PsiElement element) {
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(41);
        }
        return JSUtils.getParentSkipParentheses(element);
    }

    @Nullable
    public static JSFunction getPossibleFunction(@Nullable PsiElement element) {
        if (element instanceof JSFunction) {
            return (JSFunction)element;
        }
        if (element instanceof JSProperty) {
            element = ((JSProperty)element).tryGetFunctionInitializer();
        }
        if (element instanceof TypeScriptPropertySignature) {
            TypeScriptPropertySignature tsPropertySignature = (TypeScriptPropertySignature)element;
            element = tsPropertySignature.getTypeDeclaration();
        }
        if (element instanceof JSInitializerOwner) {
            element = ((JSInitializerOwner)element).getInitializerOrStub();
        }
        return element instanceof JSFunction ? (JSFunction)element : null;
    }

    @Nullable
    public static JSFunctionItem getPossibleFunctionItem(@Nullable PsiElement element) {
        if (element instanceof JSFunctionItem) {
            return (JSFunctionItem)element;
        }
        return JSPsiImplUtils.getPossibleFunction(element);
    }

    @Nullable
    public static JSFunctionItem calculatePossibleFunction(@NotNull PsiElement element, @Nullable PsiElement methodExpression, boolean includeRawSignatures) {
        Collection<JSFunctionWithSubstitutor> functionWithSubstitutors;
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(42);
        }
        if ((functionWithSubstitutors = JSStubBasedPsiTreeUtil.calculatePossibleFunctions(element, methodExpression, null, includeRawSignatures, false)).isEmpty()) {
            return null;
        }
        JSFunctionWithSubstitutor item = (JSFunctionWithSubstitutor)ContainerUtil.getFirstItem(functionWithSubstitutors);
        if (item != null) {
            JSFunctionItem firstFunction = item.myFunctionItem;
            JSTypeSubstitutor substitutor = item.myTypeSubstitutor;
            if (firstFunction instanceof JSImplicitFunctionImpl) {
                return firstFunction;
            }
            return functionWithSubstitutors.size() > 1 || !substitutor.isEmpty() ? null : firstFunction;
        }
        return null;
    }

    @Nullable
    public static JSExpression getRightmostInitializer(@NotNull JSInitializerOwner initializerOwner) {
        JSExpression definitionInitializer;
        JSDefinitionExpression definitionExpression;
        if (initializerOwner == null) {
            JSPsiImplUtils.$$$reportNull$$$0(43);
        }
        JSExpression initializer = initializerOwner.getInitializerOrStub();
        while (initializer instanceof JSAssignmentExpression && (definitionExpression = ((JSAssignmentExpression)initializer).getDefinitionExpression()) != null && (definitionInitializer = definitionExpression.getInitializerOrStub()) != null) {
            initializer = definitionInitializer;
        }
        return initializer;
    }

    @Nullable
    public static JSFunctionExpression findConstructsFunction(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(44);
        }
        if (DialectDetector.isTypeScript(element)) {
            return null;
        }
        PsiElement scope = element;
        if (element instanceof JSDefinitionExpression && (parent = element.getParent()) instanceof JSAssignmentExpression) {
            scope = parent;
        }
        Collection<JSObjectLiteralExpression> objectLiterals = scope instanceof JSObjectLiteralExpression ? Collections.singleton((JSObjectLiteralExpression)scope) : JSStubBasedPsiTreeUtil.findDescendants(scope, OBJECT_LITERAL_EXPRESSION_TOKEN_SET, FIND_CONSTRUCTS_STOP_AT);
        for (JSObjectLiteralExpression objectLiteral : objectLiterals) {
            for (JSProperty property : objectLiteral.getProperties()) {
                JSFunction initializer;
                JSDocComment comment = JSStubBasedPsiTreeUtil.findDocComment((PsiElement)property);
                if (comment == null || !comment.hasConstructsTag() || !((initializer = property.tryGetFunctionInitializer()) instanceof JSFunctionExpression)) continue;
                return (JSFunctionExpression)initializer;
            }
        }
        return null;
    }

    @Nullable
    public static JSExpression getAssignedExpression(@Nullable PsiElement element) {
        if (element instanceof JSDefinitionExpression) {
            PsiElement parent = element.getParent();
            if (parent instanceof JSAssignmentExpression && ((JSAssignmentExpression)parent).getLOperand() == element) {
                JSExpression rOperand = ((JSAssignmentExpression)parent).getROperand();
                return rOperand != null ? JSPsiImplUtils.getAssignedExpression((PsiElement)rOperand) : null;
            }
        } else {
            if (element instanceof JSAssignmentExpression) {
                JSExpression rOperand = ((JSAssignmentExpression)element).getROperand();
                return rOperand != null ? JSPsiImplUtils.getAssignedExpression((PsiElement)rOperand) : null;
            }
            if (element instanceof JSExpression) {
                return (JSExpression)element;
            }
            if (element instanceof JSVariable) {
                return JSPsiImplUtils.getAssignedExpression((PsiElement)((JSVariable)element).getInitializer());
            }
            if (element instanceof JSProperty) {
                return JSPsiImplUtils.getAssignedExpression((PsiElement)((JSProperty)element).getValue());
            }
            if (element instanceof ES6ExportDefaultAssignment) {
                return JSPsiImplUtils.getAssignedExpression((PsiElement)((ES6ExportDefaultAssignment)element).getExpression());
            }
        }
        return null;
    }

    @Nullable
    public static String findFunctionQualifiedName(@NotNull JSFunctionItem function) {
        JSExpression lOperand;
        String qualifiedName;
        if (function == null) {
            JSPsiImplUtils.$$$reportNull$$$0(45);
        }
        if ((qualifiedName = function.getQualifiedName()) != null) {
            return qualifiedName;
        }
        if (!(function instanceof JSExpression)) {
            return null;
        }
        JSExpression expression = (JSExpression)((Object)function);
        PsiElement parent = expression.getParent();
        if (parent instanceof JSVariable) {
            return ((JSVariable)parent).getQualifiedName();
        }
        if (parent instanceof JSProperty) {
            return ((JSProperty)parent).getName();
        }
        if (parent instanceof JSAssignmentExpression && ((JSAssignmentExpression)parent).getROperand() == expression && (lOperand = ((JSAssignmentExpression)parent).getLOperand()) instanceof JSDefinitionExpression) {
            return ((JSDefinitionExpression)lOperand).getQualifiedName();
        }
        return null;
    }

    @Nullable
    public static String findFunctionName(@NotNull JSFunctionItem function) {
        String qualifiedName;
        if (function == null) {
            JSPsiImplUtils.$$$reportNull$$$0(46);
        }
        return (qualifiedName = JSPsiImplUtils.findFunctionQualifiedName(function)) != null ? QualifiedName.fromDottedString((String)qualifiedName).getLastComponent() : null;
    }

    public static boolean isGetProperty(@NotNull PsiElement element) {
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(47);
        }
        return element instanceof JSFunctionItem ? ((JSFunctionItem)element).isGetProperty() : element instanceof JSProperty && ((JSProperty)element).isGetProperty();
    }

    public static boolean isSetProperty(@NotNull PsiElement element) {
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(48);
        }
        return element instanceof JSFunctionItem ? ((JSFunctionItem)element).isSetProperty() : element instanceof JSProperty && ((JSProperty)element).isSetProperty();
    }

    @Nullable
    public static JSExpression getRightmostOperand(@NotNull JSDefinitionExpression definitionExpression) {
        PsiElement parent;
        if (definitionExpression == null) {
            JSPsiImplUtils.$$$reportNull$$$0(49);
        }
        if ((parent = definitionExpression.getParent()) instanceof JSAssignmentExpression) {
            JSExpression expr = ((JSAssignmentExpression)parent).getROperand();
            while (expr instanceof JSAssignmentExpression) {
                expr = ((JSAssignmentExpression)expr).getROperand();
            }
            return expr;
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static JSAttributeList.AccessType getExplicitAccessType(@Nullable JSAttributeListOwner attributeListOwner) {
        if (attributeListOwner == null) {
            return null;
        }
        JSAttributeList list = attributeListOwner.getAttributeList();
        if (list == null) {
            return null;
        }
        return list.getExplicitAccessType();
    }

    @NotNull
    public static JSAttributeList.AccessType getAccessType(JSQualifiedNamedElement element) {
        JSAttributeList.AccessType accessType;
        JSAttributeList.AccessType accessType2;
        JSAttributeList list;
        if (element.isPrivateName()) {
            JSAttributeList.AccessType accessType3 = JSAttributeList.AccessType.PRIVATE;
            if (accessType3 == null) {
                JSPsiImplUtils.$$$reportNull$$$0(50);
            }
            return accessType3;
        }
        JSAttributeList jSAttributeList = list = element instanceof JSAttributeListOwner ? ((JSAttributeListOwner)((Object)element)).getAttributeList() : null;
        if (list != null && (accessType2 = list.getExplicitAccessType()) != null) {
            JSAttributeList.AccessType accessType4 = accessType2;
            if (accessType4 == null) {
                JSPsiImplUtils.$$$reportNull$$$0(51);
            }
            return accessType4;
        }
        JSDocComment docComment = JSStubBasedPsiTreeUtil.findDocComment((PsiElement)element);
        if (docComment != null && (accessType = docComment.getAccessType()) != null) {
            JSAttributeList.AccessType accessType5 = accessType;
            if (accessType5 == null) {
                JSPsiImplUtils.$$$reportNull$$$0(52);
            }
            return accessType5;
        }
        JSAttributeList.AccessType accessType6 = list != null ? list.getAccessType() : JSAttributeList.AccessType.PACKAGE_LOCAL;
        if (accessType6 == null) {
            JSPsiImplUtils.$$$reportNull$$$0(53);
        }
        return accessType6;
    }

    @Nullable
    public static Pair<String, PsiElement> getChildStringLiteralWithText(PsiElement element) {
        ASTNode literalNode = element.getNode().findChildByType(JSTokenTypes.STRING_LITERALS);
        if (literalNode == null) {
            return null;
        }
        String modulePath = literalNode.getText();
        PsiElement literalElement = literalNode.getPsi();
        return Pair.create((Object)modulePath, (Object)literalElement);
    }

    public static JSExpression getInitializer(ASTNode ownerNode) {
        ASTNode node = JSTreeUtil.getInitializerNode(ownerNode);
        return node != null ? (JSExpression)node.getPsi() : null;
    }

    @Nullable
    public static <T extends PsiReference> T findReferenceOfClass(PsiReference ref, Class<T> clazz) {
        if (clazz.isInstance(ref)) {
            return (T)ref;
        }
        if (ref instanceof PsiMultiReference) {
            for (PsiReference reference : ((PsiMultiReference)ref).getReferences()) {
                if (!clazz.isInstance(reference)) continue;
                return (T)reference;
            }
        }
        return null;
    }

    public static boolean isPrivateName(PsiNameIdentifierOwner element) {
        PsiElement nameElement = element.getNameIdentifier();
        if (nameElement == null) {
            return false;
        }
        return nameElement.getNode().getElementType() == JSTokenTypes.PRIVATE_IDENTIFIER;
    }

    public static int getPrivateNameDepthOfContext(JSQualifiedNamedElement psiElement) {
        return JSPsiImplUtils.getPrivateNameDepthOfContext(psiElement.isPrivateName(), (PsiElement)psiElement);
    }

    public static int getPrivateNameDepthOfContext(boolean privateName, @Nullable PsiElement element) {
        if (!privateName) {
            return -1;
        }
        JSClass jsClass = JSResolveUtil.getClassOfContext(element);
        if (jsClass == null) {
            return -1;
        }
        return jsClass.getInheritanceDepth();
    }

    @NlsSafe
    @Nullable
    public static String getNameOrComputedPropertyName(@Nullable JSNamedElementBase element, boolean stubSafe) {
        String computedPropertyName;
        if (element == null) {
            return null;
        }
        Object name = element.getName();
        if (name != null) {
            boolean isPrivateName = false;
            if (element instanceof JSPsiNamedElementBase) {
                isPrivateName = JSUtils.isPrivateSharpItem((PsiElement)((JSPsiNamedElementBase)element));
            }
            return element instanceof TypeScriptModule ? name : JSSymbolUtil.quoteIfSpecialPropertyName((String)name, isPrivateName, '\"');
        }
        if (element instanceof JSComputedPropertyNameOwner && (computedPropertyName = JSPsiImplUtils.getComputedPropertyNameWithoutBrackets((JSComputedPropertyNameOwner)((Object)element))) != null) {
            name = "[" + computedPropertyName + "]";
        }
        if (element instanceof JSDefinitionExpressionImpl && (!stubSafe || ((JSDefinitionExpressionImpl)element).getGreenStub() == null)) {
            PsiElement identifier = ((JSDefinitionExpression)element).getNameIdentifier();
            if (identifier != null) {
                String text = identifier.getText();
                name = "[" + text + "]";
            } else {
                JSExpression indexExpression;
                JSExpression expression = ((JSDefinitionExpression)element).getExpression();
                if (expression instanceof JSIndexedPropertyAccessExpression && (indexExpression = ((JSIndexedPropertyAccessExpression)expression).getIndexExpression()) != null) {
                    String text = indexExpression.getText();
                    name = "[" + text + "]";
                }
            }
        }
        return name;
    }

    @Nullable
    public static String getComputedPropertyNameWithoutBrackets(JSComputedPropertyNameOwner owner) {
        ES6ComputedName expr = owner.getComputedPropertyName();
        return expr == null ? null : expr.getExpressionAsPropertyName();
    }

    @Contract(value="null -> false")
    public static boolean isSymbolRef(@Nullable JSExpression expr) {
        if (!JSSymbolUtil.isAccurateReferenceExpression(expr)) {
            return false;
        }
        JSReferenceExpression ref = (JSReferenceExpression)expr;
        JSExpression qualifier = ref.getQualifier();
        return qualifier instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)qualifier, "Symbol");
    }

    @Nullable
    public static JSNamedElement findElementFromNameIdentifier(@NotNull PsiElement nameIdentifier) {
        JSNamedElement candidate;
        if (nameIdentifier == null) {
            JSPsiImplUtils.$$$reportNull$$$0(54);
        }
        PsiElement identifier = (candidate = (JSNamedElement)PsiTreeUtil.getParentOfType((PsiElement)nameIdentifier, JSNamedElement.class)) != null ? candidate.getNameIdentifier() : null;
        return identifier == nameIdentifier ? candidate : null;
    }

    public static boolean signatureIsExplicitlyDeclared(@NotNull JSFunctionItem function) {
        JSParameterItem[] parameters;
        if (function == null) {
            JSPsiImplUtils.$$$reportNull$$$0(55);
        }
        if (function instanceof JSFunction ? ((JSFunction)function).hasExplicitlyDeclaredReturnType() : function.getReturnType() != null) {
            return true;
        }
        if (function.isOverride()) {
            return true;
        }
        for (JSParameterItem parameter : parameters = function.getParameters()) {
            JSType type = parameter.getSimpleType();
            if (type == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isUseStrictStatement(@Nullable PsiElement currentChild) {
        return JSPsiImplUtils.isCompilerDirectiveStatement(currentChild, "use strict");
    }

    public static boolean isCompilerDirectiveStatement(@Nullable PsiElement element) {
        JSExpression expression;
        if (element instanceof JSExpressionStatement && (expression = ((JSExpressionStatement)element).getExpression()) instanceof JSLiteralExpression && ((JSLiteralExpression)expression).isQuotedLiteral()) {
            String value = ((JSLiteralExpression)expression).getStringValue();
            return value != null && value.startsWith("use ") && StringUtil.isJavaIdentifier((String)value.substring(4));
        }
        return false;
    }

    public static boolean isCompilerDirectiveStatement(@Nullable PsiElement element, String ... directives) {
        JSExpressionStatement statement;
        JSExpression expression;
        if (directives == null) {
            JSPsiImplUtils.$$$reportNull$$$0(56);
        }
        if (element instanceof JSExpressionStatement && (expression = (statement = (JSExpressionStatement)element).getExpression()) instanceof JSLiteralExpression) {
            JSLiteralExpression literal = (JSLiteralExpression)expression;
            return ContainerUtil.exists((Object[])directives, it -> it.equals(literal.getStringValue()));
        }
        return false;
    }

    @Nullable
    public static JSQualifiedNamedElement getInitializedElement(@NotNull JSExpression expression) {
        if (expression == null) {
            JSPsiImplUtils.$$$reportNull$$$0(57);
        }
        return JSPsiImplUtils.getInitializedElement(expression, true);
    }

    @Nullable
    public static JSQualifiedNamedElement getInitializedElement(@NotNull JSExpression expression, boolean isAstAccessAllowed) {
        JSDefinitionExpression definitionExpression;
        PsiElement parent;
        if (expression == null) {
            JSPsiImplUtils.$$$reportNull$$$0(58);
        }
        PsiElement psiElement = parent = isAstAccessAllowed ? JSUtils.getParentSkipParentheses((PsiElement)expression) : JSStubBasedPsiTreeUtil.getParentOrNull((PsiElement)expression);
        if (parent instanceof JSProperty || parent instanceof JSVariable) {
            return (JSQualifiedNamedElement)parent;
        }
        if (parent instanceof JSAssignmentExpression && (definitionExpression = ((JSAssignmentExpression)parent).getDefinitionExpression()) != expression) {
            return definitionExpression;
        }
        return null;
    }

    @Nullable
    public static JSNamedElementBase getInitializedElement(@NotNull JSExpression expression, boolean isAstAccessAllowed, boolean isResolveAllowed) {
        PsiElement parent;
        JSQualifiedNamedElement initializedElement;
        if (expression == null) {
            JSPsiImplUtils.$$$reportNull$$$0(59);
        }
        if ((initializedElement = JSPsiImplUtils.getInitializedElement(expression, isAstAccessAllowed)) != null) {
            return initializedElement;
        }
        if (isResolveAllowed && (parent = expression.getParent()) instanceof JSArgumentList) {
            return JSResolveUtil.findParameterForUsedArgument(expression, (JSArgumentList)parent);
        }
        return null;
    }

    @NotNull
    public static String getNameFromIdentifier(@NotNull ASTNode nameIdentifier) {
        Double aDouble;
        if (nameIdentifier == null) {
            JSPsiImplUtils.$$$reportNull$$$0(60);
        }
        String text = nameIdentifier.getText();
        if (nameIdentifier.getElementType() == JSTokenTypes.NUMERIC_LITERAL && (aDouble = JSNumberParser.tryParseNumericValue(text, false)) != null) {
            return JSPsiImplUtils.convertECMAScriptNumberToString(aDouble);
        }
        String string = JSStringUtil.unquoteAndUnescapeString(text);
        if (string == null) {
            JSPsiImplUtils.$$$reportNull$$$0(61);
        }
        return string;
    }

    @NotNull
    public static String convertECMAScriptNumberToString(double aDouble) {
        String string = ScriptRuntime.toString(aDouble);
        if (string == null) {
            JSPsiImplUtils.$$$reportNull$$$0(62);
        }
        return string;
    }

    @Nullable
    public static PsiComment findTrailingEndOfLineComment(@NotNull PsiElement element) {
        PsiElement sibling;
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(63);
        }
        if ((sibling = PsiTreeUtil.skipWhitespacesForward((PsiElement)element)) instanceof PsiComment && (sibling.getPrevSibling() == element || JSPsiImplUtils.hasInlineWhitespaceBefore(sibling))) {
            return (PsiComment)sibling;
        }
        return null;
    }

    @Contract(value="!null -> !null")
    @Nullable
    public static PsiElement findLeadingCommentOrSelf(@Nullable PsiElement element) {
        return JSPsiImplUtils.findLeadingCommentOrSelf(element, false);
    }

    @Contract(value="!null, _ -> !null")
    @Nullable
    public static PsiElement findLeadingCommentOrSelf(@Nullable PsiElement element, boolean contiguous) {
        if (element == null) {
            return null;
        }
        return (PsiElement)ObjectUtils.coalesce((Object)JSPsiImplUtils.findLeadingComment(element, contiguous), (Object)element);
    }

    @Nullable
    public static PsiComment findLeadingComment(@NotNull PsiElement element) {
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(64);
        }
        return JSPsiImplUtils.findLeadingComment(element, false);
    }

    @Nullable
    public static PsiComment findLeadingComment(@NotNull PsiElement element, boolean contiguous) {
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(65);
        }
        PsiElement comment = PsiTreeUtil.skipWhitespacesBackward((PsiElement)element);
        if (!contiguous) {
            return JSPsiImplUtils.isLeadingComment(comment) ? (PsiComment)comment : null;
        }
        PsiElement leading = null;
        PsiElement anchor = comment;
        while (JSPsiImplUtils.isLeadingComment(anchor)) {
            leading = anchor;
            anchor = PsiTreeUtil.skipWhitespacesBackward((PsiElement)anchor);
        }
        return (PsiComment)ObjectUtils.tryCast((Object)leading, PsiComment.class);
    }

    private static boolean isLeadingComment(@Nullable PsiElement element) {
        PsiElement afterComment;
        return element instanceof PsiComment && !FlowJSAnnotation.isFlowComment((PsiComment)element) && (afterComment = element.getNextSibling()) instanceof PsiWhiteSpace && StringUtil.countChars((CharSequence)afterComment.getText(), (char)'\n') <= 1 && !JSPsiImplUtils.hasInlineWhitespaceBefore(element);
    }

    public static boolean isGetterOrSetter(@NotNull JSFunctionItem function) {
        if (function == null) {
            JSPsiImplUtils.$$$reportNull$$$0(66);
        }
        return function.isGetProperty() || function.isSetProperty();
    }

    private static boolean hasInlineWhitespaceBefore(@NotNull PsiElement comment) {
        PsiElement prevSibling;
        if (comment == null) {
            JSPsiImplUtils.$$$reportNull$$$0(67);
        }
        if ((prevSibling = comment.getPrevSibling()) == null) {
            return false;
        }
        if (!(prevSibling instanceof PsiWhiteSpace)) {
            return true;
        }
        return !prevSibling.textContains('\n');
    }

    public static boolean isIIFE(@NotNull PsiElement function) {
        if (function == null) {
            JSPsiImplUtils.$$$reportNull$$$0(68);
        }
        if (!(function instanceof JSFunctionExpression)) {
            return false;
        }
        JSExpression node = JSUtils.getTopmostParenthesizedOrSelf((JSFunctionExpression)function);
        PsiElement call = node.getParent();
        return call instanceof JSCallExpression && ((JSCallExpression)call).getMethodExpression() == node;
    }

    @NotNull
    public static List<PsiElement> getSiblingsForward(@NotNull PsiElement start, @NotNull PsiElement end) {
        if (start == null) {
            JSPsiImplUtils.$$$reportNull$$$0(69);
        }
        if (end == null) {
            JSPsiImplUtils.$$$reportNull$$$0(70);
        }
        if (start == end) {
            return new SmartList((Object)start);
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        result.add(start);
        PsiElement current = start;
        do {
            result.add(current);
            current = current.getNextSibling();
            if (current != null) continue;
            ArrayList<PsiElement> arrayList = result;
            if (arrayList == null) {
                JSPsiImplUtils.$$$reportNull$$$0(71);
            }
            return arrayList;
        } while (current != end);
        result.add(current);
        ArrayList<PsiElement> arrayList = result;
        if (arrayList == null) {
            JSPsiImplUtils.$$$reportNull$$$0(72);
        }
        return arrayList;
    }

    @Nullable
    public static JSStatement findFirstFunctionStatement(@Nullable JSFunction function) {
        if (function == null) {
            return null;
        }
        JSBlockStatement body = function.getBlock();
        return JSPsiImplUtils.findFirstStatement(body);
    }

    @Nullable
    public static JSStatement findFirstStatement(@Nullable PsiElement parent) {
        return JSPsiImplUtils.findFirstStatement(parent, true);
    }

    @Nullable
    public static JSStatement findFirstStatementOrDirective(@Nullable PsiElement parent) {
        return JSPsiImplUtils.findFirstStatement(parent, false);
    }

    @Nullable
    private static JSStatement findFirstStatement(@Nullable PsiElement parent, boolean skipDirectives) {
        PsiElement element;
        if (parent == null) {
            return null;
        }
        for (element = parent.getFirstChild(); element != null && !(element instanceof JSStatement) || skipDirectives && JSPsiImplUtils.isCompilerDirectiveStatement(element); element = element.getNextSibling()) {
        }
        return (JSStatement)element;
    }

    @Nullable
    public static JSFunction getParentFunctionThroughLambdas(@Nullable PsiElement parent) {
        JSQualifiedNamedElement parentFunction = JSPsiImplUtils.getParentFunctionOrClassThroughLambdas(parent);
        return (JSFunction)ObjectUtils.tryCast((Object)parentFunction, JSFunction.class);
    }

    @Nullable
    public static JSQualifiedNamedElement getParentFunctionOrClassThroughLambdas(@Nullable PsiElement element) {
        JSQualifiedNamedElement parent = (JSQualifiedNamedElement)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{JSFunction.class, JSClass.class});
        if (parent instanceof JSFunction && ((JSFunction)parent).isArrowFunction()) {
            return JSPsiImplUtils.getParentFunctionOrClassThroughLambdas((PsiElement)parent);
        }
        return parent;
    }

    @Nullable
    public static String getValidNameFromComputedName(@Nullable ES6ComputedName computedName) {
        return computedName != null ? computedName.getExpressionAsPropertyName() : null;
    }

    public static boolean calculateTypeOfVariableForIteratedExpression(@NotNull JSTypeEvaluator evaluator, @Nullable PsiElement expression, @Nullable JSExpression rawQualifier) {
        if (evaluator == null) {
            JSPsiImplUtils.$$$reportNull$$$0(73);
        }
        JSExpression arrayExpression = null;
        if (expression instanceof JSReferenceExpression) {
            Object resolve = ((JSReferenceExpression)expression).resolve();
            if (resolve != null) {
                JSType type;
                if (resolve instanceof JSTypeDeclarationOwner && (type = ((JSTypeDeclarationOwner)resolve).getJSType()) != null) {
                    return evaluator.addComponentTypeFromProcessor((JSExpression)expression, type) != null;
                }
                if ((resolve = JSPsiImplUtils.getAssignedExpression(resolve)) != null) {
                    arrayExpression = (JSExpression)resolve;
                }
            }
        } else if (expression instanceof JSExpression) {
            arrayExpression = (JSExpression)expression;
        }
        if (expression != null && arrayExpression != null) {
            return evaluator.addComponentTypeFromArrayExpression(rawQualifier, arrayExpression) != null;
        }
        return false;
    }

    @Contract(value="null,_ -> false")
    public static boolean hasModifier(@Nullable JSAttributeList attributeList, @NotNull JSAttributeList.ModifierType modifier) {
        if (modifier == null) {
            JSPsiImplUtils.$$$reportNull$$$0(74);
        }
        return attributeList != null && attributeList.hasModifier(modifier);
    }

    @Contract(value="null,_ -> false")
    public static boolean hasModifier(@Nullable JSAttributeListOwner attributeListOwner, @NotNull JSAttributeList.ModifierType modifier) {
        if (modifier == null) {
            JSPsiImplUtils.$$$reportNull$$$0(75);
        }
        if (attributeListOwner == null) {
            return false;
        }
        return JSPsiImplUtils.hasModifier(attributeListOwner.getAttributeList(), modifier);
    }

    @Contract(value="null -> false")
    public static boolean isEmbeddedTypeContext(@Nullable PsiElement parent) {
        return parent instanceof JSEmbeddedContent && parent.getNode().getElementType() == JSElementTypes.XML_JS_GENERIC_ARG_SCRIPT;
    }

    @Contract(value="null -> false")
    public static boolean isEmbeddedExpressionContent(@Nullable PsiElement parent) {
        return parent instanceof JSEmbeddedContent && parent.getNode().getElementType() == JSElementTypes.EMBEDDED_EXPRESSION || parent instanceof JSEmbeddedContent && parent.getNode().getElementType() == JSElementTypes.XML_JS_SCRIPT;
    }

    @Contract(value="null -> false")
    public static boolean isCatchParameter(@Nullable PsiElement element) {
        return element instanceof JSParameter && element.getParent() instanceof JSCatchBlock;
    }

    @Nullable
    public static String getInitializerReference(@NotNull JSInitializerOwner element) {
        String string;
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(76);
        }
        if (!(element instanceof JSTypeOwner)) {
            return null;
        }
        JSTypeOwner typeOwner = (JSTypeOwner)((Object)element);
        JSType type = (JSType)JSBuiltInTypeEngineEvaluation.INSTANCE.forceTypeEngine(typeOwner::getJSType);
        if (type instanceof JSTypeofTypeImpl) {
            JSTypeofTypeImpl typeofType = (JSTypeofTypeImpl)type;
            type = typeofType.getLocallyEvaluatedType();
        }
        if (type instanceof JSReferenceType) {
            JSReferenceType referenceType = (JSReferenceType)type;
            string = referenceType.getReferenceName();
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public static String getInitializerReference(@NotNull JSInitializerOwner element, boolean allowAstAccess) {
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(77);
        }
        if (!allowAstAccess) {
            return JSPsiImplUtils.getInitializerReference(element);
        }
        JSReferenceExpression initializer = (JSReferenceExpression)ObjectUtils.tryCast((Object)element.getInitializer(), JSReferenceExpression.class);
        return initializer != null && initializer.getQualifier() == null ? initializer.getReferenceName() : null;
    }

    @Nullable
    public static JSExpression getElvisQualifier(@NotNull JSElvisOwner elvisOwner) {
        if (elvisOwner == null) {
            JSPsiImplUtils.$$$reportNull$$$0(78);
        }
        return elvisOwner instanceof JSCallExpression ? ((JSCallExpression)elvisOwner).getMethodExpression() : (elvisOwner instanceof JSQualifiedExpression ? ((JSQualifiedExpression)((Object)elvisOwner)).getQualifier() : null);
    }

    public static boolean isElvisOrInOptChain(@NotNull JSElvisOwner elvisOwner) {
        if (elvisOwner == null) {
            JSPsiImplUtils.$$$reportNull$$$0(79);
        }
        while (!elvisOwner.isElvis()) {
            JSExpression parent = JSPsiImplUtils.getElvisQualifier(elvisOwner);
            if (!(parent instanceof JSElvisOwner)) {
                return false;
            }
            elvisOwner = (JSElvisOwner)parent;
        }
        return true;
    }

    public static boolean isUnqualifiedAssignment(@NotNull JSDefinitionExpression definitionExpression) {
        JSNamespace ns;
        if (definitionExpression == null) {
            JSPsiImplUtils.$$$reportNull$$$0(80);
        }
        return (ns = definitionExpression.getJSNamespace()).getQualifiedName() == null && ns.isSourceStrict();
    }

    public static TextRange @NotNull [] getTemplateStringRanges(@NotNull PsiElement element, boolean includeEmpty) {
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(81);
        }
        ASTNode[] children = element.getNode().getChildren(null);
        ArrayList<TextRange> result = new ArrayList<TextRange>(children.length);
        int parentStart = element.getTextRange().getStartOffset();
        IElementType prevElementType = null;
        for (ASTNode child : children) {
            IElementType childElementType = child.getElementType();
            if (includeEmpty && (childElementType == JSTokenTypes.BACKQUOTE && prevElementType == JSTokenTypes.BACKQUOTE || childElementType == JSTokenTypes.DOLLAR && prevElementType != JSTokenTypes.STRING_TEMPLATE_PART || childElementType == JSTokenTypes.BACKQUOTE && prevElementType == JSTokenTypes.RBRACE)) {
                result.add(TextRange.from((int)(child.getTextRange().getStartOffset() - parentStart), (int)0));
            }
            if (childElementType == JSTokenTypes.STRING_TEMPLATE_PART) {
                result.add(child.getTextRange().shiftLeft(parentStart));
            }
            prevElementType = childElementType;
        }
        TextRange[] textRangeArray = result.toArray(TextRange.EMPTY_ARRAY);
        if (textRangeArray == null) {
            JSPsiImplUtils.$$$reportNull$$$0(82);
        }
        return textRangeArray;
    }

    public static boolean isPotentialOverride(@NotNull JSFunctionItem functionItem) {
        JSDocComment docComment;
        if (functionItem == null) {
            JSPsiImplUtils.$$$reportNull$$$0(83);
        }
        if (functionItem.isOverride()) {
            return true;
        }
        JSClass aClass = JSUtils.getMemberContainingClass((PsiElement)functionItem);
        if (aClass == null) {
            return false;
        }
        if (aClass.getExtendsList() != null || aClass.getImplementsList() != null) {
            return true;
        }
        if (!(aClass instanceof JSImplicitElementProvider)) {
            return false;
        }
        JSElementIndexingData data = ((JSImplicitElementProvider)((Object)aClass)).getIndexingData();
        if (data == null && (docComment = JSStubBasedPsiTreeUtil.findOwnDocComment(aClass)) != null) {
            data = docComment.getIndexingData();
        }
        return data != null && !ContainerUtil.isEmpty(data.getBaseTypes());
    }

    @Nullable
    public static JSStatement getBreakOrContinueTarget(@NotNull PsiElement breakOrContinue) {
        JSStatement breakOrContinueTarget;
        if (breakOrContinue == null) {
            JSPsiImplUtils.$$$reportNull$$$0(84);
        }
        JSStatement jSStatement = breakOrContinue instanceof JSBreakStatement ? ((JSBreakStatement)breakOrContinue).getStatementToBreak() : (breakOrContinueTarget = breakOrContinue instanceof JSContinueStatement ? ((JSContinueStatement)breakOrContinue).getStatementToContinue() : null);
        while (breakOrContinueTarget instanceof JSLabeledStatement) {
            breakOrContinueTarget = ((JSLabeledStatement)breakOrContinueTarget).getStatement();
        }
        return breakOrContinueTarget;
    }

    @NotNull
    public static List<JSWithStatement> getWithStatementContexts(@NotNull JSReferenceExpression expression) {
        if (expression == null) {
            JSPsiImplUtils.$$$reportNull$$$0(85);
        }
        if (expression.getQualifier() != null) {
            List<JSWithStatement> list = Collections.emptyList();
            if (list == null) {
                JSPsiImplUtils.$$$reportNull$$$0(86);
            }
            return list;
        }
        JSWithStatement withStatement = (JSWithStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, JSWithStatement.class);
        if (withStatement == null) {
            List<JSWithStatement> list = Collections.emptyList();
            if (list == null) {
                JSPsiImplUtils.$$$reportNull$$$0(87);
            }
            return list;
        }
        ArrayList<JSWithStatement> statements = new ArrayList<JSWithStatement>();
        statements.add(withStatement);
        while ((withStatement = (JSWithStatement)PsiTreeUtil.getParentOfType((PsiElement)withStatement, JSWithStatement.class, (boolean)true)) != null) {
            statements.add(withStatement);
        }
        ArrayList<JSWithStatement> arrayList = statements;
        if (arrayList == null) {
            JSPsiImplUtils.$$$reportNull$$$0(88);
        }
        return arrayList;
    }

    @Nullable
    public static JSParameterItem findParameterByName(@NotNull JSFunctionItem function, @NotNull String name) {
        if (function == null) {
            JSPsiImplUtils.$$$reportNull$$$0(89);
        }
        if (name == null) {
            JSPsiImplUtils.$$$reportNull$$$0(90);
        }
        return (JSParameterItem)ContainerUtil.find((Object[])function.getParameterVariables(), it -> name.equals(it.getName()));
    }

    public static boolean isDynamicJSCode(@NotNull JSLiteralExpression host) {
        PsiElement parent;
        if (host == null) {
            JSPsiImplUtils.$$$reportNull$$$0(91);
        }
        if (!((parent = JSUtils.getParentSkipParentheses((PsiElement)host)) instanceof JSCallExpression)) {
            return false;
        }
        JSCallExpression callExpression = (JSCallExpression)parent;
        JSExpression methodExpression = callExpression.getMethodExpression();
        if (!(methodExpression instanceof JSReferenceExpression)) {
            return false;
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)methodExpression;
        String referenceName = referenceExpression.getReferenceName();
        if (referenceName == null) {
            return false;
        }
        if (!(referenceName.equals("eval") || referenceName.equals("setTimeout") || referenceName.equals("setInterval"))) {
            return false;
        }
        if (JSUtils.unparenthesize((JSExpression)ArrayUtil.getFirstElement((Object[])callExpression.getArguments())) != host) {
            return false;
        }
        JSExpression qualifier = referenceExpression.getQualifier();
        return qualifier == null || JSSymbolUtil.isAccurateReferenceExpressionName(qualifier, "window");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 22, 24, 30, 31, 32, 33, 50, 51, 52, 53, 61, 62, 71, 72, 82, 86, 87, 88 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 22: 
            case 24: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 61: 
            case 62: 
            case 71: 
            case 72: 
            case 82: 
            case 86: 
            case 87: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementBase";
                break;
            }
            case 8: 
            case 34: 
            case 57: 
            case 58: 
            case 59: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeList";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
            case 15: 
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 17: 
            case 38: 
            case 40: 
            case 45: 
            case 46: 
            case 55: 
            case 66: 
            case 68: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isAcceptable";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializerOwner";
                break;
            }
            case 49: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitionExpression";
                break;
            }
            case 54: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameIdentifier";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directives";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
            case 74: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 78: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elvisOwner";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionItem";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakOrContinue";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findTopLevelNavigatableElement";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastLeafChild";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstLeafChild";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentifiers";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessType";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameFromIdentifier";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "convertECMAScriptNumberToString";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getSiblingsForward";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateStringRanges";
                break;
            }
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getWithStatementContexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStubOrPsiTypeElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findTopLevelNavigatableElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 22: 
            case 24: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 61: 
            case 62: 
            case 71: 
            case 72: 
            case 82: 
            case 86: 
            case 87: 
            case 88: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findTopLevelNavigatableElementWithSource";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNamespace";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceFromJSNamespace";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getJSNamespaceFromInitializedElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixFromName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceFromParent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildNamespaceFromQualifiedName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromAnnotationParameter";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getQNameForMove";
                break;
            }
            case 15: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findNameIdentifierOfFunction";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "parensAroundArrowFunctionParametersRequired";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processTopLevelComment";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isArgumentOfCallWithName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getLastLeafChild";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getFirstLeafChild";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isConst";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isLet";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isVar";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "variableDeclaredWith";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isReturnedFromFunction";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findFallbackNameIdentifierOfVariable";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findNameIdentifierOf";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getReturnedExpressionIfShorthandArrowFunction";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isShorthandArrowFunction";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getReturnedExpressionIfSingle";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getNonParenthesizeParent";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "calculatePossibleFunction";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getRightmostInitializer";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "findConstructsFunction";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "findFunctionQualifiedName";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "findFunctionName";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isGetProperty";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isSetProperty";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getRightmostOperand";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "findElementFromNameIdentifier";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "signatureIsExplicitlyDeclared";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isCompilerDirectiveStatement";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getInitializedElement";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getNameFromIdentifier";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "findTrailingEndOfLineComment";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "findLeadingComment";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "isGetterOrSetter";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "hasInlineWhitespaceBefore";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "isIIFE";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getSiblingsForward";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "calculateTypeOfVariableForIteratedExpression";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "hasModifier";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getInitializerReference";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getElvisQualifier";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "isElvisOrInOptChain";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "isUnqualifiedAssignment";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateStringRanges";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "isPotentialOverride";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getBreakOrContinueTarget";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getWithStatementContexts";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "findParameterByName";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "isDynamicJSCode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 22, 24, 30, 31, 32, 33, 50, 51, 52, 53, 61, 62, 71, 72, 82, 86, 87, 88 -> new IllegalStateException(string);
        };
    }

    static enum NamedEntityKind {
        Function,
        Variable;

    }
}

