/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptConditionalType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContextualUnionType;
import com.intellij.lang.javascript.psi.types.JSContextualUnionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSDistributedType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSKeyofType;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSReadonlyArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSpreadType;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTemplateLiteralType;
import com.intellij.lang.javascript.psi.types.JSTupleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeGenericId;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.JSUnknownType;
import com.intellij.lang.javascript.psi.types.JSUtilType;
import com.intellij.lang.javascript.psi.types.TypeScriptAwaitedJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptConditionalTypeGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptConditionalTypeJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptIndexedAccessJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptMappedJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptObjectJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeOperatorJSTypeImpl;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSBigIntTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSSymbolType;
import com.intellij.lang.javascript.psi.types.primitives.JSSymbolTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverType;
import com.intellij.lang.javascript.psi.types.recordImpl.CallSignatureImpl;
import com.intellij.lang.javascript.psi.types.recordImpl.IndexSignatureImpl;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericParameterImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSCompositeTypeFactory {
    private static final Set<Class<? extends JSType>> PRIMITIVES = Set.of(JSStringTypeImpl.class, JSNumberTypeImpl.class, JSBooleanTypeImpl.class, JSBigIntTypeImpl.class);
    private static final Set<Class<? extends JSType>> IMPOSSIBLE_COMBINATIONS = Set.of(JSNullType.class, JSUndefinedType.class, JSStringTypeImpl.class, JSNumberTypeImpl.class, JSBooleanTypeImpl.class, JSBigIntTypeImpl.class, JSSymbolTypeImpl.class, TypeScriptObjectJSTypeImpl.class, JSVoidType.class);

    @NotNull
    public static JSType createIntersectionType(@NotNull Collection<? extends JSType> types, @NotNull JSTypeSource source) {
        if (types == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(0);
        }
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(1);
        }
        return JSCompositeTypeFactory.createIntersectionType(types, source, false);
    }

    @NotNull
    public static JSType createIntersectionType(@NotNull Collection<? extends JSType> types, @NotNull JSTypeSource source, boolean allowResolve) {
        if (types == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(2);
        }
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(3);
        }
        return JSCompositeTypeFactory.createIntersectionType(types, source, allowResolve ? JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_SIMPLE : JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_NO_RESOLVE);
    }

    @NotNull
    public static JSType createIntersectionType(@NotNull Collection<? extends JSType> types, @NotNull JSTypeSource source, @NotNull JSUnionOrIntersectionType.OptimizedKind targetKind) {
        if (types == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(4);
        }
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(5);
        }
        if (targetKind == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(6);
        }
        if (types.size() == 1) {
            JSType jSType = (JSType)ContainerUtil.getFirstItem(types);
            if (jSType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(7);
            }
            return jSType;
        }
        Collection<? extends JSType> resultTypes = JSCompositeTypeFactory.optimizeIntersectionTypes(types, source, targetKind, true);
        if (resultTypes.isEmpty()) {
            JSType jSType = JSNamedTypeFactory.createType("unknown", source, JSTypeContext.UNKNOWN);
            if (jSType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(8);
            }
            return jSType;
        }
        if (resultTypes.size() == 1) {
            JSType jSType = resultTypes.iterator().next();
            if (jSType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(9);
            }
            return jSType;
        }
        return new JSIntersectionTypeImpl(source, JSCompositeTypeBaseImpl.flattenTypes(resultTypes, JSIntersectionType.class));
    }

    @NotNull
    public static JSType createContextualUnionType(@NotNull Collection<? extends JSType> types, @NotNull JSTypeSource source) {
        if (types == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(10);
        }
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(11);
        }
        return JSCompositeTypeFactory.createContextualUnionType(types, source, true);
    }

    @NotNull
    public static JSType createContextualUnionType(@NotNull Collection<? extends JSType> types, @NotNull JSTypeSource source, boolean allowResolve) {
        JSType result;
        if (types == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(12);
        }
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(13);
        }
        if ((result = JSCompositeTypeFactory.getContextualForCallSignatures(types, source)) != null) {
            JSType jSType = result;
            if (jSType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(14);
            }
            return jSType;
        }
        Collection<? extends JSType> results = JSCompositeTypeFactory.optimizeIntersectionTypes(types, source, allowResolve ? JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_SIMPLE : JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_NO_RESOLVE, false);
        if (results.isEmpty()) {
            JSAnyType jSAnyType = JSAnyType.get(source);
            if (jSAnyType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(15);
            }
            return jSAnyType;
        }
        if (results.size() == 1) {
            JSType jSType = results.iterator().next();
            if (jSType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(16);
            }
            return jSType;
        }
        return new JSContextualUnionTypeImpl(source, JSCompositeTypeBaseImpl.flattenTypes(results, JSContextualUnionTypeImpl.class));
    }

    @NotNull
    public static JSType createTupleType(@NotNull JSTypeSource source, @NotNull List<? extends JSType> _types, boolean strict, int firstOptional, boolean isReadonly) {
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(17);
        }
        if (_types == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(18);
        }
        return JSCompositeTypeFactory.createTupleType(source, _types, Collections.emptyList(), strict, firstOptional, isReadonly);
    }

    @NotNull
    public static JSType createTupleType(@NotNull JSTypeSource source, @NotNull List<? extends JSType> _types, @NotNull List<String> names, boolean strict, int firstOptional, boolean isReadonly) {
        JSType singleType;
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(19);
        }
        if (_types == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(20);
        }
        if (names == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(21);
        }
        if (_types.size() == 1 && (singleType = _types.iterator().next()) instanceof JSSpreadType && ((JSSpreadType)((Object)singleType)).isRest()) {
            JSType componentType = ((JSSpreadType)((Object)singleType)).getComponentType();
            if (!isReadonly) {
                return new JSArrayTypeImpl(componentType, source);
            }
            return new JSReadonlyArrayTypeImpl(componentType, source);
        }
        return new JSTupleTypeImpl(source, _types, names, strict, firstOptional, isReadonly);
    }

    @NotNull
    public static JSType createUnionType(@NotNull JSTypeSource source, @NotNull Collection<? extends JSType> _types) {
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(22);
        }
        if (_types == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(23);
        }
        if (_types.isEmpty()) {
            TypeScriptNeverType typeScriptNeverType = JSNamedTypeFactory.createNeverType(source);
            if (typeScriptNeverType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(24);
            }
            return typeScriptNeverType;
        }
        if (_types.size() == 1) {
            JSType jSType = _types.iterator().next();
            if (jSType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(25);
            }
            return jSType;
        }
        List<JSType> flattenedTypes = JSCompositeTypeBaseImpl.flattenTypes(JSCompositeTypeFactory.collapseTypesForUnion(_types, source.isJavaScript()), JSUnionType.class);
        if (flattenedTypes.isEmpty()) {
            TypeScriptNeverType typeScriptNeverType = JSNamedTypeFactory.createNeverType(source);
            if (typeScriptNeverType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(26);
            }
            return typeScriptNeverType;
        }
        if (flattenedTypes.size() == 1) {
            JSType jSType = flattenedTypes.iterator().next();
            if (jSType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(27);
            }
            return jSType;
        }
        return new JSCompositeTypeImpl(source, flattenedTypes);
    }

    @NotNull
    public static List<? extends JSType> collapseTypesForUnion(@NotNull Collection<? extends JSType> _types, boolean isJavaScript) {
        if (_types == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(28);
        }
        boolean hasBoolean = false;
        boolean hasTrueValue = false;
        boolean hasFalseValue = false;
        boolean hasNever = false;
        for (JSType jSType : _types) {
            if (jSType instanceof JSAnyType && !isJavaScript && !(jSType instanceof JSUnknownType)) {
                List<JSType> list = List.of(jSType);
                if (list == null) {
                    JSCompositeTypeFactory.$$$reportNull$$$0(29);
                }
                return list;
            }
            if (jSType instanceof JSBooleanLiteralTypeImpl) {
                if (((JSBooleanLiteralTypeImpl)jSType).allowWidening()) continue;
                boolean literal = ((JSBooleanLiteralTypeImpl)jSType).getLiteral();
                hasTrueValue |= literal == Boolean.TRUE;
                hasFalseValue |= literal == Boolean.FALSE;
                continue;
            }
            if (jSType instanceof JSBooleanType) {
                hasBoolean = true;
                continue;
            }
            if (!(jSType instanceof TypeScriptNeverType)) continue;
            hasNever = true;
        }
        if (hasBoolean) {
            List list = ((StreamEx)StreamEx.of(_types).filter(t -> !(t instanceof JSBooleanLiteralTypeImpl) && !(t instanceof TypeScriptNeverType))).toList();
            if (list == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(30);
            }
            return list;
        }
        if (!hasTrueValue || !hasFalseValue) {
            if (!hasNever && _types instanceof List) {
                List list = (List)_types;
                if (list == null) {
                    JSCompositeTypeFactory.$$$reportNull$$$0(31);
                }
                return list;
            }
            List list = ((StreamEx)StreamEx.of(_types).filter(t -> !(t instanceof TypeScriptNeverType))).toList();
            if (list == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(32);
            }
            return list;
        }
        JSBooleanType type = JSNamedTypeFactory.createBooleanPrimitiveType(_types.iterator().next().getSource());
        List list = ((StreamEx)StreamEx.of((Object)type).append(_types).filter(t -> !(t instanceof JSBooleanLiteralTypeImpl) && !(t instanceof TypeScriptNeverType))).toList();
        if (list == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(33);
        }
        return list;
    }

    public static JSType createUnionType(@NotNull JSTypeSource source, JSType ... _types) {
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(34);
        }
        return JSCompositeTypeFactory.createUnionType(source, Arrays.asList(_types));
    }

    @NotNull
    static Collection<? extends JSType> optimizeIntersectionTypes(@NotNull Collection<? extends JSType> types, @NotNull JSTypeSource source, @NotNull JSUnionOrIntersectionType.OptimizedKind targetKind, boolean asIntersection) {
        JSType simplifiedType;
        Collection<? extends JSType> plainTypes;
        if (types == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(35);
        }
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(36);
        }
        if (targetKind == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(37);
        }
        if ((plainTypes = JSCompositeTypeFactory.flattenAndDeduplicate(types, Collections.emptySet(), targetKind, !asIntersection)).isEmpty()) {
            List<? extends JSType> list = plainTypes;
            if (list == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(38);
            }
            return list;
        }
        if (plainTypes.size() == 1) {
            List<? extends JSType> list = plainTypes;
            if (list == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(39);
            }
            return list;
        }
        if (asIntersection) {
            if (JSCompositeTypeFactory.hasAnyType(plainTypes)) {
                JSType item = (JSType)ContainerUtil.getFirstItem(plainTypes);
                assert (item != null);
                List<JSAnyType> list = Collections.singletonList(JSAnyType.get(source));
                if (list == null) {
                    JSCompositeTypeFactory.$$$reportNull$$$0(40);
                }
                return list;
            }
            boolean hasNullOrUndefined = false;
            boolean hasEmptyObjectType = false;
            for (JSType jSType : plainTypes) {
                if (jSType instanceof JSNullType || jSType instanceof JSUndefinedType) {
                    hasNullOrUndefined = true;
                }
                if (!JSCompositeTypeFactory.isEmptyObjectType(jSType)) continue;
                hasEmptyObjectType = true;
            }
            if (hasNullOrUndefined && hasEmptyObjectType) {
                List<TypeScriptNeverType> list = Collections.singletonList(JSNamedTypeFactory.createNeverType(source));
                if (list == null) {
                    JSCompositeTypeFactory.$$$reportNull$$$0(41);
                }
                return list;
            }
        }
        if (asIntersection) {
            plainTypes = JSCompositeTypeFactory.removeRedundantSupertypes(plainTypes);
        }
        if ((simplifiedType = JSCompositeTypeFactory.normalizeIfPossible(plainTypes, source, targetKind, asIntersection)) != null) {
            List<JSType> list = Collections.singletonList(simplifiedType);
            if (list == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(42);
            }
            return list;
        }
        Collection<? extends JSType> collection = plainTypes;
        if (collection == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(43);
        }
        return collection;
    }

    @Nullable
    static JSType normalizeIfPossible(@NotNull Collection<? extends JSType> plainTypes, @NotNull JSTypeSource source, @NotNull JSUnionOrIntersectionType.OptimizedKind targetKind, boolean intersection) {
        if (plainTypes == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(44);
        }
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(45);
        }
        if (targetKind == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(46);
        }
        ProgressManager.checkCanceled();
        if (!intersection) {
            return null;
        }
        JSType impossibleType = JSCompositeTypeFactory.getTypeForImpossibleTypeCombination(plainTypes, source, targetKind);
        if (impossibleType != null) {
            return impossibleType;
        }
        int i = -1;
        for (JSType jSType : plainTypes) {
            ++i;
            if (!(jSType instanceof JSUnionType)) continue;
            List<JSType> parts = ((JSUnionType)jSType).getTypes();
            ArrayList<JSType> newParts = new ArrayList<JSType>(parts.size());
            ArrayList<? extends JSType> typesCopy = new ArrayList<JSType>(plainTypes);
            for (JSType part : parts) {
                ProgressManager.checkCanceled();
                typesCopy.set(i, part);
                newParts.add(JSCompositeTypeFactory.createIntersectionType(typesCopy, source, targetKind));
            }
            return JSCompositeTypeFactory.createUnionType(source, newParts);
        }
        return null;
    }

    private static boolean isDefinitelyNotNull(@NotNull JSType type) {
        if (type == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(47);
        }
        return type instanceof TypeScriptObjectJSTypeImpl || TypeScriptTypeRelations.isObjectType(type);
    }

    @NotNull
    private static Collection<? extends JSType> removeRedundantSupertypes(@NotNull Collection<? extends JSType> types) {
        boolean bl;
        if (types == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(48);
        }
        @NotNull MultiMap primitives = MultiMap.createSet();
        HashSet primitiveLiterals = new HashSet();
        boolean definitelyNotNull = true;
        boolean hasEmptyObjectType = false;
        for (JSType jSType : types) {
            if (PRIMITIVES.contains(jSType.getClass())) {
                primitives.putValue(jSType.getClass(), (Object)jSType);
            }
            if (jSType instanceof JSPrimitiveLiteralType && !((JSPrimitiveLiteralType)jSType).allowWidening()) {
                primitiveLiterals.add(((JSPrimitiveLiteralType)jSType).asPrimitiveType().getClass());
            }
            if (JSCompositeTypeFactory.isEmptyObjectType(jSType)) {
                hasEmptyObjectType = true;
            }
            definitelyNotNull &= JSCompositeTypeFactory.isDefinitelyNotNull(jSType);
        }
        boolean processEmptyObjectType = hasEmptyObjectType && definitelyNotNull;
        boolean bl2 = bl = !primitiveLiterals.isEmpty() && !primitives.isEmpty();
        if (!bl && !processEmptyObjectType) {
            Collection<? extends JSType> collection = types;
            if (collection == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(49);
            }
            return collection;
        }
        boolean hasModifications = false;
        ArrayList<? extends JSType> newTypes = new ArrayList<JSType>(types);
        if (processEmptyObjectType) {
            hasModifications = true;
            newTypes.removeIf(el -> JSCompositeTypeFactory.isEmptyObjectType(el));
        }
        if (bl) {
            for (Class clazz : primitiveLiterals) {
                if (!primitives.containsKey((Object)clazz)) continue;
                newTypes.removeAll(primitives.get((Object)clazz));
                hasModifications = true;
            }
        }
        Collection<? extends JSType> collection = hasModifications ? newTypes : types;
        if (collection == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(50);
        }
        return collection;
    }

    private static boolean isEmptyObjectType(@Nullable JSType type) {
        return type instanceof JSRecordType && !((JSRecordType)type).hasMembers();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static JSType getTypeForImpossibleTypeCombination(@NotNull Collection<? extends JSType> plainTypes, @NotNull JSTypeSource source, @NotNull JSUnionOrIntersectionType.OptimizedKind targetKind) {
        if (plainTypes == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(51);
        }
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(52);
        }
        if (targetKind == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(53);
        }
        boolean allowResolve = targetKind != JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_NO_RESOLVE;
        HashSet primitives = new HashSet();
        boolean hasNull = false;
        boolean hasUndefined = false;
        boolean hasPrimitive = false;
        boolean isStrictNullChecks = allowResolve && TypeScriptConfigUtil.strictNullChecks(source.getSourceElement());
        boolean hasNonObjectTypes = false;
        HashSet literalValues = new HashSet();
        for (JSType jSType : plainTypes) {
            void var12_12;
            Class<?> typeClass;
            if (jSType instanceof JSPrimitiveLiteralType && !((JSPrimitiveLiteralType)jSType).allowWidening()) {
                Object literal = ((JSPrimitiveLiteralType)jSType).getLiteral();
                boolean isEmpty = literalValues.isEmpty();
                boolean added = literalValues.add(literal);
                if (!isEmpty && added) {
                    return JSNamedTypeFactory.createNeverType(source);
                }
            }
            if (jSType instanceof JSNullType) {
                hasNull = true;
            } else if (jSType instanceof JSUndefinedType) {
                hasUndefined = true;
            } else {
                hasNonObjectTypes |= !(jSType instanceof JSRecordType);
            }
            if (jSType instanceof JSPrimitiveType) {
                hasPrimitive = true;
            }
            if ((hasNull || hasUndefined) && hasPrimitive) {
                return JSNamedTypeFactory.createNeverType(source);
            }
            if (jSType instanceof JSPrimitiveType && !((JSPrimitiveType)jSType).isPrimitive()) continue;
            if (jSType instanceof JSLiteralType) {
                JSType jSType2 = ((JSLiteralType)jSType).asPrimitiveType();
            }
            if (IMPOSSIBLE_COMBINATIONS.contains(typeClass = var12_12.getClass())) {
                primitives.add(typeClass);
            }
            if (primitives.size() <= 1) continue;
            return JSNamedTypeFactory.createNeverType(source);
        }
        if (!allowResolve) {
            return null;
        }
        if (hasNull && !hasNonObjectTypes) {
            return isStrictNullChecks ? JSNamedTypeFactory.createNeverType(source) : JSNamedTypeFactory.createNullType(source);
        }
        if (hasUndefined && !hasNonObjectTypes) {
            return isStrictNullChecks ? JSNamedTypeFactory.createNeverType(source) : JSNamedTypeFactory.createUndefinedType(source);
        }
        return null;
    }

    private static boolean hasAnyType(@NotNull Collection<? extends JSType> types) {
        if (types == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(54);
        }
        for (JSType jSType : types) {
            if (!(jSType instanceof JSAnyType)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static JSType getContextualForCallSignatures(@NotNull Collection<? extends JSType> types, @NotNull JSTypeSource source) {
        if (types == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(55);
        }
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(56);
        }
        if (types.size() > 1 && ContainerUtil.and(types, el -> el instanceof JSFunctionTypeImpl)) {
            List collect = StreamEx.of(types).select(JSFunctionTypeImpl.class).map(el -> new CallSignatureImpl(false, (JSFunctionType)el)).toList();
            return new JSRecordTypeImpl(source, collect);
        }
        return null;
    }

    @NotNull
    public static JSType createKeyOfType(@NotNull JSType referencedType, @NotNull JSTypeSource source) {
        if (referencedType == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(57);
        }
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(58);
        }
        if (referencedType instanceof JSUnknownType) {
            TypeScriptNeverType typeScriptNeverType = JSNamedTypeFactory.createNeverType(source);
            if (typeScriptNeverType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(59);
            }
            return typeScriptNeverType;
        }
        if (referencedType instanceof TypeScriptNeverType) {
            return JSCompositeTypeFactory.createUnionType(source, TypeScriptTypeRelations.getDefaultKeyOfTypes(source));
        }
        if (referencedType instanceof JSRecordType && (((JSRecordType)referencedType).getTypeMembers().isEmpty() || !JSRecordTypeImpl.isObjectType((JSRecordType)referencedType))) {
            JSType jSType = TypeScriptTypeOperatorJSTypeImpl.substituteRecordTypeNoResolve((JSRecordType)referencedType, source);
            if (jSType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(60);
            }
            return jSType;
        }
        return new TypeScriptTypeOperatorJSTypeImpl(referencedType, source);
    }

    public static JSType createConditionalType(@NotNull JSTypeSource source, @NotNull JSType checkedType, @NotNull JSType testType, @NotNull JSType typeIfTrue, @NotNull JSType typeIfFalse) {
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(61);
        }
        if (checkedType == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(62);
        }
        if (testType == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(63);
        }
        if (typeIfTrue == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(64);
        }
        if (typeIfFalse == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(65);
        }
        if (checkedType.isEquivalentTo(testType, new ProcessingContext(), false)) {
            return typeIfTrue;
        }
        if (checkedType instanceof JSRecordType && !((JSRecordType)checkedType).hasMembers() && (testType instanceof JSArrayType || testType instanceof JSPrimitiveType)) {
            return typeIfFalse;
        }
        if (checkedType instanceof TypeScriptNeverType) {
            return typeIfTrue;
        }
        if (checkedType instanceof JSAnyType && testType instanceof JSTemplateLiteralType) {
            return JSNamedTypeFactory.createNeverType(source);
        }
        if (checkedType instanceof JSAnyType && !(checkedType instanceof JSUnknownType)) {
            return JSCompositeTypeFactory.createUnionType(source, typeIfTrue, typeIfFalse);
        }
        if (checkedType instanceof JSPrimitiveType && (testType instanceof TypeScriptObjectJSTypeImpl || testType instanceof JSSymbolType || testType instanceof JSRecordType && !((JSRecordType)testType).getCallSignatures().isEmpty())) {
            return typeIfFalse;
        }
        if (!JSTypeUtils.hasForeignGenericParameter(typeIfTrue)) {
            if (checkedType instanceof JSArrayType && testType instanceof TypeScriptObjectJSTypeImpl) {
                return typeIfTrue;
            }
            if (typeIfTrue.isEquivalentTo(typeIfFalse, new ProcessingContext(), false)) {
                return typeIfTrue;
            }
        }
        if (checkedType instanceof JSUnionType && JSCompositeTypeFactory.isSimpleDistributedConditional(source)) {
            List<JSType> types = ((JSUnionOrIntersectionType)checkedType).getTypes();
            ArrayList<JSType> newTypes = new ArrayList<JSType>(types.size());
            for (JSType type : types) {
                newTypes.add(JSCompositeTypeFactory.createConditionalType(source, type, testType, TypeScriptConditionalTypeJSTypeImpl.replaceCheckedType(checkedType, type, typeIfTrue), TypeScriptConditionalTypeJSTypeImpl.replaceCheckedType(checkedType, type, typeIfFalse)));
            }
            return JSCompositeTypeFactory.createUnionType(checkedType.getSource(), newTypes);
        }
        JSType literalMatch = JSCompositeTypeFactory.processAsLiterals(checkedType, testType, typeIfTrue, typeIfFalse);
        if (literalMatch != null) {
            return literalMatch;
        }
        return new TypeScriptConditionalTypeJSTypeImpl(source, checkedType, testType, typeIfTrue, typeIfFalse);
    }

    public static boolean isSimpleDistributedConditional(@NotNull JSTypeSource source) {
        TypeScriptConditionalType typeNode;
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(66);
        }
        if ((typeNode = (TypeScriptConditionalType)ObjectUtils.tryCast((Object)source.getSourceElement(), TypeScriptConditionalType.class)) == null) {
            return false;
        }
        TypeScriptType checkedTypeNode = typeNode.getCheckedType();
        if (checkedTypeNode == null) {
            return false;
        }
        JSType checkedType = checkedTypeNode.getJSType();
        return checkedType instanceof TypeScriptGenericParameterImpl || checkedType instanceof TypeScriptConditionalTypeGenericParameterImpl;
    }

    @NotNull
    public static JSType createIndexedAccessType(@NotNull JSType owner, @NotNull JSType parameterType, @NotNull JSTypeSource source) {
        JSType jsType;
        JSRecordType.PropertySignature signature;
        if (owner == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(67);
        }
        if (parameterType == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(68);
        }
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(69);
        }
        if (owner instanceof JSAnyType || owner instanceof TypeScriptNeverType) {
            JSType jSType = owner;
            if (jSType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(70);
            }
            return jSType;
        }
        if (parameterType instanceof TypeScriptNeverType) {
            JSType jSType = parameterType;
            if (jSType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(71);
            }
            return jSType;
        }
        if (parameterType instanceof JSAnyType) {
            JSType jSType = parameterType;
            if (jSType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(72);
            }
            return jSType;
        }
        if (owner instanceof JSRecordType && parameterType instanceof JSStringLiteralTypeImpl && !((JSStringLiteralTypeImpl)parameterType).allowWidening() && (signature = ((JSRecordType)owner).findPropertySignature(((JSStringLiteralTypeImpl)parameterType).getLiteral())) != null && (jsType = signature.getJSTypeWithOptionality()) != null) {
            JSType jSType = jsType;
            if (jSType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(73);
            }
            return jSType;
        }
        if (owner instanceof TypeScriptMappedJSTypeImpl) {
            JSType type = ((TypeScriptMappedJSTypeImpl)owner).getParameterType();
            JSType resultType = ((TypeScriptMappedJSTypeImpl)owner).getResultType();
            if (!JSTypeUtils.hasForeignGenericParameter(resultType) && parameterType.isEquivalentTo(type, new ProcessingContext(), false)) {
                JSType jSType = resultType;
                if (jSType == null) {
                    JSCompositeTypeFactory.$$$reportNull$$$0(74);
                }
                return jSType;
            }
        }
        return new TypeScriptIndexedAccessJSTypeImpl(owner, parameterType, source);
    }

    public static JSType createMappedType(@NotNull JSTypeSource source, boolean isReadonly, boolean isOptional, boolean isMinusReadonly, boolean isMinusOptional, @NotNull JSTypeGenericId parameterId, @NotNull JSType parameterType, @NotNull JSType resultType, @Nullable JSType namedType) {
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(75);
        }
        if (parameterId == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(76);
        }
        if (parameterType == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(77);
        }
        if (resultType == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(78);
        }
        if (parameterType instanceof JSAnyType) {
            return JSCompositeTypeFactory.createDefaultIndexersRecord(source, resultType);
        }
        if (parameterType instanceof TypeScriptNeverType) {
            return new JSSimpleRecordTypeImpl(source, Collections.emptyList());
        }
        if (parameterType instanceof TypeScriptTypeOperatorJSTypeImpl) {
            JSType referencedType = ((TypeScriptTypeOperatorJSTypeImpl)parameterType).getReferencedType();
            if (referencedType instanceof JSUnknownType || referencedType instanceof TypeScriptNeverType) {
                return new JSSimpleRecordTypeImpl(source, Collections.emptyList());
            }
            if (referencedType instanceof JSAnyType) {
                return JSCompositeTypeFactory.createDefaultIndexersRecord(source, resultType);
            }
        }
        return new TypeScriptMappedJSTypeImpl(source, isReadonly, isOptional, isMinusReadonly, isMinusOptional, parameterId, parameterType, resultType, namedType);
    }

    public static JSType createAwaitedType(@NotNull JSType referencedType, @NotNull JSTypeSource source) {
        List<JSType> arguments;
        if (referencedType == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(79);
        }
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(80);
        }
        if (referencedType instanceof JSPrimitiveType || referencedType instanceof JSAnyType) {
            return referencedType;
        }
        if (referencedType instanceof JSGenericTypeImpl && JSTypeUtils.isPromiseNamedType(((JSGenericTypeImpl)referencedType).getType()) && (arguments = ((JSGenericTypeImpl)referencedType).getArguments()).size() == 1) {
            return arguments.get(0);
        }
        return new TypeScriptAwaitedJSTypeImpl(referencedType, source);
    }

    @NotNull
    private static JSSimpleRecordTypeImpl createDefaultIndexersRecord(@NotNull JSTypeSource source, @NotNull JSType resultType) {
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(81);
        }
        if (resultType == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(82);
        }
        return new JSSimpleRecordTypeImpl(source, Arrays.asList(new IndexSignatureImpl((JSType)JSNamedTypeFactory.createStringPrimitiveType(source), resultType, (PsiElement)null, false), new IndexSignatureImpl((JSType)JSNamedTypeFactory.createNumberPrimitiveType(source), resultType, (PsiElement)null, false), new IndexSignatureImpl((JSType)JSNamedTypeFactory.createSymbolPrimitiveType(source), resultType, (PsiElement)null, false)));
    }

    @Nullable
    private static JSType processAsLiterals(@NotNull JSType checkedType, @NotNull JSType testType, @NotNull JSType typeIfTrue, @NotNull JSType typeIfFalse) {
        if (checkedType == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(83);
        }
        if (testType == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(84);
        }
        if (typeIfTrue == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(85);
        }
        if (typeIfFalse == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(86);
        }
        if (checkedType instanceof JSKeyofType && ((JSKeyofType)checkedType).getReferencedType() instanceof JSAnyType && testType instanceof TypeScriptNeverType) {
            return typeIfFalse;
        }
        if (checkedType instanceof JSPrimitiveType && testType instanceof TypeScriptNeverType) {
            return typeIfFalse;
        }
        if (!(checkedType instanceof JSPrimitiveLiteralType) || !(testType instanceof JSPrimitiveLiteralType) || ((JSLiteralType)checkedType).allowWidening() || ((JSLiteralType)testType).allowWidening()) {
            return null;
        }
        return !Objects.equals(((JSPrimitiveLiteralType)checkedType).getLiteral(), ((JSPrimitiveLiteralType)testType).getLiteral()) ? typeIfFalse : typeIfTrue;
    }

    @NotNull
    public static JSType getCommonType(@NotNull Collection<? extends JSType> allCommonTypes, @NotNull JSTypeSource source, boolean allowResolve) {
        if (allCommonTypes == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(87);
        }
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(88);
        }
        JSUnionOrIntersectionType.OptimizedKind target = !allowResolve ? JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_NO_RESOLVE : (source.isTypeScript() ? JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_SIMPLE : JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_REMOVED_NULL_UNDEFINED);
        List<? extends JSType> types = JSCompositeTypeFactory.flattenAndDeduplicate(allCommonTypes, Collections.emptySet(), target, true);
        if (types.isEmpty()) {
            TypeScriptNeverType typeScriptNeverType = JSNamedTypeFactory.createNeverType(source);
            if (typeScriptNeverType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(89);
            }
            return typeScriptNeverType;
        }
        if (types.size() == 1) {
            JSType jSType = (JSType)types.iterator().next();
            if (jSType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(90);
            }
            return jSType;
        }
        return new JSCompositeTypeImpl(source, types);
    }

    @NotNull
    public static JSType getCommonType(@NotNull JSType type1, @NotNull JSType type2, @Nullable JSTypeSource source, boolean allowResolve) {
        if (type1 == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(91);
        }
        if (type2 == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(92);
        }
        if (type1 == type2) {
            JSType jSType = type1;
            if (jSType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(93);
            }
            return jSType;
        }
        if (type1 instanceof JSAnyType) {
            JSType jSType = type1;
            if (jSType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(94);
            }
            return jSType;
        }
        if (type2 instanceof JSAnyType) {
            JSType jSType = type2;
            if (jSType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(95);
            }
            return jSType;
        }
        if (JSCompositeTypeBaseImpl.isEmptyType(type1)) {
            JSType jSType = type2;
            if (jSType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(96);
            }
            return jSType;
        }
        if (JSCompositeTypeBaseImpl.isEmptyType(type2)) {
            JSType jSType = type1;
            if (jSType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(97);
            }
            return jSType;
        }
        if (!allowResolve && type1 instanceof JSNamedType && type2 instanceof JSNamedType && type1.getTypeText().equals(type2.getTypeText())) {
            JSType jSType = type1;
            if (jSType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(98);
            }
            return jSType;
        }
        List<JSType> allCommonTypes = JSCompositeTypeBaseImpl.flattenTypes(List.of(type1, type2), JSUnionType.class);
        if (source == null) {
            source = type1 instanceof JSUnionType || !(type2 instanceof JSUnionType) ? type1.getSource() : type2.getSource();
        }
        return JSCompositeTypeFactory.getCommonType(allCommonTypes, source, allowResolve);
    }

    @NotNull
    static List<? extends JSType> mergeUnknownType(@NotNull List<? extends JSType> types, boolean isUnion) {
        if (types == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(99);
        }
        boolean result = false;
        JSUnknownType hasUnknown = null;
        for (JSType jSType : types) {
            if (jSType instanceof JSUnknownType) {
                if (isUnion) {
                    List<JSType> list = Collections.singletonList(jSType);
                    if (list == null) {
                        JSCompositeTypeFactory.$$$reportNull$$$0(100);
                    }
                    return list;
                }
                hasUnknown = (JSUnknownType)jSType;
                continue;
            }
            result = true;
        }
        if (!result && hasUnknown != null) {
            List<Object> list = Collections.singletonList(hasUnknown);
            if (list == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(101);
            }
            return list;
        }
        List<? extends JSType> list = types;
        if (list == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(102);
        }
        return list;
    }

    @Contract(value="!null,_->!null")
    public static JSType optimizeTypeIfComposite(@Nullable JSType currentType, @NotNull JSUnionOrIntersectionType.OptimizedKind targetKind) {
        if (targetKind == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(103);
        }
        if (currentType instanceof JSDistributedType && targetKind != JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_NO_RESOLVE) {
            currentType = ((JSDistributedType)((Object)currentType)).distributeType();
        }
        if (!(currentType instanceof JSUnionOrIntersectionType)) {
            return currentType;
        }
        JSUnionOrIntersectionType unionOrIntersection = (JSUnionOrIntersectionType)currentType;
        return JSCompositeTypeFactory.optimizeTypeIfUnionOrIntersection(unionOrIntersection, targetKind);
    }

    @NotNull
    private static JSType optimizeTypeIfUnionOrIntersection(@NotNull JSUnionOrIntersectionType currentType, @NotNull JSUnionOrIntersectionType.OptimizedKind targetKind) {
        Set<JSUnionOrIntersectionType.OptimizedKind> currentOptimized;
        if (currentType == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(104);
        }
        if (targetKind == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(105);
        }
        boolean allowResolve = targetKind != JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_NO_RESOLVE;
        Set<JSUnionOrIntersectionType.OptimizedKind> set = currentOptimized = allowResolve ? currentType.getResolvedOptimized() : Collections.emptySet();
        if (JSCompositeTypeFactory.isResolvedOptimizedAcceptable(currentOptimized, targetKind)) {
            JSUnionOrIntersectionType jSUnionOrIntersectionType = currentType;
            if (jSUnionOrIntersectionType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(106);
            }
            return jSUnionOrIntersectionType;
        }
        boolean isUnion = currentType.isUnionType();
        boolean isWeakType = !currentType.isSourceStrict() || !currentType.isTypeScript();
        List<JSType> originalTypes = currentType.getTypes();
        List<? extends JSType> results = JSCompositeTypeFactory.flattenAndDeduplicate(originalTypes, currentOptimized == null ? Collections.emptySet() : currentOptimized, targetKind, isUnion);
        if (results.size() == 1) {
            JSType jSType = results.iterator().next();
            if (jSType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(107);
            }
            return jSType;
        }
        JSTypeSource source = currentType.getSource();
        if (results.isEmpty()) {
            JSUtilType jSUtilType = isWeakType ? JSAnyType.get(currentType.getSourceElement()) : JSNamedTypeFactory.createNeverType(source);
            if (jSUtilType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(108);
            }
            return jSUtilType;
        }
        if (isUnion) {
            JSUnionOrIntersectionType result;
            JSType jSType = JSCompositeTypeFactory.equalsIdentity(results, originalTypes) ? currentType : (result = results.size() == 1 ? results.iterator().next() : new JSCompositeTypeImpl(source, results));
            if (allowResolve && result instanceof JSUnionOrIntersectionType) {
                JSCompositeTypeFactory.saveResolveOptimized(result, targetKind);
            }
            JSUnionOrIntersectionType jSUnionOrIntersectionType = result;
            if (jSUnionOrIntersectionType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(109);
            }
            return jSUnionOrIntersectionType;
        }
        return JSCompositeTypeFactory.normalizeAndOptimizeIntersection(currentType, results, targetKind, source);
    }

    private static boolean equalsIdentity(List<? extends JSType> results, List<JSType> originalTypes) {
        return ContainerUtil.equalsIdentity(results, originalTypes);
    }

    @NotNull
    private static JSType normalizeAndOptimizeIntersection(@NotNull JSUnionOrIntersectionType currentType, @NotNull List<? extends JSType> results, @NotNull JSUnionOrIntersectionType.OptimizedKind targetKind, @NotNull JSTypeSource source) {
        boolean isContextual;
        boolean allowExpand;
        List expanded;
        JSType normalized;
        if (currentType == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(110);
        }
        if (results == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(111);
        }
        if (targetKind == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(112);
        }
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(113);
        }
        if ((normalized = JSCompositeTypeFactory.normalizeIfPossible(expanded = (allowExpand = targetKind != JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_NO_RESOLVE && targetKind != JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_SUBSTITUTE) ? ContainerUtil.map(results, JSType::substitute) : results, source, targetKind, !(isContextual = currentType instanceof JSContextualUnionType))) != null) {
            JSType jSType = JSCompositeTypeFactory.optimizeTypeIfComposite(normalized, targetKind);
            if (jSType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(114);
            }
            return jSType;
        }
        return JSCompositeTypeFactory.setTargetAndReturnIntersection(currentType, results, targetKind, source, isContextual);
    }

    @NotNull
    private static JSType setTargetAndReturnIntersection(@NotNull JSUnionOrIntersectionType currentType, @NotNull List<? extends JSType> results, @NotNull JSUnionOrIntersectionType.OptimizedKind targetKind, @NotNull JSTypeSource source, boolean isContextual) {
        JSUnionOrIntersectionType result;
        if (currentType == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(115);
        }
        if (results == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(116);
        }
        if (targetKind == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(117);
        }
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(118);
        }
        JSType jSType = result = JSCompositeTypeFactory.equalsIdentity(results, currentType.getTypes()) ? currentType : JSCompositeTypeFactory.createIntersectionLikeType(results, source, isContextual);
        if (targetKind != JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_NO_RESOLVE && result instanceof JSUnionOrIntersectionType) {
            JSCompositeTypeFactory.saveResolveOptimized(result, targetKind);
        }
        JSUnionOrIntersectionType jSUnionOrIntersectionType = result;
        if (jSUnionOrIntersectionType == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(119);
        }
        return jSUnionOrIntersectionType;
    }

    @NotNull
    private static JSType createIntersectionLikeType(@NotNull Collection<? extends JSType> results, @NotNull JSTypeSource source, boolean isContextual) {
        if (results == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(120);
        }
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(121);
        }
        return isContextual ? JSCompositeTypeFactory.createContextualUnionType(results, source) : JSCompositeTypeFactory.createIntersectionType(results, source);
    }

    @NotNull
    static List<? extends JSType> flattenAndDeduplicate(@NotNull Collection<? extends JSType> originalNestedTypes, @NotNull Set<JSUnionOrIntersectionType.OptimizedKind> currentOptimized, @NotNull JSUnionOrIntersectionType.OptimizedKind targetKind, boolean isUnion) {
        StreamEx typesStream;
        if (originalNestedTypes == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(122);
        }
        if (currentOptimized == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(123);
        }
        if (targetKind == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(124);
        }
        boolean allowResolve = targetKind != JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_NO_RESOLVE;
        boolean allowExpand = allowResolve && targetKind != JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_SUBSTITUTE;
        StreamEx streamEx = typesStream = !currentOptimized.isEmpty() ? StreamEx.of(originalNestedTypes) : JSCompositeTypeFactory.expandAndFlatten(originalNestedTypes, isUnion, allowExpand);
        if (targetKind == JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_REMOVED_NULL_UNDEFINED) {
            typesStream = (StreamEx)typesStream.filter(el -> !JSTypeUtils.isNullOrUndefinedType(el));
        } else if (targetKind == JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_REMOVED_FALSY) {
            typesStream = (StreamEx)typesStream.filter(el -> !JSTypeCastUtil.isFalsy(el));
        }
        List types = ((StreamEx)typesStream.distinct()).toList();
        if (types.size() <= 1) {
            List list = types;
            if (list == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(125);
            }
            return list;
        }
        return allowResolve ? JSCompositeTypeFactory.deduplicate(types, isUnion) : JSCompositeTypeFactory.mergeUnknownType(types, isUnion);
    }

    @NotNull
    private static StreamEx<JSType> expandAndFlatten(@NotNull Collection<? extends JSType> originalNestedTypes, boolean isUnion, boolean allowResolve) {
        if (originalNestedTypes == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(126);
        }
        StreamEx expanded = (StreamEx)StreamEx.of(originalNestedTypes).map(el -> JSCompositeTypeBaseImpl.getTypeOfType(el, allowResolve)).distinct();
        StreamEx streamEx = (StreamEx)JSCompositeTypeBaseImpl.flattenTypesStream((StreamEx<? extends JSType>)expanded, isUnion ? JSUnionType.class : JSIntersectionType.class).filter(JSCompositeTypeFactory.isNotEmptyType(isUnion));
        if (streamEx == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(127);
        }
        return streamEx;
    }

    @NotNull
    private static Predicate<JSType> isNotEmptyType(boolean isUnion) {
        Predicate<JSType> predicate = el -> isUnion ? !JSCompositeTypeBaseImpl.isEmptyType(el) : el != null && !(el instanceof JSUnknownType);
        if (predicate == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(128);
        }
        return predicate;
    }

    @NotNull
    private static List<JSType> deduplicate(@NotNull Collection<? extends JSType> types, boolean isUnion) {
        if (types == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(129);
        }
        ArrayList<JSType> result = new ArrayList<JSType>(types.size());
        Object2IntOpenHashMap indexes = new Object2IntOpenHashMap();
        JSUnknownType unknownType = null;
        for (JSType jSType : types) {
            if (jSType instanceof JSUnknownType) {
                if (isUnion) {
                    List<JSType> list = Collections.singletonList(jSType);
                    if (list == null) {
                        JSCompositeTypeFactory.$$$reportNull$$$0(130);
                    }
                    return list;
                }
                unknownType = (JSUnknownType)jSType;
                continue;
            }
            if (jSType instanceof TypeScriptNeverType && !isUnion) {
                List<JSType> list = Collections.singletonList(jSType);
                if (list == null) {
                    JSCompositeTypeFactory.$$$reportNull$$$0(131);
                }
                return list;
            }
            JSResolvedTypeId id = jSType.getResolvedTypeId();
            if (indexes.containsKey((Object)id)) continue;
            indexes.put((Object)id, result.size());
            result.add(jSType);
        }
        if (result.isEmpty() && unknownType != null) {
            List<Object> list = Collections.singletonList(unknownType);
            if (list == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(132);
            }
            return list;
        }
        ArrayList<JSType> arrayList = result;
        if (arrayList == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(133);
        }
        return arrayList;
    }

    private static boolean isResolvedOptimizedAcceptable(@Nullable Set<JSUnionOrIntersectionType.OptimizedKind> currentOptimized, @NotNull JSUnionOrIntersectionType.OptimizedKind targetKind) {
        if (targetKind == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(134);
        }
        return currentOptimized != null && currentOptimized.contains((Object)targetKind);
    }

    private static void saveResolveOptimized(@NotNull JSUnionOrIntersectionType type, @NotNull JSUnionOrIntersectionType.OptimizedKind kind) {
        Set<JSUnionOrIntersectionType.OptimizedKind> flags;
        if (type == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(135);
        }
        if (kind == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(136);
        }
        if ((flags = type.getResolvedOptimized()) == null) {
            return;
        }
        flags.add(kind);
        flags.addAll(kind.getIncluded());
    }

    @Contract(value="!null -> !null")
    public static JSType optimizeTypeIfComposite(@Nullable JSType currentType) {
        return JSCompositeTypeFactory.optimizeTypeIfComposite(currentType, JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_SIMPLE);
    }

    @NotNull
    public static JSType optimizeTypeForSubstitute(@NotNull JSType currentType, @Nullable PsiElement context) {
        if (currentType == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(137);
        }
        PsiElement sourceElement = currentType.getSourceElement();
        boolean keepNullTypes = context == null || TypeScriptConfigUtil.strictNullChecks(context) || sourceElement instanceof JSDocComment || sourceElement instanceof JSImplicitElement;
        JSType jSType = JSCompositeTypeFactory.optimizeTypeIfComposite(currentType, keepNullTypes ? JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_SIMPLE : JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_REMOVED_NULL_UNDEFINED);
        if (jSType == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(138);
        }
        return jSType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 14, 15, 16, 24, 25, 26, 27, 29, 30, 31, 32, 33, 38, 39, 40, 41, 42, 43, 49, 50, 59, 60, 70, 71, 72, 73, 74, 89, 90, 93, 94, 95, 96, 97, 98, 100, 101, 102, 106, 107, 108, 109, 114, 119, 125, 127, 128, 130, 131, 132, 133, 138 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 11: 
            case 13: 
            case 17: 
            case 19: 
            case 22: 
            case 34: 
            case 36: 
            case 45: 
            case 52: 
            case 56: 
            case 58: 
            case 61: 
            case 66: 
            case 69: 
            case 75: 
            case 80: 
            case 81: 
            case 88: 
            case 113: 
            case 118: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 6: 
            case 37: 
            case 46: 
            case 53: 
            case 103: 
            case 105: 
            case 112: 
            case 117: 
            case 124: 
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetKind";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 49: 
            case 50: 
            case 59: 
            case 60: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 89: 
            case 90: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 114: 
            case 119: 
            case 125: 
            case 127: 
            case 128: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSCompositeTypeFactory";
                break;
            }
            case 18: 
            case 20: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_types";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 44: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plainTypes";
                break;
            }
            case 47: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 57: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedType";
                break;
            }
            case 62: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkedType";
                break;
            }
            case 63: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testType";
                break;
            }
            case 64: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeIfTrue";
                break;
            }
            case 65: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeIfFalse";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 68: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterId";
                break;
            }
            case 78: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultType";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allCommonTypes";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
            case 104: 
            case 110: 
            case 115: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentType";
                break;
            }
            case 111: 
            case 116: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 122: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalNestedTypes";
                break;
            }
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentOptimized";
                break;
            }
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSCompositeTypeFactory";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createIntersectionType";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createContextualUnionType";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createUnionType";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "collapseTypesForUnion";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "optimizeIntersectionTypes";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "removeRedundantSupertypes";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "createKeyOfType";
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "createIndexedAccessType";
                break;
            }
            case 89: 
            case 90: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonType";
                break;
            }
            case 100: 
            case 101: 
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeUnknownType";
                break;
            }
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "optimizeTypeIfUnionOrIntersection";
                break;
            }
            case 114: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeAndOptimizeIntersection";
                break;
            }
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "setTargetAndReturnIntersection";
                break;
            }
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenAndDeduplicate";
                break;
            }
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "expandAndFlatten";
                break;
            }
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "isNotEmptyType";
                break;
            }
            case 130: 
            case 131: 
            case 132: 
            case 133: {
                objectArray = objectArray2;
                objectArray2[1] = "deduplicate";
                break;
            }
            case 138: {
                objectArray = objectArray2;
                objectArray2[1] = "optimizeTypeForSubstitute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createIntersectionType";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 49: 
            case 50: 
            case 59: 
            case 60: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 89: 
            case 90: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 114: 
            case 119: 
            case 125: 
            case 127: 
            case 128: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 138: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createContextualUnionType";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createTupleType";
                break;
            }
            case 22: 
            case 23: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createUnionType";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "collapseTypesForUnion";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "optimizeIntersectionTypes";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "normalizeIfPossible";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isDefinitelyNotNull";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "removeRedundantSupertypes";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getTypeForImpossibleTypeCombination";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "hasAnyType";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getContextualForCallSignatures";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "createKeyOfType";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "createConditionalType";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "isSimpleDistributedConditional";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "createIndexedAccessType";
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "createMappedType";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "createAwaitedType";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultIndexersRecord";
                break;
            }
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "processAsLiterals";
                break;
            }
            case 87: 
            case 88: 
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getCommonType";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "mergeUnknownType";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "optimizeTypeIfComposite";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "optimizeTypeIfUnionOrIntersection";
                break;
            }
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "normalizeAndOptimizeIntersection";
                break;
            }
            case 115: 
            case 116: 
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "setTargetAndReturnIntersection";
                break;
            }
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "createIntersectionLikeType";
                break;
            }
            case 122: 
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "flattenAndDeduplicate";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "expandAndFlatten";
                break;
            }
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "deduplicate";
                break;
            }
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "isResolvedOptimizedAcceptable";
                break;
            }
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "saveResolveOptimized";
                break;
            }
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "optimizeTypeForSubstitute";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 14, 15, 16, 24, 25, 26, 27, 29, 30, 31, 32, 33, 38, 39, 40, 41, 42, 43, 49, 50, 59, 60, 70, 71, 72, 73, 74, 89, 90, 93, 94, 95, 96, 97, 98, 100, 101, 102, 106, 107, 108, 109, 114, 119, 125, 127, 128, 130, 131, 132, 133, 138 -> new IllegalStateException(string);
        };
    }
}

