/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.remote.SshConnectionConfigPatch;
import com.intellij.ssh.KnownHostsVerifyResult;
import com.intellij.ssh.OpenSshLikeHostKeyVerifier;
import com.intellij.ssh.OpenSshLikeHostKeyVerifierImplKt;
import com.intellij.ssh.SingleKnownHostsDelegate;
import com.intellij.ssh.impl.sshj.UtilKt;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.security.Key;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.SecurityUtils;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.OpenSSHKnownHosts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\bH\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ssh/OpenSshLikeHostKeyVerifierImpl;", "Lnet/schmizz/sshj/transport/verification/HostKeyVerifier;", "info", "Lcom/intellij/ssh/OpenSshLikeHostKeyVerifier;", "OpenSshLikeHostKeyVerifierImpl", "(Lcom/intellij/ssh/OpenSshLikeHostKeyVerifier;)V", "delegates", "", "Lcom/intellij/ssh/SingleKnownHostsDelegate;", "verify", "", "hostname", "", "port", "", "key", "Ljava/security/PublicKey;", "findExistingAlgorithms", "", "I", "", "firstDelegate", "I", "Lnet/schmizz/sshj/transport/verification/OpenSSHKnownHosts$HostEntry;", "Factory", "intellij.platform.ssh"})
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nOpenSshLikeHostKeyVerifierImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenSshLikeHostKeyVerifierImpl.kt\ncom/intellij/ssh/OpenSshLikeHostKeyVerifierImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,279:1\n1617#2,9:280\n1869#2:289\n1870#2:291\n1626#2:292\n1#3:290\n1#3:293\n608#4:294\n13#5:295\n*S KotlinDebug\n*F\n+ 1 OpenSshLikeHostKeyVerifierImpl.kt\ncom/intellij/ssh/OpenSshLikeHostKeyVerifierImpl\n*L\n41#1:280,9\n41#1:289\n41#1:291\n41#1:292\n41#1:290\n123#1:294\n172#1:295\n*E\n"})
public final class OpenSshLikeHostKeyVerifierImpl
implements HostKeyVerifier {
    @NotNull
    public static final Factory Factory = new Factory(null);
    @NotNull
    private final OpenSshLikeHostKeyVerifier info;
    @NotNull
    private final List<SingleKnownHostsDelegate> delegates;
    @NotNull
    private static final ConcurrentMap<String, ReadWriteLock> knownHostsFileLock;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Lazy<File> alternativeKnownHostsFile$delegate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenSshLikeHostKeyVerifierImpl(@NotNull OpenSshLikeHostKeyVerifier info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.info = info;
        Iterable iterable = this.info.getKnownHostsFiles();
        OpenSshLikeHostKeyVerifierImpl openSshLikeHostKeyVerifierImpl = this;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        Iterable iterable3 = iterable2;
        boolean bl3 = false;
        Iterator iterator = iterable3.iterator();
        while (iterator.hasNext()) {
            SingleKnownHostsDelegate singleKnownHostsDelegate;
            SingleKnownHostsDelegate singleKnownHostsDelegate2;
            Lock lock;
            Object t;
            Object t2 = t = iterator.next();
            boolean bl4 = false;
            File file = (File)t2;
            boolean bl5 = false;
            Intrinsics.checkNotNullExpressionValue((Object)OpenSshLikeHostKeyVerifierImpl.Factory.I(file).readLock(), (String)"readLock(...)");
            lock.lock();
            try {
                SingleKnownHostsDelegate singleKnownHostsDelegate3;
                boolean bl6 = false;
                try {
                    singleKnownHostsDelegate3 = new SingleKnownHostsDelegate(file);
                }
                catch (IOException iOException) {
                    LOG.warn("Failed to read file " + file);
                    singleKnownHostsDelegate3 = null;
                }
                singleKnownHostsDelegate2 = singleKnownHostsDelegate3;
            }
            finally {
                lock.unlock();
            }
            if (singleKnownHostsDelegate2 == null) continue;
            boolean bl7 = false;
            collection.add(singleKnownHostsDelegate);
        }
        Iterable iterable4 = iterable = (List)collection;
        boolean bl8 = false;
        boolean bl9 = !((Collection)iterable4).isEmpty();
        Iterable iterable5 = bl9 ? iterable : null;
        if (iterable5 == null) {
            iterable5 = CollectionsKt.listOf((Object)((Object)new SingleKnownHostsDelegate(OpenSshLikeHostKeyVerifierImpl.Factory.I())));
        }
        openSshLikeHostKeyVerifierImpl.delegates = iterable5;
    }

    public boolean verify(@NotNull String hostname, int port, @NotNull PublicKey key) {
        Pair pair;
        Object object;
        block24: {
            Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            for (SingleKnownHostsDelegate singleKnownHostsDelegate : (Iterable)this.delegates) {
                boolean bl = false;
                KnownHostsVerifyResult knownHostsVerifyResult = singleKnownHostsDelegate.customVerify(hostname, port, key);
                singleKnownHostsDelegate = switch (WhenMappings.$EnumSwitchMapping$0[knownHostsVerifyResult.ordinal()]) {
                    case 1, 2 -> TuplesKt.to((Object)((Object)singleKnownHostsDelegate), (Object)((Object)knownHostsVerifyResult));
                    case 3 -> null;
                    default -> throw new NoWhenBranchMatchedException();
                };
                if (singleKnownHostsDelegate == null) continue;
                object = singleKnownHostsDelegate;
                break block24;
            }
            object = pair = null;
        }
        if (object == null) {
            pair = TuplesKt.to((Object)CollectionsKt.firstOrNull(this.delegates), (Object)((Object)KnownHostsVerifyResult.UNKNOWN_OR_BROKEN));
        }
        Pair pair2 = pair;
        SingleKnownHostsDelegate singleKnownHostsDelegate = (SingleKnownHostsDelegate)((Object)pair2.component1());
        KnownHostsVerifyResult knownHostsVerifyResult = (KnownHostsVerifyResult)((Object)pair2.component2());
        String string = OpenSshLikeHostKeyVerifierImplKt.access$adjustHostname(hostname, port);
        return switch (WhenMappings.$EnumSwitchMapping$0[knownHostsVerifyResult.ordinal()]) {
            case 1 -> true;
            case 2 -> {
                switch (WhenMappings.$EnumSwitchMapping$1[this.info.getStrictHostKeyChecking().ordinal()]) {
                    case 1: {
                        yield true;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        KeyType var11_11 = KeyType.fromKey((Key)key);
                        String var12_13 = SecurityUtils.getFingerprint((PublicKey)key);
                        Object v4 = singleKnownHostsDelegate;
                        if (v4 == null || (v4 = v4.getFile()) == null || (v4 = ((File)v4).getAbsolutePath()) == null) {
                            v4 = "";
                        }
                        SingleKnownHostsDelegate var13_15 = v4;
                        Function4<String, String, String, String, Boolean> v5 = this.info.getAcceptChangedHostKey();
                        String v6 = var11_11.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"toString(...)");
                        Intrinsics.checkNotNull((Object)var12_13);
                        if (((Boolean)v5.invoke((Object)string, (Object)v6, (Object)var12_13, (Object)var13_15)).booleanValue()) {
                            this.I(string, key, singleKnownHostsDelegate);
                            yield true;
                        }
                        yield false;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            case 3 -> {
                switch (WhenMappings.$EnumSwitchMapping$1[this.info.getStrictHostKeyChecking().ordinal()]) {
                    case 2: {
                        yield false;
                    }
                    case 1: 
                    case 3: {
                        this.I(string, key, singleKnownHostsDelegate);
                        yield true;
                    }
                    case 4: {
                        KeyType var11_12 = KeyType.fromKey((Key)key);
                        String var12_14 = SecurityUtils.getFingerprint((PublicKey)key);
                        Object v7 = singleKnownHostsDelegate;
                        if (v7 == null || (v7 = v7.getFile()) == null || (v7 = ((File)v7).getAbsolutePath()) == null) {
                            v7 = "";
                        }
                        SingleKnownHostsDelegate var13_16 = v7;
                        Function4<String, String, String, String, Boolean> v8 = this.info.getAcceptUnknownHostKey();
                        String v9 = var11_12.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"toString(...)");
                        Intrinsics.checkNotNull((Object)var12_14);
                        if (((Boolean)v8.invoke((Object)string, (Object)v9, (Object)var12_14, (Object)var13_16)).booleanValue()) {
                            this.I(string, key, singleKnownHostsDelegate);
                            yield true;
                        }
                        yield false;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<String> findExistingAlgorithms(@NotNull String hostname, int port) {
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (SingleKnownHostsDelegate singleKnownHostsDelegate : this.delegates) {
            Lock lock;
            File file = singleKnownHostsDelegate.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
            Intrinsics.checkNotNullExpressionValue((Object)OpenSshLikeHostKeyVerifierImpl.Factory.I(file).readLock(), (String)"readLock(...)");
            lock.lock();
            try {
                boolean bl = false;
                CollectionsKt.addAll((Collection)linkedHashSet, (Iterable)singleKnownHostsDelegate.findExistingAlgorithms(hostname, port));
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }
        return CollectionsKt.toMutableList((Collection)linkedHashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void I(String string, PublicKey publicKey, SingleKnownHostsDelegate singleKnownHostsDelegate) {
        Sequence sequence = CollectionsKt.asSequence((Iterable)this.delegates);
        boolean bl = false;
        Sequence sequence2 = SequencesKt.sortedWith((Sequence)sequence, (Comparator)new Comparator(singleKnownHostsDelegate){
            final /* synthetic */ SingleKnownHostsDelegate $firstDelegate$inlined;
            {
                this.$firstDelegate$inlined = singleKnownHostsDelegate;
            }

            public final int compare(T a, T b) {
                SingleKnownHostsDelegate singleKnownHostsDelegate = (SingleKnownHostsDelegate)((Object)a);
                boolean bl = false;
                int n = singleKnownHostsDelegate == this.$firstDelegate$inlined ? 0 : 1;
                singleKnownHostsDelegate = (SingleKnownHostsDelegate)((Object)b);
                Comparable comparable = Integer.valueOf(n);
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(singleKnownHostsDelegate == this.$firstDelegate$inlined ? 0 : 1));
            }
        });
        sequence = KeyType.fromKey((Key)publicKey);
        OpenSSHKnownHosts.HostEntry hostEntry = this.I(string, publicKey);
        for (SingleKnownHostsDelegate singleKnownHostsDelegate2 : sequence2) {
            List list = singleKnownHostsDelegate2.entries();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"entries(...)");
            List list2 = CollectionsKt.toList((Iterable)list);
            try {
                Path path2 = singleKnownHostsDelegate2.getFile().toPath().getParent();
                if (path2 != null) {
                    Path path3 = path2;
                    boolean bl2 = false;
                    NioFiles.createDirectories((Path)path3);
                }
                if (singleKnownHostsDelegate2.entries().removeIf(arg_0 -> OpenSshLikeHostKeyVerifierImpl.I(arg_0 -> OpenSshLikeHostKeyVerifierImpl.I(string, (KeyType)sequence, arg_0), arg_0))) {
                    List list3 = singleKnownHostsDelegate2.entries();
                    Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"entries(...)");
                    ((Collection)list3).add(hostEntry);
                    File file = singleKnownHostsDelegate2.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
                    Lock lock = OpenSshLikeHostKeyVerifierImpl.Factory.I(file).writeLock();
                    Intrinsics.checkNotNullExpressionValue((Object)lock, (String)"writeLock(...)");
                    Lock lock2 = lock;
                    lock2.lock();
                    try {
                        boolean bl3 = false;
                        singleKnownHostsDelegate2.write();
                        Unit unit = Unit.INSTANCE;
                        break;
                    }
                    finally {
                        lock2.unlock();
                    }
                }
                List list4 = singleKnownHostsDelegate2.entries();
                Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"entries(...)");
                ((Collection)list4).add(hostEntry);
                File file = singleKnownHostsDelegate2.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
                Lock lock = OpenSshLikeHostKeyVerifierImpl.Factory.I(file).writeLock();
                Intrinsics.checkNotNullExpressionValue((Object)lock, (String)"writeLock(...)");
                Lock lock3 = lock;
                lock3.lock();
                try {
                    boolean bl4 = false;
                    singleKnownHostsDelegate2.write((OpenSSHKnownHosts.KnownHostEntry)hostEntry);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                finally {
                    lock3.unlock();
                }
            }
            catch (IOException iOException) {
                singleKnownHostsDelegate2.entries().clear();
                List list5 = singleKnownHostsDelegate2.entries();
                Intrinsics.checkNotNullExpressionValue((Object)list5, (String)"entries(...)");
                CollectionsKt.addAll((Collection)list5, (Iterable)list2);
                UtilKt.getSSHJ_LOG().info("Failed to write to " + singleKnownHostsDelegate2.getFile() + ": " + iOException);
            }
        }
    }

    private final OpenSSHKnownHosts.HostEntry I(String string, PublicKey publicKey) {
        String string2 = this.info.getHashKnownHosts() ? OpenSshLikeHostKeyVerifierImplKt.hashHostName(string) : string;
        return new OpenSSHKnownHosts.HostEntry(null, string2, KeyType.fromKey((Key)publicKey), publicKey);
    }

    private static final boolean I(String string, KeyType keyType, OpenSSHKnownHosts.KnownHostEntry knownHostEntry) {
        return knownHostEntry.appliesTo(string) && knownHostEntry.getType() == keyType;
    }

    private static final boolean I(Function1 function1, Object object) {
        return (Boolean)function1.invoke(object);
    }

    private static final File I() {
        File file;
        File file2 = file = FileUtil.createTempFile((String)"known_hosts", (String)"", (boolean)true);
        boolean bl = false;
        file2.setReadable(false, false);
        file2.setReadable(true);
        file2.setWritable(false, false);
        file2.setWritable(true);
        return file;
    }

    static {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentSoftValueMap(...)");
        knownHostsFileLock = concurrentMap;
        boolean bl = false;
        Logger logger = Logger.getInstance(OpenSshLikeHostKeyVerifierImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        alternativeKnownHostsFile$delegate = LazyKt.lazy(OpenSshLikeHostKeyVerifierImpl::I);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R3\u0010\u0004\u001a'\u0012\u000e\u0012\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b\u0012\u000e\u0012\f0\t\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b0\u0005\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\u00020\t*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u00070\u000b\u00a2\u0006\u0002\b\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ssh/OpenSshLikeHostKeyVerifierImpl$Factory;", "", "OpenSshLikeHostKeyVerifierImpl$Factory", "()V", "knownHostsFileLock", "Ljava/util/concurrent/ConcurrentMap;", "", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "Ljava/util/concurrent/locks/ReadWriteLock;", "rwLock", "Ljava/io/File;", "I", "(Ljava/io/File;)Ljava/util/concurrent/locks/ReadWriteLock;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "alternativeKnownHostsFile", "I", "()Ljava/io/File;", "alternativeKnownHostsFile$delegate", "Lkotlin/Lazy;", "intellij.platform.ssh"})
    public static final class Factory {
        private Factory() {
        }

        private final ReadWriteLock I(File file) {
            ReadWriteLock readWriteLock = knownHostsFileLock.computeIfAbsent(file.getAbsolutePath(), arg_0 -> Factory.I(Factory::I, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)readWriteLock, (String)"computeIfAbsent(...)");
            return readWriteLock;
        }

        private final File I() {
            Lazy lazy = alternativeKnownHostsFile$delegate;
            return (File)lazy.getValue();
        }

        private static final ReadWriteLock I(String string) {
            return new ReentrantReadWriteLock();
        }

        private static final ReadWriteLock I(Function1 function1, Object object) {
            return (ReadWriteLock)function1.invoke(object);
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[KnownHostsVerifyResult.values().length];
            try {
                nArray[KnownHostsVerifyResult.OK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KnownHostsVerifyResult.CHANGED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KnownHostsVerifyResult.UNKNOWN_OR_BROKEN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.values().length];
            try {
                nArray[SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.NO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.YES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.ACCEPT_NEW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.ASK.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

