/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.ui.unified;

import com.intellij.ide.IdeCoreBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.MutableRemoteCredentials;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.ForceDisconnectListener;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.SshBackendLibrary;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.SshConnectionUtil;
import com.intellij.ssh.SshException;
import com.intellij.ssh.config.unified.ErrorMessageAndField;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshCredentialsVerifier;
import com.intellij.ssh.ui.SshCredentialsEditorBase;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.Semaphore;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class SshCredentialsEditorEx
extends SshCredentialsEditorBase<MutableRemoteCredentials> {
    private static final Logger LOG = Logger.getInstance(SshCredentialsEditorEx.class);

    public SshCredentialsEditorEx(@NotNull Disposable parent) {
        if (parent == null) {
            SshCredentialsEditorEx.f(0);
        }
        super(true, false, parent);
        this.myTestButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SshUiData sshUiData = new SshUiData(new SshConfig(true), false);
                SshCredentialsEditorEx.this.applyEditorTo(sshUiData);
                ErrorMessageAndField errorMessageAndField = SshCredentialsEditorEx.validate(sshUiData, SshCredentialsVerifier.ValidationMode.WITHOUT_STRICT_CREDENTIALS);
                if (errorMessageAndField != null) {
                    Messages.showErrorDialog((Component)SshCredentialsEditorEx.this.getComponent(), (String)SshBundle.message("ssh.editor.invalid.setting.0", StringUtil.decapitalize((String)errorMessageAndField.errorMessage())), (String)SshBundle.message("ssh.editor.message.title.unable.to.connect", new Object[0]));
                    return;
                }
                AtomicBoolean atomicBoolean = new AtomicBoolean(false);
                Ref ref = new Ref(null);
                Runnable runnable = () -> {
                    ProgressIndicator progressIndicator2 = ProgressManager.getInstance().getProgressIndicator();
                    Semaphore semaphore = new Semaphore();
                    semaphore.down();
                    EventDispatcher eventDispatcher = EventDispatcher.create(ForceDisconnectListener.class);
                    ApplicationManager.getApplication().executeOnPooledThread(() -> {
                        try {
                            progressIndicator2.setText(IdeCoreBundle.message((String)"progress.message.connecting.to", (Object[])new Object[]{sshUiData.getConfig().getPresentableFullName()}));
                            atomicBoolean.set(RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)sshUiData, null).withDisconnectTrigger((EventDispatcher<ForceDisconnectListener>)eventDispatcher).withProgressIndicator(progressIndicator2).withConnectionTimeout(10L, TimeUnit.SECONDS).checkCanAuthenticate(true));
                        }
                        catch (SshException sshException) {
                            LOG.warn((Throwable)((Object)sshException));
                            ref.set((Object)sshException);
                            atomicBoolean.set(false);
                        }
                        finally {
                            semaphore.up();
                        }
                    });
                    while (!semaphore.waitFor(10000L)) {
                        if (!progressIndicator2.isCanceled()) continue;
                        ((ForceDisconnectListener)eventDispatcher.getMulticaster()).forceDisconnect();
                        break;
                    }
                };
                String string = SshBundle.message("ssh.editor.title.connection.to.0", sshUiData.getConfig().getPresentableFullName());
                boolean bl = ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, string, true, null, SshCredentialsEditorEx.this.getComponent());
                if (!bl) {
                    throw new ProcessCanceledException();
                }
                if (atomicBoolean.get()) {
                    Messages.showInfoMessage((Component)SshCredentialsEditorEx.this.getComponent(), (String)SshBundle.message("ssh.editor.successfully.connected", new Object[0]), (String)string);
                } else {
                    String string2;
                    String string3 = string2 = !ref.isNull() ? SshConnectionUtil.getMessage((Throwable)ref.get(), false) : null;
                    if (string2 == null) {
                        Messages.showErrorDialog((Component)SshCredentialsEditorEx.this.getComponent(), (String)SshBundle.message("ssh.editor.can.t.connect.to.remote.host", new Object[0]), (String)string);
                    } else {
                        Messages.showErrorDialog((Component)SshCredentialsEditorEx.this.getComponent(), (String)SshBundle.message("ssh.editor.can.t.connect.to.remote.host.0", string2), (String)string);
                    }
                }
            }
        });
        this.myPrivateKeyFileField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.I(0);
                }
                SshCredentialsEditorEx.this.updateNeedsPassphrase();
            }

            private static /* synthetic */ void I(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ssh/ui/unified/SshCredentialsEditorEx$2", "textChanged"));
            }
        });
    }

    @Override
    public void resetEditorFrom(@NotNull MutableRemoteCredentials credentials) {
        if (credentials == null) {
            SshCredentialsEditorEx.f(1);
        }
        super.resetEditorFrom(credentials);
        this.updateNeedsPassphrase();
    }

    @Override
    public boolean isModified(@NotNull MutableRemoteCredentials credentials) {
        if (credentials == null) {
            SshCredentialsEditorEx.f(2);
        }
        return super.isModified(credentials);
    }

    public void addListenerForNameDefiningFields(final @NotNull Runnable updater) {
        if (updater == null) {
            SshCredentialsEditorEx.f(3);
        }
        DocumentAdapter documentAdapter = new DocumentAdapter(this){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.I(0);
                }
                updater.run();
            }

            private static /* synthetic */ void I(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ssh/ui/unified/SshCredentialsEditorEx$3", "textChanged"));
            }
        };
        this.myUsernameField.getDocument().addDocumentListener((DocumentListener)documentAdapter);
        this.myHostField.getDocument().addDocumentListener((DocumentListener)documentAdapter);
        this.myPortField.getDocument().addDocumentListener((DocumentListener)documentAdapter);
        this.myAuthTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                updater.run();
            }
        });
    }

    @NotNull
    private static ErrorMessageAndField I(TimeoutException timeoutException) {
        Object object = SshBundle.message("ssh.verifier.message.connection.timeout", new Object[0]);
        if (timeoutException.getMessage() != null) {
            object = (String)object + ":" + timeoutException.getMessage();
        }
        return new ErrorMessageAndField((String)object, null);
    }

    public static ErrorMessageAndField validate(SshUiData data, SshCredentialsVerifier.ValidationMode mode) {
        try {
            return SshCredentialsVerifier.validate(mode, (RemoteCredentials)data, 500L, SshBackendLibrary.get());
        }
        catch (TimeoutException timeoutException) {
            return SshCredentialsEditorEx.I(timeoutException);
        }
    }

    private static /* synthetic */ void f(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ssh/ui/unified/SshCredentialsEditorEx";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isModified";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addListenerForNameDefiningFields";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

