/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util;

import com.google.common.collect.Sets;
import com.google.common.net.MediaType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssKeyframesSelector;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTokenImpl;
import com.intellij.psi.css.impl.util.table.CssPropertyUtil;
import com.intellij.psi.css.resolve.CssInclusionContext;
import com.intellij.psi.css.util.CssResolveUtil;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiPolyVariantCachingReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.io.URLUtil;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssUtil {
    @NonNls
    public static final String ANIMATION_NAME_PROPERTY = "animation-name";
    @NonNls
    public static final String ANIMATION_PROPERTY = "animation";

    @Nullable
    public static CssTerm getEnclosingTerm(@Nullable PsiElement element) {
        PsiElement termList;
        if (element == null) {
            return null;
        }
        CssTerm term = (CssTerm)PsiTreeUtil.getParentOfType((PsiElement)element, CssTerm.class, (boolean)false);
        if (term != null && (termList = term.getParent()) != null) {
            PsiElement termList2;
            if (termList.getParent() instanceof CssDeclaration) {
                return term;
            }
            if ((term = (CssTerm)PsiTreeUtil.getParentOfType((PsiElement)term, CssTerm.class, (boolean)true)) != null && (termList2 = term.getParent()) != null && termList2.getParent() instanceof CssDeclaration) {
                return term;
            }
        }
        return null;
    }

    public static CssDeclaration @NotNull [] getCssDeclarationsDefinedForTag(@NotNull XmlTag tag) {
        if (tag == null) {
            CssUtil.$$$reportNull$$$0(0);
        }
        if (!tag.isValid()) {
            if (CssDeclaration.EMPTY_ARRAY == null) {
                CssUtil.$$$reportNull$$$0(1);
            }
            return CssDeclaration.EMPTY_ARRAY;
        }
        ArrayList result = new ArrayList();
        XmlAttribute[] attributes = tag.getAttributes();
        for (int i = 0; i < attributes.length; ++i) {
            XmlAttributeValue valueElement = attributes[i].getValueElement();
            if (valueElement == null) continue;
            PsiReference[] references = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)valueElement);
            for (int j = 0; j < references.length; ++j) {
                if (!(references[j] instanceof PsiPolyVariantCachingReference)) continue;
                ResolveResult[] results = ((PsiPolyVariantCachingReference)references[j]).multiResolve(false);
                for (int k = 0; k < results.length; ++k) {
                    CssBlock block;
                    PsiElement element = results[k].getElement();
                    CssRuleset ruleset = (CssRuleset)PsiTreeUtil.getParentOfType((PsiElement)element, CssRuleset.class);
                    if (ruleset == null || (block = ruleset.getBlock()) == null) continue;
                    Object[] declarations = block.getDeclarations();
                    ContainerUtil.addAll(result, (Object[])declarations);
                }
            }
        }
        CssDeclaration[] cssDeclarationArray = result.toArray(CssDeclaration.EMPTY_ARRAY);
        if (cssDeclarationArray == null) {
            CssUtil.$$$reportNull$$$0(2);
        }
        return cssDeclarationArray;
    }

    @Nullable
    public static CssDeclaration getDeclaration(@Nullable PsiElement element) {
        return (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, CssDeclaration.class);
    }

    public static boolean isIdent(PsiElement element) {
        return element instanceof CssTokenImpl && ((CssTokenImpl)element).getElementType() == CssElementTypes.CSS_IDENT;
    }

    public static boolean isInSelector(PsiElement element) {
        return PsiTreeUtil.getParentOfType((PsiElement)element, CssSelector.class) != null;
    }

    public static boolean isCssDeclaration(PsiElement element) {
        PsiElement parent = element != null ? element.getParent() : null;
        return parent instanceof CssDeclaration;
    }

    public static boolean processStylesheetWithImports(CssStylesheet stylesheet, Processor<? super PsiFile> processor, @Nullable PsiElement context, boolean withImportsFromImportListOnly) {
        Stack walkStack = new Stack();
        HashSet<PsiElement> visited = new HashSet<PsiElement>();
        walkStack.push((Object)stylesheet);
        PsiFile file = stylesheet.getContainingFile();
        for (CssInclusionContext inclusionContext : CssInclusionContext.EXTENSION_POINT_NAME.getExtensionList()) {
            for (PsiFile contextFile : inclusionContext.getContextFiles(stylesheet)) {
                if (!(contextFile instanceof StylesheetFile)) continue;
                walkStack.push((Object)contextFile);
            }
        }
        while (!walkStack.isEmpty()) {
            PsiElement element2process = (PsiElement)walkStack.pop();
            if (visited.contains(element2process)) continue;
            visited.add(element2process);
            if (!processor.process((Object)element2process.getContainingFile())) {
                return false;
            }
            Object stylesheet2process = element2process instanceof StylesheetFile ? ((StylesheetFile)element2process).getStylesheet() : (element2process instanceof CssStylesheet ? (CssStylesheet)element2process : null);
            if (stylesheet2process == null) continue;
            for (CssImport cssImport : stylesheet2process.getImports(withImportsFromImportListOnly)) {
                PsiFile[] resolvedFiles;
                boolean importVisible = true;
                if (file instanceof StylesheetFile) {
                    importVisible = ((StylesheetFile)file).isImportVisibleInContext(cssImport, context);
                }
                if (!importVisible) continue;
                for (PsiFile psiFile : resolvedFiles = CssResolveUtil.resolveImport(cssImport)) {
                    if (!(psiFile instanceof StylesheetFile)) continue;
                    walkStack.push((Object)psiFile);
                }
            }
        }
        return true;
    }

    public static Set<VirtualFile> getImportedFiles(PsiFile file, PsiElement context, boolean withImportsFromImportListOnly) {
        CssStylesheet sheet = file instanceof StylesheetFile ? ((StylesheetFile)file).getStylesheet() : (CssStylesheet)PsiTreeUtil.getParentOfType((PsiElement)context, CssStylesheet.class);
        if (sheet != null) {
            HashSet<VirtualFile> importedVirtualFiles = new HashSet<VirtualFile>();
            CssUtil.processStylesheetWithImports(sheet, (Processor<? super PsiFile>)((Processor)file1 -> {
                VirtualFile virtualFile = file1.getVirtualFile();
                if (virtualFile != null) {
                    importedVirtualFiles.add(virtualFile);
                }
                return true;
            }), context, withImportsFromImportListOnly);
            return importedVirtualFiles;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        return virtualFile != null ? Sets.newHashSet((Object[])new VirtualFile[]{virtualFile}) : Collections.emptySet();
    }

    public static boolean containsStrangeCharacter(String text) {
        if (!text.isEmpty() && text.charAt(0) == '$') {
            return true;
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c != '*' && (c == ':' || c == '-' || Character.isJavaIdentifierPart(c))) continue;
            return true;
        }
        return false;
    }

    public static boolean isSelectorInjected(PsiElement element) {
        PsiLanguageInjectionHost context = InjectedLanguageManager.getInstance((Project)element.getProject()).getInjectionHost(element);
        return context != null && !context.textContains('\n') && !(context.getContainingFile() instanceof XmlFile);
    }

    private CssUtil() {
    }

    public static void rebindFileReference(@NotNull PsiElement referenceOwner, @NotNull PsiFile referenceTarget) {
        if (referenceOwner == null) {
            CssUtil.$$$reportNull$$$0(3);
        }
        if (referenceTarget == null) {
            CssUtil.$$$reportNull$$$0(4);
        }
        for (PsiReference reference : referenceOwner.getReferences()) {
            PsiFileReference lastReference;
            if (!(reference instanceof FileReferenceOwner) || (lastReference = ((FileReferenceOwner)reference).getLastFileReference()) == null) continue;
            lastReference.bindToElement((PsiElement)referenceTarget);
            break;
        }
    }

    public static boolean isInsideKeyframes(PsiElement context) {
        return PsiTreeUtil.getParentOfType((PsiElement)context, CssKeyframesSelector.class, (boolean)false) != null;
    }

    public static boolean isInsideFontFace(@Nullable PsiElement psiElement) {
        if (psiElement == null) {
            return false;
        }
        ASTNode node = psiElement.getNode();
        return node != null && TreeUtil.findParent((ASTNode)node, (IElementType)CssElementTypes.CSS_FONTFACE) != null;
    }

    public static boolean isInsidePageRuleset(@Nullable PsiElement psiElement) {
        if (psiElement == null) {
            return false;
        }
        ASTNode node = psiElement.getNode();
        return node != null && TreeUtil.findParent((ASTNode)node, (IElementType)CssElementTypes.CSS_PAGE) != null;
    }

    public static boolean isInsideComposesDeclaration(@NotNull PsiElement element) {
        if (element == null) {
            CssUtil.$$$reportNull$$$0(5);
        }
        CssDeclaration declaration = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, CssDeclaration.class);
        return CssPropertyUtil.isComposesProperty(declaration);
    }

    @NotNull
    public static List<String> getClassNames(String text, PsiElement element, @Nullable Consumer<? super String> fun) {
        XmlAttribute attr;
        String delim = " \t";
        PsiElement psiElement = element.getParent();
        if (psiElement instanceof XmlAttribute && (attr = (XmlAttribute)psiElement).getName().endsWith("Classes")) {
            delim = " \t,";
        }
        StringTokenizer st = new StringTokenizer(text, delim);
        ArrayList<String> names = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            names.add(token);
            if (fun == null) continue;
            fun.consume((Object)token);
        }
        ArrayList<String> arrayList = names;
        if (arrayList == null) {
            CssUtil.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Nullable
    public static MediaType getMediaTypeFromDataUri(@NotNull String dataUrl) {
        Matcher matcher;
        if (dataUrl == null) {
            CssUtil.$$$reportNull$$$0(7);
        }
        if ((matcher = URLUtil.DATA_URI_PATTERN.matcher(StringUtil.unquoteString((String)dataUrl))).matches()) {
            try {
                return MediaType.parse((String)StringUtil.notNullize((String)matcher.group(1)));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    @NotNull
    public static GlobalSearchScope getCompletionAndResolvingScopeForElement(@NotNull PsiElement element) {
        PsiFile contextFile;
        Module module;
        if (element == null) {
            CssUtil.$$$reportNull$$$0(8);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)(contextFile = element.getContainingFile()))) != null) {
            return CssUtil.getCompletionAndResolvingScopeForModule(module, contextFile);
        }
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)element.getProject());
        VirtualFile vFile = contextFile.getOriginalFile().getVirtualFile();
        if (vFile != null && !projectScope.contains(vFile)) {
            GlobalSearchScope globalSearchScope = projectScope.uniteWith(GlobalSearchScope.fileScope((PsiFile)contextFile));
            if (globalSearchScope == null) {
                CssUtil.$$$reportNull$$$0(9);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = projectScope;
        if (globalSearchScope == null) {
            CssUtil.$$$reportNull$$$0(10);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope getCompletionAndResolvingScopeForModule(@NotNull Module module, @Nullable PsiFile context) {
        if (module == null) {
            CssUtil.$$$reportNull$$$0(11);
        }
        VirtualFile contextFile = context != null ? context.getOriginalFile().getVirtualFile() : null;
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module).uniteWith(module.getModuleContentWithDependenciesScope());
        ScriptingLibraryMappings service = (ScriptingLibraryMappings)module.getProject().getService(ScriptingLibraryMappings.class);
        if (service != null && contextFile != null) {
            scope = scope.uniteWith(service.getLibraryScopeForFile(contextFile));
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            CssUtil.$$$reportNull$$$0(12);
        }
        return globalSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 6, 9, 10, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/CssUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceOwner";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceTarget";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataUrl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/CssUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCssDeclarationsDefinedForTag";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassNames";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionAndResolvingScopeForElement";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionAndResolvingScopeForModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCssDeclarationsDefinedForTag";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "rebindFileReference";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isInsideComposesDeclaration";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMediaTypeFromDataUri";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionAndResolvingScopeForElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionAndResolvingScopeForModule";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 6, 9, 10, 12 -> new IllegalStateException(string);
        };
    }
}

