/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Plugin;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.repository.internal.MavenMetadata;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.metadata.Metadata;

final class VersionsMetadata
extends MavenMetadata {
    private final Artifact artifact;

    VersionsMetadata(Artifact artifact, Date timestamp) {
        super(VersionsMetadata.createRepositoryMetadata(artifact), null, timestamp);
        this.artifact = artifact;
    }

    VersionsMetadata(Artifact artifact, File file, Date timestamp) {
        super(VersionsMetadata.createRepositoryMetadata(artifact), file, timestamp);
        this.artifact = artifact;
    }

    private static Metadata createRepositoryMetadata(Artifact artifact) {
        Metadata metadata = new Metadata();
        metadata.setGroupId(artifact.getGroupId());
        metadata.setArtifactId(artifact.getArtifactId());
        Versioning versioning = new Versioning();
        versioning.addVersion(artifact.getBaseVersion());
        if (!artifact.isSnapshot()) {
            versioning.setRelease(artifact.getBaseVersion());
        }
        if ("maven-plugin".equals(artifact.getProperty("type", ""))) {
            versioning.setLatest(artifact.getBaseVersion());
        }
        metadata.setVersioning(versioning);
        return metadata;
    }

    @Override
    protected void merge(Metadata recessive) {
        Versioning versioning = this.metadata.getVersioning();
        versioning.setLastUpdatedTimestamp(this.timestamp);
        if (recessive.getVersioning() != null) {
            if (versioning.getLatest() == null) {
                versioning.setLatest(recessive.getVersioning().getLatest());
            }
            if (versioning.getRelease() == null) {
                versioning.setRelease(recessive.getVersioning().getRelease());
            }
            LinkedHashSet<String> versions = new LinkedHashSet<String>(recessive.getVersioning().getVersions());
            versions.addAll(versioning.getVersions());
            versioning.setVersions(new ArrayList<String>(versions));
        }
        if (!recessive.getPlugins().isEmpty()) {
            this.metadata.setPlugins(new ArrayList<Plugin>(recessive.getPlugins()));
        }
    }

    public Object getKey() {
        return this.getGroupId() + ':' + this.getArtifactId();
    }

    public static Object getKey(Artifact artifact) {
        return artifact.getGroupId() + ':' + artifact.getArtifactId();
    }

    @Override
    public MavenMetadata setFile(File file) {
        return new VersionsMetadata(this.artifact, file, this.timestamp);
    }

    @Override
    public String getGroupId() {
        return this.artifact.getGroupId();
    }

    @Override
    public String getArtifactId() {
        return this.artifact.getArtifactId();
    }

    @Override
    public String getVersion() {
        return "";
    }

    @Override
    public Metadata.Nature getNature() {
        return this.artifact.isSnapshot() ? Metadata.Nature.RELEASE_OR_SNAPSHOT : Metadata.Nature.RELEASE;
    }
}

