/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CompiledAutomaton;

public class AutomatonQuery
extends MultiTermQuery
implements Accountable {
    private static final long BASE_RAM_BYTES = RamUsageEstimator.shallowSizeOfInstance(AutomatonQuery.class);
    protected final Automaton automaton;
    protected final CompiledAutomaton compiled;
    protected final Term term;
    protected final boolean automatonIsBinary;
    private final long ramBytesUsed;

    public AutomatonQuery(Term term, Automaton automaton) {
        this(term, automaton, false);
    }

    public AutomatonQuery(Term term, Automaton automaton, boolean isBinary) {
        this(term, automaton, isBinary, CONSTANT_SCORE_BLENDED_REWRITE);
    }

    public AutomatonQuery(Term term, Automaton automaton, boolean isBinary, MultiTermQuery.RewriteMethod rewriteMethod) {
        super(term.field(), rewriteMethod);
        this.term = term;
        this.automaton = automaton;
        this.automatonIsBinary = isBinary;
        this.compiled = new CompiledAutomaton(automaton, false, true, isBinary);
        this.ramBytesUsed = BASE_RAM_BYTES + term.ramBytesUsed() + automaton.ramBytesUsed() + this.compiled.ramBytesUsed();
    }

    @Override
    protected TermsEnum getTermsEnum(Terms terms, AttributeSource atts) throws IOException {
        return this.compiled.getTermsEnum(terms);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.compiled.hashCode();
        result = 31 * result + (this.term == null ? 0 : this.term.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AutomatonQuery other = (AutomatonQuery)obj;
        if (!this.compiled.equals(other.compiled)) {
            return false;
        }
        return !(this.term == null ? other.term != null : !this.term.equals(other.term));
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        if (!this.term.field().equals(field)) {
            buffer.append(this.term.field());
            buffer.append(":");
        }
        buffer.append(this.getClass().getSimpleName());
        buffer.append(" {");
        buffer.append('\n');
        buffer.append(this.automaton.toString());
        buffer.append("}");
        return buffer.toString();
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            this.compiled.visit(visitor, this, this.field);
        }
    }

    public Automaton getAutomaton() {
        return this.automaton;
    }

    public CompiledAutomaton getCompiled() {
        return this.compiled;
    }

    public boolean isAutomatonBinary() {
        return this.automatonIsBinary;
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }
}

