/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.environment.stores;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.helper.JupyterHelper;
import com.intellij.jupyter.core.premium.JupyterLicence;
import com.intellij.jupyter.py.environment.JupyterEnvironmentState;
import com.intellij.jupyter.py.environment.JupyterStandaloneVariablesView;
import com.intellij.jupyter.py.environment.frame.JupyterVarsFrameAccessor;
import com.intellij.jupyter.py.environment.stores.JupyterStandaloneVariablesViewStore;
import com.intellij.jupyter.py.variables.toolwindow.JupyterVarsSorter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.state.PyRuntime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 !2\u00020\u00012\u00020\u0002:\u0001!B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J \u0010\r\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u000eJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\tH\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0018\u001a\u00020\tH\u0016J \u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001b2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010 \u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/jupyter/py/environment/stores/JupyterEnvironmentStore;", "Lcom/jetbrains/python/debugger/state/PyRuntime;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "environments", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/jupyter/py/environment/JupyterEnvironmentState;", "tracker", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "updateEnvironmentState", "Lcom/intellij/xdebugger/frame/XValueChildrenList;", "backedNotebookVirtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "", "frameAccessor", "Lcom/jetbrains/python/debugger/PyFrameAccessor;", "frameValues", "getModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getFrameVariables", "notebookVirtualFile", "getFrameAccessor", "getGlobalPythonVariables", "", "Ljavax/swing/tree/TreeNode;", "virtualFile", "refreshEnv", "resortEnv", "dispose", "Companion", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterEnvironmentStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterEnvironmentStore.kt\ncom/intellij/jupyter/py/environment/stores/JupyterEnvironmentStore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1617#2,9:102\n1869#2:111\n1870#2:113\n1626#2:114\n1869#2,2:115\n1#3:112\n*S KotlinDebug\n*F\n+ 1 JupyterEnvironmentStore.kt\ncom/intellij/jupyter/py/environment/stores/JupyterEnvironmentStore\n*L\n83#1:102,9\n83#1:111\n83#1:113\n83#1:114\n86#1:115,2\n83#1:112\n*E\n"})
public class JupyterEnvironmentStore
implements PyRuntime,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentHashMap<VirtualFile, JupyterEnvironmentState> environments;
    @NotNull
    private final SimpleModificationTracker tracker;

    public JupyterEnvironmentStore(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.environments = new ConcurrentHashMap();
        this.tracker = new SimpleModificationTracker();
    }

    @Nullable
    public final XValueChildrenList updateEnvironmentState(@NotNull BackedNotebookVirtualFile backedNotebookVirtualFile) {
        Intrinsics.checkNotNullParameter((Object)backedNotebookVirtualFile, (String)"backedNotebookVirtualFile");
        if (JupyterLicence.INSTANCE.isUnpaidVersion()) {
            return null;
        }
        this.tracker.incModificationCount();
        JupyterVarsFrameAccessor frameAccessor = new JupyterVarsFrameAccessor(this.project, backedNotebookVirtualFile);
        XValueChildrenList frameValues = frameAccessor.loadValuesState();
        JupyterEnvironmentState environmentState = new JupyterEnvironmentState(frameAccessor, frameValues);
        ((Map)this.environments).put(backedNotebookVirtualFile.getOriginFile(), environmentState);
        return frameValues;
    }

    public final void updateEnvironmentState(@NotNull BackedNotebookVirtualFile backedNotebookVirtualFile, @NotNull PyFrameAccessor frameAccessor, @Nullable XValueChildrenList frameValues) {
        Intrinsics.checkNotNullParameter((Object)backedNotebookVirtualFile, (String)"backedNotebookVirtualFile");
        Intrinsics.checkNotNullParameter((Object)frameAccessor, (String)"frameAccessor");
        if (JupyterLicence.INSTANCE.isUnpaidVersion()) {
            return;
        }
        this.tracker.incModificationCount();
        JupyterEnvironmentState environmentState = new JupyterEnvironmentState(frameAccessor, frameValues);
        ((Map)this.environments).put(backedNotebookVirtualFile.getOriginFile(), environmentState);
    }

    @NotNull
    public final ModificationTracker getModificationTracker() {
        return (ModificationTracker)this.tracker;
    }

    @Nullable
    public XValueChildrenList getFrameVariables(@NotNull VirtualFile notebookVirtualFile) {
        Intrinsics.checkNotNullParameter((Object)notebookVirtualFile, (String)"notebookVirtualFile");
        JupyterEnvironmentState jupyterEnvironmentState = this.environments.get(notebookVirtualFile);
        return jupyterEnvironmentState != null ? jupyterEnvironmentState.getPythonVariablesList() : null;
    }

    @Nullable
    public PyFrameAccessor getFrameAccessor(@NotNull VirtualFile notebookVirtualFile) {
        Intrinsics.checkNotNullParameter((Object)notebookVirtualFile, (String)"notebookVirtualFile");
        JupyterEnvironmentState jupyterEnvironmentState = this.environments.get(notebookVirtualFile);
        return jupyterEnvironmentState != null ? jupyterEnvironmentState.getFrameAccessor() : null;
    }

    @Nullable
    public List<TreeNode> getGlobalPythonVariables(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterHelper.INSTANCE.getJupyterVirtualFileByOriginalVirtualFile(virtualFile);
        if (backedNotebookVirtualFile == null) {
            return null;
        }
        BackedNotebookVirtualFile backedNotebookVirtualFile2 = backedNotebookVirtualFile;
        JupyterStandaloneVariablesViewStore variablesViewStore = JupyterStandaloneVariablesViewStore.Companion.getInstance(project);
        JupyterStandaloneVariablesView jupyterStandaloneVariablesView = variablesViewStore.getOrCreateVariablesView(backedNotebookVirtualFile2);
        return jupyterStandaloneVariablesView != null && (jupyterStandaloneVariablesView = jupyterStandaloneVariablesView.getTree()) != null && (jupyterStandaloneVariablesView = jupyterStandaloneVariablesView.getRoot()) != null ? jupyterStandaloneVariablesView.getChildren() : null;
    }

    public void refreshEnv(@NotNull BackedNotebookVirtualFile backedNotebookVirtualFile) {
        Intrinsics.checkNotNullParameter((Object)backedNotebookVirtualFile, (String)"backedNotebookVirtualFile");
        this.environments.compute(backedNotebookVirtualFile.getOriginFile(), (arg_0, arg_1) -> JupyterEnvironmentStore.refreshEnv$lambda$1((arg_0, arg_1) -> JupyterEnvironmentStore.refreshEnv$lambda$0(this, backedNotebookVirtualFile, arg_0, arg_1), arg_0, arg_1));
    }

    public final void resortEnv(@NotNull BackedNotebookVirtualFile backedNotebookVirtualFile) {
        Intrinsics.checkNotNullParameter((Object)backedNotebookVirtualFile, (String)"backedNotebookVirtualFile");
        this.environments.computeIfPresent(backedNotebookVirtualFile.getOriginFile(), (arg_0, arg_1) -> JupyterEnvironmentStore.resortEnv$lambda$1((arg_0, arg_1) -> JupyterEnvironmentStore.resortEnv$lambda$0(this, arg_0, arg_1), arg_0, arg_1));
    }

    public void dispose() {
        this.tracker.incModificationCount();
        this.environments.clear();
    }

    private static final JupyterEnvironmentState refreshEnv$lambda$0(JupyterEnvironmentStore this$0, BackedNotebookVirtualFile $backedNotebookVirtualFile, VirtualFile virtualFile, JupyterEnvironmentState envState) {
        JupyterEnvironmentState frameAccessor;
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"<unused var>");
        this$0.tracker.incModificationCount();
        JupyterEnvironmentState jupyterEnvironmentState = envState;
        if (jupyterEnvironmentState == null || (jupyterEnvironmentState = jupyterEnvironmentState.getFrameAccessor()) == null) {
            jupyterEnvironmentState = new JupyterVarsFrameAccessor(this$0.project, $backedNotebookVirtualFile);
        }
        if ((frameAccessor = jupyterEnvironmentState) instanceof JupyterVarsFrameAccessor) {
            XValueChildrenList frameValues = ((JupyterVarsFrameAccessor)((Object)frameAccessor)).loadValuesState();
            return new JupyterEnvironmentState((PyFrameAccessor)frameAccessor, frameValues);
        }
        return null;
    }

    private static final JupyterEnvironmentState refreshEnv$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (JupyterEnvironmentState)$tmp0.invoke(p0, p1);
    }

    /*
     * WARNING - void declaration
     */
    private static final JupyterEnvironmentState resortEnv$lambda$0(JupyterEnvironmentStore this$0, VirtualFile virtualFile, JupyterEnvironmentState envState) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)envState, (String)"envState");
        this$0.tracker.incModificationCount();
        XValueChildrenList xValueChildrenList = envState.getPythonVariablesList();
        if (xValueChildrenList == null) {
            return envState;
        }
        XValueChildrenList old = xValueChildrenList;
        Iterable $this$mapNotNull$iv = (Iterable)RangesKt.until((int)0, (int)old.size());
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PyDebugValue it$iv$iv;
            int element$iv$iv$iv;
            int element$iv$iv = element$iv$iv$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            int it = element$iv$iv;
            boolean bl2 = false;
            XValue xValue = old.getValue(it);
            if ((xValue instanceof PyDebugValue ? (PyDebugValue)xValue : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv;
        List<PyDebugValue> sorted = JupyterVarsSorter.INSTANCE.sort(list, this$0.project);
        XValueChildrenList children = new XValueChildrenList(sorted.size());
        Iterable $this$forEach$iv = sorted;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            PyDebugValue v = (PyDebugValue)element$iv;
            boolean bl = false;
            children.add(v.getVisibleName(), (XValue)v);
        }
        return JupyterEnvironmentState.copy$default(envState, null, children, 1, null);
    }

    private static final JupyterEnvironmentState resortEnv$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (JupyterEnvironmentState)$tmp0.invoke(p0, p1);
    }

    @JvmStatic
    @NotNull
    public static final JupyterEnvironmentStore getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/py/environment/stores/JupyterEnvironmentStore$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/jupyter/py/environment/stores/JupyterEnvironmentStore;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.jupyter.py"})
    @SourceDebugExtension(value={"SMAP\nJupyterEnvironmentStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterEnvironmentStore.kt\ncom/intellij/jupyter/py/environment/stores/JupyterEnvironmentStore$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,101:1\n30#2,2:102\n*S KotlinDebug\n*F\n+ 1 JupyterEnvironmentStore.kt\ncom/intellij/jupyter/py/environment/stores/JupyterEnvironmentStore$Companion\n*L\n99#1:102,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JupyterEnvironmentStore getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<JupyterEnvironmentStore> serviceClass$iv = JupyterEnvironmentStore.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (JupyterEnvironmentStore)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

