/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.PredefinedCodeStyle;

public class JSGoogleCodeStyle
extends PredefinedCodeStyle {
    public JSGoogleCodeStyle() {
        super(JavaScriptBundle.message((String)"list.item.google.javascript.style.guide", (Object[])new Object[0]), (Language)JavascriptLanguage.INSTANCE);
    }

    public void apply(CodeStyleSettings settings) {
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings((Language)JavascriptLanguage.INSTANCE);
        JSCodeStyleSettings jsSettings = (JSCodeStyleSettings)settings.getCustomSettings(JSCodeStyleSettings.class);
        CommonCodeStyleSettings.IndentOptions indentOptions = commonSettings.getIndentOptions();
        if (indentOptions == null) {
            throw new RuntimeException("Assertion failure. indent options were null");
        }
        indentOptions.USE_TAB_CHARACTER = false;
        indentOptions.INDENT_SIZE = 2;
        indentOptions.TAB_SIZE = 2;
        indentOptions.CONTINUATION_INDENT_SIZE = 4;
        commonSettings.RIGHT_MARGIN = 80;
        commonSettings.KEEP_BLANK_LINES_IN_CODE = 1;
        jsSettings.USE_SEMICOLON_AFTER_STATEMENT = true;
        jsSettings.FORCE_SEMICOLON_STYLE = true;
        jsSettings.USE_DOUBLE_QUOTES = false;
        jsSettings.FORCE_QUOTE_STYlE = true;
        jsSettings.SPACE_BEFORE_FUNCTION_LEFT_PARENTH = false;
        jsSettings.CHAINED_CALL_DOT_ON_NEW_LINE = false;
        jsSettings.ENFORCE_TRAILING_COMMA = JSCodeStyleSettings.TrailingCommaOption.WhenMultiline;
        commonSettings.CALL_PARAMETERS_WRAP = 1;
        commonSettings.METHOD_PARAMETERS_WRAP = 1;
        commonSettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE = true;
        commonSettings.METHOD_CALL_CHAIN_WRAP = 5;
        commonSettings.BINARY_OPERATION_WRAP = 1;
        commonSettings.TERNARY_OPERATION_WRAP = 5;
        commonSettings.ARRAY_INITIALIZER_WRAP = 5;
        commonSettings.ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE = true;
        commonSettings.SPACE_BEFORE_METHOD_PARENTHESES = false;
        commonSettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES = false;
        commonSettings.SPACE_BEFORE_FOR_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_SWITCH_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_IF_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_WHILE_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_CATCH_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_CATCH_LBRACE = true;
        commonSettings.SPACE_BEFORE_ELSE_LBRACE = true;
        commonSettings.SPACE_BEFORE_FINALLY_LBRACE = true;
        commonSettings.SPACE_BEFORE_FOR_LBRACE = true;
        commonSettings.SPACE_BEFORE_IF_LBRACE = true;
        commonSettings.SPACE_BEFORE_METHOD_LBRACE = true;
        commonSettings.SPACE_BEFORE_SWITCH_LBRACE = true;
        commonSettings.SPACE_BEFORE_TRY_LBRACE = true;
        commonSettings.SPACE_BEFORE_WHILE_LBRACE = true;
        commonSettings.SPACE_BEFORE_DO_LBRACE = true;
        commonSettings.SPACE_AROUND_ASSIGNMENT_OPERATORS = true;
        commonSettings.SPACE_AROUND_LOGICAL_OPERATORS = true;
        commonSettings.SPACE_AROUND_EQUALITY_OPERATORS = true;
        commonSettings.SPACE_AROUND_RELATIONAL_OPERATORS = true;
        commonSettings.SPACE_AROUND_BITWISE_OPERATORS = true;
        commonSettings.SPACE_AROUND_ADDITIVE_OPERATORS = true;
        commonSettings.SPACE_AROUND_MULTIPLICATIVE_OPERATORS = true;
        commonSettings.SPACE_AROUND_SHIFT_OPERATORS = true;
        jsSettings.SPACE_AROUND_ARROW_FUNCTION_OPERATOR = true;
        commonSettings.SPACE_AFTER_COMMA = true;
        commonSettings.SPACE_BEFORE_COMMA = false;
        jsSettings.SPACE_BEFORE_PROPERTY_COLON = false;
        jsSettings.SPACE_AFTER_PROPERTY_COLON = true;
        jsSettings.SPACES_WITHIN_OBJECT_LITERAL_BRACES = false;
        jsSettings.SPACES_WITHIN_IMPORTS = false;
        jsSettings.SPACE_WITHIN_ARRAY_INITIALIZER_BRACKETS = false;
        jsSettings.SPACE_AFTER_DOTS_IN_REST_PARAMETER = false;
        jsSettings.SPACE_BEFORE_GENERATOR_MULT = false;
        jsSettings.SPACE_AFTER_GENERATOR_MULT = true;
    }
}

