/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions.nullPropagation;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElvisOwner;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSQualifiedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThenableElement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.sixrr.inspectjs.utils.EquivalenceChecker;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSNullPropagationIntention
extends JavaScriptIntention
implements LowPriorityAction {
    @IntentionName
    private String myText = JavaScriptBundle.message((String)"javascript.intention.opt.chain.chain.only", (Object[])new Object[0]);

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element2) throws IncorrectOperationException {
        NullPropagationData data2;
        if (project == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(1);
        }
        if ((data2 = JSNullPropagationIntention.getDataForExtendedConversion(element2)) != null) {
            JSNullPropagationIntention.doExtendedConversion(element2, data2);
        } else {
            JSNullPropagationIntention.doExpressionConversion(element2);
        }
    }

    private static void doExpressionConversion(@NotNull PsiElement element2) {
        JSExpression initialExpression;
        if (element2 == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(2);
        }
        if ((initialExpression = JSNullPropagationIntention.findInitialExpression(element2)) == null) {
            return;
        }
        List<JSExpression> expressionsChain = JSNullPropagationIntention.getLongestPossibleExpressionsChain(initialExpression);
        if (expressionsChain.isEmpty()) {
            return;
        }
        JSExpression trailingExpression = (JSExpression)ContainerUtil.getLastItem(expressionsChain);
        PsiElement containingParent = trailingExpression.getParent();
        PsiElement initialParent = initialExpression.getParent();
        String precedingText = initialParent.getText().substring(0, initialExpression.getStartOffsetInParent());
        JSNullPropagationIntention.addElvisOperators(trailingExpression, expressionsChain);
        containingParent.replace((PsiElement)JSPsiElementFactory.createJSExpression((String)(precedingText + trailingExpression.getText()), (PsiElement)initialExpression));
    }

    private static void doExtendedConversion(@NotNull PsiElement element2, @NotNull NullPropagationData data2) {
        JSSourceElement[] items;
        boolean isThen;
        if (element2 == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(3);
        }
        if (data2 == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(4);
        }
        JSThenableElement topmostThenable = (JSThenableElement)ContainerUtil.getFirstItem(data2.thenableElements);
        JSThenableElement deepestThenable = (JSThenableElement)ContainerUtil.getLastItem(data2.thenableElements);
        if (topmostThenable == null || deepestThenable == null) {
            return;
        }
        JSExpression conditionExpression = data2.getConditionExpression();
        JSExpression qualifier = JSNullPropagationIntention.getQualifierOf(conditionExpression, data2.nonNullableExpression);
        if (qualifier == null && data2.conditionIsEquivalentToThenExpr && data2.nonNullableExpression instanceof JSQualifiedExpression) {
            qualifier = ((JSQualifiedExpression)data2.nonNullableExpression).getQualifier();
        }
        String coalescingSign = JSNullPropagationIntention.shouldUseConditional(conditionExpression) ? " || " : " ?? ";
        boolean bl = isThen = qualifier != null && PsiTreeUtil.isAncestor((PsiElement)topmostThenable.getThenBranch(), (PsiElement)qualifier, (boolean)false);
        if (qualifier == null || !data2.hasMultipleConditions() && data2.conditionIsEquivalentToThenExpr) {
            String defaultValue = data2.nullableExpression != null ? data2.nullableExpression.getText() : "undefined";
            data2.nonNullableExpression.replace(JSPsiElementFactory.createJSExpression((String)(data2.nonNullableExpression.getText() + coalescingSign + defaultValue), (PsiElement)element2));
        } else {
            JSNullPropagationIntention.addElvisOperators(data2.nonNullableExpression, data2.conditions);
            if (!JSSymbolUtil.isUndefinedExpression((JSExpression)data2.nullableExpression) && data2.nullableExpression != null) {
                data2.nonNullableExpression.replace(JSPsiElementFactory.createJSExpression((String)(data2.nonNullableExpression.getText() + " ?? " + data2.nullableExpression.getText()), (PsiElement)element2));
            }
        }
        JSElement then = deepestThenable.getThenBranch();
        JSElement anElse = topmostThenable.getElseBranch();
        if (!isThen && anElse == null) {
            topmostThenable.delete();
            return;
        }
        PsiElement replaced = topmostThenable.replace(isThen ? (PsiElement)Objects.requireNonNull(then) : (PsiElement)Objects.requireNonNull(anElse));
        if (replaced instanceof JSBlockStatement && (items = ((JSBlockStatement)replaced).getStatementListItems()).length == 1) {
            replaced.replace((PsiElement)items[0]);
        }
    }

    private static void addElvisOperators(@NotNull JSExpression expression, @NotNull List<? extends JSExpression> conditions) {
        if (expression == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(5);
        }
        if (conditions == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(6);
        }
        for (JSExpression condition : ContainerUtil.reverse(conditions)) {
            JSExpression qualifier = JSNullPropagationIntention.getQualifierOf(condition, expression);
            if (qualifier == null) continue;
            JSChangeUtil.setElvisAfter((PsiElement)qualifier);
        }
    }

    @Nullable
    private static NullPropagationData getDataForExtendedConversion(@NotNull PsiElement element2) {
        boolean hasInitialValue;
        boolean reinit;
        List<JSThenableElement<?>> thenableElements;
        JSThenableElement topmostThenable;
        if (element2 == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(7);
        }
        if ((topmostThenable = (JSThenableElement)ContainerUtil.getFirstItem(thenableElements = JSNullPropagationIntention.getThenableElements(element2))) == null) {
            return null;
        }
        List<JSExpression> conditionExpressions = JSNullPropagationIntention.getExpressionsChain(thenableElements);
        if (conditionExpressions.isEmpty()) {
            return null;
        }
        JSExpression trailingConditionExpression = (JSExpression)ContainerUtil.getLastItem(conditionExpressions);
        if (trailingConditionExpression == null) {
            return null;
        }
        JSThenableElement deepestThenable = (JSThenableElement)ContainerUtil.getLastItem(thenableElements);
        if (deepestThenable == null) {
            return null;
        }
        JSElement thenBranch = deepestThenable.getThenBranch();
        JSElement elseBranch = topmostThenable.getElseBranch();
        String variableName = JSNullPropagationIntention.findTargetVariableNameFromBranches(new PsiElement[]{thenBranch, elseBranch});
        JSVariable assignmentTarget = JSNullPropagationIntention.findAdjacentAssignmentTarget((PsiElement)topmostThenable, variableName);
        JSExpression topmostConditionExpression = topmostThenable.getCondition();
        Pair<JSExpression, JSExpression> expressions = JSNullPropagationIntention.findThenElseExpressions(topmostConditionExpression, thenBranch, elseBranch, assignmentTarget, variableName, reinit = elseBranch == null && JSNullPropagationIntention.isNullReinit(topmostConditionExpression, conditionExpressions, assignmentTarget));
        if (expressions == null) {
            return null;
        }
        JSExpression nonNullableExpression = (JSExpression)expressions.first;
        JSExpression nullableExpression = (JSExpression)expressions.second;
        boolean bl = hasInitialValue = assignmentTarget != null && assignmentTarget.getInitializer() != null;
        if (!reinit && hasInitialValue && nullableExpression == null) {
            return null;
        }
        boolean conditionIsSubsetOfThenExpr = JSNullPropagationIntention.getQualifierOf(trailingConditionExpression, nonNullableExpression) != null;
        boolean conditionIsEquivalentToThenExpr = JSNullPropagationIntention.isEquivalentExpr(trailingConditionExpression, nonNullableExpression);
        NullPropagationData result2 = new NullPropagationData(nonNullableExpression, nullableExpression, conditionExpressions, thenableElements, conditionIsSubsetOfThenExpr, conditionIsEquivalentToThenExpr);
        return conditionIsEquivalentToThenExpr && (conditionExpressions.size() > 1 || nullableExpression != null) || conditionIsSubsetOfThenExpr || reinit ? result2 : null;
    }

    @NotNull
    private static List<JSThenableElement<?>> getThenableElements(@NotNull PsiElement element2) {
        JSThenableElement<?> thenable;
        if (element2 == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(8);
        }
        if ((thenable = JSNullPropagationIntention.findTopmostThenableElement(element2)) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSNullPropagationIntention.$$$reportNull$$$0(9);
            }
            return list;
        }
        SmartList elements = new SmartList(thenable);
        while (true) {
            if ((thenable = JSNullPropagationIntention.getChildThenable(thenable)) == null) {
                SmartList smartList = elements;
                if (smartList == null) {
                    JSNullPropagationIntention.$$$reportNull$$$0(10);
                }
                return smartList;
            }
            if (thenable.getElseBranch() != null) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    JSNullPropagationIntention.$$$reportNull$$$0(11);
                }
                return list;
            }
            elements.add(thenable);
        }
    }

    @Nullable
    private static JSThenableElement<?> findTopmostThenableElement(@NotNull PsiElement element2) {
        JSThenableElement item;
        if (element2 == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(12);
        }
        if ((item = (JSThenableElement)PsiTreeUtil.getParentOfType((PsiElement)element2, JSThenableElement.class, (boolean)false, (Class[])new Class[]{JSExecutionScope.class})) == null) {
            return null;
        }
        while (item.getElseBranch() == null) {
            PsiElement parent = item.getParent();
            if (parent instanceof JSBlockStatement) {
                parent = parent.getParent();
            }
            if (!(parent instanceof JSThenableElement)) break;
            item = (JSThenableElement)parent;
        }
        return item;
    }

    @NotNull
    private static List<JSExpression> getExpressionsChain(@NotNull List<JSThenableElement<?>> thenableElements) {
        if (thenableElements == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(13);
        }
        if (thenableElements.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSNullPropagationIntention.$$$reportNull$$$0(14);
            }
            return list;
        }
        if (thenableElements.size() == 1) {
            JSThenableElement firstItem = (JSThenableElement)ContainerUtil.getFirstItem(thenableElements);
            assert (firstItem != null);
            List conditionExpressions = JSNullPropagationIntention.getConditionExpressions(firstItem.getCondition());
            List list = JSNullPropagationIntention.validateConditionExpressionsChain(conditionExpressions) ? conditionExpressions : ContainerUtil.emptyList();
            if (list == null) {
                JSNullPropagationIntention.$$$reportNull$$$0(15);
            }
            return list;
        }
        ArrayList<JSExpression> conditions = new ArrayList<JSExpression>();
        for (JSThenableElement<?> thenableElement : thenableElements) {
            JSExpression condition = thenableElement.getCondition();
            if (JSNullPropagationIntention.isExpectedConditionExpression((PsiElement)condition)) {
                conditions.add(condition);
                continue;
            }
            if (condition instanceof JSBinaryExpression) {
                List<JSExpression> childExpressions = JSNullPropagationIntention.splitCompoundConditionToExpressions(condition);
                if (childExpressions.isEmpty()) {
                    List list = ContainerUtil.emptyList();
                    if (list == null) {
                        JSNullPropagationIntention.$$$reportNull$$$0(16);
                    }
                    return list;
                }
                conditions.addAll(childExpressions);
                continue;
            }
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSNullPropagationIntention.$$$reportNull$$$0(17);
            }
            return list;
        }
        List<Object> list = JSNullPropagationIntention.validateConditionExpressionsChain(conditions) ? conditions : ContainerUtil.emptyList();
        if (list == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(18);
        }
        return list;
    }

    @Nullable
    private static JSThenableElement<?> getChildThenable(@NotNull JSThenableElement<?> thenable) {
        JSElement then;
        if (thenable == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(19);
        }
        if ((then = thenable.getThenBranch()) instanceof JSBlockStatement) {
            JSSourceElement[] statements = ((JSBlockStatement)then).getStatementListItems();
            if (statements.length != 1) {
                return null;
            }
            JSThenableElement statement = (JSThenableElement)ObjectUtils.tryCast((Object)statements[0], JSThenableElement.class);
            if (statement != null) {
                return statement;
            }
        } else if (then instanceof JSThenableElement) {
            return (JSThenableElement)then;
        }
        return null;
    }

    private static boolean isEquivalentExpr(@NotNull JSExpression expr1, @NotNull JSExpression expr2) {
        if (expr1 == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(20);
        }
        if (expr2 == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(21);
        }
        return JSNullPropagationIntention.isExpectedConditionExpression((PsiElement)expr1) && JSNullPropagationIntention.isExpectedConditionExpression((PsiElement)expr2) && EquivalenceChecker.expressionsAreEquivalent(expr1, expr2);
    }

    @Nullable
    private static String findTargetVariableNameFromBranches(PsiElement ... elements) {
        if (elements == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(22);
        }
        for (PsiElement element2 : elements) {
            JSInitializerOwner[] declarations;
            JSSourceElement[] items;
            if (element2 instanceof JSBlockStatement && (items = ((JSBlockStatement)element2).getStatementListItems()).length != 0 && items[0] instanceof JSStatement) {
                element2 = items[0];
            }
            if (element2 instanceof JSExpressionStatement) {
                element2 = ((JSExpressionStatement)element2).getExpression();
            }
            if (element2 instanceof JSAssignmentExpression) {
                JSReferenceExpression reference;
                if ((element2 = ((JSAssignmentExpression)element2).getLOperand()) instanceof JSDefinitionExpression) {
                    element2 = ((JSDefinitionExpression)element2).getExpression();
                }
                if ((reference = (JSReferenceExpression)ObjectUtils.tryCast((Object)element2, JSReferenceExpression.class)) != null) {
                    return reference.getReferenceName();
                }
            }
            if (element2 instanceof JSVarStatement && (declarations = ((JSVarStatement)element2).getDeclarations()).length != 0 && declarations[0] instanceof JSVariable) {
                element2 = declarations[0];
            }
            if (!(element2 instanceof JSVariable)) continue;
            return ((JSVariable)element2).getName();
        }
        return null;
    }

    @Nullable
    private static JSVariable findAdjacentAssignmentTarget(@NotNull PsiElement from, @Nullable String name) {
        JSVarStatement varStatement;
        if (from == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(23);
        }
        if ((varStatement = (JSVarStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)PsiTreeUtil.getParentOfType((PsiElement)from, JSStatement.class, (boolean)false), JSVarStatement.class)) == null) {
            return null;
        }
        JSInitializerOwner owner = (JSInitializerOwner)ContainerUtil.find((Object[])varStatement.getDeclarations(), decl -> decl instanceof JSVariable && Objects.equals(decl.getName(), name));
        return (JSVariable)ObjectUtils.tryCast((Object)owner, JSVariable.class);
    }

    @Nullable
    private static JSExpression getQualifierOf(@Nullable JSExpression compareWith, @Nullable JSExpression expression) {
        if (compareWith == null || expression == null) {
            return null;
        }
        if (compareWith instanceof JSThisExpression && expression instanceof JSThisExpression) {
            return expression;
        }
        if (!(expression instanceof JSElvisOwner)) {
            return null;
        }
        JSExpression qualifier = JSPsiImplUtils.getElvisQualifier((JSElvisOwner)((JSElvisOwner)expression));
        if (qualifier == null && EquivalenceChecker.expressionsAreEquivalent(expression, compareWith)) {
            return expression;
        }
        while (qualifier != null) {
            if (EquivalenceChecker.expressionsAreEquivalent(qualifier, compareWith)) {
                return qualifier;
            }
            if (!(qualifier instanceof JSElvisOwner)) {
                return null;
            }
            qualifier = JSPsiImplUtils.getElvisQualifier((JSElvisOwner)((JSElvisOwner)qualifier));
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static BranchExpressionInfo getBranchExpression(@Nullable JSElement element2, @Nullable String targetName, Boolean isNullableBranch) {
        JSInitializerOwner[] declarations;
        boolean hadBlock = false;
        if (element2 instanceof JSBlockStatement) {
            JSSourceElement[] items = ((JSBlockStatement)element2).getStatementListItems();
            if (items.length != 1 || !(items[0] instanceof JSStatement)) {
                return null;
            }
            element2 = items[0];
            hadBlock = true;
        }
        if (element2 instanceof JSExpressionStatement) {
            if ((element2 = ((JSExpressionStatement)element2).getExpression()) instanceof JSAssignmentExpression) {
                JSReferenceExpression leftRef;
                JSExpression operand = ((JSAssignmentExpression)element2).getLOperand();
                if (operand instanceof JSDefinitionExpression) {
                    operand = ((JSDefinitionExpression)operand).getExpression();
                }
                if ((leftRef = (JSReferenceExpression)ObjectUtils.tryCast((Object)operand, JSReferenceExpression.class)) != null) {
                    String leftName = leftRef.getReferenceName();
                    if (targetName != null && !targetName.equals(leftName)) return null;
                    element2 = ((JSAssignmentExpression)element2).getROperand();
                }
            } else if (hadBlock && (isNullableBranch.booleanValue() || !(element2 instanceof JSCallExpression))) {
                return null;
            }
        }
        if (element2 instanceof JSVarStatement && (declarations = ((JSVarStatement)element2).getDeclarations()).length == 1 && declarations[0] instanceof JSVariable) {
            element2 = declarations[0];
        }
        if (element2 instanceof JSVariable) {
            JSVarStatement statement = ((JSVariable)element2).getStatement();
            if (statement == null || hadBlock && statement.getVarKeyword() != JSVarStatement.VarKeyword.VAR) {
                return null;
            }
            String leftName = element2.getName();
            if (targetName != null && !targetName.equals(leftName)) return null;
            element2 = ((JSVariable)element2).getInitializer();
        }
        if (isNullableBranch.booleanValue() || element2 instanceof JSElvisOwner || element2 instanceof JSThisExpression) return new BranchExpressionInfo((JSExpression)ObjectUtils.tryCast((Object)element2, JSExpression.class));
        return null;
    }

    @Nullable
    private static Pair<JSExpression, JSExpression> findThenElseExpressions(@Nullable JSExpression topmostCondition, @Nullable JSElement thenBranch, @Nullable JSElement elseBranch, @Nullable JSVariable assignmentTargetDeclaration, @Nullable String variableName, boolean isNullReinit) {
        JSElement nonNullableBranch;
        IElementType sign = topmostCondition instanceof JSBinaryExpression ? ((JSBinaryExpression)topmostCondition).getOperationSign() : null;
        boolean truthy = JSNullPropagationIntention.isExpectedConditionExpression((PsiElement)topmostCondition) || sign == JSTokenTypes.ANDAND || sign == JSTokenTypes.NEQEQ || sign == JSTokenTypes.NE;
        JSElement jSElement = nonNullableBranch = truthy ? thenBranch : elseBranch;
        if (nonNullableBranch == null && isNullReinit) {
            nonNullableBranch = assignmentTargetDeclaration;
        }
        if (nonNullableBranch == null) {
            return null;
        }
        JSElement nullableBranch = truthy ? elseBranch : thenBranch;
        BranchExpressionInfo nonNullableExpression = JSNullPropagationIntention.getBranchExpression(nonNullableBranch, variableName, false);
        if (nonNullableExpression == null || nonNullableExpression.myExpression == null) {
            return null;
        }
        BranchExpressionInfo nullableExpression = JSNullPropagationIntention.getBranchExpression(nullableBranch, variableName, true);
        if (nullableExpression == null) {
            return null;
        }
        return Pair.create((Object)nonNullableExpression.myExpression, (Object)nullableExpression.myExpression);
    }

    private static boolean isNullReinit(@Nullable JSExpression topmostCondition, @NotNull List<JSExpression> conditions, @Nullable JSVariable assignmentTargetDeclaration) {
        if (conditions == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(24);
        }
        return assignmentTargetDeclaration != null && assignmentTargetDeclaration.getInitializer() != null && conditions.size() == 1 && topmostCondition instanceof JSBinaryExpression && ((JSBinaryExpression)topmostCondition).getOperationSign() == JSTokenTypes.EQEQ && assignmentTargetDeclaration.isEquivalentTo(JSNullPropagationIntention.resolveExpression((JSExpression)ContainerUtil.getLastItem(conditions)));
    }

    @NotNull
    private static List<JSExpression> getConditionExpressions(@Nullable JSExpression condition) {
        if (JSNullPropagationIntention.isExpectedConditionExpression((PsiElement)condition)) {
            List<JSExpression> list = List.of(condition);
            if (list == null) {
                JSNullPropagationIntention.$$$reportNull$$$0(25);
            }
            return list;
        }
        if (condition instanceof JSBinaryExpression) {
            IElementType operationSign = ((JSBinaryExpression)condition).getOperationSign();
            if (operationSign == JSTokenTypes.ANDAND) {
                return JSNullPropagationIntention.splitCompoundConditionToExpressions(condition);
            }
            if (!JSTokenTypes.EQUALITY_OPERATIONS.contains(operationSign)) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    JSNullPropagationIntention.$$$reportNull$$$0(26);
                }
                return list;
            }
            JSExpression lOperand = ((JSBinaryExpression)condition).getLOperand();
            JSExpression rOperand = ((JSBinaryExpression)condition).getROperand();
            if (lOperand instanceof JSLiteralExpression && ((JSLiteralExpression)lOperand).isNullLiteral() || JSSymbolUtil.isUndefinedExpression((JSExpression)lOperand)) {
                List<JSExpression> list = JSNullPropagationIntention.isExpectedConditionExpression((PsiElement)rOperand) ? List.of(rOperand) : ContainerUtil.emptyList();
                if (list == null) {
                    JSNullPropagationIntention.$$$reportNull$$$0(27);
                }
                return list;
            }
            if (rOperand instanceof JSLiteralExpression && ((JSLiteralExpression)rOperand).isNullLiteral() || JSSymbolUtil.isUndefinedExpression((JSExpression)rOperand)) {
                List<JSExpression> list = JSNullPropagationIntention.isExpectedConditionExpression((PsiElement)lOperand) ? List.of(lOperand) : ContainerUtil.emptyList();
                if (list == null) {
                    JSNullPropagationIntention.$$$reportNull$$$0(28);
                }
                return list;
            }
        }
        if (condition instanceof JSPrefixExpression && ((JSPrefixExpression)condition).getOperationSign() == JSTokenTypes.EXCL) {
            JSExpression expression = ((JSPrefixExpression)condition).getExpression();
            List<JSExpression> list = JSNullPropagationIntention.isExpectedConditionExpression((PsiElement)expression) ? List.of(expression) : ContainerUtil.emptyList();
            if (list == null) {
                JSNullPropagationIntention.$$$reportNull$$$0(29);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(30);
        }
        return list;
    }

    private static boolean validateConditionExpressionsChain(@NotNull List<JSExpression> conditionExpressions) {
        JSExpression trailingExpression;
        if (conditionExpressions == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(31);
        }
        if (conditionExpressions.isEmpty()) {
            return false;
        }
        ListIterator<JSExpression> iterator = conditionExpressions.listIterator(conditionExpressions.size());
        JSExpression jSExpression = trailingExpression = iterator.hasPrevious() ? iterator.previous() : null;
        if (trailingExpression == null) {
            return false;
        }
        while (iterator.hasPrevious()) {
            JSExpression expression = iterator.previous();
            if (JSNullPropagationIntention.getQualifierOf(expression, trailingExpression) == null) {
                return false;
            }
            trailingExpression = expression;
        }
        return JSNullPropagationIntention.isExpressionResolvedSuccessfully(trailingExpression);
    }

    @NotNull
    private static List<JSExpression> splitCompoundConditionToExpressions(@Nullable JSExpression expression) {
        if (!(expression instanceof JSBinaryExpression)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSNullPropagationIntention.$$$reportNull$$$0(32);
            }
            return list;
        }
        ArrayList<JSExpression> expressions = new ArrayList<JSExpression>();
        while (expression != null) {
            JSExpression conditionExpression;
            if (expression instanceof JSBinaryExpression && ((JSBinaryExpression)expression).getOperationSign() == JSTokenTypes.ANDAND) {
                conditionExpression = ((JSBinaryExpression)expression).getROperand();
                expression = ((JSBinaryExpression)expression).getLOperand();
            } else {
                conditionExpression = expression;
                expression = null;
            }
            if (!JSNullPropagationIntention.isExpectedConditionExpression((PsiElement)conditionExpression)) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    JSNullPropagationIntention.$$$reportNull$$$0(33);
                }
                return list;
            }
            expressions.add(conditionExpression);
        }
        List list = ContainerUtil.reverse(expressions);
        if (list == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(34);
        }
        return list;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element2) {
        if (project == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(35);
        }
        if (element2 == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(36);
        }
        if (!super.isAvailable(project, editor, element2)) {
            return false;
        }
        String intentionText = JSNullPropagationIntention.getExtendedConversionIntentionText(element2);
        if (intentionText == null) {
            intentionText = JSNullPropagationIntention.getExpressionConversionText(element2);
        }
        if (intentionText == null) {
            return false;
        }
        this.myText = intentionText;
        return true;
    }

    @Nullable
    @IntentionName
    private static String getExtendedConversionIntentionText(@NotNull PsiElement element2) {
        boolean shouldUseConditional;
        NullPropagationData data2;
        if (element2 == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(37);
        }
        if ((data2 = JSNullPropagationIntention.getDataForExtendedConversion(element2)) == null) {
            return null;
        }
        JSExpression conditionExpression = data2.getConditionExpression();
        boolean isStrictOptChain = JSSymbolUtil.isUndefinedExpression((JSExpression)data2.nullableExpression) || data2.nullableExpression == null;
        boolean isStrictNullish = data2.conditionIsEquivalentToThenExpr && !data2.hasMultipleConditions() || data2.nonNullableExpression.getParent() instanceof JSVariable;
        boolean bl = shouldUseConditional = JSNullPropagationIntention.shouldUseConditional(conditionExpression) && (!data2.conditionIsSubsetOfThenExpr || data2.conditionIsEquivalentToThenExpr);
        return isStrictOptChain ? JavaScriptBundle.message((String)"javascript.intention.opt.chain.chain.only", (Object[])new Object[0]) : (isStrictNullish ? (shouldUseConditional ? JavaScriptBundle.message((String)"javascript.intention.opt.chain.conditional.only", (Object[])new Object[0]) : JavaScriptBundle.message((String)"javascript.intention.opt.chain.coalesce.only", (Object[])new Object[0])) : JavaScriptBundle.message((String)"javascript.intention.opt.chain.chain.and.coalesce", (Object[])new Object[0]));
    }

    @Nullable
    @IntentionName
    private static String getExpressionConversionText(@NotNull PsiElement element2) {
        JSExpression expression;
        if (element2 == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(38);
        }
        return (expression = JSNullPropagationIntention.findInitialExpression(element2)) != null && !JSNullPropagationIntention.getLongestPossibleExpressionsChain(expression).isEmpty() ? JavaScriptBundle.message((String)"javascript.intention.opt.chain.chain.only", (Object[])new Object[0]) : null;
    }

    @Nullable
    private static JSExpression findInitialExpression(@NotNull PsiElement element2) {
        if (element2 == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(39);
        }
        PsiElement parent = element2.getParent();
        JSExpression trailingExpression = null;
        if (JSNullPropagationIntention.isExpectedBinaryCondition(parent)) {
            JSExpression rOperand;
            trailingExpression = JSNullPropagationIntention.getExpressionFromOperand(((JSBinaryExpression)parent).getLOperand());
            if (JSNullPropagationIntention.getQualifierOf(trailingExpression, rOperand = JSNullPropagationIntention.getExpressionFromOperand(((JSBinaryExpression)parent).getROperand())) == null) {
                return null;
            }
        } else if (JSNullPropagationIntention.isExpectedConditionExpression(parent) && JSNullPropagationIntention.isExpectedConditionExpression(parent = PsiTreeUtil.findFirstParent((PsiElement)parent, (boolean)false, el -> !JSNullPropagationIntention.isExpectedConditionExpression(el.getParent()))) && JSNullPropagationIntention.isExpectedBinaryCondition(parent.getParent())) {
            trailingExpression = (JSExpression)parent;
        }
        if (trailingExpression == null) {
            return null;
        }
        while (JSNullPropagationIntention.isExpectedBinaryCondition(trailingExpression.getParent())) {
            JSExpression prevExpression = JSNullPropagationIntention.findPrevExpression(trailingExpression);
            if (prevExpression == null || JSNullPropagationIntention.getQualifierOf(prevExpression, trailingExpression) == null) {
                return trailingExpression;
            }
            trailingExpression = prevExpression;
        }
        return trailingExpression;
    }

    @Nullable
    private static JSExpression getExpressionFromOperand(@Nullable JSExpression operand) {
        JSExpression rOperand;
        if (JSNullPropagationIntention.isExpectedConditionExpression((PsiElement)operand)) {
            return operand;
        }
        if (JSNullPropagationIntention.isExpectedBinaryCondition((PsiElement)operand) && JSNullPropagationIntention.isExpectedConditionExpression((PsiElement)(rOperand = ((JSBinaryExpression)operand).getROperand()))) {
            return rOperand;
        }
        return null;
    }

    @Nullable
    public static JSExpression findPrevExpression(@NotNull JSExpression expression) {
        PsiElement parent;
        if (expression == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(40);
        }
        if (!JSNullPropagationIntention.isExpectedBinaryCondition(parent = expression.getParent())) {
            return null;
        }
        JSExpression operand = ((JSBinaryExpression)parent).getLOperand();
        return operand != expression ? JSNullPropagationIntention.getExpressionFromOperand(operand) : null;
    }

    @Nullable
    public static JSExpression findNextExpression(@NotNull JSExpression expression) {
        PsiElement parent;
        if (expression == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(41);
        }
        if (!JSNullPropagationIntention.isExpectedBinaryCondition(parent = expression.getParent())) {
            return null;
        }
        JSExpression operand = ((JSBinaryExpression)parent).getROperand();
        if (operand == expression) {
            if (JSNullPropagationIntention.isExpectedBinaryCondition(parent = parent.getParent())) {
                operand = ((JSBinaryExpression)parent).getROperand();
            } else {
                return null;
            }
        }
        return JSNullPropagationIntention.isExpectedConditionExpression((PsiElement)operand) ? operand : null;
    }

    @NotNull
    private static List<JSExpression> getLongestPossibleExpressionsChain(@NotNull JSExpression condition) {
        JSExpression nextExpression;
        if (condition == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(42);
        }
        SmartList expressions = new SmartList((Object)condition);
        while (JSNullPropagationIntention.isExpectedBinaryCondition(condition.getParent()) && (nextExpression = JSNullPropagationIntention.findNextExpression(condition)) != null && JSNullPropagationIntention.getQualifierOf(condition, nextExpression) != null && JSNullPropagationIntention.validateConditionDeep((PsiElement)nextExpression)) {
            expressions.add(nextExpression);
            condition = nextExpression;
        }
        if (expressions.size() > 1) {
            JSExpression expression = (JSExpression)expressions.get(0);
            Object object = JSNullPropagationIntention.isExpressionResolvedSuccessfully(expression) ? expressions : ContainerUtil.emptyList();
            if (object == null) {
                JSNullPropagationIntention.$$$reportNull$$$0(43);
            }
            return object;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(44);
        }
        return list;
    }

    @Nullable
    private static PsiElement resolveExpression(@NotNull JSExpression expression) {
        JSExpression qualifier;
        if (expression == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(45);
        }
        return (qualifier = JSResolveUtil.getLeftmostQualifier((JSExpression)expression)) instanceof PsiReference ? ((PsiReference)qualifier).resolve() : null;
    }

    private static boolean isExpressionResolvedSuccessfully(@NotNull JSExpression expression) {
        if (expression == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(46);
        }
        return JSNullPropagationIntention.resolveExpression(expression) != null;
    }

    private static boolean isExpectedConditionExpression(@Nullable PsiElement expression) {
        return expression instanceof JSQualifiedExpression || expression instanceof JSThisExpression;
    }

    private static boolean isExpectedBinaryCondition(@Nullable PsiElement expression) {
        return expression instanceof JSBinaryExpression && ((JSBinaryExpression)expression).getOperationSign() == JSTokenTypes.ANDAND;
    }

    private static boolean validateConditionDeep(@NotNull PsiElement expression) {
        if (expression == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(47);
        }
        if (expression instanceof JSThisExpression) {
            return true;
        }
        if (!(expression instanceof JSElvisOwner)) {
            return false;
        }
        JSExpression qualifier = JSPsiImplUtils.getElvisQualifier((JSElvisOwner)((JSElvisOwner)expression));
        while (qualifier != null) {
            if (qualifier instanceof JSThisExpression) {
                return true;
            }
            if (!(qualifier instanceof JSElvisOwner) || !JSNullPropagationIntention.isExpectedConditionExpression((PsiElement)qualifier)) {
                return false;
            }
            qualifier = JSPsiImplUtils.getElvisQualifier((JSElvisOwner)((JSElvisOwner)qualifier));
        }
        return true;
    }

    private static boolean shouldUseConditional(JSExpression first) {
        PsiElement parent = first.getParent();
        boolean explicitNullCheck = parent instanceof JSBinaryExpression && JSTokenTypes.EQUALITY_OPERATIONS.contains(((JSBinaryExpression)parent).getOperationSign());
        return JSNullPropagationIntention.isExpectedConditionExpression((PsiElement)first) && !explicitNullCheck;
    }

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"javascript.intention.opt.chain.family", (Object[])new Object[0]);
        if (string == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(48);
        }
        return string;
    }

    @IntentionName
    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            JSNullPropagationIntention.$$$reportNull$$$0(49);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 11, 14, 15, 16, 17, 18, 25, 26, 27, 28, 29, 30, 32, 33, 34, 43, 44, 48, 49 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 12: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 5: 
            case 40: 
            case 41: 
            case 45: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditions";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 43: 
            case 44: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/nullPropagation/JSNullPropagationIntention";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thenableElements";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thenable";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr1";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr2";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditionExpressions";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/nullPropagation/JSNullPropagationIntention";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getThenableElements";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionsChain";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getConditionExpressions";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "splitCompoundConditionToExpressions";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getLongestPossibleExpressionsChain";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doExpressionConversion";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doExtendedConversion";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addElvisOperators";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDataForExtendedConversion";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getThenableElements";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 43: 
            case 44: 
            case 48: 
            case 49: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findTopmostThenableElement";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionsChain";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getChildThenable";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentExpr";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findTargetVariableNameFromBranches";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findAdjacentAssignmentTarget";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isNullReinit";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "validateConditionExpressionsChain";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getExtendedConversionIntentionText";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionConversionText";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "findInitialExpression";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "findPrevExpression";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "findNextExpression";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getLongestPossibleExpressionsChain";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "resolveExpression";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isExpressionResolvedSuccessfully";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "validateConditionDeep";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 11, 14, 15, 16, 17, 18, 25, 26, 27, 28, 29, 30, 32, 33, 34, 43, 44, 48, 49 -> new IllegalStateException(string);
        };
    }

    private static final class NullPropagationData {
        @NotNull
        private final JSExpression nonNullableExpression;
        @Nullable
        private final JSExpression nullableExpression;
        @NotNull
        private final List<JSExpression> conditions;
        @NotNull
        private final List<JSThenableElement<?>> thenableElements;
        private final boolean conditionIsSubsetOfThenExpr;
        private final boolean conditionIsEquivalentToThenExpr;

        private NullPropagationData(@NotNull JSExpression nonNullableExpression, @Nullable JSExpression nullableExpression, @NotNull List<JSExpression> conditionExpressions, @NotNull List<JSThenableElement<?>> thenableElements, boolean conditionIsSubsetOfThenExpr, boolean conditionIsEquivalentToThenExpr) {
            if (nonNullableExpression == null) {
                NullPropagationData.$$$reportNull$$$0(0);
            }
            if (conditionExpressions == null) {
                NullPropagationData.$$$reportNull$$$0(1);
            }
            if (thenableElements == null) {
                NullPropagationData.$$$reportNull$$$0(2);
            }
            if (conditionExpressions.isEmpty()) {
                throw new IllegalArgumentException("Empty condition expressions list");
            }
            if (thenableElements.isEmpty()) {
                throw new IllegalArgumentException("Empty thenable elements list");
            }
            this.nonNullableExpression = nonNullableExpression;
            this.nullableExpression = nullableExpression;
            this.conditions = conditionExpressions;
            this.thenableElements = thenableElements;
            this.conditionIsSubsetOfThenExpr = conditionIsSubsetOfThenExpr;
            this.conditionIsEquivalentToThenExpr = conditionIsEquivalentToThenExpr;
        }

        private boolean hasMultipleConditions() {
            return this.conditions.size() > 1;
        }

        @NotNull
        private JSExpression getConditionExpression() {
            JSExpression jSExpression = (JSExpression)ContainerUtil.getLastItem(this.conditions);
            if (jSExpression == null) {
                NullPropagationData.$$$reportNull$$$0(3);
            }
            return jSExpression;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nonNullableExpression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "conditionExpressions";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thenableElements";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/intentions/nullPropagation/JSNullPropagationIntention$NullPropagationData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/intentions/nullPropagation/JSNullPropagationIntention$NullPropagationData";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConditionExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static final class BranchExpressionInfo {
        @Nullable
        private final JSExpression myExpression;

        private BranchExpressionInfo(@Nullable JSExpression expression) {
            this.myExpression = expression;
        }
    }
}

