/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.util;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.e4x.JSE4XNamespaceReference;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageWrapper;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.util.JSMemberUsageInfo;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.Nullable;

public final class ActionScriptRefactoringUtil {
    private ActionScriptRefactoringUtil() {
    }

    public static Collection<PsiFile> qualifyIncomingReferences(UsageInfo[] usages) {
        HashSet<PsiFile> filesWithUsages = new HashSet<PsiFile>();
        for (UsageInfo usageInfo : usages) {
            JSMemberUsageInfo usage = (JSMemberUsageInfo)usageInfo;
            PsiFile file = usage.getElement().getContainingFile();
            XmlBackedJSClass xmlBackedClass = JSResolveUtil.getXmlBackedClass((JSFile)((JSFile)file));
            filesWithUsages.add(xmlBackedClass != null ? xmlBackedClass.getContainingFile() : file);
            JSRefactoringUtil.makeQualified((JSReferenceExpression)usage.getElement(), (JSQualifiedNamedElement)usage.qualifierClass, false);
        }
        return filesWithUsages;
    }

    public static PsiElement fixOutgoingReferences(PsiElement scope2, Collection<String> imports, Collection<String> namespaces, Collection<JSAttributeListOwner> membersToMove, @Nullable JSClass targetClass, boolean justCollectImports, boolean visibilityWillChange) {
        JSReferenceExpression refExpr;
        PsiElement resolved;
        if (scope2 != null && !DialectDetector.isActionScript((PsiElement)scope2)) {
            return scope2;
        }
        if (scope2 instanceof JSReferenceExpression && (resolved = (refExpr = (JSReferenceExpression)scope2).resolve()) instanceof JSQualifiedNamedElement) {
            String qName;
            JSNamespaceDeclaration namespaceDecl;
            boolean isReferenceToMovedMember = JSRefactoringUtil.isChildOfAny(resolved, membersToMove);
            if (!(PsiTreeUtil.isAncestor((PsiElement)resolved, (PsiElement)refExpr, (boolean)false) || isReferenceToMovedMember && visibilityWillChange || (namespaceDecl = JSRefactoringUtil.getNamespace(resolved)) == null)) {
                qName = namespaceDecl.getQualifiedName();
                JSE4XNamespaceReference namespaceRef = (JSE4XNamespaceReference)PsiTreeUtil.getChildOfType((PsiElement)refExpr, JSE4XNamespaceReference.class);
                if (!"AS3".equals(qName)) {
                    if (namespaceRef == null) {
                        namespaces.add(qName);
                    }
                    if (qName.indexOf(46) != -1) {
                        imports.add(qName);
                    }
                }
            }
            if (!isReferenceToMovedMember || resolved instanceof JSClass) {
                PsiElement r;
                JSClass containingClass = JSUtils.getMemberContainingClass((PsiElement)resolved);
                if (containingClass == null) {
                    JSType type2 = JSNamedType.createType((String)((JSQualifiedNamedElement)resolved).getQualifiedName(), (JSTypeSource)JSTypeSourceFactory.createTypeSource((PsiElement)resolved), (JSContext)JSContext.INSTANCE);
                    if (JSTypeUtils.isActionScriptVectorType((JSType)type2)) {
                        ActionScriptRefactoringUtil.processChildren((PsiElement)refExpr, imports, namespaces, membersToMove, targetClass, justCollectImports, visibilityWillChange);
                        return refExpr;
                    }
                    String qName2 = type2.getTypeText();
                    if (qName2.indexOf(46) != -1) {
                        imports.add(qName2);
                    }
                    if (!justCollectImports && refExpr.getQualifier() == null && !(refExpr.getParent() instanceof JSE4XNamespaceReference)) {
                        refExpr = JSReferenceExpressionImpl.bindToElement((JSReferenceExpression)refExpr, (String)qName2, (PsiNamedElement)((PsiNamedElement)resolved), (boolean)true);
                    }
                    return refExpr;
                }
                if (JSResolveUtil.isConstructorFunction((PsiElement)resolved) && JSTypeUtils.isActionScriptVectorType((JSType)JSNamedType.createType((String)containingClass.getQualifiedName(), (JSTypeSource)JSTypeSource.EMPTY, (JSContext)JSContext.INSTANCE))) {
                    ActionScriptRefactoringUtil.processChildren((PsiElement)refExpr, imports, namespaces, membersToMove, targetClass, justCollectImports, visibilityWillChange);
                } else if (refExpr.getQualifier() == null) {
                    if (targetClass == null || !JSInheritanceUtil.isParentClass((JSClass)targetClass, (JSClass)containingClass, (boolean)false)) {
                        qName = containingClass.getQualifiedName();
                        if (!justCollectImports) {
                            String packageName;
                            Object bindTo = JSResolveUtil.isConstructorFunction((PsiElement)resolved) ? ((packageName = StringUtil.getPackageName((String)qName)).isEmpty() ? null : new JSPackageWrapper(packageName, containingClass.getProject(), null)) : containingClass;
                            JSRefactoringUtil.makeQualified(refExpr, (JSQualifiedNamedElement)bindTo, false);
                        }
                        if (qName.indexOf(46) != -1) {
                            imports.add(qName);
                        }
                        return refExpr;
                    }
                } else if (refExpr.getQualifier() instanceof JSReferenceExpression && (r = ((JSReferenceExpression)refExpr.getQualifier()).resolve()) instanceof JSClass && targetClass != null && JSInheritanceUtil.isParentClass((JSClass)targetClass, (JSClass)((JSClass)r), (boolean)false)) {
                    if (!justCollectImports) {
                        JSRefactoringUtil.makeQualified(refExpr, null, false);
                    }
                    return refExpr;
                }
            }
        }
        ActionScriptRefactoringUtil.processChildren(scope2, imports, namespaces, membersToMove, targetClass, justCollectImports, visibilityWillChange);
        return scope2;
    }

    private static void processChildren(PsiElement scope2, Collection<String> imports, Collection<String> namespaces, Collection<JSAttributeListOwner> membersToMove, JSClass targetClass, boolean justCollectImports, boolean visibilityWillChange) {
        for (PsiElement child = scope2.getFirstChild(); child != null; child = child.getNextSibling()) {
            child = ActionScriptRefactoringUtil.fixOutgoingReferences(child, imports, namespaces, membersToMove, targetClass, justCollectImports, visibilityWillChange);
        }
    }
}

