/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.lsp;

import com.intellij.lang.typescript.compiler.languageService.LanguageServiceInfo;
import com.intellij.lang.typescript.compiler.languageService.LanguageServiceKind;
import com.intellij.lang.typescript.library.TypeScriptServiceDirectoryWatcher;
import com.intellij.lang.typescript.lsp.TypeScriptGoPackageInfo;
import com.intellij.lang.typescript.lsp.TypeScriptGoPackageInfoKt;
import com.intellij.lang.typescript.lsp.TypeScriptGoPackageKind;
import com.intellij.openapi.project.Project;
import com.intellij.util.text.SemVer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\"\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"getLanguageServiceInfo", "Lcom/intellij/lang/typescript/compiler/languageService/LanguageServiceInfo;", "project", "Lcom/intellij/openapi/project/Project;", "getPrefix", "", "source", "languageServiceKind", "Lcom/intellij/lang/typescript/compiler/languageService/LanguageServiceKind;", "code", "", "intellij.javascript.backend"})
public final class LspAnnotationErrorKt {
    private static final LanguageServiceInfo getLanguageServiceInfo(Project project) {
        LanguageServiceInfo languageServiceInfo;
        TypeScriptServiceDirectoryWatcher typeScriptServiceDirectoryWatcher = TypeScriptServiceDirectoryWatcher.getService(project);
        Intrinsics.checkNotNullExpressionValue((Object)typeScriptServiceDirectoryWatcher, (String)"getService(...)");
        TypeScriptServiceDirectoryWatcher service = typeScriptServiceDirectoryWatcher;
        String string = service.calcServiceDirectoryAndRefresh();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"calcServiceDirectoryAndRefresh(...)");
        String servicePath = string;
        TypeScriptGoPackageInfo tsGoInfo = TypeScriptGoPackageInfoKt.getTypeScriptGoPackageInfo(servicePath);
        if (tsGoInfo != null) {
            SemVer semVer = tsGoInfo.getVersion();
            String string2 = semVer != null ? semVer.getParsedVersion() : null;
            languageServiceInfo = new LanguageServiceInfo(servicePath, string2, null, switch (WhenMappings.$EnumSwitchMapping$0[tsGoInfo.getKind().ordinal()]) {
                case 1 -> LanguageServiceKind.TsGoLocal;
                case 2 -> LanguageServiceKind.TsGoNativePreview;
                case 3 -> LanguageServiceKind.TsGoJetBrainsFork;
                default -> throw new NoWhenBranchMatchedException();
            });
        } else {
            String string3 = service.getDefaultServicePath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getDefaultServicePath(...)");
            languageServiceInfo = new LanguageServiceInfo(string3, "5.9.3", null, LanguageServiceKind.OtherLsp);
        }
        return languageServiceInfo;
    }

    private static final String getPrefix(String source, LanguageServiceKind languageServiceKind, int code) {
        return code > 0 && (languageServiceKind == LanguageServiceKind.TsGoLocal || languageServiceKind == LanguageServiceKind.TsGoNativePreview || languageServiceKind == LanguageServiceKind.TsGoJetBrainsFork) ? "(tsgo) TS" + code + ": " : (source != null ? source + ": " : "");
    }

    public static final /* synthetic */ LanguageServiceInfo access$getLanguageServiceInfo(Project project) {
        return LspAnnotationErrorKt.getLanguageServiceInfo(project);
    }

    public static final /* synthetic */ String access$getPrefix(String source, LanguageServiceKind languageServiceKind, int code) {
        return LspAnnotationErrorKt.getPrefix(source, languageServiceKind, code);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TypeScriptGoPackageKind.values().length];
            try {
                nArray[TypeScriptGoPackageKind.LocallyClonedAndBuilt.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TypeScriptGoPackageKind.NativePreviewPackage.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TypeScriptGoPackageKind.JetBrainsFork.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

