/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.functionmetrics;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

class NegationCountVisitor
extends JSRecursiveElementVisitor {
    private int negationCount = 0;

    NegationCountVisitor() {
    }

    public void visitJSElement(@NotNull JSElement jsElement) {
        if (jsElement == null) {
            NegationCountVisitor.$$$reportNull$$$0(0);
        }
        int oldCount = 0;
        if (jsElement instanceof JSFunction) {
            oldCount = this.negationCount;
        }
        super.visitJSElement(jsElement);
        if (jsElement instanceof JSFunction) {
            this.negationCount = oldCount;
        }
    }

    public void visitJSBinaryExpression(@NotNull JSBinaryExpression expression) {
        if (expression == null) {
            NegationCountVisitor.$$$reportNull$$$0(1);
        }
        super.visitJSBinaryExpression(expression);
        IElementType sign = expression.getOperationSign();
        if (JSTokenTypes.NE.equals(sign) || JSTokenTypes.NEQEQ.equals(sign)) {
            ++this.negationCount;
        }
    }

    public void visitJSPrefixExpression(@NotNull JSPrefixExpression expression) {
        if (expression == null) {
            NegationCountVisitor.$$$reportNull$$$0(2);
        }
        super.visitJSPrefixExpression(expression);
        IElementType sign = expression.getOperationSign();
        if (JSTokenTypes.EXCL.equals(sign)) {
            ++this.negationCount;
        }
    }

    public int getNegationCount() {
        return this.negationCount;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/sixrr/inspectjs/functionmetrics/NegationCountVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSBinaryExpression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSPrefixExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

