/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.requests;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.jetbrains.rd.ide.document.DocumentLogRangeShifterKt;
import com.jetbrains.rd.ide.document.DocumentSynchronizerListener;
import com.jetbrains.rd.ide.document.DocumentSynchronizerListeners;
import com.jetbrains.rd.ide.document.DocumentVersionsKt;
import com.jetbrains.rd.ide.model.DocOffsetAndVirtualModel;
import com.jetbrains.rd.ide.model.RdCaret;
import com.jetbrains.rd.ide.model.RdCaretState;
import com.jetbrains.rd.ide.model.RdCaretStateChange;
import com.jetbrains.rd.ide.model.RdCaretStateSnapshot;
import com.jetbrains.rd.ide.model.RdDocumentChange;
import com.jetbrains.rd.ide.model.RdDocumentChangeBase;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdDocumentVersion;
import com.jetbrains.rd.ide.model.RdEditorChange;
import com.jetbrains.rd.ide.model.RdInitialCaretStateSnapshot;
import com.jetbrains.rd.ide.model.RdPatchItem;
import com.jetbrains.rd.ide.model.RdPatchItemId;
import com.jetbrains.rd.ide.model.RdPatchItemVersion;
import com.jetbrains.rd.ide.model.RdSelection;
import com.jetbrains.rd.ide.model.RdSelectionChangeBase;
import com.jetbrains.rd.tracing.SyncEventsLogger;
import com.jetbrains.rd.util.string.IPrintableKt;
import com.jetbrains.rdclient.diagnostics.CaretMovementTracker;
import com.jetbrains.rdclient.diagnostics.ConflictTracker;
import com.jetbrains.rdclient.editors.FrontendTextControlHostKt;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchHandlerContext;
import com.jetbrains.rdclient.patches.FrontendRdPatchHandlerRegistry;
import com.jetbrains.rdclient.requests.FrontendAsyncRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 22\u00020\u0001:\u00012B\u001b\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0018H\u0016J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J \u0010\u001d\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020!2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010\u001d\u001a\u00020%2\u0006\u0010\"\u001a\u00020#2\u0006\u0010&\u001a\u00020%H\u0002J\u0016\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010'\u001a\u00020 J\u0018\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010(\u001a\u00020\u001bH\u0002J\u000e\u0010)\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020#J\u0014\u0010*\u001a\u00020\u00112\f\u0010+\u001a\b\u0012\u0004\u0012\u00020#0\u0013J\u0018\u0010,\u001a\u00020\u00112\b\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u00020\u001bJ\u000e\u00100\u001a\u00020\u00112\u0006\u00101\u001a\u00020\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/jetbrains/rdclient/requests/FrontendRebaseSession;", "Lcom/jetbrains/rd/ide/document/DocumentSynchronizerListener;", "conflictTracker", "Lcom/jetbrains/rdclient/diagnostics/ConflictTracker;", "caretMovementTracker", "Lcom/jetbrains/rdclient/diagnostics/CaretMovementTracker;", "<init>", "(Lcom/jetbrains/rdclient/diagnostics/ConflictTracker;Lcom/jetbrains/rdclient/diagnostics/CaretMovementTracker;)V", "updatedVersionsMutableMap", "", "Lcom/jetbrains/rd/ide/model/RdPatchItemId;", "Lcom/jetbrains/rd/ide/model/RdPatchItemVersion;", "updatedVersionsMap", "", "getUpdatedVersionsMap", "()Ljava/util/Map;", "validateAndUpdateVersions", "", "versions", "", "ctx", "Lcom/jetbrains/rdclient/engine/handlers/FrontendRdPatchHandlerContext;", "history", "", "Lcom/jetbrains/rd/ide/model/RdDocumentChange;", "pointers", "", "", "change", "replay", "Lcom/jetbrains/rd/ide/model/RdSelectionChangeBase;", "newDocumentVersion", "Lcom/jetbrains/rd/ide/model/RdDocumentVersion;", "Lcom/jetbrains/rd/ide/model/RdCaretState;", "anchor", "Lcom/jetbrains/rd/ide/model/RdPatchItem;", "state", "Lcom/jetbrains/rd/ide/model/DocOffsetAndVirtualModel;", "offsetAndVirtualModel", "currentDocumentVersion", "offset", "record", "beforeApply", "patches", "trackConflict", "request", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequest;", "conflicts", "trackRestoredChanges", "count", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendRebaseSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendRebaseSession.kt\ncom/jetbrains/rdclient/requests/FrontendRebaseSession\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,201:1\n1869#2,2:202\n808#2,11:204\n13#3:215\n*S KotlinDebug\n*F\n+ 1 FrontendRebaseSession.kt\ncom/jetbrains/rdclient/requests/FrontendRebaseSession\n*L\n65#1:202,2\n186#1:204,11\n28#1:215\n*E\n"})
public final class FrontendRebaseSession
implements DocumentSynchronizerListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConflictTracker conflictTracker;
    @Nullable
    private final CaretMovementTracker caretMovementTracker;
    @NotNull
    private final Map<RdPatchItemId, RdPatchItemVersion> updatedVersionsMutableMap;
    @NotNull
    private final List<RdDocumentChange> history;
    @NotNull
    private final Map<Object, Integer> pointers;
    @NotNull
    private static final Logger logger;

    private FrontendRebaseSession(ConflictTracker conflictTracker, CaretMovementTracker caretMovementTracker) {
        this.conflictTracker = conflictTracker;
        this.caretMovementTracker = caretMovementTracker;
        this.updatedVersionsMutableMap = new LinkedHashMap();
        this.history = new ArrayList();
        this.pointers = new LinkedHashMap();
    }

    @NotNull
    public final Map<RdPatchItemId, RdPatchItemVersion> getUpdatedVersionsMap() {
        return this.updatedVersionsMutableMap;
    }

    public final void validateAndUpdateVersions(@NotNull List<? extends RdPatchItemVersion> versions, @NotNull FrontendRdPatchHandlerContext ctx) {
        Intrinsics.checkNotNullParameter(versions, (String)"versions");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        FrontendRdPatchHandlerRegistry registry = FrontendRdPatchHandlerRegistry.Companion.getInstance();
        if (!registry.validate(versions, ctx)) {
            throw new IllegalStateException("Not matched versions".toString());
        }
        Iterable $this$forEach$iv = versions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RdPatchItemVersion it = (RdPatchItemVersion)element$iv;
            boolean bl = false;
            this.updatedVersionsMutableMap.put(it.getId(), it);
        }
        if (!registry.validate(CollectionsKt.toList((Iterable)this.getUpdatedVersionsMap().values()), ctx)) {
            throw new IllegalStateException("Not matched versions".toString());
        }
    }

    public void change(@NotNull RdDocumentChange change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        this.history.add(change);
    }

    @NotNull
    public final RdSelectionChangeBase replay(@NotNull RdSelectionChangeBase change, @NotNull RdDocumentVersion newDocumentVersion) {
        RdSelectionChangeBase rdSelectionChangeBase;
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        Intrinsics.checkNotNullParameter((Object)newDocumentVersion, (String)"newDocumentVersion");
        RdSelectionChangeBase rdSelectionChangeBase2 = change;
        if (rdSelectionChangeBase2 instanceof RdCaretStateChange) {
            rdSelectionChangeBase = (RdSelectionChangeBase)new RdCaretStateChange(this.replay((RdPatchItem)change, ((RdCaretStateChange)change).getOldState(), newDocumentVersion), this.replay((RdPatchItem)change, ((RdCaretStateChange)change).getNewState(), newDocumentVersion), change.getEditorId());
        } else if (rdSelectionChangeBase2 instanceof RdCaretStateSnapshot) {
            rdSelectionChangeBase = (RdSelectionChangeBase)new RdCaretStateSnapshot(((RdCaretStateSnapshot)change).getDocumentChangeWrapping(), this.replay((RdPatchItem)change, ((RdCaretStateSnapshot)change).getState(), newDocumentVersion), change.getEditorId());
        } else if (rdSelectionChangeBase2 instanceof RdInitialCaretStateSnapshot) {
            rdSelectionChangeBase = (RdSelectionChangeBase)new RdInitialCaretStateSnapshot(this.replay((RdPatchItem)change, ((RdInitialCaretStateSnapshot)change).getState(), newDocumentVersion), change.getEditorId());
        } else {
            throw new IllegalStateException(("Unsupported selection change: " + this).toString());
        }
        return rdSelectionChangeBase;
    }

    private final RdCaretState replay(RdPatchItem anchor, RdCaretState state2, RdDocumentVersion newDocumentVersion) {
        List shiftCarets = new ArrayList();
        for (RdCaret caret : state2.getCarets()) {
            RdCaret shiftCaret = new RdCaret(caret.getId(), this.replay(anchor, caret.getOffset()), new RdSelection(this.replay(anchor, caret.getSelection().getStart()), this.replay(anchor, caret.getSelection().getEnd())));
            shiftCarets.add(shiftCaret);
        }
        return new RdCaretState(state2.getPrimaryCaretId(), shiftCarets, newDocumentVersion);
    }

    private final DocOffsetAndVirtualModel replay(RdPatchItem anchor, DocOffsetAndVirtualModel offsetAndVirtualModel) {
        int shiftOffset = this.replay(anchor, offsetAndVirtualModel.getOffset());
        return new DocOffsetAndVirtualModel(shiftOffset, offsetAndVirtualModel.getVirtualDelta(), offsetAndVirtualModel.getLogicalLeansForward());
    }

    @NotNull
    public final RdDocumentChange replay(@NotNull RdDocumentChange change, @NotNull RdDocumentVersion currentDocumentVersion) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        Intrinsics.checkNotNullParameter((Object)currentDocumentVersion, (String)"currentDocumentVersion");
        if (Intrinsics.areEqual((Object)change.isWholeTextReplaced(), (Object)true)) {
            RdDocumentVersion newVersion = DocumentVersionsKt.nextVersion((RdDocumentVersion)currentDocumentVersion, (int)change.getOffset(), (int)change.getMoveOffset(), (String)change.getOldText(), (String)change.getNewText(), (int)change.getOldDocumentLength());
            return new RdDocumentChange(change.getOffset(), change.getMoveOffset(), change.getNewText(), change.getOldText(), change.getModificationKind(), change.getOldDocumentLength(), change.getText(), change.isWholeTextReplaced(), change.getDocumentId(), newVersion, currentDocumentVersion, change.getUniqueId());
        }
        int shiftOffset = this.replay((RdPatchItem)change, change.getOffset());
        int shiftMoveOffset = this.replay((RdPatchItem)change, change.getMoveOffset());
        int shiftOldDocumentLength = this.replay((RdPatchItem)change, change.getOldDocumentLength());
        RdDocumentVersion newVersion = DocumentVersionsKt.nextVersion((RdDocumentVersion)currentDocumentVersion, (int)shiftOffset, (int)shiftMoveOffset, (String)change.getOldText(), (String)change.getNewText(), (int)shiftOldDocumentLength);
        return new RdDocumentChange(shiftOffset, shiftMoveOffset, change.getNewText(), change.getOldText(), change.getModificationKind(), shiftOldDocumentLength, change.getText(), change.isWholeTextReplaced(), change.getDocumentId(), newVersion, currentDocumentVersion, change.getUniqueId());
    }

    private final int replay(RdPatchItem anchor, int offset) {
        RdDocumentId rdDocumentId;
        Integer index = this.pointers.get(anchor);
        if (index == null) {
            logger.error("Can not find anchor patch item in the history: " + IPrintableKt.printToString((Object)anchor));
            return offset;
        }
        RdPatchItem rdPatchItem = anchor;
        if (rdPatchItem instanceof RdDocumentChangeBase) {
            rdDocumentId = ((RdDocumentChangeBase)anchor).getDocumentId();
        } else if (rdPatchItem instanceof RdEditorChange) {
            rdDocumentId = ((RdEditorChange)anchor).getEditorId().getDocumentId();
        } else {
            throw new IllegalStateException(("Unknown anchor: " + IPrintableKt.printToString((Object)anchor)).toString());
        }
        RdDocumentId documentId = rdDocumentId;
        List changes = new ArrayList();
        Iterator iterator2 = ((Iterable)this.history).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            RdDocumentChange change = (RdDocumentChange)iterator2.next();
            if (i <= index || !Intrinsics.areEqual((Object)change.getDocumentId(), (Object)documentId)) continue;
            changes.add(change);
        }
        int newOffset = DocumentLogRangeShifterKt.shiftOnePoint((List)changes, (int)offset, (boolean)false, (boolean)false);
        if (newOffset == -1) {
            newOffset = DocumentLogRangeShifterKt.shiftOnePoint((List)changes, (int)offset, (boolean)true, (boolean)true);
        }
        if (newOffset == offset) {
            return offset;
        }
        logger.trace("Offset was rebased: " + offset + " -> " + newOffset + " for change " + anchor.getClass().getSimpleName());
        return newOffset;
    }

    public final void record(@NotNull RdPatchItem anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        this.pointers.put(anchor, this.history.size() - 1);
    }

    /*
     * WARNING - void declaration
     */
    public final void beforeApply(@NotNull List<? extends RdPatchItem> patches) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter(patches, (String)"patches");
        if (this.caretMovementTracker == null) {
            return;
        }
        Iterable $this$filterIsInstance$iv = patches;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof RdSelectionChangeBase)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List selectionChanges = (List)destination$iv$iv;
        for (RdSelectionChangeBase change : selectionChanges) {
            Editor editor;
            if (FrontendTextControlHostKt.toEditorOrNull(change.getEditorId()) == null || editor.isDisposed()) continue;
            this.caretMovementTracker.trackEditor(editor);
        }
    }

    public final void trackConflict(@Nullable FrontendAsyncRequest request, int conflicts) {
        this.conflictTracker.trackConflict(request, conflicts);
    }

    public final void trackRestoredChanges(int count) {
        this.conflictTracker.trackRestoredChanges(count);
    }

    public /* synthetic */ FrontendRebaseSession(ConflictTracker conflictTracker, CaretMovementTracker caretMovementTracker, DefaultConstructorMarker $constructor_marker) {
        this(conflictTracker, caretMovementTracker);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendRebaseSession.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendRebaseSession.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00070\rH\u0086\b\u00f8\u0001\u0000J&\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rdclient/requests/FrontendRebaseSession$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "using", "", "clientAppSession", "Lcom/intellij/openapi/client/ClientAppSession;", "sessionType", "Lcom/jetbrains/rd/tracing/SyncEventsLogger$RebaseSessionType;", "action", "Lkotlin/Function1;", "Lcom/jetbrains/rdclient/requests/FrontendRebaseSession;", "createEmpty", "conflictTracker", "Lcom/jetbrains/rdclient/diagnostics/ConflictTracker;", "caretMovementTracker", "Lcom/jetbrains/rdclient/diagnostics/CaretMovementTracker;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void using(@NotNull ClientAppSession clientAppSession, @NotNull SyncEventsLogger.RebaseSessionType sessionType, @NotNull Function1<? super FrontendRebaseSession, Unit> action) {
            Intrinsics.checkNotNullParameter((Object)clientAppSession, (String)"clientAppSession");
            Intrinsics.checkNotNullParameter((Object)sessionType, (String)"sessionType");
            Intrinsics.checkNotNullParameter(action, (String)"action");
            boolean $i$f$using = false;
            ConflictTracker conflictTracker = new ConflictTracker(sessionType);
            CaretMovementTracker caretMovementTracker = new CaretMovementTracker();
            FrontendRebaseSession rebaseSession = this.createEmpty(sessionType, conflictTracker, caretMovementTracker);
            try {
                DocumentSynchronizerListeners.Companion.getInstance(clientAppSession).addListener((DocumentSynchronizerListener)rebaseSession);
                action.invoke((Object)rebaseSession);
            }
            finally {
                InlineMarker.finallyStart((int)1);
                DocumentSynchronizerListeners.Companion.getInstance(clientAppSession).removeListener((DocumentSynchronizerListener)rebaseSession);
                caretMovementTracker.reportAllMovements(conflictTracker);
                conflictTracker.reportSummary();
                InlineMarker.finallyEnd((int)1);
            }
        }

        @NotNull
        public final FrontendRebaseSession createEmpty(@NotNull SyncEventsLogger.RebaseSessionType sessionType, @NotNull ConflictTracker conflictTracker, @Nullable CaretMovementTracker caretMovementTracker) {
            Intrinsics.checkNotNullParameter((Object)sessionType, (String)"sessionType");
            Intrinsics.checkNotNullParameter((Object)conflictTracker, (String)"conflictTracker");
            return new FrontendRebaseSession(conflictTracker, caretMovementTracker, null);
        }

        public static /* synthetic */ FrontendRebaseSession createEmpty$default(Companion companion, SyncEventsLogger.RebaseSessionType rebaseSessionType, ConflictTracker conflictTracker, CaretMovementTracker caretMovementTracker, int n, Object object) {
            if ((n & 1) != 0) {
                rebaseSessionType = SyncEventsLogger.RebaseSessionType.OTHER;
            }
            if ((n & 2) != 0) {
                conflictTracker = new ConflictTracker(rebaseSessionType);
            }
            if ((n & 4) != 0) {
                caretMovementTracker = null;
            }
            return companion.createEmpty(rebaseSessionType, conflictTracker, caretMovementTracker);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

