/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.document;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.editor.Document;
import com.intellij.util.containers.CollectionFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\bJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u000bJ\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R3\u0010\u0006\u001a'\u0012\u000e\u0012\f0\b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\n\u0012\u000e\u0012\f0\u000b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\n0\u0007\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rd/ide/document/DocumentUniqueIdSessionRegistry;", "", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "documentUniqueIds", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/editor/Document;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "hasUniqueId", "", "document", "getUniqueId", "registerUniqueId", "", "uniqueId", "unregisterUniqueId", "Companion", "intellij.rd.platform"})
public final class DocumentUniqueIdSessionRegistry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientAppSession session;
    @NotNull
    private final ConcurrentMap<Document, String> documentUniqueIds;

    public DocumentUniqueIdSessionRegistry(@NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakMap(...)");
        this.documentUniqueIds = concurrentMap;
    }

    public final boolean hasUniqueId(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return this.documentUniqueIds.containsKey(document);
    }

    @Nullable
    public final String getUniqueId(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return (String)this.documentUniqueIds.get(document);
    }

    public final void registerUniqueId(@NotNull Document document, @NotNull String uniqueId) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)uniqueId, (String)"uniqueId");
        ((Map)this.documentUniqueIds).put(document, uniqueId);
    }

    public final void unregisterUniqueId(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.documentUniqueIds.remove(document);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rd/ide/document/DocumentUniqueIdSessionRegistry$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rd/ide/document/DocumentUniqueIdSessionRegistry;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "intellij.rd.platform"})
    @SourceDebugExtension(value={"SMAP\nDocumentUniqueIdSessionRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentUniqueIdSessionRegistry.kt\ncom/jetbrains/rd/ide/document/DocumentUniqueIdSessionRegistry$Companion\n+ 2 Components.kt\ncom/jetbrains/rd/platform/util/ComponentsKt\n*L\n1#1,23:1\n23#2:24\n*S KotlinDebug\n*F\n+ 1 DocumentUniqueIdSessionRegistry.kt\ncom/jetbrains/rd/ide/document/DocumentUniqueIdSessionRegistry$Companion\n*L\n10#1:24\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DocumentUniqueIdSessionRegistry getInstance(@NotNull ClientAppSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ClientSession $this$service$iv = (ClientSession)session;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(DocumentUniqueIdSessionRegistry.class);
            if (object == null) {
                throw new IllegalStateException(("Can't find service for " + $this$service$iv).toString());
            }
            return (DocumentUniqueIdSessionRegistry)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

