/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteDev.util;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.execution.ParametersListUtil;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JF\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0014\b\u0002\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nJ!\u0010\u0017\u001a\u00020\u00142\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0019\"\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u001aR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/remoteDev/util/WindowsFileUtil;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "windowsCreateProcess", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "executable", "Ljava/nio/file/Path;", "workingDirectory", "parameters", "", "", "environment", "", "waitForProcess", "Ljava/time/Duration;", "createJunction", "", "junctionFile", "targetFile", "runCommand", "command", "", "([Ljava/lang/String;)V", "intellij.remoteDev.util"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nWindowsFileUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsFileUtil.kt\ncom/intellij/remoteDev/util/WindowsFileUtil\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n216#2,2:162\n126#2:165\n153#2,3:166\n1#3:164\n*S KotlinDebug\n*F\n+ 1 WindowsFileUtil.kt\ncom/intellij/remoteDev/util/WindowsFileUtil\n*L\n47#1:162,2\n57#1:165\n57#1:166,3\n*E\n"})
public final class WindowsFileUtil {
    @NotNull
    public static final WindowsFileUtil INSTANCE = new WindowsFileUtil();
    @NotNull
    private static final Logger LOG;

    private WindowsFileUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final WinNT.HANDLE windowsCreateProcess(@NotNull Path executable, @NotNull Path workingDirectory, @NotNull List<String> parameters, @NotNull Map<String, String> environment, @Nullable Duration waitForProcess) {
        String string;
        Memory environmentBlock;
        Object environmentBytes;
        Object key;
        Memory memory;
        WinBase.STARTUPINFO sTARTUPINFO;
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter(environment, (String)"environment");
        WinBase.STARTUPINFO $this$windowsCreateProcess_u24lambda_u240 = sTARTUPINFO = new WinBase.STARTUPINFO();
        boolean bl = false;
        $this$windowsCreateProcess_u24lambda_u240.dwFlags = 1;
        $this$windowsCreateProcess_u24lambda_u240.wShowWindow = new WinDef.WORD(1L);
        WinBase.STARTUPINFO si = sTARTUPINFO;
        WinBase.PROCESS_INFORMATION pi = new WinBase.PROCESS_INFORMATION();
        String string2 = ParametersListUtil.join((List)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)((Object)executable).toString()), (Iterable)parameters));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"join(...)");
        String commandLine = string2;
        WindowsFileUtil $this$windowsCreateProcess_u24lambda_u241 = this;
        boolean bl2 = false;
        if (environment.isEmpty()) {
            memory = null;
        } else {
            void $this$forEach$iv;
            Map<String, String> map = System.getenv();
            Intrinsics.checkNotNullExpressionValue(map, (String)"getenv(...)");
            SortedMap fullEnvironment = MapsKt.toSortedMap((Map)MapsKt.toMutableMap(map));
            fullEnvironment.putAll(environment);
            StringBuilder environmentBlockBuilder = new StringBuilder();
            Map map2 = fullEnvironment;
            boolean $i$f$forEach = false;
            for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
                Map.Entry entry = element$iv;
                boolean bl3 = false;
                key = (String)entry.getKey();
                String value = (String)entry.getValue();
                environmentBlockBuilder.append((String)key + "=" + value + "\u0000");
            }
            String string3 = environmentBlockBuilder.append('\u0000').toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            String environmentBlockStr = string3;
            byte[] byArray = environmentBlockStr.getBytes(Charsets.UTF_16LE);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            environmentBytes = byArray;
            Memory environmentBlock2 = new Memory((long)((Object)environmentBytes).length);
            environmentBlock2.write(0L, (byte[])environmentBytes, 0, ((Object)environmentBytes).length);
            memory = environmentBlock2;
        }
        Memory memory2 = environmentBlock = memory;
        if (memory2 != null) {
            void $this$mapTo$iv$iv;
            Memory it = memory2;
            boolean bl4 = false;
            Map<String, String> $this$map$iv = environment;
            boolean $i$f$map = false;
            environmentBytes = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                void it2;
                key = item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl5 = false;
                collection.add(it2.getKey() + "=" + it2.getValue());
            }
            string = "System.getenv()+{" + CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), null, null, null, (int)0, null, null, (int)63, null) + "}, ";
        } else {
            string = null;
        }
        String envString = string;
        String createProcessDebugParams = "CreateProcessW(lpApplicationName=null, lpCommandLine='" + commandLine + "', lpProcessAttributes=null, lpThreadAttributes=null, bInheritHandles=false, dwCreationFlags=CREATE_UNICODE_PROCESS_ENVIRONMENT, lpEnvironment=" + envString + "lpCurrentDirectory='" + workingDirectory + "', lpStartupInfo=si, lpProcessInformation=pi)";
        LOG.info("Calling " + createProcessDebugParams);
        WinDef.DWORD CREATE_UNICODE_PROCESS_ENVIRONMENT = new WinDef.DWORD(1024L);
        char[] cArray = (commandLine + "\u0000").toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        if (!Kernel32.INSTANCE.CreateProcessW(null, cArray, null, null, false, CREATE_UNICODE_PROCESS_ENVIRONMENT, (Pointer)environmentBlock, workingDirectory + "\u0000", si, pi)) {
            int lastError = Kernel32.INSTANCE.GetLastError();
            PointerByReference lpBuffer = new PointerByReference();
            int result2 = Kernel32.INSTANCE.FormatMessage(4864, null, lastError, Kernel32.LANG_USER_DEFAULT, lpBuffer, 0, null);
            Pointer buffer = lpBuffer.getValue();
            char[] errorTextBuffer = buffer.getCharArray(0L, result2);
            Kernel32.INSTANCE.LocalFree(buffer);
            Intrinsics.checkNotNull((Object)errorTextBuffer);
            String message = new String(errorTextBuffer);
            throw new IOException(createProcessDebugParams + " returned error " + lastError + ": " + message);
        }
        if (!(pi.hProcess != null)) {
            boolean $i$a$-require-WindowsFileUtil$windowsCreateProcess$22 = false;
            String $i$a$-require-WindowsFileUtil$windowsCreateProcess$22 = "hProcess should not be null in our case";
            throw new IllegalArgumentException($i$a$-require-WindowsFileUtil$windowsCreateProcess$22.toString());
        }
        if (waitForProcess != null) {
            IntByReference exitCode = new IntByReference(-1);
            int waitRc = Kernel32.INSTANCE.WaitForSingleObject(pi.hProcess, -1);
            if (waitRc == 258) {
                throw new IOException(createProcessDebugParams + ": timeout waiting for process to exit");
            }
            Kernel32.INSTANCE.GetExitCodeProcess(pi.hProcess, exitCode);
            Kernel32.INSTANCE.CloseHandle(pi.hProcess);
            if (exitCode.getValue() == -1) {
                throw new IOException(createProcessDebugParams + ": could not read exit code");
            }
            if (exitCode.getValue() != 0) {
                throw new IOException(createProcessDebugParams + ": non-zero exit code: " + exitCode.getValue());
            }
        }
        WinNT.HANDLE hANDLE = pi.hProcess;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)"hProcess");
        return hANDLE;
    }

    public static /* synthetic */ WinNT.HANDLE windowsCreateProcess$default(WindowsFileUtil windowsFileUtil, Path path, Path path2, List list, Map map, Duration duration, int n, Object object) {
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x10) != 0) {
            duration = null;
        }
        return windowsFileUtil.windowsCreateProcess(path, path2, list, map, duration);
    }

    public final void createJunction(@NotNull Path junctionFile, @NotNull Path targetFile) {
        Intrinsics.checkNotNullParameter((Object)junctionFile, (String)"junctionFile");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        if (!SystemInfo.isWindows) {
            throw new UnsupportedOperationException("Requires Windows OS");
        }
        String[] stringArray = new String[]{"cmd", "/C", "mklink", "/J", ((Object)junctionFile).toString(), ((Object)targetFile).toString()};
        this.runCommand(stringArray);
    }

    private final void runCommand(String ... command) {
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(Arrays.copyOf(command, command.length)).withRedirectErrorStream(true);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withRedirectErrorStream(...)");
        GeneralCommandLine cmd = generalCommandLine;
        int timeoutMs = 30000;
        ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)cmd, (int)timeoutMs);
        if (output.getExitCode() != 0) {
            int n = output.getExitCode();
            String string = output.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
            throw new IOException("Could not create a windows junction with mklink: exit code " + n + "; mklink output: " + ((Object)StringsKt.trim((CharSequence)string)).toString());
        }
        if (output.isTimeout()) {
            throw new IllegalStateException("Failed to create junction in " + timeoutMs + " ms, cmd: '" + cmd + "'");
        }
    }

    static {
        Logger logger = Logger.getInstance(INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

