/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteDev.tests.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remoteDev.tests.impl.AgentTestLogger;
import com.intellij.remoteDev.tests.modelGenerated.LambdaRdTestSession;
import com.intellij.remoteDev.tests.modelGenerated.RdTestSession;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/intellij/remoteDev/tests/impl/AgentTestLoggerFactory;", "Lcom/intellij/openapi/diagnostic/Logger$Factory;", "loggerFactory", "<init>", "(Lcom/intellij/openapi/diagnostic/Logger$Factory;)V", "testSession", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/remoteDev/tests/modelGenerated/RdTestSession;", "getTestSession", "()Ljava/util/concurrent/atomic/AtomicReference;", "lambdaTestSession", "Lcom/intellij/remoteDev/tests/modelGenerated/LambdaRdTestSession;", "getLambdaTestSession", "getLoggerInstance", "Lcom/intellij/openapi/diagnostic/Logger;", "category", "", "intellij.remoteDev.util"})
public class AgentTestLoggerFactory
implements Logger.Factory {
    @NotNull
    private final Logger.Factory loggerFactory;
    @NotNull
    private final AtomicReference<RdTestSession> testSession;
    @NotNull
    private final AtomicReference<LambdaRdTestSession> lambdaTestSession;

    public AgentTestLoggerFactory(@NotNull Logger.Factory loggerFactory) {
        Intrinsics.checkNotNullParameter((Object)loggerFactory, (String)"loggerFactory");
        this.loggerFactory = loggerFactory;
        this.testSession = new AtomicReference<Object>(null);
        this.lambdaTestSession = new AtomicReference<Object>(null);
    }

    @NotNull
    public final AtomicReference<RdTestSession> getTestSession() {
        return this.testSession;
    }

    @NotNull
    public final AtomicReference<LambdaRdTestSession> getLambdaTestSession() {
        return this.lambdaTestSession;
    }

    @NotNull
    public Logger getLoggerInstance(@NotNull String category) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        Logger logger = this.loggerFactory.getLoggerInstance(category);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLoggerInstance(...)");
        return (Logger)new AgentTestLogger(logger, this);
    }
}

