/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteDev.downloader;

import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CustomConfigMigrationOption;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.bootstrap.RuntimeModuleIntrospection;
import com.intellij.platform.runtime.product.ProductMode;
import com.intellij.platform.runtime.repository.RuntimeModuleId;
import com.intellij.platform.runtime.repository.RuntimeModuleRepository;
import com.intellij.remoteDev.downloader.CodeWithMeClientDownloader;
import com.intellij.remoteDev.downloader.EmbeddedClientErrorReporter;
import com.intellij.remoteDev.downloader.EmbeddedClientLauncher;
import com.intellij.remoteDev.downloader.JetBrainsClientLauncherData;
import com.intellij.remoteDev.util.ProductInfo;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.JavaModuleOptions;
import com.intellij.util.PathsList;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.system.OS;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ,\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0002J&\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/remoteDev/downloader/EmbeddedClientLauncher;", "", "moduleRepository", "Lcom/intellij/platform/runtime/repository/RuntimeModuleRepository;", "moduleRepositoryPath", "Ljava/nio/file/Path;", "<init>", "(Lcom/intellij/platform/runtime/repository/RuntimeModuleRepository;Ljava/nio/file/Path;)V", "launch", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "urlToOpen", "", "lifetime", "errorReporter", "Lcom/intellij/remoteDev/downloader/EmbeddedClientErrorReporter;", "url", "extraArguments", "", "createLauncherViaIdeExecutable", "Lcom/intellij/remoteDev/downloader/JetBrainsClientLauncherData;", "findOldJetBrainsClientLauncher", "createProcessParameters", "Lcom/intellij/execution/configurations/SimpleJavaParameters;", "arguments", "passProperties", "", "vmParametersList", "Lcom/intellij/execution/configurations/ParametersList;", "addVmOptions", "getDefaultCustomizableVmOptions", "Companion", "intellij.remoteDev.util"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nEmbeddedClientLauncher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmbeddedClientLauncher.kt\ncom/intellij/remoteDev/downloader/EmbeddedClientLauncher\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,311:1\n60#2,5:312\n13#2:340\n1761#3,3:317\n1563#3:320\n1634#3,3:321\n1869#3,2:324\n1617#3,9:326\n1869#3:335\n1870#3:338\n1626#3:339\n1#4:336\n1#4:337\n*S KotlinDebug\n*F\n+ 1 EmbeddedClientLauncher.kt\ncom/intellij/remoteDev/downloader/EmbeddedClientLauncher\n*L\n109#1:312,5\n43#1:340\n136#1:317,3\n198#1:320\n198#1:321,3\n215#1:324,2\n224#1:326,9\n224#1:335\n224#1:338\n224#1:339\n224#1:337\n*E\n"})
public final class EmbeddedClientLauncher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RuntimeModuleRepository moduleRepository;
    @NotNull
    private final Path moduleRepositoryPath;
    @NotNull
    private static final String USE_CUSTOM_PATHS_PROPERTY = "rdct.embedded.client.use.custom.paths";
    @NotNull
    private static final Logger LOG;

    private EmbeddedClientLauncher(RuntimeModuleRepository moduleRepository, Path moduleRepositoryPath) {
        this.moduleRepository = moduleRepository;
        this.moduleRepositoryPath = moduleRepositoryPath;
    }

    @NotNull
    public final Lifetime launch(@NotNull String urlToOpen, @NotNull Lifetime lifetime, @NotNull EmbeddedClientErrorReporter errorReporter) {
        Intrinsics.checkNotNullParameter((Object)urlToOpen, (String)"urlToOpen");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)errorReporter, (String)"errorReporter");
        return this.launch(urlToOpen, CollectionsKt.emptyList(), lifetime, errorReporter);
    }

    @NotNull
    public final Lifetime launch(@NotNull String url, @NotNull List<String> extraArguments, @NotNull Lifetime lifetime, @NotNull EmbeddedClientErrorReporter errorReporter) {
        JetBrainsClientLauncherData launcherData;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(extraArguments, (String)"extraArguments");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)errorReporter, (String)"errorReporter");
        JetBrainsClientLauncherData jetBrainsClientLauncherData = this.createLauncherViaIdeExecutable();
        if (jetBrainsClientLauncherData == null) {
            jetBrainsClientLauncherData = this.findOldJetBrainsClientLauncher();
        }
        if ((launcherData = jetBrainsClientLauncherData) != null) {
            LOG.debug("Start embedded client using launcher");
            String string = PathManager.getHomePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHomePath(...)");
            Path path = Paths.get(string, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            Path workingDirectory = path;
            BuildNumber buildNumber = ApplicationInfo.getInstance().getBuild().withoutProductCode();
            Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"withoutProductCode(...)");
            return CodeWithMeClientDownloader.INSTANCE.runJetBrainsClientProcess$intellij_remoteDev_util(launcherData, workingDirectory, buildNumber, url, extraArguments, lifetime);
        }
        LifetimeDefinition processLifetimeDef = lifetime.createNested();
        Object[] objectArray = new String[]{"thinClient", url};
        List arguments = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)extraArguments);
        SimpleJavaParameters javaParameters = this.createProcessParameters(this.moduleRepository, this.moduleRepositoryPath, arguments);
        GeneralCommandLine generalCommandLine = javaParameters.toCommandLine();
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"toCommandLine(...)");
        GeneralCommandLine commandLine = generalCommandLine;
        Logger $this$debug_u24default$iv = LOG;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Starting embedded client: " + commandLine, e$iv);
        }
        OSProcessHandler.Silent handler = new OSProcessHandler.Silent(commandLine);
        List<String> output = Collections.synchronizedList(new ArrayList());
        handler.addProcessListener(new ProcessListener(output, errorReporter, processLifetimeDef){
            final /* synthetic */ List<String> $output;
            final /* synthetic */ EmbeddedClientErrorReporter $errorReporter;
            final /* synthetic */ LifetimeDefinition $processLifetimeDef;
            {
                this.$output = $output;
                this.$errorReporter = $errorReporter;
                this.$processLifetimeDef = $processLifetimeDef;
            }

            public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                this.$output.add(event.getText());
            }

            public void processTerminated(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getExitCode() != 0) {
                    int n = event.getExitCode();
                    List<String> list = this.$output;
                    Intrinsics.checkNotNull(list);
                    this.$errorReporter.startupFailed(n, list);
                }
                ApplicationManager.getApplication().invokeLater(() -> launch.2.processTerminated$lambda$0(this.$processLifetimeDef));
            }

            private static final void processTerminated$lambda$0(LifetimeDefinition $processLifetimeDef) {
                LifetimeDefinition.terminate$default((LifetimeDefinition)$processLifetimeDef, (boolean)false, (int)1, null);
            }
        });
        handler.startNotify();
        return (Lifetime)processLifetimeDef;
    }

    /*
     * WARNING - void declaration
     */
    private final JetBrainsClientLauncherData createLauncherViaIdeExecutable() {
        Object v6;
        Path ideHome;
        block12: {
            String string = PathManager.getHomePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHomePath(...)");
            Path path = Paths.get(string, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            ideHome = path;
            String productInfoPath = SystemInfo.isMac ? "Resources/product-info.json" : "product-info.json";
            Path path2 = ideHome.resolve(productInfoPath);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            ProductInfo productInfo = CodeWithMeClientDownloader.INSTANCE.parseProductInfo$intellij_remoteDev_util(path2);
            if (productInfo == null) {
                return null;
            }
            ProductInfo productInfoData = productInfo;
            Iterable iterable = productInfoData.getLaunch();
            for (Object t : iterable) {
                boolean bl;
                block11: {
                    void $this$any$iv;
                    ProductInfo.LaunchData launchData = (ProductInfo.LaunchData)t;
                    boolean bl2 = false;
                    List list = launchData.getCustomCommands();
                    if (list == null) {
                        list = CollectionsKt.emptyList();
                    }
                    Iterable iterable2 = list;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            ProductInfo.CustomCommandLaunchData it = (ProductInfo.CustomCommandLaunchData)element$iv;
                            boolean bl3 = false;
                            if (!Companion.isThinClientCustomCommand(it)) continue;
                            bl = true;
                            break block11;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                v6 = t;
                break block12;
            }
            v6 = null;
        }
        ProductInfo.LaunchData frontendLaunchData = v6;
        if (frontendLaunchData == null) {
            LOG.info("Cannot use IDE's launcher because product info under " + ideHome + " doesn't have special handling for 'thinClient' command");
            return null;
        }
        if (SystemInfo.isMac) {
            JetBrainsClientLauncherData jetBrainsClientLauncherData;
            Path appPath = ideHome.getParent();
            if (appPath != null && StringsKt.endsWith$default((String)PathsKt.getName((Path)appPath), (String)".app", (boolean)false, (int)2, null)) {
                jetBrainsClientLauncherData = CodeWithMeClientDownloader.INSTANCE.createLauncherDataForMacOs$intellij_remoteDev_util(appPath);
            } else {
                LOG.info("Cannot use launcher because " + ideHome + " doesn't look like a path with installation");
                jetBrainsClientLauncherData = null;
            }
            return jetBrainsClientLauncherData;
        }
        Path executable = ideHome.resolve(frontendLaunchData.getLauncherPath());
        Intrinsics.checkNotNull((Object)executable);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(executable, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LOG.warn("Cannot use IDE's launcher because " + executable + " does not exist");
            return null;
        }
        return new JetBrainsClientLauncherData(executable, CollectionsKt.listOf((Object)((Object)executable).toString()));
    }

    private final JetBrainsClientLauncherData findOldJetBrainsClientLauncher() {
        JetBrainsClientLauncherData jetBrainsClientLauncherData;
        OS oS = OS.CURRENT;
        switch (oS == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oS.ordinal()]) {
            case 1: {
                return null;
            }
            case 2: {
                Path path = PathManager.findBinFile((String)"jetbrains_client64.exe");
                if (path != null) {
                    Path it = path;
                    boolean bl = false;
                    jetBrainsClientLauncherData = new JetBrainsClientLauncherData(it, CollectionsKt.listOf((Object)((Object)it).toString()));
                    break;
                }
                jetBrainsClientLauncherData = null;
                break;
            }
            default: {
                Path path = PathManager.findBinFile((String)"jetbrains_client.sh");
                if (path != null) {
                    Path it = path;
                    boolean bl = false;
                    jetBrainsClientLauncherData = new JetBrainsClientLauncherData(it, CollectionsKt.listOf((Object)((Object)it).toString()));
                    break;
                }
                jetBrainsClientLauncherData = null;
            }
        }
        return jetBrainsClientLauncherData;
    }

    /*
     * WARNING - void declaration
     */
    private final SimpleJavaParameters createProcessParameters(RuntimeModuleRepository moduleRepository, Path moduleRepositoryPath, List<String> arguments) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Path logDir;
        Iterable<Path> configDir;
        SimpleJavaParameters javaParameters = new SimpleJavaParameters();
        javaParameters.setJdk(SimpleJavaSdkType.getInstance().createJdk("", SystemProperties.getJavaHome()));
        javaParameters.setShortenCommandLine(ShortenCommandLine.ARGS_FILE);
        String customIdeaPropertiesPath = EnvironmentUtil.getValue((String)"JETBRAINS_CLIENT_PROPERTIES");
        if (customIdeaPropertiesPath != null) {
            javaParameters.getVMParametersList().addProperty("idea.properties.file", customIdeaPropertiesPath);
        } else if (ApplicationManager.getApplication().isUnitTestMode() || SystemProperties.getBooleanProperty((String)USE_CUSTOM_PATHS_PROPERTY, (boolean)false)) {
            String string = PathManager.getTempPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTempPath(...)");
            Path path = Paths.get(string, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            Path path2 = path;
            Path path3 = path2.resolve("embedded-client");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
            Path tempDir = path3;
            Path path4 = tempDir.resolve("config");
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
            configDir = path4;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists((Path)configDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Path path5 = PathManager.getConfigDir();
                Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"getConfigDir(...)");
                new CustomConfigMigrationOption.MigrateFromCustomPlace(path5).writeConfigMarkerFile(configDir);
            }
            javaParameters.getVMParametersList().defineProperty("idea.config.path", configDir.toString());
            Path path6 = tempDir.resolve("system");
            Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"resolve(...)");
            Path systemDir = path6;
            javaParameters.getVMParametersList().defineProperty("idea.system.path", ((Object)systemDir).toString());
            Path path7 = PathManager.getLogDir();
            Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"getLogDir(...)");
            Path path8 = path7;
            Path path9 = path8.resolve("embedded-client");
            Intrinsics.checkNotNullExpressionValue((Object)path9, (String)"resolve(...)");
            logDir = path9;
            javaParameters.getVMParametersList().defineProperty("idea.log.path", ((Object)logDir).toString());
        }
        ParametersList parametersList = javaParameters.getVMParametersList();
        Intrinsics.checkNotNullExpressionValue((Object)parametersList, (String)"getVMParametersList(...)");
        this.passProperties(parametersList);
        javaParameters.setMainClass("com.intellij.platform.runtime.loader.IntellijLoader");
        RuntimeModuleId runtimeModuleId = RuntimeModuleId.module((String)"intellij.platform.runtime.loader");
        Intrinsics.checkNotNullExpressionValue((Object)runtimeModuleId, (String)"module(...)");
        RuntimeModuleId runtimeLoaderModule = runtimeModuleId;
        PathsList pathsList = javaParameters.getClassPath();
        List list = moduleRepository.getModule(runtimeLoaderModule).getModuleClasspath();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getModuleClasspath(...)");
        configDir = list;
        PathsList pathsList2 = pathsList;
        boolean $i$f$map = false;
        logDir = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toFile());
        }
        pathsList2.addAllFiles((List)destination$iv$iv);
        ParametersList parametersList2 = javaParameters.getVMParametersList();
        Intrinsics.checkNotNullExpressionValue((Object)parametersList2, (String)"getVMParametersList(...)");
        this.addVmOptions(parametersList2, moduleRepositoryPath);
        javaParameters.getProgramParametersList().addAll(arguments);
        return javaParameters;
    }

    private final void passProperties(ParametersList vmParametersList) {
        Object[] objectArray = new String[]{"jna.boot.library.path", "pty4j.preferred.native.folder", "jna.nosys", "jna.noclasspath", "idea.is.internal", "intellij.test.jars.location", "idea.home.path", "skiko.library.path"};
        List propertiesToPass = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$forEach$iv = propertiesToPass;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            vmParametersList.defineProperty(it, System.getProperty(it));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addVmOptions(ParametersList vmParametersList, Path moduleRepositoryPath) {
        Object object;
        Object object2;
        Object $this$forEach$iv$iv$iv;
        Object[] $this$mapNotNullTo$iv$iv;
        Path path = PathManager.getConfigDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getConfigDir(...)");
        Path path2 = path;
        Path path3 = path2.resolve("embedded-client");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        path2 = path3;
        Path path4 = path2.resolve("jetbrains_client64.vmoptions");
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
        Path vmOptionsFile = path4;
        List customizableOptions = null;
        Iterable<Path> iterable = vmOptionsFile;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(iterable, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            iterable = vmOptionsFile;
            List<String> list = Files.readAllLines(iterable, Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
            iterable = list;
            boolean $i$f$mapNotNull = false;
            Path path5 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            object2 = $this$forEach$iv$iv$iv.iterator();
            while (object2.hasNext()) {
                String it$iv$iv;
                String string;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object2.next();
                boolean bl = false;
                String line = (String)element$iv$iv;
                boolean bl2 = false;
                String it = string = ((Object)StringsKt.trim((CharSequence)line)).toString();
                boolean bl3 = false;
                if ((((CharSequence)it).length() > 0 ? string : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            customizableOptions = (List)destination$iv$iv;
            v4 = Unit.INSTANCE;
        } else {
            customizableOptions = this.getDefaultCustomizableVmOptions();
            PathsKt.createParentDirectories((Path)vmOptionsFile, (FileAttribute[])new FileAttribute[0]);
            $this$mapNotNull$iv = vmOptionsFile;
            $this$mapNotNullTo$iv$iv = new OpenOption[]{};
            Charset $i$f$mapNotNull = Charsets.UTF_8;
            Path path6 = Files.write($this$mapNotNull$iv, (Iterable<? extends CharSequence>)customizableOptions, $i$f$mapNotNull, Arrays.copyOf($this$mapNotNullTo$iv$iv, $this$mapNotNullTo$iv$iv.length));
            v4 = path6;
            Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"write(...)");
        }
        vmParametersList.addAll(customizableOptions);
        BuildNumber buildNumber = ApplicationInfo.getInstance().getBuild();
        Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"getBuild(...)");
        BuildNumber build = buildNumber;
        $this$mapNotNullTo$iv$iv = new String[]{"-Djb.vmOptionsFile=" + ((Object)vmOptionsFile).toString(), "-Didea.vendor.name=JetBrains", "-Didea.paths.selector=" + PathManager.getPathsSelector(), "-Didea.platform.prefix=JetBrainsClient", "-Dide.no.platform.update=true", "-Didea.initially.ask.config=never", "-Dnosplash=true", "-Didea.paths.customizer=com.intellij.platform.ide.impl.startup.multiProcess.FrontendProcessPathCustomizer", "-Dintellij.platform.runtime.repository.path=" + ((Object)moduleRepositoryPath).toString(), "-Dintellij.platform.root.module=" + EmbeddedClientLauncher.Companion.getRootFrontendModule().getStringId(), "-Dintellij.platform.product.mode=" + ProductMode.FRONTEND.getId(), "-Dintellij.platform.full.ide.product.code=" + build.getProductCode(), "-Dintellij.platform.load.app.info.from.resources=true", "-Dsplash=true"};
        List jetBrainsClientOptions = CollectionsKt.listOf((Object[])$this$mapNotNullTo$iv$iv);
        vmParametersList.addAll(jetBrainsClientOptions);
        if (SystemInfo.isMac) {
            vmParametersList.add("-Dapple.awt.application.name=JetBrains Client");
        }
        InputStream inputStream = EmbeddedClientLauncher.class.getResourceAsStream("/META-INF/OpenedPackages.txt");
        if (inputStream == null) {
            String $i$f$mapNotNullTo = "Cannot load OpenedPackages.txt";
            throw new IllegalStateException($i$f$mapNotNullTo.toString());
        }
        InputStream openedPackagesStream = inputStream;
        $this$forEach$iv$iv$iv = openedPackagesStream;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)$this$forEach$iv$iv$iv;
            boolean bl = false;
            object2 = JavaModuleOptions.readOptions((InputStream)it, (OS)OS.CURRENT);
            object = object2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)$this$forEach$iv$iv$iv, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"use(...)");
        Object addOpensOptions = object;
        vmParametersList.addAll((List)addOpensOptions);
        int debugPort = Registry.Companion.get("rdct.embedded.client.debug.port").asInteger();
        if (debugPort > 0) {
            String suspend = Registry.Companion.get("rdct.embedded.client.debug.suspend").asBoolean() ? "y" : "n";
            vmParametersList.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=" + suspend + ",address=" + debugPort);
        }
    }

    private final List<String> getDefaultCustomizableVmOptions() {
        Object[] objectArray = new String[]{"-Xms128m", "-Xmx1500m", "-XX:ReservedCodeCacheSize=512m"};
        List memoryOptions = CollectionsKt.listOf((Object[])objectArray);
        Object[] objectArray2 = new String[]{"-XX:+UseG1GC", "-XX:SoftRefLRUPolicyMSPerMB=50", "-XX:CICompilerCount=2", "-XX:+HeapDumpOnOutOfMemoryError", "-XX:-OmitStackTraceInFastThrow", "-XX:+IgnoreUnrecognizedVMOptions", "-XX:CompileCommand=exclude,com/intellij/openapi/vfs/impl/FilePartNodeRoot,trieDescend", "-XX:MaxJavaStackTraceDepth=10000", "-ea", "-Dsun.io.useCanonCaches=false", "-Dsun.java2d.metal=true", "-Djbr.catch.SIGABRT=true", "-Djdk.http.auth.tunneling.disabledSchemes=\"\"", "-Djdk.attach.allowAttachSelf=true", "-Djdk.module.illegalAccess.silent=true", "-Dkotlinx.coroutines.debug=off", "-Djava.system.class.loader=com.intellij.util.lang.PathClassLoader"};
        List commonOptions = CollectionsKt.listOf((Object[])objectArray2);
        OS oS = OS.CURRENT;
        List osSpecificOptions = switch (oS == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oS.ordinal()]) {
            case 3 -> {
                Object[] var4_4 = new String[]{"-Dsun.tools.attach.tmp.only=true", "-Dawt.lock.fair=true"};
                yield CollectionsKt.listOf((Object[])var4_4);
            }
            case 1 -> CollectionsKt.listOf((Object)"-Dapple.awt.application.appearance=system");
            default -> CollectionsKt.emptyList();
        };
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)memoryOptions, (Iterable)commonOptions), (Iterable)osSpecificOptions);
    }

    public /* synthetic */ EmbeddedClientLauncher(RuntimeModuleRepository moduleRepository, Path moduleRepositoryPath, DefaultConstructorMarker $constructor_marker) {
        this(moduleRepository, moduleRepositoryPath);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EmbeddedClientLauncher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u0004\u0018\u00010\tJ\b\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0005H\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/remoteDev/downloader/EmbeddedClientLauncher$Companion;", "", "<init>", "()V", "USE_CUSTOM_PATHS_PROPERTY", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "create", "Lcom/intellij/remoteDev/downloader/EmbeddedClientLauncher;", "getRootFrontendModule", "Lcom/intellij/platform/runtime/repository/RuntimeModuleId;", "getRootFrontendModuleForIde", "platformPrefix", "isThinClientCustomCommand", "", "customCommandData", "Lcom/intellij/remoteDev/util/ProductInfo$CustomCommandLaunchData;", "intellij.remoteDev.util"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final EmbeddedClientLauncher create() {
            RuntimeModuleRepository runtimeModuleRepository = RuntimeModuleIntrospection.INSTANCE.getModuleRepository();
            if (runtimeModuleRepository == null) {
                return null;
            }
            RuntimeModuleRepository moduleRepository = runtimeModuleRepository;
            Path path = RuntimeModuleIntrospection.INSTANCE.getModuleRepositoryPath();
            if (path == null) {
                return null;
            }
            Path moduleRepositoryPath = path;
            try {
                moduleRepository.getModule(this.getRootFrontendModule());
            }
            catch (Exception e) {
                LOG.warn("Failed to load embedded client: " + e.getMessage());
                return null;
            }
            return new EmbeddedClientLauncher(moduleRepository, moduleRepositoryPath, null);
        }

        private final RuntimeModuleId getRootFrontendModule() {
            String string = PlatformUtils.getPlatformPrefix();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPlatformPrefix(...)");
            return this.getRootFrontendModuleForIde(string);
        }

        @VisibleForTesting
        @NotNull
        public final RuntimeModuleId getRootFrontendModuleForIde(@NotNull String platformPrefix) {
            RuntimeModuleId runtimeModuleId;
            Intrinsics.checkNotNullParameter((Object)platformPrefix, (String)"platformPrefix");
            switch (platformPrefix) {
                case "Idea": 
                case "idea": {
                    RuntimeModuleId runtimeModuleId2 = RuntimeModuleId.module((String)"intellij.idea.frontend.split");
                    runtimeModuleId = runtimeModuleId2;
                    Intrinsics.checkNotNullExpressionValue((Object)runtimeModuleId2, (String)"module(...)");
                    break;
                }
                case "IdeaEdu": {
                    RuntimeModuleId runtimeModuleId3 = RuntimeModuleId.module((String)"intellij.edu.remote.frontend.split");
                    runtimeModuleId = runtimeModuleId3;
                    Intrinsics.checkNotNullExpressionValue((Object)runtimeModuleId3, (String)"module(...)");
                    break;
                }
                case "PyCharmCore": 
                case "Python": {
                    RuntimeModuleId runtimeModuleId4 = RuntimeModuleId.module((String)"intellij.pycharm.frontend.split");
                    runtimeModuleId = runtimeModuleId4;
                    Intrinsics.checkNotNullExpressionValue((Object)runtimeModuleId4, (String)"module(...)");
                    break;
                }
                case "Rider": {
                    RuntimeModuleId runtimeModuleId5 = RuntimeModuleId.module((String)"intellij.rider.frontend.split");
                    runtimeModuleId = runtimeModuleId5;
                    Intrinsics.checkNotNullExpressionValue((Object)runtimeModuleId5, (String)"module(...)");
                    break;
                }
                case "GoLand": {
                    RuntimeModuleId runtimeModuleId6 = RuntimeModuleId.module((String)"intellij.goland.frontend.split");
                    runtimeModuleId = runtimeModuleId6;
                    Intrinsics.checkNotNullExpressionValue((Object)runtimeModuleId6, (String)"module(...)");
                    break;
                }
                case "CLion": {
                    RuntimeModuleId runtimeModuleId7 = RuntimeModuleId.module((String)"intellij.clion.ide.frontend.split");
                    runtimeModuleId = runtimeModuleId7;
                    Intrinsics.checkNotNullExpressionValue((Object)runtimeModuleId7, (String)"module(...)");
                    break;
                }
                case "PhpStorm": {
                    RuntimeModuleId runtimeModuleId8 = RuntimeModuleId.module((String)"intellij.phpstorm.frontend.split");
                    runtimeModuleId = runtimeModuleId8;
                    Intrinsics.checkNotNullExpressionValue((Object)runtimeModuleId8, (String)"module(...)");
                    break;
                }
                case "WebStorm": {
                    RuntimeModuleId runtimeModuleId9 = RuntimeModuleId.module((String)"intellij.webstorm.frontend.split");
                    runtimeModuleId = runtimeModuleId9;
                    Intrinsics.checkNotNullExpressionValue((Object)runtimeModuleId9, (String)"module(...)");
                    break;
                }
                case "Ruby": {
                    RuntimeModuleId runtimeModuleId10 = RuntimeModuleId.module((String)"intellij.rubymine.frontend.split");
                    runtimeModuleId = runtimeModuleId10;
                    Intrinsics.checkNotNullExpressionValue((Object)runtimeModuleId10, (String)"module(...)");
                    break;
                }
                case "RustRover": {
                    RuntimeModuleId runtimeModuleId11 = RuntimeModuleId.module((String)"intellij.rustrover.frontend.split");
                    runtimeModuleId = runtimeModuleId11;
                    Intrinsics.checkNotNullExpressionValue((Object)runtimeModuleId11, (String)"module(...)");
                    break;
                }
                default: {
                    RuntimeModuleId runtimeModuleId12 = RuntimeModuleId.module((String)"intellij.platform.frontend.split");
                    runtimeModuleId = runtimeModuleId12;
                    Intrinsics.checkNotNullExpressionValue((Object)runtimeModuleId12, (String)"module(...)");
                }
            }
            return runtimeModuleId;
        }

        public final boolean isThinClientCustomCommand(@NotNull ProductInfo.CustomCommandLaunchData customCommandData) {
            Intrinsics.checkNotNullParameter((Object)customCommandData, (String)"customCommandData");
            return customCommandData.getCommands().contains("thinClient");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.values().length];
            try {
                nArray[OS.macOS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Windows.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Linux.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

