/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.listeners;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.testng.IAnnotationTransformer;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.IRetryAnalyzer;
import org.testng.ITestResult;
import org.testng.annotations.ITestAnnotation;
import org.testng.internal.annotations.DisabledRetryAnalyzer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J8\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u001c\u0010\u000f\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/test/listeners/RetryUntilFailedListener;", "Lorg/testng/IInvokedMethodListener;", "Lorg/testng/IAnnotationTransformer;", "<init>", "()V", "transform", "", "annotation", "Lorg/testng/annotations/ITestAnnotation;", "testClass", "Ljava/lang/Class;", "testConstructor", "Ljava/lang/reflect/Constructor;", "testMethod", "Ljava/lang/reflect/Method;", "afterInvocation", "method", "Lorg/testng/IInvokedMethod;", "testResult", "Lorg/testng/ITestResult;", "Analyzer", "intellij.rider.test.framework.testng"})
public final class RetryUntilFailedListener
implements IInvokedMethodListener,
IAnnotationTransformer {
    public void transform(@Nullable ITestAnnotation annotation, @Nullable Class<?> testClass, @Nullable Constructor<?> testConstructor, @Nullable Method testMethod) {
        Class retry;
        ITestAnnotation iTestAnnotation = annotation;
        Class clazz = retry = iTestAnnotation != null ? iTestAnnotation.getRetryAnalyzerClass() : null;
        if (retry == null || Intrinsics.areEqual((Object)retry, DisabledRetryAnalyzer.class)) {
            ITestAnnotation iTestAnnotation2 = annotation;
            Intrinsics.checkNotNull((Object)iTestAnnotation2);
            iTestAnnotation2.setRetryAnalyzer(Analyzer.class);
        }
    }

    public void afterInvocation(@Nullable IInvokedMethod method, @Nullable ITestResult testResult) {
        IInvokedMethod iInvokedMethod = method;
        Intrinsics.checkNotNull((Object)iInvokedMethod);
        if (iInvokedMethod.isTestMethod()) {
            ITestResult iTestResult = testResult;
            Intrinsics.checkNotNull((Object)iTestResult);
            if (iTestResult.getStatus() == 1) {
                testResult.setStatus(2);
                testResult.setAttribute("RETRY", (Object)true);
            } else if (testResult.getStatus() == 2) {
                testResult.setAttribute("RETRY", (Object)false);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/test/listeners/RetryUntilFailedListener$Analyzer;", "Lorg/testng/IRetryAnalyzer;", "<init>", "()V", "retry", "", "result", "Lorg/testng/ITestResult;", "Companion", "intellij.rider.test.framework.testng"})
    public static final class Analyzer
    implements IRetryAnalyzer {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        public static final String RETRY_PARAMETER = "RETRY";
        private static int retryCount;
        private static int maxRetryCount;

        public boolean retry(@Nullable ITestResult result) {
            ITestResult iTestResult = result;
            Intrinsics.checkNotNull((Object)iTestResult);
            Object object = iTestResult.getAttribute(RETRY_PARAMETER);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
            boolean shouldRetry = (Boolean)object;
            if (shouldRetry && retryCount < maxRetryCount) {
                int n = retryCount;
                retryCount = n + 1;
                return true;
            }
            return false;
        }

        static {
            maxRetryCount = 500;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/test/listeners/RetryUntilFailedListener$Analyzer$Companion;", "", "<init>", "()V", "RETRY_PARAMETER", "", "retryCount", "", "maxRetryCount", "intellij.rider.test.framework.testng"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

