/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.retryanalyzer;

import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.rider.test.framework.TestFrameworkBaseKt;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.testng.IRetryAnalyzer;
import org.testng.ITestResult;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/test/retryanalyzer/RetryAnalyzer;", "Lorg/testng/IRetryAnalyzer;", "maxRetryCount", "", "<init>", "(I)V", "getMaxRetryCount", "()I", "count", "Ljava/util/concurrent/atomic/AtomicInteger;", "getCount", "()Ljava/util/concurrent/atomic/AtomicInteger;", "setCount", "(Ljava/util/concurrent/atomic/AtomicInteger;)V", "shouldRetry", "", "result", "Lorg/testng/ITestResult;", "retry", "resetRetryCount", "", "methodName", "", "Companion", "Linux", "intellij.rider.test.framework.testng"})
public class RetryAnalyzer
implements IRetryAnalyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxRetryCount;
    @NotNull
    private AtomicInteger count;
    @NotNull
    private static String testMethod = "";

    public RetryAnalyzer(int maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
        this.count = new AtomicInteger(this.maxRetryCount);
    }

    public /* synthetic */ RetryAnalyzer(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        this(n);
    }

    public final int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    @NotNull
    public final AtomicInteger getCount() {
        return this.count;
    }

    public final void setCount(@NotNull AtomicInteger atomicInteger) {
        Intrinsics.checkNotNullParameter((Object)atomicInteger, (String)"<set-?>");
        this.count = atomicInteger;
    }

    public boolean shouldRetry(@NotNull ITestResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        return true;
    }

    public boolean retry(@Nullable ITestResult result) {
        Object object;
        if (result == null) {
            return false;
        }
        if (!this.shouldRetry(result)) {
            return false;
        }
        String string = result.getName();
        Object[] objectArray = result.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getParameters(...)");
        if (!(objectArray.length == 0)) {
            Object object2 = result.getParameters()[0];
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.String");
            object = "_" + (String)object2;
        } else {
            object = "";
        }
        String testMethodName = string + (String)object + "}";
        if (!Intrinsics.areEqual((Object)testMethod, (Object)testMethodName)) {
            this.resetRetryCount(testMethodName);
        }
        if (this.count.getAndDecrement() > 0) {
            TestFrameworkBaseKt.getFrameworkLogger().info("Retry test method: '" + testMethodName + "', attempt: " + (this.maxRetryCount - this.count.get()));
            return true;
        }
        return false;
    }

    private final void resetRetryCount(String methodName) {
        this.count = new AtomicInteger(this.maxRetryCount);
        testMethod = methodName;
    }

    public RetryAnalyzer() {
        this(0, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/test/retryanalyzer/RetryAnalyzer$Companion;", "", "<init>", "()V", "testMethod", "", "intellij.rider.test.framework.testng"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/test/retryanalyzer/RetryAnalyzer$Linux;", "Lcom/jetbrains/rider/test/retryanalyzer/RetryAnalyzer;", "<init>", "()V", "shouldRetry", "", "result", "Lorg/testng/ITestResult;", "intellij.rider.test.framework.testng"})
    public static final class Linux
    extends RetryAnalyzer {
        public Linux() {
            super(1);
        }

        @Override
        public boolean shouldRetry(@NotNull ITestResult result) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            return SystemInfo.isLinux;
        }
    }
}

