/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.teamcity;

import com.jetbrains.rider.test.TestDirectories;
import com.jetbrains.rider.test.teamcity.TestServiceMessageReporter;
import com.jetbrains.rider.test.testng.TestNgUtilsKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.testng.ISuite;
import org.testng.ITestResult;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001a\u0010\u0010\u001a\u00020\r*\u00020\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/test/teamcity/RetryInfoReporter;", "", "serviceMessageReporter", "Lcom/jetbrains/rider/test/teamcity/TestServiceMessageReporter;", "<init>", "(Lcom/jetbrains/rider/test/teamcity/TestServiceMessageReporter;)V", "classesToRetryFile", "Ljava/io/File;", "groupsToRetryFile", "failedConfigurationsFile", "retryOnConfigurationFailure", "", "reportRetryInfo", "", "suite", "Lorg/testng/ISuite;", "appendUniqueLines", "set", "", "", "intellij.rider.test.framework.testng"})
@SourceDebugExtension(value={"SMAP\nRetryInfoReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RetryInfoReporter.kt\ncom/jetbrains/rider/test/teamcity/RetryInfoReporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1563#2:94\n1634#2,3:95\n1374#2:98\n1460#2,5:99\n774#2:104\n865#2,2:105\n1563#2:107\n1634#2,3:108\n1374#2:111\n1460#2,5:112\n774#2:117\n865#2,2:118\n1563#2:120\n1634#2,3:121\n774#2:125\n865#2,2:126\n1#3:124\n*S KotlinDebug\n*F\n+ 1 RetryInfoReporter.kt\ncom/jetbrains/rider/test/teamcity/RetryInfoReporter\n*L\n33#1:94\n33#1:95,3\n34#1:98\n34#1:99,5\n39#1:104\n39#1:105,2\n44#1:107\n44#1:108,3\n63#1:111\n63#1:112,5\n63#1:117\n63#1:118,2\n69#1:120\n69#1:121,3\n90#1:125\n90#1:126,2\n*E\n"})
public final class RetryInfoReporter {
    @NotNull
    private final TestServiceMessageReporter serviceMessageReporter;
    @NotNull
    private final File classesToRetryFile;
    @NotNull
    private final File groupsToRetryFile;
    @NotNull
    private final File failedConfigurationsFile;
    private final boolean retryOnConfigurationFailure;

    public RetryInfoReporter(@NotNull TestServiceMessageReporter serviceMessageReporter) {
        Intrinsics.checkNotNullParameter((Object)serviceMessageReporter, (String)"serviceMessageReporter");
        this.serviceMessageReporter = serviceMessageReporter;
        this.classesToRetryFile = FilesKt.resolve((File)TestDirectories.INSTANCE.getJetTestRider(), (String)"failedClasses.txt");
        this.groupsToRetryFile = FilesKt.resolve((File)TestDirectories.INSTANCE.getJetTestRider(), (String)"failedGroups.txt");
        this.failedConfigurationsFile = FilesKt.resolve((File)TestDirectories.INSTANCE.getJetTestRider(), (String)"failedConfigurations.txt");
        this.retryOnConfigurationFailure = Boolean.parseBoolean(System.getProperty("retryOnConfigurationFailure"));
    }

    /*
     * WARNING - void declaration
     */
    public final void reportRetryInfo(@NotNull ISuite suite) {
        void $this$flatMapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
        Iterable $this$map$iv = TestNgUtilsKt.getFailedTestResults(suite);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ITestResult iTestResult = (ITestResult)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getTestClass().getRealClass().getName());
        }
        Set failedClasses = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
        Iterable $this$flatMap$iv = TestNgUtilsKt.getFailedTestResults(suite);
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ITestResult it = (ITestResult)element$iv$iv;
            boolean bl = false;
            String[] stringArray = it.getTestContext().getIncludedGroups();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getIncludedGroups(...)");
            Iterable list$iv$iv = ArraysKt.asIterable((Object[])stringArray);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Set groups = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv2));
        if (this.retryOnConfigurationFailure) {
            void $this$mapTo$iv$iv2;
            Iterable destination$iv$iv3;
            void $this$mapTo$iv$iv3;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = TestNgUtilsKt.getFailedConfigurationResults(suite);
            boolean $i$f$filter = false;
            destination$iv$iv2 = $this$filter$iv;
            Iterable destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ITestResult it = (ITestResult)element$iv$iv;
                boolean bl = false;
                if (!(it.getMethod().isBeforeMethodConfiguration() || it.getMethod().isAfterMethodConfiguration() || it.getMethod().isBeforeClassConfiguration() || it.getMethod().isAfterClassConfiguration())) continue;
                destination$iv$iv4.add(element$iv$iv);
            }
            List failedConfigurationResults = (List)destination$iv$iv4;
            Iterable $this$map$iv2 = failedConfigurationResults;
            boolean $i$f$map2 = false;
            destination$iv$iv4 = $this$map$iv2;
            Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it;
                ITestResult bl = (ITestResult)item$iv$iv;
                collection = destination$iv$iv5;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(TestNgUtilsKt.getFullTestName((ITestResult)it));
            }
            Set failedConfigurationNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv5));
            File $this$reportRetryInfo_u24lambda_u244 = this.failedConfigurationsFile;
            boolean bl = false;
            List previousFailedConfigurationNames = $this$reportRetryInfo_u24lambda_u244.exists() ? FilesKt.readLines$default((File)$this$reportRetryInfo_u24lambda_u244, null, (int)1, null) : CollectionsKt.emptyList();
            for (Object configToReport : previousFailedConfigurationNames) {
                if (failedConfigurationNames.contains(configToReport)) continue;
                this.serviceMessageReporter.testStarted((String)configToReport);
                this.serviceMessageReporter.testFinishedSuccess((String)configToReport, 0);
            }
            Set allFailedConfigurationNames = SetsKt.plus((Set)failedConfigurationNames, (Iterable)previousFailedConfigurationNames);
            if (!((Collection)allFailedConfigurationNames).isEmpty()) {
                void $this$filterTo$iv$iv2;
                void $this$filter$iv2;
                Object it;
                void $this$flatMapTo$iv$iv2;
                Iterable $this$flatMap$iv2;
                Object configToReport;
                configToReport = failedConfigurationResults;
                collection = groups;
                boolean $i$f$flatMap2 = false;
                void $i$f$mapTo22 = $this$flatMap$iv2;
                destination$iv$iv3 = new ArrayList();
                boolean $i$f$flatMapTo2 = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
                    it = (ITestResult)element$iv$iv;
                    boolean bl3 = false;
                    String[] stringArray = it.getTestContext().getIncludedGroups();
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getIncludedGroups(...)");
                    Iterable list$iv$iv = ArraysKt.asIterable((Object[])stringArray);
                    CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
                }
                $this$flatMap$iv2 = (List)destination$iv$iv3;
                boolean $i$f$filter2 = false;
                $this$flatMapTo$iv$iv2 = $this$filter$iv2;
                destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    it = (String)element$iv$iv;
                    boolean bl4 = false;
                    if (!(!groups.contains(it))) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                collection.addAll((List)destination$iv$iv3);
                FilesKt.writeText$default((File)this.failedConfigurationsFile, (String)CollectionsKt.joinToString$default((Iterable)allFailedConfigurationNames, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, (int)2, null);
                this.appendUniqueLines(this.groupsToRetryFile, groups);
            }
            Collection collection2 = failedClasses;
            Iterable $this$map$iv3 = failedConfigurationResults;
            boolean $i$f$map3 = false;
            destination$iv$iv3 = $this$map$iv3;
            Collection destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                ITestResult bl4 = (ITestResult)item$iv$iv;
                collection = destination$iv$iv6;
                boolean bl5 = false;
                collection.add(it.getTestClass().getRealClass().getName());
            }
            Iterable iterable2 = (List)destination$iv$iv6;
            CollectionsKt.addAll((Collection)collection2, (Iterable)iterable2);
        }
        if (!((Collection)failedClasses).isEmpty()) {
            FilesKt.writeText$default((File)this.classesToRetryFile, (String)CollectionsKt.joinToString$default((Iterable)failedClasses, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, (int)2, null);
            if (!((Collection)groups).isEmpty()) {
                this.appendUniqueLines(this.groupsToRetryFile, groups);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void appendUniqueLines(File $this$appendUniqueLines, Set<String> set) {
        if (!$this$appendUniqueLines.exists()) {
            FilesKt.writeText$default((File)$this$appendUniqueLines, (String)CollectionsKt.joinToString$default((Iterable)set, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, (int)2, null);
        } else {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$appendUniqueLines_u24lambda_u240;
            Set set2;
            Set set3 = set2 = CollectionsKt.toMutableSet((Iterable)FilesKt.readLines$default((File)$this$appendUniqueLines, null, (int)1, null));
            File file = $this$appendUniqueLines;
            boolean bl = false;
            Iterable iterable = set;
            void var7_8 = $this$appendUniqueLines_u24lambda_u240;
            boolean $i$f$filter = false;
            void var9_10 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (!(!FilesKt.readLines$default((File)$this$appendUniqueLines, null, (int)1, null).contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            var7_8.addAll((List)destination$iv$iv);
            FilesKt.writeText$default((File)file, (String)CollectionsKt.joinToString$default((Iterable)set2, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, (int)2, null);
        }
    }
}

