/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.framework.runner;

import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.openapi.application.Application;
import com.intellij.testFramework.UITestUtil;
import com.jetbrains.rd.platform.util.ApplicationKt;
import com.jetbrains.rider.test.EdtTestExecutor;
import com.jetbrains.rider.test.ProcessKiller;
import com.jetbrains.rider.test.TestDirectories;
import com.jetbrains.rider.test.framework.TeamCityHelper;
import com.jetbrains.rider.test.framework.TestFrameworkBaseKt;
import com.jetbrains.rider.test.framework.TestToolsDownloadHelperState;
import com.jetbrains.rider.test.framework.ToolSetupState;
import com.jetbrains.rider.test.framework.processor.TestProcessor;
import com.jetbrains.rider.test.framework.processor.model.IntegrationTestMethod;
import com.jetbrains.rider.test.framework.runner.BaseTestRunner;
import com.jetbrains.rider.test.logging.RiderLoggedErrorProcessor;
import com.jetbrains.rider.test.teamcity.RiderTeamCityTestngListener;
import com.jetbrains.rider.test.timeout.TimeoutProcessor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.test.AssertionsKt;
import org.jetbrains.annotations.NotNull;
import org.testng.ISuiteListener;
import org.testng.ITestResult;
import org.testng.TestNG;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012H\u0014J\u001e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012H\u0014J\u0018\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/test/framework/runner/IntegrationTestRunner;", "Lcom/jetbrains/rider/test/framework/runner/BaseTestRunner;", "Lcom/jetbrains/rider/test/framework/processor/model/IntegrationTestMethod;", "testProcessor", "Lcom/jetbrains/rider/test/framework/processor/TestProcessor;", "riderLoggedErrorProcessor", "Lcom/jetbrains/rider/test/logging/RiderLoggedErrorProcessor;", "<init>", "(Lcom/jetbrains/rider/test/framework/processor/TestProcessor;Lcom/jetbrains/rider/test/logging/RiderLoggedErrorProcessor;)V", "runOnEdtWithoutApplication", "", "getRunOnEdtWithoutApplication", "()Z", "runConfigurationMethod", "", "testResult", "Lorg/testng/ITestResult;", "callBack", "Lkotlin/Function0;", "runTest", "checkFreeSpace", "methodName", "", "IntegrationTestProcessKiller", "intellij.rider.test.framework.testng"})
@SourceDebugExtension(value={"SMAP\nIntegrationTestRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntegrationTestRunner.kt\ncom/jetbrains/rider/test/framework/runner/IntegrationTestRunner\n+ 2 EdtTestExecutor.kt\ncom/jetbrains/rider/test/EdtTestExecutor\n*L\n1#1,90:1\n22#2,6:91\n38#2,23:97\n15#2,13:120\n38#2,23:133\n*S KotlinDebug\n*F\n+ 1 IntegrationTestRunner.kt\ncom/jetbrains/rider/test/framework/runner/IntegrationTestRunner\n*L\n34#1:91,6\n34#1:97,23\n43#1:120,13\n43#1:133,23\n*E\n"})
public class IntegrationTestRunner
extends BaseTestRunner<IntegrationTestMethod> {
    private final boolean runOnEdtWithoutApplication;

    public IntegrationTestRunner(@NotNull TestProcessor<IntegrationTestMethod> testProcessor, @NotNull RiderLoggedErrorProcessor riderLoggedErrorProcessor) {
        Intrinsics.checkNotNullParameter(testProcessor, (String)"testProcessor");
        Intrinsics.checkNotNullParameter((Object)riderLoggedErrorProcessor, (String)"riderLoggedErrorProcessor");
        super(testProcessor, riderLoggedErrorProcessor);
        this.runOnEdtWithoutApplication = true;
    }

    public boolean getRunOnEdtWithoutApplication() {
        return this.runOnEdtWithoutApplication;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void runConfigurationMethod(@NotNull ITestResult testResult, @NotNull Function0<Unit> callBack) {
        void timeout$iv;
        Intrinsics.checkNotNullParameter((Object)testResult, (String)"testResult");
        Intrinsics.checkNotNullParameter(callBack, (String)"callBack");
        IdeaForkJoinWorkerThreadFactory.setupForkJoinCommonPool((boolean)true);
        UITestUtil.replaceIdeEventQueueSafely();
        IntegrationTestProcessKiller processKiller = new IntegrationTestProcessKiller(testResult);
        Method method = testResult.getMethod().getConstructorOrMethod().getMethod();
        Intrinsics.checkNotNullExpressionValue((Object)method, (String)"getMethod(...)");
        Duration timeout = TimeoutProcessor.INSTANCE.getSetupTeardownTimeout(method);
        EdtTestExecutor edtTestExecutor = EdtTestExecutor.INSTANCE;
        String string = testResult.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = string;
        Duration duration = timeout;
        ProcessKiller processKiller2 = processKiller;
        boolean runOnEdtWithoutApplication$iv = this.getRunOnEdtWithoutApplication();
        boolean $i$f$runInEdtAndWait = false;
        if (SwingUtilities.isEventDispatchThread()) {
            AssertionsKt.fail((String)"Test runner is working on EDT...");
            throw new KotlinNothingValueException();
        }
        CountDownLatch finished$iv = new CountDownLatch(1);
        Ref.ObjectRef throwable$iv = new Ref.ObjectRef();
        Function0 runnable$iv = (Function0)new Function0<Unit>(callBack, throwable$iv, finished$iv){
            final /* synthetic */ Function0 $action;
            final /* synthetic */ Ref.ObjectRef $throwable;
            final /* synthetic */ CountDownLatch $finished;
            {
                this.$action = $action;
                this.$throwable = $throwable;
                this.$finished = $finished;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                try {
                    this.$action.invoke();
                }
                catch (Throwable t) {
                    this.$throwable.element = t;
                }
                finally {
                    this.$finished.countDown();
                }
            }
        };
        if (ApplicationKt.getApplicationOrNull() != null) {
            Application application = ApplicationKt.getApplicationOrNull();
            if (application != null) {
                application.invokeLater(new Runnable(runnable$iv){
                    private final /* synthetic */ Function0 function;
                    {
                        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                        this.function = function;
                    }

                    public final /* synthetic */ void run() {
                        this.function.invoke();
                    }
                });
            }
        } else if (runOnEdtWithoutApplication$iv) {
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        } else {
            ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(runnable$iv){
                final /* synthetic */ Function0 $runnable;
                {
                    this.$runnable = $runnable;
                }

                public final void invoke() {
                    this.$runnable.invoke();
                }
            }), (int)31, null);
        }
        while (!finished$iv.await(timeout$iv.toMinutes(), TimeUnit.MINUTES)) {
            void processKiller$iv;
            void testName$iv;
            String description$iv = "Timeout " + timeout$iv.toMinutes() + " min was expired in test: " + (String)testName$iv;
            ToolSetupState setupState$iv = TestToolsDownloadHelperState.INSTANCE.getCurrent();
            if (setupState$iv.isInProgress()) {
                if (!TeamCityHelper.Companion.isUnderTeamCity()) continue;
                TestFrameworkBaseKt.getFrameworkLogger().warn(description$iv + ", but prolonged because tool setup is in progress: " + setupState$iv.getDescription());
                continue;
            }
            processKiller$iv.killSelf(description$iv, "TestTimeout", (String)testName$iv);
            break;
        }
        if (throwable$iv.element != null) {
            Object object = throwable$iv.element;
            Intrinsics.checkNotNull((Object)object);
            throw (Throwable)object;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void runTest(@NotNull ITestResult testResult, @NotNull Function0<Unit> callBack) {
        Intrinsics.checkNotNullParameter((Object)testResult, (String)"testResult");
        Intrinsics.checkNotNullParameter(callBack, (String)"callBack");
        IntegrationTestProcessKiller processKiller = new IntegrationTestProcessKiller(testResult);
        try {
            void timeout$iv;
            IdeaForkJoinWorkerThreadFactory.setupForkJoinCommonPool((boolean)true);
            UITestUtil.replaceIdeEventQueueSafely();
            EdtTestExecutor edtTestExecutor = EdtTestExecutor.INSTANCE;
            String string = ((IntegrationTestMethod)this.getTestMethod()).getCanonicalName();
            Duration duration = ((IntegrationTestMethod)this.getTestMethod()).getTimeout();
            ProcessKiller processKiller$iv = processKiller;
            boolean runOnEdtWithoutApplication$iv = true;
            boolean $i$f$runInEdtAndWait = false;
            if (SwingUtilities.isEventDispatchThread()) {
                AssertionsKt.fail((String)"Test runner is working on EDT...");
                throw new KotlinNothingValueException();
            }
            CountDownLatch finished$iv = new CountDownLatch(1);
            Ref.ObjectRef throwable$iv = new Ref.ObjectRef();
            Function0 runnable$iv = (Function0)new Function0<Unit>(throwable$iv, finished$iv, callBack, testResult){
                final /* synthetic */ Ref.ObjectRef $throwable;
                final /* synthetic */ CountDownLatch $finished;
                final /* synthetic */ Function0 $callBack$inlined;
                final /* synthetic */ ITestResult $testResult$inlined;
                {
                    this.$throwable = $throwable;
                    this.$finished = $finished;
                    this.$callBack$inlined = function0;
                    this.$testResult$inlined = iTestResult;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    try {
                        boolean bl = false;
                        try {
                            Throwable throwable;
                            this.$callBack$inlined.invoke();
                            Throwable throwable2 = this.$testResult$inlined.getThrowable();
                            if (throwable2 instanceof InvocationTargetException && (throwable = ((InvocationTargetException)throwable2).getCause()) == null) {
                                throwable = throwable2 = throwable2;
                            }
                            if (throwable2 != null) {
                                TestFrameworkBaseKt.getFrameworkLogger().error(throwable2);
                            }
                        }
                        catch (Throwable e) {
                            TestFrameworkBaseKt.getFrameworkLogger().error(e);
                        }
                    }
                    catch (Throwable t) {
                        this.$throwable.element = t;
                    }
                    finally {
                        this.$finished.countDown();
                    }
                }
            };
            if (ApplicationKt.getApplicationOrNull() != null) {
                Application application = ApplicationKt.getApplicationOrNull();
                if (application != null) {
                    application.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            } else {
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            while (!finished$iv.await(timeout$iv.toMinutes(), TimeUnit.MINUTES)) {
                void testName$iv;
                String description$iv = "Timeout " + timeout$iv.toMinutes() + " min was expired in test: " + (String)testName$iv;
                ToolSetupState setupState$iv = TestToolsDownloadHelperState.INSTANCE.getCurrent();
                if (setupState$iv.isInProgress()) {
                    if (!TeamCityHelper.Companion.isUnderTeamCity()) continue;
                    TestFrameworkBaseKt.getFrameworkLogger().warn(description$iv + ", but prolonged because tool setup is in progress: " + setupState$iv.getDescription());
                    continue;
                }
                processKiller$iv.killSelf(description$iv, "TestTimeout", (String)testName$iv);
                break;
            }
            if (throwable$iv.element != null) {
                Object object = throwable$iv.element;
                Intrinsics.checkNotNull((Object)object);
                throw (Throwable)object;
            }
        }
        catch (Throwable e) {
            TestFrameworkBaseKt.getFrameworkLogger().error(e);
        }
    }

    @Override
    protected void checkFreeSpace(@NotNull String methodName, @NotNull ITestResult testResult) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)testResult, (String)"testResult");
        super.checkFreeSpace(methodName, testResult);
        IntegrationTestProcessKiller processKiller = new IntegrationTestProcessKiller(testResult);
        if (!TestDirectories.INSTANCE.getJetTestRider().exists()) {
            TestDirectories.INSTANCE.getJetTestRider().mkdirs();
        }
        if (Files.getFileStore(TestDirectories.INSTANCE.getJetTestRider().toPath()).getUsableSpace() < 1024L) {
            processKiller.killSelf("Not enough disk space", "TestSetUpOrTearDownError", methodName);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/test/framework/runner/IntegrationTestRunner$IntegrationTestProcessKiller;", "Lcom/jetbrains/rider/test/ProcessKiller;", "testResult", "Lorg/testng/ITestResult;", "<init>", "(Lorg/testng/ITestResult;)V", "getTestResult", "()Lorg/testng/ITestResult;", "cleanup", "", "reason", "", "errorCategory", "testName", "intellij.rider.test.framework.testng"})
    @SourceDebugExtension(value={"SMAP\nIntegrationTestRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntegrationTestRunner.kt\ncom/jetbrains/rider/test/framework/runner/IntegrationTestRunner$IntegrationTestProcessKiller\n+ 2 TestNgUtils.kt\ncom/jetbrains/rider/test/testng/TestNgUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n30#2:91\n808#3,11:92\n*S KotlinDebug\n*F\n+ 1 IntegrationTestRunner.kt\ncom/jetbrains/rider/test/framework/runner/IntegrationTestRunner$IntegrationTestProcessKiller\n*L\n81#1:91\n81#1:92,11\n*E\n"})
    private static final class IntegrationTestProcessKiller
    extends ProcessKiller {
        @NotNull
        private final ITestResult testResult;

        public IntegrationTestProcessKiller(@NotNull ITestResult testResult) {
            Intrinsics.checkNotNullParameter((Object)testResult, (String)"testResult");
            this.testResult = testResult;
        }

        @NotNull
        public final ITestResult getTestResult() {
            return this.testResult;
        }

        /*
         * WARNING - void declaration
         */
        protected void cleanup(@NotNull String reason, @NotNull String errorCategory, @NotNull String testName) {
            void $this$filterIsInstanceTo$iv$iv$iv;
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Intrinsics.checkNotNullParameter((Object)errorCategory, (String)"errorCategory");
            Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
            super.cleanup(reason, errorCategory, testName);
            this.testResult.setThrowable((Throwable)new Exception("CRITICAL FAILURE: " + reason + " (" + errorCategory + ")"));
            boolean $i$f$getSuiteListener = false;
            List list = TestNG.getDefault().getSuiteListeners();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSuiteListeners(...)");
            Iterable $this$filterIsInstance$iv$iv = list;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
                if (!(element$iv$iv$iv instanceof RiderTeamCityTestngListener)) continue;
                destination$iv$iv$iv.add(element$iv$iv$iv);
            }
            RiderTeamCityTestngListener listener = (RiderTeamCityTestngListener)((ISuiteListener)CollectionsKt.singleOrNull((List)((List)destination$iv$iv$iv)));
            if (listener == null) {
                System.out.println((Object)"RiderTeamCityTestngListener.instance == null");
            } else if (this.testResult.getMethod().isTest()) {
                listener.onTestFailed(this.testResult);
            } else {
                listener.onConfigurationFailed(this.testResult);
            }
        }
    }
}

