/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.teamcity;

import com.jetbrains.rider.test.framework.processor.TestProcessor;
import com.jetbrains.rider.test.teamcity.FullDurationTestListener;
import com.jetbrains.rider.test.teamcity.GoldFilesReporter;
import com.jetbrains.rider.test.teamcity.LogDirectoryReporter;
import com.jetbrains.rider.test.teamcity.PerformanceReadMeHtmlReporter;
import com.jetbrains.rider.test.teamcity.QaPortalAnnotationsReporter;
import com.jetbrains.rider.test.teamcity.RetryInfoReporter;
import com.jetbrains.rider.test.teamcity.TestServiceMessageReporter;
import com.jetbrains.rider.test.testng.TestNgUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.testng.ISuite;
import org.testng.ITestResult;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0015H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/test/teamcity/RiderTeamCityTestngListener;", "Lcom/jetbrains/rider/test/teamcity/FullDurationTestListener;", "<init>", "()V", "testServiceMessageReporter", "Lcom/jetbrains/rider/test/teamcity/TestServiceMessageReporter;", "getTestServiceMessageReporter", "()Lcom/jetbrains/rider/test/teamcity/TestServiceMessageReporter;", "retryInfoReporter", "Lcom/jetbrains/rider/test/teamcity/RetryInfoReporter;", "qaPortalAnnotationsReporter", "Lcom/jetbrains/rider/test/teamcity/QaPortalAnnotationsReporter;", "logDirectoryReporter", "Lcom/jetbrains/rider/test/teamcity/LogDirectoryReporter;", "goldFilesReporter", "Lcom/jetbrains/rider/test/teamcity/GoldFilesReporter;", "performanceReadMeHtmlReporter", "Lcom/jetbrains/rider/test/teamcity/PerformanceReadMeHtmlReporter;", "onTestStarted", "", "testResult", "Lorg/testng/ITestResult;", "onTestPassed", "onTestFailed", "onTestSkipped", "onConfigurationFailed", "configurationResult", "onFinish", "suite", "Lorg/testng/ISuite;", "reportTestForConfiguration", "intellij.rider.test.framework.testng"})
public class RiderTeamCityTestngListener
extends FullDurationTestListener {
    @NotNull
    private final TestServiceMessageReporter testServiceMessageReporter = new TestServiceMessageReporter();
    @NotNull
    private final RetryInfoReporter retryInfoReporter = new RetryInfoReporter(this.getTestServiceMessageReporter());
    @NotNull
    private final QaPortalAnnotationsReporter qaPortalAnnotationsReporter = new QaPortalAnnotationsReporter(this.getTestServiceMessageReporter());
    @NotNull
    private final LogDirectoryReporter logDirectoryReporter = new LogDirectoryReporter(this.getTestServiceMessageReporter());
    @NotNull
    private final GoldFilesReporter goldFilesReporter = new GoldFilesReporter(this.getTestServiceMessageReporter());
    @NotNull
    private final PerformanceReadMeHtmlReporter performanceReadMeHtmlReporter = new PerformanceReadMeHtmlReporter();

    @NotNull
    public TestServiceMessageReporter getTestServiceMessageReporter() {
        return this.testServiceMessageReporter;
    }

    @Override
    public void onTestStarted(@NotNull ITestResult testResult) {
        Intrinsics.checkNotNullParameter((Object)testResult, (String)"testResult");
        this.getTestServiceMessageReporter().testStarted(TestNgUtilsKt.getFullTestName(testResult));
    }

    @Override
    public void onTestPassed(@NotNull ITestResult testResult) {
        Intrinsics.checkNotNullParameter((Object)testResult, (String)"testResult");
        this.qaPortalAnnotationsReporter.reportTestAnnotations(TestNgUtilsKt.getFullTestName(testResult), testResult);
        this.getTestServiceMessageReporter().testFinishedSuccess(TestNgUtilsKt.getFullTestName(testResult), this.getCurrentTestDuration());
    }

    @Override
    public void onTestFailed(@NotNull ITestResult testResult) {
        Intrinsics.checkNotNullParameter((Object)testResult, (String)"testResult");
        this.qaPortalAnnotationsReporter.reportTestAnnotations(TestNgUtilsKt.getFullTestName(testResult), testResult);
        this.logDirectoryReporter.reportLogDirectory(testResult);
        this.performanceReadMeHtmlReporter.reportReadme(testResult);
        this.goldFilesReporter.reportGoldFile(testResult);
        this.getTestServiceMessageReporter().testFinishedFailure(TestNgUtilsKt.getFullTestName(testResult), testResult.getThrowable(), this.getCurrentTestDuration());
    }

    @Override
    public void onTestSkipped(@NotNull ITestResult testResult) {
        Intrinsics.checkNotNullParameter((Object)testResult, (String)"testResult");
        this.qaPortalAnnotationsReporter.reportTestAnnotations(TestNgUtilsKt.getFullTestName(testResult), testResult);
        this.getTestServiceMessageReporter().testFinishedIgnored(TestNgUtilsKt.getFullTestName(testResult), TestNgUtilsKt.getIgnoreReason(testResult));
    }

    @Override
    public void onConfigurationFailed(@NotNull ITestResult configurationResult) {
        Intrinsics.checkNotNullParameter((Object)configurationResult, (String)"configurationResult");
        this.getTestServiceMessageReporter().testStarted(TestNgUtilsKt.getFullTestName(configurationResult));
        this.reportTestForConfiguration(configurationResult);
        long duration = configurationResult.getEndMillis() - configurationResult.getStartMillis();
        this.getTestServiceMessageReporter().testFinishedFailure(TestNgUtilsKt.getFullTestName(configurationResult), configurationResult.getThrowable(), (int)duration);
    }

    @Override
    public void onFinish(@NotNull ISuite suite) {
        Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
        super.onFinish(suite);
        this.retryInfoReporter.reportRetryInfo(suite);
        this.performanceReadMeHtmlReporter.buildHtml();
    }

    private final void reportTestForConfiguration(ITestResult configurationResult) {
        if (configurationResult.getMethod().isBeforeMethodConfiguration() || configurationResult.getMethod().isAfterMethodConfiguration()) {
            TestProcessor instance;
            Object object = configurationResult.getInstance();
            TestProcessor testProcessor = instance = object instanceof TestProcessor ? (TestProcessor)object : null;
            if (instance != null && instance.getHasTestMethod()) {
                String packageName = instance.getTestMethod().getRealClass().getPackageName();
                String testName = StringsKt.removePrefix((String)instance.getTestMethod().getCanonicalName(), (CharSequence)(packageName + "."));
                TestServiceMessageReporter testServiceMessageReporter = this.getTestServiceMessageReporter();
                String string = TestNgUtilsKt.getFullTestName(configurationResult);
                String string2 = "Test: " + testName;
                Intrinsics.checkNotNull((Object)packageName);
                String string3 = packageName;
                TestServiceMessageReporter.reportMetadata$default((TestServiceMessageReporter)testServiceMessageReporter, (String)string3, (String)string, null, (String)string2, null, (int)20, null);
            }
        }
    }
}

