/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.base;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.platform.diagnostics.LogTraceScenario;
import com.jetbrains.rider.diagnostics.LogTraceScenarios;
import com.jetbrains.rider.test.OpenSolutionParams;
import com.jetbrains.rider.test.annotations.Solution;
import com.jetbrains.rider.test.base.PerTestSolutionTestBase;
import com.jetbrains.rider.test.framework.testData.TestDataStorage;
import com.jetbrains.rider.test.scriptingApi.DebugTestExecutionContext;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPIKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_DebugKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_ProjectModelKt;
import com.jetbrains.rider.utils.NullPrintStream;
import java.io.File;
import java.io.PrintStream;
import java.time.Duration;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.testng.annotations.BeforeMethod;

@Solution(name="ConsoleAppCore")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0007J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0004J\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0004R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/test/base/ArgumentPassingTestBase;", "Lcom/jetbrains/rider/test/base/PerTestSolutionTestBase;", "<init>", "()V", "modifyOpenSolutionParams", "", "params", "Lcom/jetbrains/rider/test/OpenSolutionParams;", "traceScenarios", "", "Lcom/jetbrains/rd/platform/diagnostics/LogTraceScenario;", "getTraceScenarios", "()Ljava/util/Set;", "testCaseSourceDirectory", "Ljava/io/File;", "getTestCaseSourceDirectory", "()Ljava/io/File;", "prepareTestProgram", "printProgramOutput", "settings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "printStream", "Ljava/io/PrintStream;", "printDebugProgramOutput", "intellij.rider.test.framework"})
public abstract class ArgumentPassingTestBase
extends PerTestSolutionTestBase {
    @NotNull
    private final Set<LogTraceScenario> traceScenarios = SetsKt.setOf((Object)LogTraceScenarios.Run.INSTANCE);

    @Override
    public void modifyOpenSolutionParams(@NotNull OpenSolutionParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        super.modifyOpenSolutionParams(params);
        params.setWaitForCaches(true);
        params.setRestoreNuGetPackages(true);
    }

    @Override
    @NotNull
    public Set<LogTraceScenario> getTraceScenarios() {
        return this.traceScenarios;
    }

    @NotNull
    public File getTestCaseSourceDirectory() {
        File file = this.getTestClassDataDirectory().getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
        return file;
    }

    @BeforeMethod
    public final void prepareTestProgram() {
        ScriptingAPI_ProjectModelKt.replaceFileContent((TestDataStorage)this, this.getProject(), "Program.cs", "WindowsPrintCommandLine.cs");
    }

    protected final void printProgramOutput(@NotNull RunnerAndConfigurationSettings settings, @NotNull PrintStream printStream) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)printStream, (String)"printStream");
        Project project2 = this.getProject();
        Duration duration = Duration.ofSeconds(30L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        String output2 = ScriptingAPIKt.runProgramAndCollectStdOut(project2, settings, duration);
        printStream.println(output2);
        printStream.println();
    }

    protected final void printDebugProgramOutput(@NotNull RunnerAndConfigurationSettings settings, @NotNull PrintStream printStream) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)printStream, (String)"printStream");
        this.getLogger().info("Printing debug output, configuration: " + settings.getConfiguration().getName());
        RunManager runManager = RunManager.Companion.getInstance(this.getProject());
        runManager.addConfiguration(settings);
        runManager.setSelectedConfiguration(settings);
        StringBuilder outBuilder = new StringBuilder();
        this.getLogger().info("Executing run configuration: " + settings.getConfiguration().getName());
        ScriptingAPI_DebugKt.debugProgram$default(this.getProject(), (PrintStream)NullPrintStream.INSTANCE, ArgumentPassingTestBase::printDebugProgramOutput$lambda$0, ArgumentPassingTestBase::printDebugProgramOutput$lambda$1, arg_0 -> ArgumentPassingTestBase.printDebugProgramOutput$lambda$2(outBuilder, arg_0), false, null, null, null, 480, null);
        this.getLogger().info("Finished debug session, configuration: " + settings.getConfiguration().getName());
        String string = outBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String output2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
        this.getLogger().info("Output: " + output2);
        printStream.println(output2);
        printStream.println();
    }

    private static final Unit printDebugProgramOutput$lambda$0(ExecutionEnvironment $this$debugProgram) {
        Intrinsics.checkNotNullParameter((Object)$this$debugProgram, (String)"$this$debugProgram");
        return Unit.INSTANCE;
    }

    private static final Unit printDebugProgramOutput$lambda$1(DebugTestExecutionContext $this$debugProgram) {
        Intrinsics.checkNotNullParameter((Object)$this$debugProgram, (String)"$this$debugProgram");
        ProcessHandler processHandler = $this$debugProgram.getSession().getDebugProcess().getProcessHandler();
        Intrinsics.checkNotNullExpressionValue((Object)processHandler, (String)"getProcessHandler(...)");
        Duration duration = Duration.ofSeconds(30L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        ScriptingAPIKt.waitForExitOrStop$default(processHandler, duration, false, false, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit printDebugProgramOutput$lambda$2(StringBuilder $outBuilder, String output2) {
        Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
        $outBuilder.append(output2);
        return Unit.INSTANCE;
    }
}

