/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.base;

import com.jetbrains.rider.model.SolutionAnalysisWarningsMode;
import com.jetbrains.rider.test.OpenSolutionParams;
import com.jetbrains.rider.test.annotations.Mute;
import com.jetbrains.rider.test.annotations.RiderTestTimeout;
import com.jetbrains.rider.test.base.PerTestSettingsTestBase;
import com.jetbrains.rider.test.facades.TestApiScopes;
import com.jetbrains.rider.test.facades.build.BuildApiFacade;
import com.jetbrains.rider.test.facades.build.RiderBuildApiFacade;
import com.jetbrains.rider.test.facades.solution.RiderSolutionApiFacade;
import com.jetbrains.rider.test.facades.solution.SolutionApiFacade;
import com.jetbrains.rider.test.framework.TestFrameworkKt;
import com.jetbrains.rider.test.framework.workDirectory.CustomTestWorkDirectoryStorage;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_BuildKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_NuGetKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_SolutionAnalysisKt;
import com.jetbrains.rider.test.suplementary.ExternalSolutions;
import com.jetbrains.rider.test.suplementary.ITestSolution;
import com.jetbrains.rider.test.suplementary.TestSolutionFromRepo;
import java.io.File;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\tJ\b\u0010*\u001a\u00020+H\u0007J\b\u0010,\u001a\u00020+H\u0017J\b\u0010-\u001a\u00020+H\u0017J\b\u0010.\u001a\u00020+H\u0017J\b\u0010/\u001a\u00020+H\u0017J\b\u00100\u001a\u00020+H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u001b\u0010\u0010\u001a\u00020\u00118VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001b\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u000f\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001e\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010!R\u0014\u0010$\u001a\u00020%X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020%X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010'\u00a8\u00061"}, d2={"Lcom/jetbrains/rider/test/base/ExternalSolutionBaseTest;", "Lcom/jetbrains/rider/test/base/PerTestSettingsTestBase;", "Lcom/jetbrains/rider/test/facades/TestApiScopes$Solution;", "Lcom/jetbrains/rider/test/facades/TestApiScopes$Build;", "solutionFromRepo", "Lcom/jetbrains/rider/test/suplementary/TestSolutionFromRepo;", "<init>", "(Lcom/jetbrains/rider/test/suplementary/TestSolutionFromRepo;)V", "Lcom/jetbrains/rider/test/suplementary/ExternalSolutions;", "(Lcom/jetbrains/rider/test/suplementary/ExternalSolutions;)V", "solutionApiFacade", "Lcom/jetbrains/rider/test/facades/solution/RiderSolutionApiFacade;", "getSolutionApiFacade", "()Lcom/jetbrains/rider/test/facades/solution/RiderSolutionApiFacade;", "solutionApiFacade$delegate", "Lkotlin/Lazy;", "buildApiFacade", "Lcom/jetbrains/rider/test/facades/build/RiderBuildApiFacade;", "getBuildApiFacade", "()Lcom/jetbrains/rider/test/facades/build/RiderBuildApiFacade;", "buildApiFacade$delegate", "openSolutionParams", "Lcom/jetbrains/rider/test/OpenSolutionParams;", "getOpenSolutionParams", "()Lcom/jetbrains/rider/test/OpenSolutionParams;", "testWorkDirectoryStorage", "Lcom/jetbrains/rider/test/framework/workDirectory/CustomTestWorkDirectoryStorage;", "getTestWorkDirectoryStorage", "()Lcom/jetbrains/rider/test/framework/workDirectory/CustomTestWorkDirectoryStorage;", "testWorkDirectoryStorage$delegate", "buildTimeout", "Ljava/time/Duration;", "getBuildTimeout", "()Ljava/time/Duration;", "sweaTimeout", "getSweaTimeout", "errorsCount", "", "getErrorsCount", "()I", "warningsCount", "getWarningsCount", "downloadAndOpenSolution", "", "checkNuGetRestore", "buildSolution", "swea", "sweaWithWarnings", "closeSolutionAfterClass", "intellij.rider.test.framework"})
public abstract class ExternalSolutionBaseTest
extends PerTestSettingsTestBase
implements TestApiScopes.Solution,
TestApiScopes.Build {
    @NotNull
    private final TestSolutionFromRepo solutionFromRepo;
    @NotNull
    private final Lazy solutionApiFacade$delegate;
    @NotNull
    private final Lazy buildApiFacade$delegate;
    @NotNull
    private final Lazy testWorkDirectoryStorage$delegate;
    @NotNull
    private final Duration buildTimeout;
    @NotNull
    private final Duration sweaTimeout;
    private final int errorsCount;
    private final int warningsCount;

    public ExternalSolutionBaseTest(@NotNull TestSolutionFromRepo solutionFromRepo) {
        Intrinsics.checkNotNullParameter((Object)solutionFromRepo, (String)"solutionFromRepo");
        this.solutionFromRepo = solutionFromRepo;
        this.solutionApiFacade$delegate = LazyKt.lazy(ExternalSolutionBaseTest::solutionApiFacade_delegate$lambda$0);
        this.buildApiFacade$delegate = LazyKt.lazy(() -> ExternalSolutionBaseTest.buildApiFacade_delegate$lambda$0(this));
        this.testWorkDirectoryStorage$delegate = LazyKt.lazy(() -> ExternalSolutionBaseTest.testWorkDirectoryStorage_delegate$lambda$0(this));
        Duration duration = Duration.ofMinutes(10L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
        this.buildTimeout = duration;
        Duration duration2 = Duration.ofMinutes(10L);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMinutes(...)");
        this.sweaTimeout = duration2;
    }

    public ExternalSolutionBaseTest(@NotNull ExternalSolutions solutionFromRepo) {
        Intrinsics.checkNotNullParameter((Object)solutionFromRepo, (String)"solutionFromRepo");
        this(solutionFromRepo.get());
    }

    @NotNull
    public RiderSolutionApiFacade getSolutionApiFacade() {
        Lazy lazy = this.solutionApiFacade$delegate;
        return (RiderSolutionApiFacade)((Object)lazy.getValue());
    }

    @NotNull
    public RiderBuildApiFacade getBuildApiFacade() {
        Lazy lazy = this.buildApiFacade$delegate;
        return (RiderBuildApiFacade)lazy.getValue();
    }

    @NotNull
    public OpenSolutionParams getOpenSolutionParams() {
        OpenSolutionParams openSolutionParams;
        OpenSolutionParams $this$_get_openSolutionParams__u24lambda_u240 = openSolutionParams = new OpenSolutionParams();
        boolean bl = false;
        $this$_get_openSolutionParams__u24lambda_u240.setWaitForCaches(true);
        $this$_get_openSolutionParams__u24lambda_u240.setPersistCaches(true);
        $this$_get_openSolutionParams__u24lambda_u240.setRestoreNuGetPackages(true);
        Duration duration = Duration.ofMinutes(10L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
        $this$_get_openSolutionParams__u24lambda_u240.setBackendLoadedTimeout(duration);
        Duration duration2 = Duration.ofMinutes(10L);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMinutes(...)");
        $this$_get_openSolutionParams__u24lambda_u240.setProjectModelReadyTimeout(duration2);
        Duration duration3 = Duration.ofMinutes(2L);
        Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofMinutes(...)");
        $this$_get_openSolutionParams__u24lambda_u240.setInitWithCachesTimeout(duration3);
        $this$_get_openSolutionParams__u24lambda_u240.setPreprocessTempDirectory(arg_0 -> ExternalSolutionBaseTest._get_openSolutionParams_$lambda$0$0(this, arg_0));
        return openSolutionParams;
    }

    @NotNull
    public CustomTestWorkDirectoryStorage getTestWorkDirectoryStorage() {
        Lazy lazy = this.testWorkDirectoryStorage$delegate;
        return (CustomTestWorkDirectoryStorage)lazy.getValue();
    }

    @NotNull
    public Duration getBuildTimeout() {
        return this.buildTimeout;
    }

    @NotNull
    public Duration getSweaTimeout() {
        return this.sweaTimeout;
    }

    public int getErrorsCount() {
        return this.errorsCount;
    }

    public int getWarningsCount() {
        return this.warningsCount;
    }

    @BeforeMethod
    public final void downloadAndOpenSolution() {
        if (this.getSolutionApiFacade().getHasProject()) {
            return;
        }
        File solutionFile2 = this.getSolutionApiFacade().prepareSolution((ITestSolution)this.solutionFromRepo, this.getOpenSolutionParams(), this.getTestWorkDirectory(), this.getSolutionSourceRootDirectory());
        this.getSolutionApiFacade().openSolution(solutionFile2, this.getOpenSolutionParams());
    }

    @Test
    public void checkNuGetRestore() {
        TestFrameworkKt.checkThatSolutionWasRestoredOnce(this.getProject());
        ScriptingAPI_NuGetKt.checkThatNuGetRestoreSucceeded(this.getProject());
        ScriptingAPI_NuGetKt.checkThatNuGetInstallSucceeded(this.getProject());
    }

    @Test
    public void buildSolution() {
        ScriptingAPI_BuildKt.buildSolutionWithReSharperBuild$default((BuildApiFacade)this, null, null, this.getBuildTimeout(), 3, null);
        BuildApiFacade buildApiFacade2 = (BuildApiFacade)this;
        Duration duration = Duration.ofMinutes(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
        List buildOutput = ScriptingAPI_BuildKt.buildSolutionWithReSharperBuild$default(buildApiFacade2, null, null, duration, 3, null).getOutputMessages();
        ScriptingAPI_BuildKt.checkThatAllProjectsWereSkipped(buildOutput);
        BuildApiFacade buildApiFacade3 = (BuildApiFacade)this;
        Duration duration2 = Duration.ofMinutes(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMinutes(...)");
        buildOutput = ScriptingAPI_BuildKt.buildSolutionWithReSharperBuild$default(buildApiFacade3, null, null, duration2, 3, null).getOutputMessages();
        ScriptingAPI_BuildKt.checkThatAllProjectsWereSkipped(buildOutput);
    }

    @Test
    @RiderTestTimeout(timeout=20L, unit=TimeUnit.MINUTES)
    public void swea() {
        ScriptingAPI_SolutionAnalysisKt.checkSwea$default(this.getProject(), this.getErrorsCount(), null, this.getSweaTimeout(), 4, null);
    }

    @Test
    @Mute(reason="RIDER-114893")
    @RiderTestTimeout(timeout=20L, unit=TimeUnit.MINUTES)
    public void sweaWithWarnings() {
        ScriptingAPI_SolutionAnalysisKt.withSweaWarningsMode(this.getProject(), SolutionAnalysisWarningsMode.ShowAndRun, (Function0<Unit>)((Function0)() -> ExternalSolutionBaseTest.sweaWithWarnings$lambda$0(this)));
    }

    @AfterClass(alwaysRun=true)
    public final void closeSolutionAfterClass() {
        this.getSolutionApiFacade().closeSolution();
    }

    private static final RiderSolutionApiFacade solutionApiFacade_delegate$lambda$0() {
        return new RiderSolutionApiFacade();
    }

    private static final RiderBuildApiFacade buildApiFacade_delegate$lambda$0(ExternalSolutionBaseTest this$0) {
        return new RiderBuildApiFacade((SolutionApiFacade)this$0, null, 2, null);
    }

    private static final Unit _get_openSolutionParams_$lambda$0$0(ExternalSolutionBaseTest this$0, File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ScriptingAPI_SolutionAnalysisKt.disableSweaWithDotSettingsUser(it, this$0.solutionFromRepo.getSlnName());
        return Unit.INSTANCE;
    }

    private static final CustomTestWorkDirectoryStorage testWorkDirectoryStorage_delegate$lambda$0(ExternalSolutionBaseTest this$0) {
        return new CustomTestWorkDirectoryStorage(this$0.getTestProcessor(), "ExternalSolutionTest");
    }

    private static final Unit sweaWithWarnings$lambda$0(ExternalSolutionBaseTest this$0) {
        ScriptingAPI_SolutionAnalysisKt.checkSwea$default(this$0.getProject(), this$0.getWarningsCount(), null, this$0.getSweaTimeout(), 4, null);
        return Unit.INSTANCE;
    }
}

