/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.base;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rdclient.util.idea.ExtensionsKt;
import com.jetbrains.rider.quickDoc.QuickDocElementWithInfo;
import com.jetbrains.rider.test.OpenSolutionParams;
import com.jetbrains.rider.test.annotations.Solution;
import com.jetbrains.rider.test.base.ExecuteActionTestBase;
import com.jetbrains.rider.test.facades.solution.SolutionApiFacade;
import com.jetbrains.rider.test.framework.GoldFilesHelperKt;
import com.jetbrains.rider.test.framework.testData.TestDataStorage;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPIKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_EditorKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_Popups_BaseKt;
import java.io.File;
import java.io.PrintStream;
import java.time.Duration;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.test.AssertionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.testng.annotations.BeforeMethod;

@Solution(name="QuickDocTestSolution")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001(B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0017H\u0007J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020\u0017H\u0014J\b\u0010\"\u001a\u00020\u0017H\u0002J\b\u0010#\u001a\u00020\u0017H\u0004J\u001c\u0010$\u001a\u00020\u00172\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u00170&H\u0004R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/jetbrains/rider/test/base/QuickDocTestBase;", "Lcom/jetbrains/rider/test/base/ExecuteActionTestBase;", "<init>", "()V", "solutionFileToOverwriteByTestCase", "", "getSolutionFileToOverwriteByTestCase", "()Ljava/lang/String;", "docComponent", "Lcom/jetbrains/rider/test/base/QuickDocTestBase$MockDocComponent;", "getDocComponent", "()Lcom/jetbrains/rider/test/base/QuickDocTestBase$MockDocComponent;", "setDocComponent", "(Lcom/jetbrains/rider/test/base/QuickDocTestBase$MockDocComponent;)V", "documentationManager", "Lcom/intellij/codeInsight/documentation/DocumentationManager;", "getDocumentationManager", "()Lcom/intellij/codeInsight/documentation/DocumentationManager;", "setDocumentationManager", "(Lcom/intellij/codeInsight/documentation/DocumentationManager;)V", "popupCreated", "", "modifyOpenSolutionParams", "", "params", "Lcom/jetbrains/rider/test/OpenSolutionParams;", "setUpTestCaseQuickDoc", "onPopupCreation", "popupModel", "Lcom/intellij/ui/popup/list/ListPopupImpl;", "dumpCustomData", "it", "Ljava/io/PrintStream;", "waitAdditional", "waitTillDone", "doQuickDocTest", "doQuickDocTestWithAction", "action", "Lkotlin/Function1;", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "MockDocComponent", "intellij.rider.test.framework"})
@SourceDebugExtension(value={"SMAP\nQuickDocTestBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuickDocTestBase.kt\ncom/jetbrains/rider/test/base/QuickDocTestBase\n+ 2 RLifetime.kt\ncom/jetbrains/rd/util/lifetime/Lifetime$Companion\n*L\n1#1,141:1\n39#2,5:142\n*S KotlinDebug\n*F\n+ 1 QuickDocTestBase.kt\ncom/jetbrains/rider/test/base/QuickDocTestBase\n*L\n83#1:142,5\n*E\n"})
public abstract class QuickDocTestBase
extends ExecuteActionTestBase {
    @NotNull
    private final String solutionFileToOverwriteByTestCase;
    protected MockDocComponent docComponent;
    protected DocumentationManager documentationManager;
    private boolean popupCreated;

    public QuickDocTestBase() {
        this.solutionFileToOverwriteByTestCase = "QuickDocTestSolution/Program.cs";
    }

    @Override
    @NotNull
    protected String getSolutionFileToOverwriteByTestCase() {
        return this.solutionFileToOverwriteByTestCase;
    }

    @NotNull
    protected final MockDocComponent getDocComponent() {
        MockDocComponent mockDocComponent = this.docComponent;
        if (mockDocComponent != null) {
            return mockDocComponent;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"docComponent");
        return null;
    }

    protected final void setDocComponent(@NotNull MockDocComponent mockDocComponent) {
        Intrinsics.checkNotNullParameter((Object)((Object)mockDocComponent), (String)"<set-?>");
        this.docComponent = mockDocComponent;
    }

    @NotNull
    protected final DocumentationManager getDocumentationManager() {
        DocumentationManager documentationManager = this.documentationManager;
        if (documentationManager != null) {
            return documentationManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"documentationManager");
        return null;
    }

    protected final void setDocumentationManager(@NotNull DocumentationManager documentationManager) {
        Intrinsics.checkNotNullParameter((Object)documentationManager, (String)"<set-?>");
        this.documentationManager = documentationManager;
    }

    @Override
    public void modifyOpenSolutionParams(@NotNull OpenSolutionParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        super.modifyOpenSolutionParams(params);
        params.setWaitForCaches(true);
    }

    @BeforeMethod
    public final void setUpTestCaseQuickDoc() {
        DocumentationManager documentationManager = DocumentationManager.getInstance((Project)this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)documentationManager, (String)"getInstance(...)");
        this.setDocumentationManager(documentationManager);
        this.setDocComponent(new MockDocComponent(this.getDocumentationManager(), this.getLogger()));
        this.getDocumentationManager().setDocumentationComponent((DocumentationComponent)this.getDocComponent());
        this.popupCreated = false;
        Disposer.register((Disposable)((Disposable)this.getProject()), (Disposable)((Disposable)this.getDocComponent()));
    }

    @Override
    protected void onPopupCreation(@NotNull ListPopupImpl popupModel) {
        Intrinsics.checkNotNullParameter((Object)popupModel, (String)"popupModel");
        if (this.popupCreated) {
            AssertionsKt.fail((String)"Single popup expected but one more was opened. See log");
            throw new KotlinNothingValueException();
        }
        this.popupCreated = true;
        super.onPopupCreation(popupModel);
    }

    @Override
    protected void dumpCustomData(@NotNull PrintStream it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.println("========= Documentation html =========");
        if (this.getDocComponent().getDocText() == null) {
            it.println("No QuickDoc provided");
        } else {
            it.println(this.getDocComponent().getDocText());
        }
        it.println("======================================");
        String string = this.getDocComponent().getElementName();
        if (string == null) {
            string = "Not provided";
        }
        it.println("Element presentable name: " + string);
        String string2 = this.getDocComponent().getElementId();
        if (string2 == null) {
            string2 = "Not provided";
        }
        it.println("Element doc id: " + string2);
    }

    @Override
    protected void waitAdditional() {
        this.waitTillDone();
    }

    private final void waitTillDone() {
        Duration duration = Duration.ofSeconds(20L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        if (!ExtensionsKt.pumpMessages((Duration)duration, (Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ QuickDocTestBase this$0;
            {
                this.this$0 = $receiver;
                super(0, Intrinsics.Kotlin.class, "processed", "waitTillDone$processed(Lcom/jetbrains/rider/test/base/QuickDocTestBase;)Z", 0);
            }

            public final Boolean invoke() {
                return QuickDocTestBase.access$waitTillDone$processed(this.this$0);
            }
        }))) {
            AssertionsKt.fail((String)("Timed out. Quick doc status text was {" + this.getDocComponent().getStatusText() + "}"));
            throw new KotlinNothingValueException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doQuickDocTest() {
        Lifetime.Companion this_$iv = Lifetime.Companion;
        boolean $i$f$using = false;
        LifetimeDefinition def$iv = new LifetimeDefinition();
        try {
            Lifetime lifetime = def$iv.getLifetime();
            boolean bl = false;
            StringBuilder builder = new StringBuilder();
            ScriptingAPI_EditorKt.adviseAllEditorsScrolling(this.getProject(), builder);
            EditorImpl editorImpl = ScriptingAPI_EditorKt.withOpenedEditor$default((TestDataStorage)this, (SolutionApiFacade)this, this.getSolutionFileToOverwriteByTestCase(), "Program.cs", false, null, arg_0 -> QuickDocTestBase.doQuickDocTest$lambda$0$0(lifetime, builder, this, arg_0), 48, null);
        }
        finally {
            LifetimeDefinition.terminate$default((LifetimeDefinition)def$iv, (boolean)false, (int)1, null);
        }
    }

    protected final void doQuickDocTestWithAction(@NotNull Function1<? super EditorImpl, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        String[] stringArray = new String[]{"QuickJavaDoc"};
        ExecuteActionTestBase.doTest$default(this, stringArray, false, action, 2, null);
    }

    private static final boolean waitTillDone$processed(QuickDocTestBase this$0) {
        return this$0.getDocComponent().getDocText() != null || this$0.popupCreated;
    }

    private static final Unit doQuickDocTest$lambda$0$0(Lifetime $lifetime, StringBuilder $builder, QuickDocTestBase this$0, EditorImpl $this$withOpenedEditor) {
        Intrinsics.checkNotNullParameter((Object)$this$withOpenedEditor, (String)"$this$withOpenedEditor");
        ScriptingAPI_EditorKt.adviseEditorScrolling((Editor)$this$withOpenedEditor, $lifetime, $builder);
        Duration duration = Duration.ofMillis(700L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        ScriptingAPIKt.waitPumping(duration);
        Duration duration2 = Duration.ofSeconds(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
        ScriptingAPI_Popups_BaseKt.callActionAndHandlePopup$default((EditorImpl)$this$withOpenedEditor, (String)"QuickJavaDoc", (boolean)false, (Duration)duration2, null, arg_0 -> QuickDocTestBase.doQuickDocTest$lambda$0$0$0(this$0, arg_0), (int)8, null);
        this$0.waitAdditional();
        GoldFilesHelperKt.executeWithGold((File)ScriptingAPI_EditorKt.getEditorGoldFile((TestDataStorage)this$0, (SolutionApiFacade)this$0), arg_0 -> QuickDocTestBase.doQuickDocTest$lambda$0$0$1(this$0, $builder, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit doQuickDocTest$lambda$0$0$0(QuickDocTestBase this$0, ListPopupImpl $this$callActionAndHandlePopup) {
        Intrinsics.checkNotNullParameter((Object)$this$callActionAndHandlePopup, (String)"$this$callActionAndHandlePopup");
        this$0.onPopupCreation($this$callActionAndHandlePopup);
        return Unit.INSTANCE;
    }

    private static final Unit doQuickDocTest$lambda$0$0$1(QuickDocTestBase this$0, StringBuilder $builder, PrintStream it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ScriptingAPI_EditorKt.dumpOpenedDocument$default(it, this$0.getProject(), false, 4, null);
        if (((CharSequence)$builder).length() > 0) {
            it.println();
            it.print($builder);
        }
        this$0.dumpCustomData(it);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$waitTillDone$processed(QuickDocTestBase this$0) {
        return QuickDocTestBase.waitTillDone$processed(this$0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\n\u0010 \u001a\u0004\u0018\u00010\u000bH\u0016J8\u0010!\u001a\u00020\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001b\u001a\u00020\u000b2\b\u0010\"\u001a\u0004\u0018\u00010\u000b2\b\u0010#\u001a\u0004\u0018\u00010\u000b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\r\"\u0004\b\u0018\u0010\u000f\u00a8\u0006$"}, d2={"Lcom/jetbrains/rider/test/base/QuickDocTestBase$MockDocComponent;", "Lcom/intellij/codeInsight/documentation/DocumentationComponent;", "documentationManager", "Lcom/intellij/codeInsight/documentation/DocumentationManager;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "<init>", "(Lcom/intellij/codeInsight/documentation/DocumentationManager;Lcom/intellij/openapi/diagnostic/Logger;)V", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "docText", "", "getDocText", "()Ljava/lang/String;", "setDocText", "(Ljava/lang/String;)V", "elementName", "getElementName", "setElementName", "elementId", "getElementId", "setElementId", "statusText", "getStatusText", "setStatusText", "setText", "", "text", "element", "Lcom/intellij/psi/PsiElement;", "provider", "Lcom/intellij/lang/documentation/DocumentationProvider;", "getText", "setData", "effectiveExternalUrl", "ref", "intellij.rider.test.framework"})
    public static final class MockDocComponent
    extends DocumentationComponent {
        @NotNull
        private final Logger logger;
        @Nullable
        private String docText;
        @Nullable
        private String elementName;
        @Nullable
        private String elementId;
        @Nullable
        private String statusText;

        public MockDocComponent(@NotNull DocumentationManager documentationManager, @NotNull Logger logger) {
            Intrinsics.checkNotNullParameter((Object)documentationManager, (String)"documentationManager");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            super(documentationManager);
            this.logger = logger;
        }

        @NotNull
        public final Logger getLogger() {
            return this.logger;
        }

        @Nullable
        public final String getDocText() {
            return this.docText;
        }

        public final void setDocText(@Nullable String string) {
            this.docText = string;
        }

        @Nullable
        public final String getElementName() {
            return this.elementName;
        }

        public final void setElementName(@Nullable String string) {
            this.elementName = string;
        }

        @Nullable
        public final String getElementId() {
            return this.elementId;
        }

        public final void setElementId(@Nullable String string) {
            this.elementId = string;
        }

        @Nullable
        public final String getStatusText() {
            return this.statusText;
        }

        public final void setStatusText(@Nullable String string) {
            this.statusText = string;
        }

        public void setText(@NotNull String text, @Nullable PsiElement element, @Nullable DocumentationProvider provider) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.logger.info("Doc component status set: " + text);
            this.statusText = text;
        }

        @Nullable
        public String getText() {
            return this.docText;
        }

        public void setData(@Nullable PsiElement element, @NotNull String text, @Nullable String effectiveExternalUrl, @Nullable String ref, @Nullable DocumentationProvider provider) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.logger.info("Doc component text set: " + text);
            this.docText = text;
            if (element instanceof PsiNamedElement) {
                this.elementName = ((PsiNamedElement)element).getName();
            }
            if (element instanceof QuickDocElementWithInfo) {
                this.elementId = ((QuickDocElementWithInfo)element).getInfo().getElementId();
            }
        }
    }
}

