/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.debugger;

import com.intellij.openapi.util.Pair;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.jetbrains.rider.test.debugger.XDebuggerTestHelper;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.function.BiFunction;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XTestContainer<T> {
    private final List<T> myChildren = new SmartList();
    private String myErrorMessage;
    private final Semaphore myFinished = new Semaphore(0);

    public void addChildren(List<? extends T> children, boolean last) {
        this.myChildren.addAll(children);
        if (last) {
            this.myFinished.release();
        }
    }

    public void tooManyChildren(int remaining) {
        this.myFinished.release();
    }

    public void setMessage(@NotNull String message, Icon icon, @NotNull SimpleTextAttributes attributes, @Nullable XDebuggerTreeNodeHyperlink link) {
        if (message == null) {
            XTestContainer.$$$reportNull$$$0(0);
        }
        if (attributes == null) {
            XTestContainer.$$$reportNull$$$0(1);
        }
    }

    public void setErrorMessage(@NotNull String message, @Nullable XDebuggerTreeNodeHyperlink link) {
        if (message == null) {
            XTestContainer.$$$reportNull$$$0(2);
        }
        this.setErrorMessage(message);
    }

    public void setErrorMessage(@NotNull String errorMessage) {
        if (errorMessage == null) {
            XTestContainer.$$$reportNull$$$0(3);
        }
        this.myErrorMessage = errorMessage;
        this.myFinished.release();
    }

    public Pair<List<T>, String> waitFor(Duration timeout) {
        return this.waitFor(timeout, (semaphore, semaphoreTimeout) -> XDebuggerTestHelper.waitFor(this.myFinished, semaphoreTimeout));
    }

    public Pair<List<T>, String> waitFor(Duration timeout, BiFunction<Semaphore, Duration, Boolean> waitFunction) {
        if (!waitFunction.apply(this.myFinished, timeout).booleanValue()) {
            throw new AssertionError((Object)"Waiting timed out");
        }
        return Pair.create(this.myChildren, (Object)this.myErrorMessage);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/rider/test/debugger/XTestContainer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setMessage";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setErrorMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

