/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.facades.solution;

import com.intellij.codeInsight.folding.CodeFoldingSettings;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rdclient.notifications.NotificationsHost;
import com.jetbrains.rider.debugger.settings.DotNetDebuggerSettings;
import com.jetbrains.rider.model.RdNuGetNotificationContext;
import com.jetbrains.rider.projectView.SolutionManager;
import com.jetbrains.rider.test.OpenSolutionParams;
import com.jetbrains.rider.test.facades.solution.BaseSolutionApiFacade;
import com.jetbrains.rider.test.framework.TestFrameworkBaseKt;
import com.jetbrains.rider.test.framework.TestToolsDownloadHelperKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_DebugKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_NuGetKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_ProjectModelKt;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0014J\b\u0010\u0018\u001a\u00020\u0012H\u0002J\b\u0010\u0019\u001a\u00020\u0012H\u0002J\b\u0010\u001c\u001a\u00020\u0012H\u0002J\b\u0010\u001d\u001a\u00020\u0012H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rider/test/facades/solution/RiderSolutionApiFacade;", "Lcom/jetbrains/rider/test/facades/solution/BaseSolutionApiFacade;", "<init>", "()V", "notificationList", "", "Lcom/intellij/notification/Notification;", "solutionNotificationSequentialLifetime", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "openSolutionOrProject", "Lcom/intellij/openapi/project/Project;", "projectToClose", "solutionOrProjectFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "params", "Lcom/jetbrains/rider/test/OpenSolutionParams;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/jetbrains/rider/test/OpenSolutionParams;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "waitForSolution", "", "doOpenSolution", "solutionFile", "Ljava/io/File;", "closeSolution", "afterCloseSolution", "registerNotificationConsumer", "resetDebuggerSettings", "oldCollapseImports", "", "setupCollapseSettings", "resetCollapseSettings", "intellij.rider.test.framework"})
public class RiderSolutionApiFacade
extends BaseSolutionApiFacade {
    @NotNull
    private final List<Notification> notificationList = new ArrayList();
    @NotNull
    private SequentialLifetimes solutionNotificationSequentialLifetime = new SequentialLifetimes(Lifetime.Companion.getEternal());
    private boolean oldCollapseImports;

    @Nullable
    public Object openSolutionOrProject(@Nullable Project projectToClose, @NotNull VirtualFile solutionOrProjectFile, @NotNull OpenSolutionParams params, @NotNull Continuation<? super Project> $completion) {
        return SolutionManager.INSTANCE.openExistingSolutionOrProject(projectToClose, params.getForceOpenInNewFrame(), solutionOrProjectFile, params.getRestoreNuGetPackages(), $completion);
    }

    public void waitForSolution(@NotNull OpenSolutionParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        super.waitForSolution(params);
        if (params.getRestoreNuGetPackages()) {
            ScriptingAPI_NuGetKt.checkNuGetOperationStatus(this.getProject(), RdNuGetNotificationContext.Restore);
        }
    }

    @NotNull
    protected Project doOpenSolution(@NotNull OpenSolutionParams params, @NotNull File solutionFile2) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)solutionFile2, (String)"solutionFile");
        this.registerNotificationConsumer();
        this.resetDebuggerSettings();
        this.setupCollapseSettings();
        return super.doOpenSolution(params, solutionFile2);
    }

    public void closeSolution() {
        super.closeSolution();
        this.afterCloseSolution();
    }

    protected void afterCloseSolution() {
        this.solutionNotificationSequentialLifetime.terminateCurrent();
        ScriptingAPI_ProjectModelKt.deleteScratchesAndConsoles$default(null, 1, null);
        this.resetCollapseSettings();
    }

    private final void registerNotificationConsumer() {
        NotificationsHost.Companion.registerConsumer((Lifetime)this.solutionNotificationSequentialLifetime.next(), arg_0 -> RiderSolutionApiFacade.registerNotificationConsumer$lambda$0(this, arg_0));
    }

    private final void resetDebuggerSettings() {
        ScriptingAPI_DebugKt.restoreAllDebuggerSettings();
        DotNetDebuggerSettings.Companion.getInstance().setShowReturnValues(false);
    }

    private final void setupCollapseSettings() {
        this.oldCollapseImports = CodeFoldingSettings.getInstance().COLLAPSE_IMPORTS;
        CodeFoldingSettings.getInstance().COLLAPSE_IMPORTS = false;
    }

    private final void resetCollapseSettings() {
        CodeFoldingSettings.getInstance().COLLAPSE_IMPORTS = this.oldCollapseImports;
    }

    private static final Unit registerNotificationConsumer$lambda$0(RiderSolutionApiFacade this$0, Notification it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.notificationList.add(it);
        Object[] objectArray = new NotificationType[]{NotificationType.ERROR, NotificationType.WARNING};
        if (ArraysKt.contains((Object[])objectArray, (Object)it.getType())) {
            String notificationMessage = it.getTitle() + ": " + it.getContent();
            TestFrameworkBaseKt.getFrameworkLogger().warn(notificationMessage);
        }
        String string = it.getTitle();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTitle(...)");
        if (StringsKt.startsWith$default((String)string, (String)"Unable to locate .NET Core SDK", (boolean)false, (int)2, null)) {
            TestFrameworkBaseKt.getFrameworkLogger().error(it.getTitle() + ": " + it.getContent());
        }
        String string2 = it.getTitle();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTitle(...)");
        if (StringsKt.startsWith$default((String)string2, (String)"Rider was unable to connect to MSBuild", (boolean)false, (int)2, null)) {
            TestFrameworkBaseKt.getFrameworkLogger().error(it.getTitle() + ". Try to delete and download again the MsBuild and .NET SDK from " + TestToolsDownloadHelperKt.getPersistentCacheFolder());
        }
        return Unit.INSTANCE;
    }
}

