/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.scriptingApi;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import com.jetbrains.rdclient.util.idea.ExtensionsKt;
import com.jetbrains.rider.test.scriptingApi.IRiderDebugCustomDebugSessionProvider;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\bH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/test/scriptingApi/RiderDockerDebugSessionProvider;", "Lcom/jetbrains/rider/test/scriptingApi/IRiderDebugCustomDebugSessionProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "debugSession", "Lkotlinx/coroutines/CompletableDeferred;", "Lcom/intellij/xdebugger/XDebugSession;", "getDebugSession", "intellij.rider.test.framework"})
public final class RiderDockerDebugSessionProvider
implements IRiderDebugCustomDebugSessionProvider {
    @NotNull
    private final CompletableDeferred<XDebugSession> debugSession;

    public RiderDockerDebugSessionProvider(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.debugSession = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        MessageBusConnection messageBusConnection = project2.getMessageBus().connect((Disposable)project2);
        Topic topic = XDebuggerManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new XDebuggerManagerListener(){

            public void processStarted(XDebugProcess debugProcess) {
                Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
                if (!debugSession.isCompleted()) {
                    CompletableDeferred completableDeferred = debugSession;
                    XDebugSession xDebugSession = debugProcess.getSession();
                    Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"getSession(...)");
                    completableDeferred.complete((Object)xDebugSession);
                }
            }
        });
    }

    @Override
    @NotNull
    public XDebugSession getDebugSession() {
        long l = DurationKt.toDuration((int)3, (DurationUnit)DurationUnit.MINUTES);
        int n = kotlin.time.Duration.getNanosecondsComponent-impl((long)l);
        long l2 = kotlin.time.Duration.getInWholeSeconds-impl((long)l);
        Duration duration = Duration.ofSeconds(l2, n);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"toComponents-impl(...)");
        ExtensionsKt.pumpMessages((Duration)duration, () -> RiderDockerDebugSessionProvider.getDebugSession$lambda$0(this));
        if (!this.debugSession.isCompleted()) {
            throw new IllegalStateException("Can't get debug session within specified timeout");
        }
        return (XDebugSession)this.debugSession.getCompleted();
    }

    private static final boolean getDebugSession$lambda$0(RiderDockerDebugSessionProvider this$0) {
        return this$0.debugSession.isCompleted();
    }
}

