/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.scriptingApi;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.rider.test.framework.TestFrameworkBaseKt;
import com.jetbrains.rider.test.scriptingApi.RunningProcessInfo;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_Process_BaseKt;
import com.jetbrains.rider.util.concurrent.SyncEvent;
import java.io.File;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.test.AssertionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a-\u0010\u0000\u001a\u0002H\u0001\"\b\b\u0000\u0010\u0001*\u00020\u0002*\u0002H\u00012\u0006\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007\u001a-\u0010\b\u001a\u0002H\u0001\"\b\b\u0000\u0010\u0001*\u00020\u0002*\u0002H\u00012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\f\u001a!\u0010\b\u001a\u0002H\u0001\"\b\b\u0000\u0010\u0001*\u00020\u0002*\u0002H\u00012\u0006\u0010\r\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000e\u001a\u0012\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0006\u0010\u0014\u001a\u00020\u0013\u00a8\u0006\u0015"}, d2={"waitForOutput", "TProcess", "Lcom/intellij/execution/process/ProcessHandler;", "timeout", "Ljava/time/Duration;", "specifiedOutput", "", "(Lcom/intellij/execution/process/ProcessHandler;Ljava/time/Duration;Ljava/lang/String;)Lcom/intellij/execution/process/ProcessHandler;", "redirectOutputTo", "fileFactory", "Lkotlin/Function1;", "Ljava/io/File;", "(Lcom/intellij/execution/process/ProcessHandler;Lkotlin/jvm/functions/Function1;)Lcom/intellij/execution/process/ProcessHandler;", "file", "(Lcom/intellij/execution/process/ProcessHandler;Ljava/io/File;)Lcom/intellij/execution/process/ProcessHandler;", "destroyProcess", "", "Ljava/lang/Process;", "killHangingUnityProcesses", "", "killHangingUnrealProcesses", "intellij.rider.test.framework"})
@SourceDebugExtension(value={"SMAP\nScriptingAPI.Process.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptingAPI.Process.kt\ncom/jetbrains/rider/test/scriptingApi/ScriptingAPI_ProcessKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n1761#2,3:87\n1761#2,3:90\n*S KotlinDebug\n*F\n+ 1 ScriptingAPI.Process.kt\ncom/jetbrains/rider/test/scriptingApi/ScriptingAPI_ProcessKt\n*L\n65#1:87,3\n83#1:90,3\n*E\n"})
public final class ScriptingAPI_ProcessKt {
    @NotNull
    public static final <TProcess extends ProcessHandler> TProcess waitForOutput(@NotNull TProcess $this$waitForOutput, @NotNull Duration timeout, @Nullable String specifiedOutput) {
        Intrinsics.checkNotNullParameter($this$waitForOutput, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        SyncEvent waitForOutput2 = new SyncEvent();
        $this$waitForOutput.addProcessListener((ProcessListener)new ProcessAdapter(specifiedOutput, waitForOutput2){
            final /* synthetic */ String $specifiedOutput;
            final /* synthetic */ SyncEvent $waitForOutput;
            {
                this.$specifiedOutput = $specifiedOutput;
                this.$waitForOutput = $waitForOutput;
            }

            public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                block3: {
                    block2: {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                        if (this.$specifiedOutput == null) break block2;
                        String string = event.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)this.$specifiedOutput, (boolean)false, (int)2, null)) break block3;
                    }
                    this.$waitForOutput.set();
                }
            }

            public void processTerminated(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                TestFrameworkBaseKt.getFrameworkLogger().info("Process terminated with exit code " + event.getExitCode());
            }
        });
        if (!waitForOutput2.wait(timeout)) {
            AssertionsKt.fail((String)("Process hadn't written any output within " + timeout.toMillis() + "ms. This may mean that it wasn't started correctly or it doesn't write to console"));
            throw new KotlinNothingValueException();
        }
        return $this$waitForOutput;
    }

    public static /* synthetic */ ProcessHandler waitForOutput$default(ProcessHandler processHandler, Duration duration, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return ScriptingAPI_ProcessKt.waitForOutput(processHandler, duration, string);
    }

    @NotNull
    public static final <TProcess extends ProcessHandler> TProcess redirectOutputTo(@NotNull TProcess $this$redirectOutputTo, @NotNull Function1<? super TProcess, ? extends File> fileFactory) {
        Intrinsics.checkNotNullParameter($this$redirectOutputTo, (String)"<this>");
        Intrinsics.checkNotNullParameter(fileFactory, (String)"fileFactory");
        File file = (File)fileFactory.invoke($this$redirectOutputTo);
        return ScriptingAPI_ProcessKt.redirectOutputTo($this$redirectOutputTo, file);
    }

    @NotNull
    public static final <TProcess extends ProcessHandler> TProcess redirectOutputTo(@NotNull TProcess $this$redirectOutputTo, @NotNull File file) {
        Intrinsics.checkNotNullParameter($this$redirectOutputTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.isFile()) {
            file.createNewFile();
        }
        $this$redirectOutputTo.addProcessListener((ProcessListener)new ProcessAdapter(file){
            final /* synthetic */ File $file;
            {
                this.$file = $file;
            }

            public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                String string = event.getText();
                if (string == null) {
                    string = "";
                }
                FilesKt.appendText$default((File)this.$file, (String)string, null, (int)2, null);
            }
        });
        return $this$redirectOutputTo;
    }

    public static final boolean destroyProcess(@NotNull Process $this$destroyProcess, @NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)$this$destroyProcess, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        return $this$destroyProcess.destroyForcibly().waitFor(timeout.toMillis(), TimeUnit.MILLISECONDS);
    }

    public static final void killHangingUnityProcesses() {
        Object[] objectArray = new String[]{SystemInfo.isUnix ? "Unity/Hub/Editor" : "Unity\\Hub\\Editor", "SimpleUnityGame"};
        List unityCmdStrings = CollectionsKt.listOf((Object[])objectArray);
        ScriptingAPI_Process_BaseKt.killSuspiciousProcesses((String)"to cleanup hanging Unity processes", arg_0 -> ScriptingAPI_ProcessKt.killHangingUnityProcesses$lambda$0(unityCmdStrings, arg_0));
    }

    public static final void killHangingUnrealProcesses() {
        Object[] objectArray = new String[]{"EpicGamesLauncher", "EpicWebHelper", "UE4Editor", "CrashReportClient", "CrashReportClientEditor", "UnrealEditor", "UnrealTraceServer"};
        List unrealCmdStrings = CollectionsKt.listOf((Object[])objectArray);
        ScriptingAPI_Process_BaseKt.killSuspiciousProcesses((String)"to cleanup hanging Unreal processes", arg_0 -> ScriptingAPI_ProcessKt.killHangingUnrealProcesses$lambda$0(unrealCmdStrings, arg_0));
    }

    private static final boolean killHangingUnityProcesses$lambda$0(List $unityCmdStrings, RunningProcessInfo processInfo) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)processInfo, (String)"processInfo");
            Iterable $this$any$iv = $unityCmdStrings;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!((StringsKt.contains$default((CharSequence)processInfo.getCommandLine(), (CharSequence)it, (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)processInfo.getFullCommand(), (CharSequence)it, (boolean)false, (int)2, null)) && !StringsKt.contains$default((CharSequence)processInfo.getCommandLine(), (CharSequence)"Licensing", (boolean)false, (int)2, null))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean killHangingUnrealProcesses$lambda$0(List $unrealCmdStrings, RunningProcessInfo processInfo) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)processInfo, (String)"processInfo");
            Iterable $this$any$iv = $unrealCmdStrings;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!(StringsKt.contains$default((CharSequence)processInfo.getCommandLine(), (CharSequence)it, (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)processInfo.getFullCommand(), (CharSequence)it, (boolean)false, (int)2, null))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

