/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.scriptingApi;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.terminal.TerminalExecutionConsole;
import com.jetbrains.rdclient.util.idea.ExtensionsKt;
import com.jetbrains.rider.run.settings.DotNetConsoleSettings;
import com.jetbrains.rider.test.asserts.ShouldAssertsKt;
import com.jetbrains.rider.test.framework.TestFrameworkBaseKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPIKt;
import com.jetbrains.rider.test.scriptingApi.TerminalExecutionConsoleTestWrapper;
import com.jetbrains.rider.test.scriptingApi.TestConsoleWrapper;
import java.nio.charset.Charset;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001c\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r\u00a8\u0006\u000e"}, d2={"startAndGetConsole", "Lkotlin/Pair;", "Lcom/intellij/execution/process/ProcessHandler;", "Lcom/jetbrains/rider/test/scriptingApi/TestConsoleWrapper;", "settings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "timeout", "Ljava/time/Duration;", "withRunConsoleCharset", "", "charset", "Ljava/nio/charset/Charset;", "action", "Lkotlin/Function0;", "intellij.rider.test.framework"})
public final class ScriptingAPI_RunConsoleKt {
    @NotNull
    public static final Pair<ProcessHandler, TestConsoleWrapper> startAndGetConsole(@NotNull RunnerAndConfigurationSettings settings, @NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Ref.ObjectRef console = new Ref.ObjectRef();
        Project project2 = settings.getConfiguration().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        ProcessHandler process = ScriptingAPIKt.startRunConfigurationProcess$default(project2, settings, timeout, null, arg_0 -> ScriptingAPI_RunConsoleKt.startAndGetConsole$lambda$0(console, arg_0), 8, null);
        ExtensionsKt.waitAndPump$default((Duration)timeout, () -> ScriptingAPI_RunConsoleKt.startAndGetConsole$lambda$1(console), null, (int)4, null);
        Object object = console.element;
        Intrinsics.checkNotNull((Object)object);
        ShouldAssertsKt.shouldNotBeNull$default((Object)((ExecutionConsole)object).getComponent(), null, (int)1, null);
        ExecutionConsole finalConsole = (ExecutionConsole)console.element;
        if (!(finalConsole instanceof TerminalExecutionConsole)) {
            throw new Exception("Console " + finalConsole + " is not supported by TestConsoleWrapper, yet.");
        }
        TerminalExecutionConsoleTestWrapper wrapper = new TerminalExecutionConsoleTestWrapper((TerminalExecutionConsole)finalConsole);
        return new Pair((Object)process, (Object)wrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void withRunConsoleCharset(@NotNull Charset charset, @NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Charset oldCharset = DotNetConsoleSettings.Companion.getInstance().getCharset();
        TestFrameworkBaseKt.getFrameworkLogger().info("Resetting DotNetConsoleSettings.instance.charset to " + charset + ".");
        try {
            DotNetConsoleSettings.Companion.getInstance().setCharset(charset);
            action.invoke();
        }
        finally {
            TestFrameworkBaseKt.getFrameworkLogger().info("Rolling DotNetConsoleSettings.instance.charset back to " + oldCharset + ".");
            DotNetConsoleSettings.Companion.getInstance().setCharset(oldCharset);
        }
    }

    private static final void startAndGetConsole$lambda$0(Ref.ObjectRef $console, RunContentDescriptor descriptor) {
        $console.element = descriptor.getExecutionConsole();
    }

    private static final boolean startAndGetConsole$lambda$1(Ref.ObjectRef $console) {
        return $console.element != null;
    }
}

