/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.scriptingApi;

import com.intellij.openapi.project.Project;
import com.intellij.testFramework.PlatformTestUtil;
import com.jetbrains.rider.model.RdUnitTestPlatformMonoPreference;
import com.jetbrains.rider.test.TestDirectories;
import com.jetbrains.rider.test.facades.build.BuildApiFacade;
import com.jetbrains.rider.test.facades.settings.BackendSettingsApiFacade;
import com.jetbrains.rider.test.facades.settings.RiderBackendSettingsApiFacade;
import com.jetbrains.rider.test.facades.solution.SolutionApiFacade;
import com.jetbrains.rider.test.framework.TestFrameworkBaseKt;
import com.jetbrains.rider.test.scriptingApi.RiderUnitTestScriptingFacade;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPIKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_BuildKt;
import com.jetbrains.rider.unitTesting.trees.RiderUnitTestTreeSessionDescriptor;
import java.io.File;
import java.time.Duration;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u001a6\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\f\u001aJ\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\f2\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0012\u001a\u00020\u00052\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u001a0\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\u0016\b\u0002\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0017\u001a8\u0010\u0019\u001a\u00020\u0007*\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\f2\b\b\u0002\u0010\u001a\u001a\u00020\u0005\u001a6\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0012\u001a\u00020\u00052\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u0017\u001a\u000e\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0014\u001a\u000e\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0018\u001a(\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\f2\b\b\u0002\u0010%\u001a\u00020\n\u001a\u0016\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\f\u001a\u001e\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\n\u001a\u000e\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020.\u001a\u0018\u0010/\u001a\u00020\n2\u0006\u0010-\u001a\u00020.2\b\b\u0002\u00100\u001a\u00020\u0005\u00a8\u00061"}, d2={"createUtFacade", "Lcom/jetbrains/rider/test/scriptingApi/RiderUnitTestScriptingFacade;", "project", "Lcom/intellij/openapi/project/Project;", "detailedLog", "", "runAllUnitTestsFromProject", "", "Lcom/jetbrains/rider/test/facades/solution/SolutionApiFacade;", "projectName", "", "discoveringElements", "", "sessionElements", "timeout", "Ljava/time/Duration;", "expectedSuccessful", "runAllUnitTestsFromSolutionAutomaticBuild", "runnerLog", "utTreeGoldFile", "Ljava/io/File;", "runAllUnitTestsFromSolutionAutomaticBuildHeavy", "check", "Lkotlin/Function1;", "Lcom/jetbrains/rider/unitTesting/trees/RiderUnitTestTreeSessionDescriptor;", "runAllUnitTestsInSolution", "runUnderDebug", "withUtFacade", "actions", "enableMSTestSupport", "msTestExecutionEngineDirectory", "preferMono", "session", "generateListTests", "codeName", "startIndex", "count", "body", "generateTreeTests", "root", "generateFile", "projectRoot", "path", "content", "expandTree", "tree", "Ljavax/swing/JTree;", "dumpTreeToString", "withSelection", "intellij.rider.test.framework"})
public final class ScriptingAPI_UnitTestingKt {
    @NotNull
    public static final RiderUnitTestScriptingFacade createUtFacade(@NotNull Project project2, boolean detailedLog) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return new RiderUnitTestScriptingFacade(project2, detailedLog);
    }

    public static /* synthetic */ RiderUnitTestScriptingFacade createUtFacade$default(Project project2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return ScriptingAPI_UnitTestingKt.createUtFacade(project2, bl);
    }

    public static final void runAllUnitTestsFromProject(@NotNull SolutionApiFacade $this$runAllUnitTestsFromProject, @NotNull String projectName, int discoveringElements, int sessionElements, @NotNull Duration timeout, int expectedSuccessful) {
        Intrinsics.checkNotNullParameter((Object)$this$runAllUnitTestsFromProject, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        ScriptingAPI_BuildKt.withBuildApiFacade($this$runAllUnitTestsFromProject, (Function1<? super BuildApiFacade, Unit>)((Function1)ScriptingAPI_UnitTestingKt::runAllUnitTestsFromProject$lambda$0));
        ScriptingAPI_BuildKt.checkThatBuildArtifactsExist($this$runAllUnitTestsFromProject.getProject());
        ScriptingAPI_UnitTestingKt.withUtFacade$default($this$runAllUnitTestsFromProject.getProject(), false, false, arg_0 -> ScriptingAPI_UnitTestingKt.runAllUnitTestsFromProject$lambda$1(projectName, sessionElements, timeout, expectedSuccessful, arg_0), 6, null);
    }

    public static /* synthetic */ void runAllUnitTestsFromProject$default(SolutionApiFacade solutionApiFacade, String string, int n, int n2, Duration duration, int n3, int n4, Object object) {
        if ((n4 & 8) != 0) {
            duration = RiderUnitTestScriptingFacade.Companion.getDefaultTimeout();
        }
        if ((n4 & 0x10) != 0) {
            n3 = -1;
        }
        ScriptingAPI_UnitTestingKt.runAllUnitTestsFromProject(solutionApiFacade, string, n, n2, duration, n3);
    }

    public static final void runAllUnitTestsFromSolutionAutomaticBuild(@NotNull Project project2, int sessionElements, @NotNull Duration timeout, int expectedSuccessful, boolean detailedLog, boolean runnerLog, @Nullable File utTreeGoldFile) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        ScriptingAPI_UnitTestingKt.withUtFacade(project2, detailedLog, runnerLog, (Function1<? super RiderUnitTestScriptingFacade, Unit>)((Function1)arg_0 -> ScriptingAPI_UnitTestingKt.runAllUnitTestsFromSolutionAutomaticBuild$lambda$0(sessionElements, timeout, expectedSuccessful, utTreeGoldFile, arg_0)));
    }

    public static /* synthetic */ void runAllUnitTestsFromSolutionAutomaticBuild$default(Project project2, int n, Duration duration, int n2, boolean bl, boolean bl2, File file, int n3, Object object) {
        if ((n3 & 4) != 0) {
            duration = RiderUnitTestScriptingFacade.Companion.getDefaultTimeout();
        }
        if ((n3 & 8) != 0) {
            n2 = -1;
        }
        if ((n3 & 0x10) != 0) {
            bl = true;
        }
        if ((n3 & 0x20) != 0) {
            bl2 = true;
        }
        if ((n3 & 0x40) != 0) {
            file = null;
        }
        ScriptingAPI_UnitTestingKt.runAllUnitTestsFromSolutionAutomaticBuild(project2, n, duration, n2, bl, bl2, file);
    }

    public static final void runAllUnitTestsFromSolutionAutomaticBuildHeavy(@NotNull Project project2, @NotNull Duration timeout, @Nullable Function1<? super RiderUnitTestTreeSessionDescriptor, Unit> check) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        ScriptingAPI_UnitTestingKt.withUtFacade(project2, false, false, (Function1<? super RiderUnitTestScriptingFacade, Unit>)((Function1)arg_0 -> ScriptingAPI_UnitTestingKt.runAllUnitTestsFromSolutionAutomaticBuildHeavy$lambda$0(timeout, check, arg_0)));
    }

    public static /* synthetic */ void runAllUnitTestsFromSolutionAutomaticBuildHeavy$default(Project project2, Duration duration, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            duration = RiderUnitTestScriptingFacade.Companion.getDefaultTimeout();
        }
        if ((n & 4) != 0) {
            function1 = null;
        }
        ScriptingAPI_UnitTestingKt.runAllUnitTestsFromSolutionAutomaticBuildHeavy(project2, duration, (Function1<? super RiderUnitTestTreeSessionDescriptor, Unit>)function1);
    }

    public static final void runAllUnitTestsInSolution(@NotNull SolutionApiFacade $this$runAllUnitTestsInSolution, int discoveringElements, int sessionElements, @NotNull Duration timeout, int expectedSuccessful, boolean runUnderDebug) {
        Intrinsics.checkNotNullParameter((Object)$this$runAllUnitTestsInSolution, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        ScriptingAPI_BuildKt.withBuildApiFacade($this$runAllUnitTestsInSolution, (Function1<? super BuildApiFacade, Unit>)((Function1)ScriptingAPI_UnitTestingKt::runAllUnitTestsInSolution$lambda$0));
        ScriptingAPI_BuildKt.checkThatBuildArtifactsExist($this$runAllUnitTestsInSolution.getProject());
        Duration duration = Duration.ofSeconds(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        ScriptingAPIKt.waitInternal(duration);
        ScriptingAPI_UnitTestingKt.withUtFacade$default($this$runAllUnitTestsInSolution.getProject(), false, false, arg_0 -> ScriptingAPI_UnitTestingKt.runAllUnitTestsInSolution$lambda$1(sessionElements, timeout, expectedSuccessful, runUnderDebug, arg_0), 6, null);
    }

    public static /* synthetic */ void runAllUnitTestsInSolution$default(SolutionApiFacade solutionApiFacade, int n, int n2, Duration duration, int n3, boolean bl, int n4, Object object) {
        if ((n4 & 4) != 0) {
            duration = RiderUnitTestScriptingFacade.Companion.getDefaultTimeout();
        }
        if ((n4 & 8) != 0) {
            n3 = -1;
        }
        if ((n4 & 0x10) != 0) {
            bl = false;
        }
        ScriptingAPI_UnitTestingKt.runAllUnitTestsInSolution(solutionApiFacade, n, n2, duration, n3, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void withUtFacade(@NotNull Project project2, boolean detailedLog, boolean runnerLog, @NotNull Function1<? super RiderUnitTestScriptingFacade, Unit> actions) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        RiderUnitTestScriptingFacade ut = ScriptingAPI_UnitTestingKt.createUtFacade(project2, detailedLog);
        if (runnerLog) {
            ut.enableLogging(true);
        }
        try {
            actions.invoke((Object)ut);
            ut.closeAllSessions();
            ut.logAllElements();
        }
        finally {
            ut.enableLogging(false);
            ut.close();
        }
    }

    public static /* synthetic */ void withUtFacade$default(Project project2, boolean bl, boolean bl2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        ScriptingAPI_UnitTestingKt.withUtFacade(project2, bl, bl2, (Function1<? super RiderUnitTestScriptingFacade, Unit>)function1);
    }

    public static final void enableMSTestSupport(@NotNull File msTestExecutionEngineDirectory) {
        Intrinsics.checkNotNullParameter((Object)msTestExecutionEngineDirectory, (String)"msTestExecutionEngineDirectory");
        String[] stringArray = new String[]{"MSTestExecutionEngine"};
        FilesKt.copyRecursively$default((File)TestFrameworkBaseKt.combine((File)msTestExecutionEngineDirectory, (String[])stringArray), (File)new File(TestDirectories.INSTANCE.getJetTestRiderTools(), "MSTestExecutionEngine"), (boolean)true, null, (int)4, null);
        String prefix = new File(TestDirectories.INSTANCE.getJetTestRiderTools(), "MSTestExecutionEngine").getPath();
        BackendSettingsApiFacade backendSettingsApiFacade = (BackendSettingsApiFacade)new RiderBackendSettingsApiFacade();
        Intrinsics.checkNotNull((Object)prefix);
        BackendSettingsApiFacade.setReSharperSetting$default((BackendSettingsApiFacade)backendSettingsApiFacade, (String)"Environment/Hierarchy/RiderUnitTestMsTestOptions/VisualStudioRootFolder", (String)prefix, null, (int)4, null);
    }

    public static final void preferMono(@NotNull RiderUnitTestTreeSessionDescriptor session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        session2.getRdSession().getOptions().getPlatformMonoPreference().set((Object)RdUnitTestPlatformMonoPreference.PreferMono);
    }

    @NotNull
    public static final String generateListTests(@NotNull String codeName, int startIndex, int count, @NotNull String body) {
        Intrinsics.checkNotNullParameter((Object)codeName, (String)"codeName");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        StringBuilder builder = new StringBuilder();
        builder.append("using System;").append('\n');
        builder.append("using Xunit;").append('\n');
        builder.append("").append('\n');
        builder.append("// ReSharper disable once CheckNamespace").append('\n');
        builder.append("namespace UnitTestNamespace" + codeName).append('\n');
        builder.append("{").append('\n');
        builder.append("  public class UnitTestClass" + codeName).append('\n');
        builder.append("  {").append('\n');
        int n = startIndex + count;
        for (int i = startIndex; i < n; ++i) {
            String index = StringsKt.padStart((String)String.valueOf(i), (int)6, (char)'0');
            builder.append("    [Fact] public void Test" + index + "() {{ " + body + " }}").append('\n');
        }
        builder.append("  }").append('\n');
        builder.append("}").append('\n');
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String generateListTests$default(String string, int n, int n2, String string2, int n3, Object object) {
        if ((n3 & 8) != 0) {
            string2 = "";
        }
        return ScriptingAPI_UnitTestingKt.generateListTests(string, n, n2, string2);
    }

    public static final void generateTreeTests(@NotNull File root, int count) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        int finished = 0;
        int indexA = 0;
        while (finished < count) {
            for (int indexB = 0; indexB < 10 && finished < count; ++indexB) {
                int testsCount;
                for (int indexC = 0; indexC < 10 && finished < count; finished += testsCount, ++indexC) {
                    File path = FilesKt.resolve((File)FilesKt.resolve((File)new File("A" + StringsKt.padStart((String)String.valueOf(indexA), (int)3, (char)'0')), (String)("B" + indexB)), (String)("TestClass" + indexC));
                    String codeName = StringsKt.padStart((String)String.valueOf(indexA), (int)3, (char)'0') + indexB + indexC;
                    testsCount = Math.min(count - finished, 10);
                    String content = ScriptingAPI_UnitTestingKt.generateListTests$default(codeName, finished, testsCount, null, 8, null);
                    ScriptingAPI_UnitTestingKt.generateFile(root, path, content);
                }
            }
            ++indexA;
        }
    }

    public static final void generateFile(@NotNull File projectRoot, @NotNull File path, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)projectRoot, (String)"projectRoot");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        File testsRoot = FilesKt.resolve((File)projectRoot, (String)"Tests");
        if (testsRoot.exists()) {
            testsRoot.delete();
        }
        testsRoot.mkdir();
        File file = new File(testsRoot.getPath(), path + ".cs");
        if (file.exists()) {
            file.delete();
        }
        file.getParentFile().mkdirs();
        file.createNewFile();
        FilesKt.writeText$default((File)file, (String)content, null, (int)2, null);
    }

    public static final void expandTree(@NotNull JTree tree) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        PlatformTestUtil.waitWhileBusy((JTree)tree);
        PlatformTestUtil.expandAll((JTree)tree);
        PlatformTestUtil.waitWhileBusy((JTree)tree);
    }

    @NotNull
    public static final String dumpTreeToString(@NotNull JTree tree, boolean withSelection) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        ScriptingAPI_UnitTestingKt.expandTree(tree);
        String string = PlatformTestUtil.print((JTree)tree, (boolean)withSelection);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"print(...)");
        return string;
    }

    public static /* synthetic */ String dumpTreeToString$default(JTree jTree, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return ScriptingAPI_UnitTestingKt.dumpTreeToString(jTree, bl);
    }

    private static final Unit runAllUnitTestsFromProject$lambda$0(BuildApiFacade $this$withBuildApiFacade) {
        Intrinsics.checkNotNullParameter((Object)$this$withBuildApiFacade, (String)"$this$withBuildApiFacade");
        ScriptingAPI_BuildKt.buildSolutionWithReSharperBuild$default($this$withBuildApiFacade, null, null, null, 7, null);
        return Unit.INSTANCE;
    }

    private static final Unit runAllUnitTestsFromProject$lambda$1(String $projectName, int $sessionElements, Duration $timeout, int $expectedSuccessful, RiderUnitTestScriptingFacade ut) {
        Intrinsics.checkNotNullParameter((Object)ut, (String)"ut");
        ut.waitForDiscovering();
        ut.runAllTestsInProject($projectName, $sessionElements, $timeout, $expectedSuccessful);
        return Unit.INSTANCE;
    }

    private static final Unit runAllUnitTestsFromSolutionAutomaticBuild$lambda$0(int $sessionElements, Duration $timeout, int $expectedSuccessful, File $utTreeGoldFile, RiderUnitTestScriptingFacade ut) {
        Intrinsics.checkNotNullParameter((Object)ut, (String)"ut");
        RiderUnitTestScriptingFacade.runAllTestsInSolution$default(ut, $sessionElements, $timeout, $expectedSuccessful, $utTreeGoldFile, null, false, 48, null);
        return Unit.INSTANCE;
    }

    private static final Unit runAllUnitTestsFromSolutionAutomaticBuildHeavy$lambda$0(Duration $timeout, Function1 $check, RiderUnitTestScriptingFacade ut) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)ut, (String)"ut");
            RiderUnitTestTreeSessionDescriptor treeSessionDescriptor = ut.runAllTestsInSolutionHeavy($timeout);
            Function1 function1 = $check;
            if (function1 == null) break block0;
            function1.invoke((Object)treeSessionDescriptor);
        }
        return Unit.INSTANCE;
    }

    private static final Unit runAllUnitTestsInSolution$lambda$0(BuildApiFacade $this$withBuildApiFacade) {
        Intrinsics.checkNotNullParameter((Object)$this$withBuildApiFacade, (String)"$this$withBuildApiFacade");
        ScriptingAPI_BuildKt.buildSolutionWithReSharperBuild$default($this$withBuildApiFacade, null, null, null, 7, null);
        return Unit.INSTANCE;
    }

    private static final Unit runAllUnitTestsInSolution$lambda$1(int $sessionElements, Duration $timeout, int $expectedSuccessful, boolean $runUnderDebug, RiderUnitTestScriptingFacade ut) {
        Intrinsics.checkNotNullParameter((Object)ut, (String)"ut");
        ut.waitForDiscovering();
        RiderUnitTestScriptingFacade.runAllTestsInSolution$default(ut, $sessionElements, $timeout, $expectedSuccessful, null, null, $runUnderDebug, 24, null);
        return Unit.INSTANCE;
    }
}

