/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.base;

import com.intellij.codeInsight.codeVision.settings.CodeVisionSettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.impl.ModuleVcsDetector;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ApplicationKt;
import com.intellij.util.io.Decompressor;
import com.jetbrains.rd.platform.diagnostics.LogTraceScenario;
import com.jetbrains.rdclient.codeVision.FrontendEditorCodeVisionContextKt;
import com.jetbrains.rdclient.util.idea.ExtensionsKt;
import com.jetbrains.rider.diagnostics.LogTraceScenarios;
import com.jetbrains.rider.test.OpenSolutionParams;
import com.jetbrains.rider.test.annotations.Solution;
import com.jetbrains.rider.test.base.PerTestSolutionTestBase;
import com.jetbrains.rider.test.framework.GoldFilesHelperKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_CodeLensKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_EditorKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_Editor_BaseKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_SolutionAnalysisKt;
import java.io.File;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;

@Solution(name="CodeLensTestSolution")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b'\u0018\u0000 -2\u00020\u0001:\u0001-B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\r\u001a\u00020\u0005H\u0007J\b\u0010\u000e\u001a\u00020\u0005H\u0007J\b\u0010\u000f\u001a\u00020\u0005H\u0007J\b\u0010\u0010\u001a\u00020\u0005H\u0007J\u0016\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J'\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0017\u0010\u0017\u001a\u0013\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00050\u0018\u00a2\u0006\u0002\b\u001aJ\u0014\u0010\u001b\u001a\u00020\u00052\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u001cJ\u0016\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013JB\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020 0\u001f*\u00020\u00192\u0006\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020%2\b\b\u0002\u0010&\u001a\u00020'H\u0004J(\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\u0013H\u0004R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006."}, d2={"Lcom/jetbrains/rider/test/base/CodeLensTestBase;", "Lcom/jetbrains/rider/test/base/PerTestSolutionTestBase;", "<init>", "()V", "modifyOpenSolutionParams", "", "params", "Lcom/jetbrains/rider/test/OpenSolutionParams;", "traceScenarios", "", "Lcom/jetbrains/rd/platform/diagnostics/LogTraceScenario;", "getTraceScenarios", "()Ljava/util/Set;", "prepareRegistry", "activateVcs", "wipeSettings", "restoreRegistry", "doTest", "file", "", "lensId", "withOpenedEditor", "Lcom/intellij/openapi/editor/Editor;", "action", "Lkotlin/Function1;", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "Lkotlin/ExtensionFunctionType;", "doCustomTest", "Lkotlin/Function0;", "doTestWithTyping", "waitForExpectedLenses", "Lkotlin/Pair;", "", "expectedInlaysText", "beforeInlaysText", "separationMarker", "stream", "Ljava/io/PrintStream;", "lensesUpdateTimeout", "Ljava/time/Duration;", "doTestInvalidation", "path", "enable", "separator", "providerId", "Companion", "intellij.rider.test.framework"})
@SourceDebugExtension(value={"SMAP\nCodeLensTestBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeLensTestBase.kt\ncom/jetbrains/rider/test/base/CodeLensTestBase\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 ComponentContainerUtil.kt\ncom/jetbrains/rider/util/idea/ComponentContainerUtilKt\n*L\n1#1,234:1\n30#2,2:235\n17#3,2:237\n17#3,2:239\n*S KotlinDebug\n*F\n+ 1 CodeLensTestBase.kt\ncom/jetbrains/rider/test/base/CodeLensTestBase\n*L\n73#1:235,2\n89#1:237,2\n96#1:239,2\n*E\n"})
public abstract class CodeLensTestBase
extends PerTestSolutionTestBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String USAGES_PROVIDER = "Usages";
    @NotNull
    public static final String EXTENSION_METHODS_PROVIDER = "Extension methods";
    @NotNull
    public static final String EXPOSING_API_PROVIDER = "Exposing API";
    @NotNull
    public static final String DERIVED_PROVIDER = "Derived symbols";

    @Override
    public void modifyOpenSolutionParams(@NotNull OpenSolutionParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        super.modifyOpenSolutionParams(params);
        params.setPreprocessTempDirectory(CodeLensTestBase::modifyOpenSolutionParams$lambda$0);
        params.setWaitForCaches(true);
    }

    @Override
    @NotNull
    public Set<LogTraceScenario> getTraceScenarios() {
        return SetsKt.setOf((Object)LogTraceScenarios.CodeVision.INSTANCE);
    }

    @BeforeClass
    public final void prepareRegistry() {
    }

    @BeforeMethod
    public final void activateVcs() {
        AbstractVcs vcs;
        String string = this.getProject().getBasePath();
        if (string == null) {
            return;
        }
        String projectBasePath = string;
        ProjectLevelVcsManagerImpl vcsManager = ProjectLevelVcsManagerImpl.Companion.getInstanceImpl(this.getProject());
        if (!(vcsManager.getAllActiveVcssDoNotUse().length == 0)) {
            return;
        }
        Path file = Paths.get(projectBasePath, new String[0]);
        ComponentManager $this$service$iv = (ComponentManager)this.getProject();
        boolean $i$f$service = false;
        Class<ModuleVcsDetector> serviceClass$iv = ModuleVcsDetector.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ModuleVcsDetector moduleVcsDetector = (ModuleVcsDetector)object;
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)propertiesComponent, (String)"getInstance(...)");
        if (!moduleVcsDetector.needInitialDetection(propertiesComponent, (ProjectLevelVcsManager)vcsManager)) {
            return;
        }
        VirtualFile virtualFile2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)((Object)file).toString()));
        if (virtualFile2 != null && (vcs = vcsManager.findVersioningVcs(virtualFile2)) != null && vcs != vcsManager.getVcsFor(virtualFile2)) {
            vcsManager.setAutoDirectoryMappings(CollectionsKt.listOf((Object)new VcsDirectoryMapping(virtualFile2.getPath(), vcs.getName())));
        }
    }

    @BeforeMethod
    @AfterMethod
    public final void wipeSettings() {
        ComponentManager $this$getService$iv = (ComponentManager)ApplicationKt.getApplication();
        boolean $i$f$getService = false;
        Object object = $this$getService$iv.getService(CodeVisionSettings.class);
        if (object == null) {
            throw new IllegalStateException("Service " + CodeVisionSettings.class + " not found in container " + $this$getService$iv);
        }
        CodeVisionSettings settings = (CodeVisionSettings)object;
        settings.loadState(new CodeVisionSettings.State());
    }

    @AfterClass
    public final void restoreRegistry() {
        ComponentManager $this$getService$iv = (ComponentManager)ApplicationKt.getApplication();
        boolean $i$f$getService = false;
        Object object = $this$getService$iv.getService(CodeVisionSettings.class);
        if (object == null) {
            throw new IllegalStateException("Service " + CodeVisionSettings.class + " not found in container " + $this$getService$iv);
        }
        CodeVisionSettings settings = (CodeVisionSettings)object;
        settings.loadState(new CodeVisionSettings.State());
    }

    public final void doTest(@NotNull String file, @NotNull String lensId) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)lensId, (String)"lensId");
        ProjectLevelVcsManager projectVcs = ProjectLevelVcsManager.Companion.getInstance(this.getProject());
        projectVcs.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, (AbstractVcs)ArraysKt.single((Object[])projectVcs.getAllActiveVcss())).setValue(VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY);
        ScriptingAPI_CodeLensKt.waitForLensInfos$default(this.getProject(), 0L, 2, null);
        ScriptingAPI_CodeLensKt.enableSingleLensProvider(this.getProject(), lensId);
        ScriptingAPI_SolutionAnalysisKt.waitForAllAnalysisFinished$default(this.getProject(), null, 2, null);
        Editor editor = this.withOpenedEditor(file, (Function1<? super EditorImpl, Unit>)((Function1)arg_0 -> CodeLensTestBase.doTest$lambda$0(this, arg_0)));
        ScriptingAPI_EditorKt.closeEditor(editor);
    }

    @NotNull
    public final Editor withOpenedEditor(@NotNull String file, @NotNull Function1<? super EditorImpl, Unit> action) {
        EditorImpl editor;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        EditorImpl $this$withOpenedEditor_u24lambda_u240 = editor = ScriptingAPI_EditorKt.openFileInEditorByRelativePath(this.getProject(), file);
        boolean bl = false;
        ScriptingAPI_CodeLensKt.installGlobalDaemonWatcher((Editor)$this$withOpenedEditor_u24lambda_u240);
        action.invoke((Object)$this$withOpenedEditor_u24lambda_u240);
        return (Editor)editor;
    }

    public final void doCustomTest(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        ProjectLevelVcsManager projectVcs = ProjectLevelVcsManager.Companion.getInstance(this.getProject());
        projectVcs.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, (AbstractVcs)ArraysKt.single((Object[])projectVcs.getAllActiveVcss())).setValue(VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY);
        ScriptingAPI_CodeLensKt.waitForLensInfos$default(this.getProject(), 0L, 2, null);
        ScriptingAPI_SolutionAnalysisKt.waitForAllAnalysisFinished$default(this.getProject(), null, 2, null);
        action.invoke();
    }

    public final void doTestWithTyping(@NotNull String file, @NotNull String lensId) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)lensId, (String)"lensId");
        ProjectLevelVcsManager projectVcs = ProjectLevelVcsManager.Companion.getInstance(this.getProject());
        projectVcs.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, (AbstractVcs)ArraysKt.single((Object[])projectVcs.getAllActiveVcss())).setValue(VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY);
        ScriptingAPI_CodeLensKt.waitForLensInfos$default(this.getProject(), 0L, 2, null);
        ScriptingAPI_CodeLensKt.enableSingleLensProvider(this.getProject(), lensId);
        ScriptingAPI_SolutionAnalysisKt.waitForAllAnalysisFinished$default(this.getProject(), null, 2, null);
        Editor editor = this.withOpenedEditor(file, (Function1<? super EditorImpl, Unit>)((Function1)arg_0 -> CodeLensTestBase.doTestWithTyping$lambda$0(this, arg_0)));
        ScriptingAPI_EditorKt.closeEditor(editor);
    }

    @NotNull
    protected final Pair<String, Boolean> waitForExpectedLenses(@NotNull EditorImpl $this$waitForExpectedLenses, @NotNull String expectedInlaysText, @NotNull String beforeInlaysText, @NotNull String separationMarker, @NotNull PrintStream stream, @NotNull Duration lensesUpdateTimeout) {
        Intrinsics.checkNotNullParameter((Object)$this$waitForExpectedLenses, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expectedInlaysText, (String)"expectedInlaysText");
        Intrinsics.checkNotNullParameter((Object)beforeInlaysText, (String)"beforeInlaysText");
        Intrinsics.checkNotNullParameter((Object)separationMarker, (String)"separationMarker");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)lensesUpdateTimeout, (String)"lensesUpdateTimeout");
        ScriptingAPI_CodeLensKt.waitForLenses$default((Editor)$this$waitForExpectedLenses, null, 1, null);
        String expectedBeforeErasingText = !(((CharSequence)separationMarker).length() == 0) ? StringsKt.substringBefore$default((String)expectedInlaysText, (String)separationMarker, null, (int)2, null) : expectedInlaysText;
        StringBuilder currentText = new StringBuilder(expectedInlaysText.length());
        boolean lensesProcessingReachedTimeoutBeforeErasing = ExtensionsKt.pumpMessages((Duration)lensesUpdateTimeout, () -> CodeLensTestBase.waitForExpectedLenses$lambda$0($this$waitForExpectedLenses, currentText, beforeInlaysText, expectedBeforeErasingText));
        boolean shouldContinueProcessing = true;
        if (!lensesProcessingReachedTimeoutBeforeErasing) {
            this.getLogger().warn("Lenses processing reached '" + lensesUpdateTimeout + "' timeout before erasing");
            ScriptingAPI_CodeLensKt.dumpLenses$default((Editor)$this$waitForExpectedLenses, false, false, 3, null);
            stream.print(beforeInlaysText + currentText);
            shouldContinueProcessing = false;
        }
        return new Pair((Object)(beforeInlaysText + currentText + separationMarker), (Object)shouldContinueProcessing);
    }

    public static /* synthetic */ Pair waitForExpectedLenses$default(CodeLensTestBase codeLensTestBase, EditorImpl editorImpl, String string, String string2, String string3, PrintStream printStream, Duration duration, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: waitForExpectedLenses");
        }
        if ((n & 0x10) != 0) {
            Duration duration2 = Duration.ofSeconds(5L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        return codeLensTestBase.waitForExpectedLenses(editorImpl, string, string2, string3, printStream, duration);
    }

    protected final void doTestInvalidation(@NotNull String path, boolean enable, @NotNull String separator, @NotNull String providerId) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
        this.doCustomTest((Function0<Unit>)((Function0)() -> CodeLensTestBase.doTestInvalidation$lambda$0(enable, this, providerId, path, separator)));
    }

    private static final Unit modifyOpenSolutionParams$lambda$0(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Path outputDir = it.toPath();
        new Decompressor.Zip(outputDir.resolve("git.zip")).extract(outputDir);
        return Unit.INSTANCE;
    }

    private static final Unit doTest$lambda$0(CodeLensTestBase this$0, EditorImpl $this$withOpenedEditor) {
        Intrinsics.checkNotNullParameter((Object)$this$withOpenedEditor, (String)"$this$withOpenedEditor");
        ScriptingAPI_CodeLensKt.waitForLenses$default((Editor)$this$withOpenedEditor, null, 1, null);
        GoldFilesHelperKt.executeWithGold((File)this$0.getTestGoldFile(), arg_0 -> CodeLensTestBase.doTest$lambda$0$0(this$0, $this$withOpenedEditor, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit doTest$lambda$0$0(CodeLensTestBase this$0, EditorImpl $this_withOpenedEditor, PrintStream it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String expectedInlaysText = GoldFilesHelperKt.getGoldFileText((File)this$0.getTestGoldFile());
        Pair pair = CodeLensTestBase.waitForExpectedLenses$default(this$0, $this_withOpenedEditor, expectedInlaysText, "", "", it, null, 16, null);
        String currentInlaysText = (String)pair.component1();
        boolean matched = (Boolean)pair.component2();
        if (!matched) {
            return Unit.INSTANCE;
        }
        it.print(currentInlaysText);
        return Unit.INSTANCE;
    }

    private static final Unit doTestWithTyping$lambda$0(CodeLensTestBase this$0, EditorImpl $this$withOpenedEditor) {
        Intrinsics.checkNotNullParameter((Object)$this$withOpenedEditor, (String)"$this$withOpenedEditor");
        ScriptingAPI_CodeLensKt.waitForLenses$default((Editor)$this$withOpenedEditor, null, 1, null);
        GoldFilesHelperKt.executeWithGold((File)this$0.getTestGoldFile(), arg_0 -> CodeLensTestBase.doTestWithTyping$lambda$0$0(this$0, $this$withOpenedEditor, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit doTestWithTyping$lambda$0$0(CodeLensTestBase this$0, EditorImpl $this_withOpenedEditor, PrintStream it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String expectedInlaysText = GoldFilesHelperKt.getGoldFileText((File)this$0.getTestGoldFile());
        EditorImpl $this$doTestWithTyping_u24lambda_u240_u240_u240 = $this_withOpenedEditor;
        boolean bl = false;
        Pair pair = CodeLensTestBase.waitForExpectedLenses$default(this$0, $this$doTestWithTyping_u24lambda_u240_u240_u240, expectedInlaysText, "", "\n\nAfter typing:\n", it, null, 16, null);
        String currentBeforeTypingText = (String)pair.component1();
        boolean matched = (Boolean)pair.component2();
        if (!matched) {
            return Unit.INSTANCE;
        }
        String currentBeforeTypingInlaysText = currentBeforeTypingText;
        EditorImpl $this$doTestWithTyping_u24lambda_u240_u240_u241 = $this_withOpenedEditor;
        boolean bl2 = false;
        ScriptingAPI_EditorKt.typeFromOffset($this$doTestWithTyping_u24lambda_u240_u240_u241, " ", 0);
        currentBeforeTypingText = CodeLensTestBase.waitForExpectedLenses$default(this$0, $this$doTestWithTyping_u24lambda_u240_u240_u241, expectedInlaysText, currentBeforeTypingInlaysText, "\n\nAfter erasing:\n", it, null, 16, null);
        String currentBeforeErasingText = (String)currentBeforeTypingText.component1();
        boolean matched2 = (Boolean)currentBeforeTypingText.component2();
        if (!matched2) {
            return Unit.INSTANCE;
        }
        String currentBeforeErasingInlaysText = currentBeforeErasingText;
        EditorImpl $this$doTestWithTyping_u24lambda_u240_u240_u242 = $this_withOpenedEditor;
        boolean bl3 = false;
        ScriptingAPI_Editor_BaseKt.pressBackspace$default((EditorImpl)$this$doTestWithTyping_u24lambda_u240_u240_u242, (int)0, (int)1, null);
        Pair pair2 = CodeLensTestBase.waitForExpectedLenses$default(this$0, $this$doTestWithTyping_u24lambda_u240_u240_u242, expectedInlaysText, currentBeforeErasingInlaysText, "", it, null, 16, null);
        String currentTextAfterErasingText = (String)pair2.component1();
        boolean matched3 = (Boolean)pair2.component2();
        if (!matched3) {
            return Unit.INSTANCE;
        }
        String currentAfterErasingInlaysText = currentTextAfterErasingText;
        it.print(currentAfterErasingInlaysText);
        return Unit.INSTANCE;
    }

    private static final boolean waitForExpectedLenses$lambda$0(EditorImpl $this_waitForExpectedLenses, StringBuilder $currentText, String $beforeInlaysText, String $expectedBeforeErasingText) {
        FrontendEditorCodeVisionContextKt.getFrontendLensContextOrThrow((Editor)((Editor)$this_waitForExpectedLenses)).resubmitThings();
        StringsKt.clear((StringBuilder)$currentText);
        $currentText.append(ScriptingAPI_CodeLensKt.dumpLenses$default((Editor)$this_waitForExpectedLenses, false, false, 3, null));
        boolean matches = Intrinsics.areEqual((Object)($beforeInlaysText + $currentText), (Object)$expectedBeforeErasingText);
        return matches;
    }

    private static final Unit doTestInvalidation$lambda$0(boolean $enable, CodeLensTestBase this$0, String $providerId, String $path, String $separator) {
        if ($enable) {
            ScriptingAPI_CodeLensKt.disableAllLensProviders(this$0.getProject());
        } else {
            ScriptingAPI_CodeLensKt.enableSingleLensProvider(this$0.getProject(), $providerId);
        }
        Editor editor = this$0.withOpenedEditor($path, (Function1<? super EditorImpl, Unit>)((Function1)arg_0 -> CodeLensTestBase.doTestInvalidation$lambda$0$0(this$0, $separator, $providerId, $enable, arg_0)));
        ScriptingAPI_EditorKt.closeEditor(editor);
        return Unit.INSTANCE;
    }

    private static final Unit doTestInvalidation$lambda$0$0(CodeLensTestBase this$0, String $separator, String $providerId, boolean $enable, EditorImpl $this$withOpenedEditor) {
        Intrinsics.checkNotNullParameter((Object)$this$withOpenedEditor, (String)"$this$withOpenedEditor");
        GoldFilesHelperKt.executeWithGold((File)this$0.getTestGoldFile(), arg_0 -> CodeLensTestBase.doTestInvalidation$lambda$0$0$0(this$0, $this$withOpenedEditor, $separator, $providerId, $enable, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit doTestInvalidation$lambda$0$0$0(CodeLensTestBase this$0, EditorImpl $this_withOpenedEditor, String $separator, String $providerId, boolean $enable, PrintStream printer) {
        Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
        String expectedInlaysText = GoldFilesHelperKt.getGoldFileText((File)this$0.getTestGoldFile());
        EditorImpl $this$doTestInvalidation_u24lambda_u240_u240_u240_u240 = $this_withOpenedEditor;
        boolean bl = false;
        Pair pair = CodeLensTestBase.waitForExpectedLenses$default(this$0, $this$doTestInvalidation_u24lambda_u240_u240_u240_u240, expectedInlaysText, "", $separator, printer, null, 16, null);
        String result2 = (String)pair.component1();
        boolean success = (Boolean)pair.component2();
        if (!success) {
            return Unit.INSTANCE;
        }
        String currentBeforeSettingChangeInlaysText = result2;
        ScriptingAPI_CodeLensKt.changeCodeLensSettings((Function1<? super CodeVisionSettings, Unit>)((Function1)arg_0 -> CodeLensTestBase.doTestInvalidation$lambda$0$0$0$1($providerId, $enable, arg_0)));
        EditorImpl $this$doTestInvalidation_u24lambda_u240_u240_u240_u242 = $this_withOpenedEditor;
        boolean bl2 = false;
        Pair pair2 = CodeLensTestBase.waitForExpectedLenses$default(this$0, $this$doTestInvalidation_u24lambda_u240_u240_u240_u242, expectedInlaysText, currentBeforeSettingChangeInlaysText, "", printer, null, 16, null);
        String result3 = (String)pair2.component1();
        boolean success2 = (Boolean)pair2.component2();
        if (!success2) {
            return Unit.INSTANCE;
        }
        String currentAfterSettingChangeInlaysText = result3;
        printer.print(currentAfterSettingChangeInlaysText);
        return Unit.INSTANCE;
    }

    private static final Unit doTestInvalidation$lambda$0$0$0$1(String $providerId, boolean $enable, CodeVisionSettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setProviderEnabled($providerId, $enable);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/test/base/CodeLensTestBase$Companion;", "", "<init>", "()V", "USAGES_PROVIDER", "", "EXTENSION_METHODS_PROVIDER", "EXPOSING_API_PROVIDER", "DERIVED_PROVIDER", "intellij.rider.test.framework"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

