/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.base.templates.sdk;

import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.test.annotations.TestEnvironment;
import com.jetbrains.rider.test.base.ProjectTemplateBaseTest;
import com.jetbrains.rider.test.base.templates.sdk.WinFormsProjectTemplateTestBase;
import com.jetbrains.rider.test.enums.PlatformType;
import com.jetbrains.rider.test.framework.GoldFilesHelperKt;
import com.jetbrains.rider.test.scriptingApi.DebugTestExecutionContext;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPIKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_DebugKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_ProjectModelKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_RunCfgKt;
import com.jetbrains.rider.test.scriptingApi.TemplateIdWithVersion;
import java.io.File;
import java.io.PrintStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@TestEnvironment(platform={PlatformType.WINDOWS_ALL})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0007J\b\u0010\u0014\u001a\u00020\u0013H\u0007J\b\u0010\u0015\u001a\u00020\u0013H\u0007J\b\u0010\u0016\u001a\u00020\u0013H\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/test/base/templates/sdk/WinFormsProjectTemplateTestBase;", "Lcom/jetbrains/rider/test/base/ProjectTemplateBaseTest;", "templateId", "Lcom/jetbrains/rider/test/scriptingApi/TemplateIdWithVersion;", "<init>", "(Lcom/jetbrains/rider/test/scriptingApi/TemplateIdWithVersion;)V", "getTemplateId", "()Lcom/jetbrains/rider/test/scriptingApi/TemplateIdWithVersion;", "projectName", "", "getProjectName", "()Ljava/lang/String;", "expectedOutput", "getExpectedOutput", "breakpointLine", "", "getBreakpointLine", "()I", "runConfiguration", "", "runProgram", "debugProgram", "deleteScratches", "intellij.rider.test.framework"})
@SourceDebugExtension(value={"SMAP\nWinFormsProjectTemplateTestBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WinFormsProjectTemplateTestBase.kt\ncom/jetbrains/rider/test/base/templates/sdk/WinFormsProjectTemplateTestBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1#2:58\n*E\n"})
public abstract class WinFormsProjectTemplateTestBase
extends ProjectTemplateBaseTest {
    @NotNull
    private final TemplateIdWithVersion templateId;

    public WinFormsProjectTemplateTestBase(@NotNull TemplateIdWithVersion templateId) {
        Intrinsics.checkNotNullParameter((Object)templateId, (String)"templateId");
        this.templateId = templateId;
    }

    @Override
    @NotNull
    public TemplateIdWithVersion getTemplateId() {
        return this.templateId;
    }

    @Override
    @NotNull
    public String getProjectName() {
        return "WinFormsApp";
    }

    @NotNull
    public abstract String getExpectedOutput();

    public abstract int getBreakpointLine();

    @Test(dependsOnMethods={"createTemplateProject"})
    public final void runConfiguration() {
        ScriptingAPI_RunCfgKt.checkCanExecuteSelectedRunConfiguration(this.getProject());
        GoldFilesHelperKt.executeWithGold((File)this.getConfigGoldFile(), arg_0 -> WinFormsProjectTemplateTestBase.runConfiguration$lambda$0(this, arg_0));
    }

    @Test(dependsOnMethods={"buildSolution", "runConfiguration"})
    public final void runProgram() {
        StringBuilder output2 = ScriptingAPIKt.runProgram$default(this.getProject(), null, false, false, runProgram.output.1.INSTANCE, 14, null);
        String string = output2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        boolean bl = StringsKt.contains$default((CharSequence)StringsKt.replace$default((String)string, (char)'\\', (char)'/', (boolean)false, (int)4, null), (CharSequence)this.getExpectedOutput(), (boolean)false, (int)2, null);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "Wrong program output: " + output2;
            throw new AssertionError((Object)string2);
        }
    }

    @Test(dependsOnMethods={"runProgram"})
    public final void debugProgram() {
        GoldFilesHelperKt.executeWithGold((File)this.getDebugGoldFile(), arg_0 -> WinFormsProjectTemplateTestBase.debugProgram$lambda$0(this, arg_0));
    }

    @AfterMethod(alwaysRun=true)
    public final void deleteScratches() {
        ScriptingAPI_ProjectModelKt.deleteScratchesAndConsoles$default(this.getProject(), null, 2, null);
    }

    private static final Unit runConfiguration$lambda$0(WinFormsProjectTemplateTestBase this$0, PrintStream printStream) {
        Intrinsics.checkNotNullParameter((Object)printStream, (String)"printStream");
        ScriptingAPI_RunCfgKt.doTestDumpRunConfigurationsFromRunManager$default(this$0.getProject(), printStream, true, false, false, null, 56, null);
        return Unit.INSTANCE;
    }

    private static final Unit debugProgram$lambda$0(WinFormsProjectTemplateTestBase this$0, PrintStream it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ScriptingAPI_DebugKt.debugProgram$default(this$0.getProject(), it, arg_0 -> WinFormsProjectTemplateTestBase.debugProgram$lambda$0$0(this$0, arg_0), WinFormsProjectTemplateTestBase::debugProgram$lambda$0$1, null, false, null, null, null, 496, null);
        return Unit.INSTANCE;
    }

    private static final Unit debugProgram$lambda$0$0(WinFormsProjectTemplateTestBase this$0, ExecutionEnvironment $this$debugProgram) {
        Intrinsics.checkNotNullParameter((Object)$this$debugProgram, (String)"$this$debugProgram");
        Project project2 = $this$debugProgram.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        ScriptingAPI_DebugKt.toggleBreakpoint(project2, "Program.cs", this$0.getBreakpointLine());
        return Unit.INSTANCE;
    }

    private static final Unit debugProgram$lambda$0$1(DebugTestExecutionContext $this$debugProgram) {
        Intrinsics.checkNotNullParameter((Object)$this$debugProgram, (String)"$this$debugProgram");
        ScriptingAPI_DebugKt.waitForPause($this$debugProgram);
        ScriptingAPI_DebugKt.dumpFullCurrentData$default($this$debugProgram, 1, null, 2, null);
        ScriptingAPI_DebugKt.resumeSession($this$debugProgram);
        return Unit.INSTANCE;
    }
}

