/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.facades.editor;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rdclient.patches.PatchEngineRegistryKt;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rdclient.util.idea.ExtensionsKt;
import com.jetbrains.rider.completion.FrontendCompletionHost;
import com.jetbrains.rider.completion.PreemptiveCompletionHost;
import com.jetbrains.rider.inTests.TestHost;
import com.jetbrains.rider.model.SyncImpulseArgs;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import com.jetbrains.rider.protocol.ProtocolManager;
import com.jetbrains.rider.test.WaitForTypingSessionKt;
import com.jetbrains.rider.test.asserts.ShouldAssertsKt;
import com.jetbrains.rider.test.caret.CaretPositionsProcessor;
import com.jetbrains.rider.test.facades.editor.EditorApiFacade;
import com.jetbrains.rider.test.facades.editor.EditorFacade;
import com.jetbrains.rider.test.facades.editor.patchEngine.ClassicEditorFacade;
import com.jetbrains.rider.test.facades.solution.SolutionApiFacade;
import com.jetbrains.rider.test.framework.GoldFilesHelperKt;
import com.jetbrains.rider.test.framework.TestFrameworkBaseKt;
import com.jetbrains.rider.test.framework.testData.TestDataStorage;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_BaseKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_CodeLensKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_EditorKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_Editor_BaseKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_Solution_BaseKt;
import com.jetbrains.rider.test.scriptingApi.TextControlDumps;
import java.io.File;
import java.io.PrintStream;
import java.time.Duration;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ1\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00072\u0017\u0010\u0019\u001a\u0013\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\u0002\b\u001cH\u0016J;\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0018\u001a\u00020\u00072\u0017\u0010\u0019\u001a\u0013\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\u0002\b\u001cH\u0016J3\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0017\u0010\u0019\u001a\u0013\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\u0002\b\u001cH\u0016J)\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u00152\u0017\u0010\"\u001a\u0013\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\u0002\b\u001cH\u0016J\u001c\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010(H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006)"}, d2={"Lcom/jetbrains/rider/test/facades/editor/RiderEditorApiFacade;", "Lcom/jetbrains/rider/test/facades/editor/EditorApiFacade;", "solutionApiFacade", "Lcom/jetbrains/rider/test/facades/solution/SolutionApiFacade;", "testDataStorage", "Lcom/jetbrains/rider/test/framework/testData/TestDataStorage;", "checkTextControls", "", "<init>", "(Lcom/jetbrains/rider/test/facades/solution/SolutionApiFacade;Lcom/jetbrains/rider/test/framework/testData/TestDataStorage;Z)V", "getSolutionApiFacade", "()Lcom/jetbrains/rider/test/facades/solution/SolutionApiFacade;", "getTestDataStorage", "()Lcom/jetbrains/rider/test/framework/testData/TestDataStorage;", "getCheckTextControls", "()Z", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "withOpenedEditor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "checkTextControlInternalState", "block", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "sourceFile", "Ljava/io/File;", "dumpOpenedEditor", "withFacade", "editor", "action", "Lcom/jetbrains/rider/test/facades/editor/EditorFacade;", "assertDocumentControls", "document", "Lcom/intellij/openapi/editor/Document;", "forceFileName", "", "intellij.rider.test.framework"})
public class RiderEditorApiFacade
implements EditorApiFacade {
    @NotNull
    private final SolutionApiFacade solutionApiFacade;
    @NotNull
    private final TestDataStorage testDataStorage;
    private final boolean checkTextControls;

    public RiderEditorApiFacade(@NotNull SolutionApiFacade solutionApiFacade, @NotNull TestDataStorage testDataStorage, boolean checkTextControls) {
        Intrinsics.checkNotNullParameter((Object)solutionApiFacade, (String)"solutionApiFacade");
        Intrinsics.checkNotNullParameter((Object)testDataStorage, (String)"testDataStorage");
        this.solutionApiFacade = solutionApiFacade;
        this.testDataStorage = testDataStorage;
        this.checkTextControls = checkTextControls;
    }

    public /* synthetic */ RiderEditorApiFacade(SolutionApiFacade solutionApiFacade, TestDataStorage testDataStorage, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(solutionApiFacade, testDataStorage, bl);
    }

    @NotNull
    public final SolutionApiFacade getSolutionApiFacade() {
        return this.solutionApiFacade;
    }

    @NotNull
    public final TestDataStorage getTestDataStorage() {
        return this.testDataStorage;
    }

    public final boolean getCheckTextControls() {
        return this.checkTextControls;
    }

    private final Project getProject() {
        return this.solutionApiFacade.getProject();
    }

    @NotNull
    public EditorImpl withOpenedEditor(@NotNull VirtualFile file, boolean checkTextControlInternalState, @NotNull Function1<? super EditorImpl, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Project project2 = this.solutionApiFacade.getProject();
        TestFrameworkBaseKt.getFrameworkLogger().info("Open editor with file: '" + file.getPath() + "'");
        ShouldAssertsKt.shouldBeTrue((boolean)file.exists(), (String)("File '" + file.getPath() + "' does not exist"));
        ShouldAssertsKt.shouldBeNull((Object)LookupManager.getInstance((Project)project2).getActiveLookup(), (String)"Active lookup on test setup detected");
        EditorImpl editor = ScriptingAPI_EditorKt.openFileInEditor(project2, file);
        ScriptingAPI_CodeLensKt.installGlobalDaemonWatcher((Editor)editor);
        DocumentEx documentEx = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx document = documentEx;
        document.setStripTrailingSpacesEnabled(false);
        TestHost.Companion.getInstance(ApplicationProtocolKt.getProtocolHost((Project)project2).getSession()).backendWaitForCaches("Waiting for caches before running editor block");
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        DumbService dumbService = DumbService.Companion.getInstance(project2);
        ExtensionsKt.pumpMessages$default(null, () -> RiderEditorApiFacade.withOpenedEditor$lambda$0(dumbService), (int)1, null);
        ScriptingAPI_EditorKt.assertIsConsistent((Document)document, project2);
        block.invoke((Object)editor);
        Editor editor2 = (Editor)editor;
        Duration duration = Duration.ofSeconds(5L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        WaitForTypingSessionKt.waitForTypingSessionTermination((Editor)editor2, (Duration)duration, (String)"before assertIsConsistent call", (boolean)true);
        FrontendCompletionHost.Companion.getInstance(project2).terminateCurrentCompletion((Editor)editor, "End of test");
        VirtualFile file2 = editor.getVirtualFile();
        if (file2 != null) {
            String string = file2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            if (DocumentUtilKt.toIOFile((String)string).exists()) {
                ScriptingAPI_EditorKt.assertIsConsistent((Document)document, project2);
                if (checkTextControlInternalState) {
                    ScriptingAPI_EditorKt.checkTextControlInternalState(editor, project2);
                }
            }
        }
        return editor;
    }

    @NotNull
    public EditorImpl withOpenedEditor(@NotNull VirtualFile file, @Nullable File sourceFile, boolean checkTextControlInternalState, @NotNull Function1<? super EditorImpl, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        CaretPositionsProcessor caretProcessor = new CaretPositionsProcessor();
        if (sourceFile != null) {
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            File ioFile = DocumentUtilKt.toIOFile((String)string);
            Function1 modifier = arg_0 -> RiderEditorApiFacade.withOpenedEditor$lambda$1(sourceFile, this, caretProcessor, arg_0);
            ScriptingAPI_EditorKt.modifyEditorContent(this.getProject(), ioFile, (Function1<? super VirtualFile, Unit>)modifier);
        }
        return this.withOpenedEditor(file, checkTextControlInternalState, (Function1<? super EditorImpl, Unit>)((Function1)arg_0 -> RiderEditorApiFacade.withOpenedEditor$lambda$2(this, caretProcessor, block, arg_0)));
    }

    @NotNull
    public EditorImpl dumpOpenedEditor(@NotNull VirtualFile file, @Nullable File sourceFile, @NotNull Function1<? super EditorImpl, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        EditorImpl editor = this.withOpenedEditor(file, sourceFile, true, block);
        DocumentEx documentEx = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        RiderEditorApiFacade.assertDocumentControls$default(this, (Document)documentEx, null, 2, null);
        return editor;
    }

    public void withFacade(@NotNull EditorImpl editor, @NotNull Function1<? super EditorFacade, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        ClassicEditorFacade classicEditorFacade = new ClassicEditorFacade(this.solutionApiFacade.getProject(), editor, false);
        action.invoke((Object)classicEditorFacade);
    }

    private final void assertDocumentControls(Document document, String forceFileName) {
        File testCaseGoldDirectory = this.testDataStorage.getTestCaseGoldDirectory();
        List customGoldSuffixes = this.testDataStorage.getCustomGoldSuffixes();
        TestFrameworkBaseKt.getFrameworkLogger().info("Start checking document controls for document");
        String string = forceFileName;
        if (string == null) {
            VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(document);
            string = (String)ShouldAssertsKt.shouldNotBeNull((Object)(virtualFile2 != null ? virtualFile2.getNameWithoutExtension() : null), (String)"Opened editor file is not defined");
        }
        String fileName = string;
        File editorGoldFile = FilesKt.resolve((File)testCaseGoldDirectory, (String)fileName);
        GoldFilesHelperKt.executeWithGold((File)editorGoldFile, (List)customGoldSuffixes, arg_0 -> RiderEditorApiFacade.assertDocumentControls$lambda$0(this, arg_0));
        if (this.checkTextControls) {
            TextControlDumps dumps = ScriptingAPI_EditorKt.getTextControlsDumps(this.getProject());
            File ideaGoldFile = FilesKt.resolve((File)testCaseGoldDirectory, (String)(fileName + "_idea"));
            File resharperGoldFile = FilesKt.resolve((File)testCaseGoldDirectory, (String)(fileName + "_resharper"));
            GoldFilesHelperKt.executeWithGold((File)ideaGoldFile, (List)customGoldSuffixes, arg_0 -> RiderEditorApiFacade.assertDocumentControls$lambda$1(dumps, arg_0));
            GoldFilesHelperKt.executeWithGold((File)resharperGoldFile, (List)customGoldSuffixes, arg_0 -> RiderEditorApiFacade.assertDocumentControls$lambda$2(dumps, arg_0));
        }
    }

    static /* synthetic */ void assertDocumentControls$default(RiderEditorApiFacade riderEditorApiFacade, Document document, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: assertDocumentControls");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        riderEditorApiFacade.assertDocumentControls(document, string);
    }

    private static final boolean withOpenedEditor$lambda$0(DumbService $dumbService) {
        return !$dumbService.isDumb();
    }

    private static final Unit withOpenedEditor$lambda$1(File $sourceFile, RiderEditorApiFacade this$0, CaretPositionsProcessor $caretProcessor, VirtualFile vf) {
        Intrinsics.checkNotNullParameter((Object)vf, (String)"vf");
        ShouldAssertsKt.shouldBeTrue((boolean)$sourceFile.exists(), (String)("Source file '" + $sourceFile.getPath() + "' does not exist"));
        String string = FileUtilRt.loadFile((File)$sourceFile, (String)"UTF-8", (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadFile(...)");
        String sourceText = string;
        ScriptingAPI_Solution_BaseKt.waitForDaemonAndCaches$default((Project)this$0.getProject(), null, (int)2, null);
        ApplicationKt.getApplication().runWriteAction(() -> RiderEditorApiFacade.withOpenedEditor$lambda$1$0($caretProcessor, sourceText, vf, this$0));
        return Unit.INSTANCE;
    }

    private static final void withOpenedEditor$lambda$1$0(CaretPositionsProcessor $caretProcessor, String $sourceText, VirtualFile $vf, RiderEditorApiFacade this$0) {
        String string = $vf.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        $caretProcessor.processString($sourceText, DocumentUtilKt.toIOFile((String)string), arg_0 -> RiderEditorApiFacade.withOpenedEditor$lambda$1$0$0(this$0, $vf, arg_0));
    }

    private static final Unit withOpenedEditor$lambda$1$0$0(RiderEditorApiFacade this$0, VirtualFile $vf, String processedString) {
        Intrinsics.checkNotNullParameter((Object)processedString, (String)"processedString");
        LoadTextUtil.write((Project)this$0.getProject(), (VirtualFile)$vf, (Object)$vf, (String)processedString, (long)System.currentTimeMillis());
        if (!ProtocolManager.Companion.isResharperBackendDisabled()) {
            ScriptingAPI_Editor_BaseKt.waitBackendDocumentChange$default((Project)this$0.getProject(), (List)CollectionsKt.listOf((Object)$vf), (boolean)false, (int)4, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit withOpenedEditor$lambda$2(RiderEditorApiFacade this$0, CaretPositionsProcessor $caretProcessor, Function1 $block, EditorImpl $this$withOpenedEditor) {
        Intrinsics.checkNotNullParameter((Object)$this$withOpenedEditor, (String)"$this$withOpenedEditor");
        Project project2 = this$0.getProject();
        PreemptiveCompletionHost.Companion.getInstance(project2).flushSessionQueue();
        VirtualFile virtualFile2 = $this$withOpenedEditor.getVirtualFile();
        Intrinsics.checkNotNull((Object)virtualFile2);
        ScriptingAPI_Editor_BaseKt.waitBackendDocumentChange$default((Project)project2, (List)CollectionsKt.listOf((Object)virtualFile2), (boolean)false, (int)4, null);
        ScriptingAPI_EditorKt.waitForExternalChangeProcessor(project2);
        ScriptingAPI_Solution_BaseKt.waitForDaemonAndCaches$default((Project)project2, null, (int)2, null);
        ScriptingAPI_Editor_BaseKt.setCarets((EditorImpl)$this$withOpenedEditor, (CaretPositionsProcessor)$caretProcessor);
        ScriptingAPI_Editor_BaseKt.setSelection((EditorImpl)$this$withOpenedEditor, (CaretPositionsProcessor)$caretProcessor);
        DumbService.Companion.getInstance(project2).runWhenSmart(() -> RiderEditorApiFacade.withOpenedEditor$lambda$2$0(project2, $block, $this$withOpenedEditor));
        return Unit.INSTANCE;
    }

    private static final void withOpenedEditor$lambda$2$0(Project $project, Function1 $block, EditorImpl $this_withOpenedEditor) {
        TestFrameworkBaseKt.getFrameworkLogger().info("runWhenSmart: before commitAllDocuments");
        PsiDocumentManager.getInstance((Project)$project).commitAllDocuments();
        TestFrameworkBaseKt.getFrameworkLogger().info("runWhenSmart: after commitAllDocuments");
        $block.invoke((Object)$this_withOpenedEditor);
        if (PatchEngineRegistryKt.isPatchEngineEnabled()) {
            WaitForTypingSessionKt.waitForPatchEngine-HG0u8IE$default((String)"withOpenedEditor::awaitSpeculativeRequests", (long)0L, (int)2, null);
        }
        ScriptingAPI_BaseKt.runBlockingWithFlushing-8Mi8wO0((String)"waitBackendSuspending", (long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($project, null){
            int label;
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = TestFrameworkBaseKt.waitBackendSuspending((Project)this.$project, (SyncImpulseArgs)new SyncImpulseArgs(true), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        TestFrameworkBaseKt.getFrameworkLogger().info("runWhenSmart: finish");
    }

    private static final Unit assertDocumentControls$lambda$0(RiderEditorApiFacade this$0, PrintStream printStream) {
        Intrinsics.checkNotNullParameter((Object)printStream, (String)"printStream");
        ScriptingAPI_EditorKt.dumpOpenedDocument$default(printStream, this$0.getProject(), false, 4, null);
        return Unit.INSTANCE;
    }

    private static final Unit assertDocumentControls$lambda$1(TextControlDumps $dumps, PrintStream printStream) {
        Intrinsics.checkNotNullParameter((Object)printStream, (String)"printStream");
        printStream.print($dumps.getIdea());
        return Unit.INSTANCE;
    }

    private static final Unit assertDocumentControls$lambda$2(TextControlDumps $dumps, PrintStream printStream) {
        Intrinsics.checkNotNullParameter((Object)printStream, (String)"printStream");
        printStream.print($dumps.getResharper());
        return Unit.INSTANCE;
    }
}

