/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.scriptingApi;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.RangeMarkersKt;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TestDialog;
import com.intellij.openapi.ui.TestDialogManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.jetbrains.dotCover.RiderDotCoverService;
import com.jetbrains.dotCover.actions.RiderDotCoverCoverageTreeExcludeAllNodesExceptSelectedAction;
import com.jetbrains.dotCover.actions.RiderDotCoverCoverageTreeExcludeNodesAction;
import com.jetbrains.dotCover.actions.frontendDataContext.RiderDotCoverDataConstantProvider;
import com.jetbrains.dotCover.ui.DataSliceTypeExtensionsKt;
import com.jetbrains.dotCover.ui.coverageIndicator.CoverageIndicatorWidget;
import com.jetbrains.dotCover.ui.coverageTree.RiderDotCoverCoverageTreeNode;
import com.jetbrains.dotCover.ui.coverageTree.RiderDotCoverCoverageTreeTable;
import com.jetbrains.dotCover.ui.lineMarkers.RiderDotCoverActiveLineMarkerRenderer;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.framework.IRdDynamic;
import com.jetbrains.rd.framework.InterfacesKt;
import com.jetbrains.rd.ui.bedsl.extensions.BeGetterExtensionsKt;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rdclient.daemon.util.HighlightersUtilKt;
import com.jetbrains.rdclient.patches.PatchEngineRegistryKt;
import com.jetbrains.rdclient.util.idea.ExtensionsKt;
import com.jetbrains.rider.actions.base.RiderAnAction;
import com.jetbrains.rider.model.RdDotCoverCoverageIndicatorStateType;
import com.jetbrains.rider.model.RdDotCoverCoverageTreeSearch;
import com.jetbrains.rider.model.RdDotCoverCoverageTreeViewModel;
import com.jetbrains.rider.model.RdDotCoverDataSliceType;
import com.jetbrains.rider.model.RdDotCoverLineMarkerShape;
import com.jetbrains.rider.model.RdDotCoverSnapshot;
import com.jetbrains.rider.model.RdDotCoverTargetFrameworkFilter;
import com.jetbrains.rider.model.RdDotCoverTargetFrameworkMoniker;
import com.jetbrains.rider.model.RdDotCoverWorkspace;
import com.jetbrains.rider.model.RdUnitTestHost;
import com.jetbrains.rider.test.asserts.ShouldAssertsKt;
import com.jetbrains.rider.test.facades.settings.BackendSettingsApiFacade;
import com.jetbrains.rider.test.facades.settings.RiderBackendSettingsApiFacade;
import com.jetbrains.rider.test.framework.GoldFilesHelperKt;
import com.jetbrains.rider.test.framework.TestFrameworkBaseKt;
import com.jetbrains.rider.test.scriptingApi.ContinuousTestingMode;
import com.jetbrains.rider.test.scriptingApi.CoverageNodePredicate;
import com.jetbrains.rider.test.scriptingApi.CoverageToolWindowActions;
import com.jetbrains.rider.test.scriptingApi.CoverageTreePredicate;
import com.jetbrains.rider.test.scriptingApi.HighlightingType;
import com.jetbrains.rider.test.scriptingApi.NoCoverageNodePredicate;
import com.jetbrains.rider.test.scriptingApi.RiderUnitTestScriptingFacade;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPIKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_Actions_BaseKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_DotCoverKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_Settings_BaseKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_UnitTestingKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingApi_HighlightersKt;
import java.io.File;
import java.io.PrintStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00f0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00a2\u00012\u00020\u0001:\u0004\u00a2\u0001\u00a3\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001bJ\u0010\u0010(\u001a\u00020\u001b2\b\b\u0002\u0010)\u001a\u00020*J\u0010\u0010+\u001a\u00020\u001b2\b\b\u0002\u0010)\u001a\u00020*J\u0006\u0010,\u001a\u00020-J,\u0010.\u001a\u00020\u001b2\u0006\u0010/\u001a\u0002002\b\b\u0002\u00101\u001a\u00020\u001d2\b\b\u0002\u00102\u001a\u00020-2\b\b\u0002\u00103\u001a\u00020&J'\u00104\u001a\u00020\u001b2\u0006\u00105\u001a\u00020-2\u0012\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d07\"\u00020\u001d\u00a2\u0006\u0002\u00108J'\u00109\u001a\u00020\u001b2\u0006\u00105\u001a\u00020-2\u0012\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d07\"\u00020\u001d\u00a2\u0006\u0002\u00108J\u0006\u0010<\u001a\u00020\u001bJ\u000e\u0010=\u001a\u00020\u001b2\u0006\u0010>\u001a\u00020?J\u000e\u0010@\u001a\u00020\u001b2\u0006\u0010>\u001a\u00020?J\u000e\u0010A\u001a\u00020\u001b2\u0006\u0010B\u001a\u00020CJ\u0010\u0010D\u001a\u00020E2\u0006\u0010>\u001a\u00020?H\u0002J2\u0010F\u001a\u00020\u001b\"\n\b\u0000\u0010G\u0018\u0001*\u00020H2\u0006\u00105\u001a\u00020-2\u000e\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d07H\u0082\b\u00a2\u0006\u0002\u00108J\u0006\u0010I\u001a\u00020\u001bJ\u000e\u0010J\u001a\u00020\u001b2\u0006\u0010K\u001a\u00020LJ\u000e\u0010M\u001a\u00020\u001b2\u0006\u0010N\u001a\u00020&J\u000e\u0010O\u001a\u00020\u001b2\u0006\u0010N\u001a\u00020&J \u0010P\u001a\u00020\u001b2\u0006\u0010Q\u001a\u00020R2\u0006\u0010/\u001a\u0002002\b\b\u0002\u00101\u001a\u00020\u001dJ \u0010S\u001a\u00020\u001b2\u0006\u0010Q\u001a\u00020R2\u0006\u0010/\u001a\u0002002\b\b\u0002\u00101\u001a\u00020\u001dJ\u0016\u0010T\u001a\b\u0012\u0004\u0012\u00020V0U2\u0006\u0010Q\u001a\u00020RH\u0002J\u0010\u0010W\u001a\u00020&2\u0006\u0010X\u001a\u00020YH\u0002J\u0010\u0010Z\u001a\u00020&2\u0006\u0010X\u001a\u00020YH\u0002J\u0010\u0010[\u001a\u00020&2\u0006\u0010X\u001a\u00020YH\u0002J\u0010\u0010\\\u001a\u00020&2\u0006\u0010X\u001a\u00020YH\u0002J\u0010\u0010]\u001a\u00020&2\u0006\u0010X\u001a\u00020YH\u0002J\u0010\u0010^\u001a\u00020&2\u0006\u0010X\u001a\u00020YH\u0002J\u0010\u0010_\u001a\u00020&2\u0006\u0010X\u001a\u00020YH\u0002J\u001e\u0010`\u001a\u00020\u001b2\u0006\u0010Q\u001a\u00020R2\u0006\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020bJ.\u0010d\u001a\u00020\u001b2\u0006\u0010Q\u001a\u00020R2\u0006\u0010e\u001a\u00020b2\u0006\u0010f\u001a\u00020b2\u0006\u0010g\u001a\u00020b2\u0006\u0010h\u001a\u00020bJ&\u0010i\u001a\u00020\u001b2\u0006\u0010Q\u001a\u00020R2\u0006\u0010j\u001a\u00020b2\u0006\u0010k\u001a\u00020b2\u0006\u0010l\u001a\u00020bJ\u0016\u0010m\u001a\u00020\u001b2\u0006\u0010Q\u001a\u00020R2\u0006\u0010n\u001a\u00020bJ\u0006\u0010v\u001a\u00020\u001bJ\u0006\u0010w\u001a\u00020\u001bJO\u0010x\u001a\u00020\u001b2\n\b\u0002\u0010y\u001a\u0004\u0018\u00010b2\n\b\u0002\u0010z\u001a\u0004\u0018\u00010{2\n\b\u0002\u0010|\u001a\u0004\u0018\u00010{2\b\b\u0002\u0010)\u001a\u00020*2\n\b\u0002\u0010/\u001a\u0004\u0018\u0001002\b\b\u0002\u00101\u001a\u00020\u001d\u00a2\u0006\u0002\u0010}JX\u0010~\u001a\u00020\u001b2\u0006\u0010\u007f\u001a\u00020\u001d2\n\b\u0002\u0010y\u001a\u0004\u0018\u00010b2\n\b\u0002\u0010z\u001a\u0004\u0018\u00010{2\n\b\u0002\u0010|\u001a\u0004\u0018\u00010{2\b\b\u0002\u0010)\u001a\u00020*2\n\b\u0002\u0010/\u001a\u0004\u0018\u0001002\b\b\u0002\u00101\u001a\u00020\u001d\u00a2\u0006\u0003\u0010\u0080\u0001J/\u0010\u0081\u0001\u001a\u00020\u001b2\u0006\u0010\u007f\u001a\u00020\u001d2\b\b\u0002\u0010)\u001a\u00020*2\n\b\u0002\u0010/\u001a\u0004\u0018\u0001002\b\b\u0002\u00101\u001a\u00020\u001dJ\u0007\u0010\u0082\u0001\u001a\u00020\u001bJ7\u0010\u0083\u0001\u001a\u00020\u001b2\u000e\u0010\u0084\u0001\u001a\t\u0012\u0005\u0012\u00030\u0085\u00010U2\b\b\u0002\u0010)\u001a\u00020*2\n\b\u0002\u0010/\u001a\u0004\u0018\u0001002\b\b\u0002\u00101\u001a\u00020\u001dJ\u001e\u0010\u0086\u0001\u001a\u00020\u001b2\b\u0010\u0087\u0001\u001a\u00030\u0088\u00012\t\b\u0002\u0010\u0089\u0001\u001a\u00020&H\u0002J\u0010\u0010\u008a\u0001\u001a\u00020\u001b2\u0007\u0010\u008b\u0001\u001a\u00020\u001dJ\u0007\u0010\u008c\u0001\u001a\u00020\u001bJ\u0010\u0010\u008d\u0001\u001a\u00020\u001b2\u0007\u0010\u008e\u0001\u001a\u00020\u001dJ\u0010\u0010\u008f\u0001\u001a\u00020\u001b2\u0007\u0010\u0090\u0001\u001a\u00020\u001dJ\u0010\u0010\u0091\u0001\u001a\u00020\u001b2\u0007\u0010\u0092\u0001\u001a\u00020&J\u0010\u0010\u0093\u0001\u001a\u00020\u001b2\u0007\u0010K\u001a\u00030\u0094\u0001J\u0010\u0010\u0095\u0001\u001a\u00020\u001b2\u0007\u0010\u0092\u0001\u001a\u00020&J\u0010\u0010\u0096\u0001\u001a\u00020\u001b2\u0007\u0010\u0092\u0001\u001a\u00020&J3\u0010\u0097\u0001\u001a\u00020\u001b2\u0006\u00102\u001a\u00020-2\u000f\u0010\u0098\u0001\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d072\t\b\u0002\u0010\u0099\u0001\u001a\u00020&H\u0002\u00a2\u0006\u0003\u0010\u009a\u0001J\u0011\u0010\u009b\u0001\u001a\u00020\u001b2\b\u0010\u009c\u0001\u001a\u00030\u009d\u0001J\u0012\u0010\u009e\u0001\u001a\u00020\u001b2\t\b\u0002\u0010\u0092\u0001\u001a\u00020&J\u0007\u0010\u009f\u0001\u001a\u00020\u001bJ\u0007\u0010\u00a0\u0001\u001a\u00020\u001bJ\u0007\u0010\u00a1\u0001\u001a\u00020\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001f\u001a\u0004\u0018\u00010 8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\"R\u0011\u0010%\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010'R\u0011\u0010:\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b;\u0010'R\u0018\u0010o\u001a\u00020p*\u00020Y8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bq\u0010rR\u0018\u0010s\u001a\u00020&*\u00020Y8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bt\u0010u\u00a8\u0006\u00a4\u0001"}, d2={"Lcom/jetbrains/rider/test/scriptingApi/RiderDotCoverScriptingFacade;", "", "project", "Lcom/intellij/openapi/project/Project;", "unitTestScriptingFacade", "Lcom/jetbrains/rider/test/scriptingApi/RiderUnitTestScriptingFacade;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/test/scriptingApi/RiderUnitTestScriptingFacade;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "host", "Lcom/jetbrains/rider/model/RdUnitTestHost;", "getHost", "()Lcom/jetbrains/rider/model/RdUnitTestHost;", "service", "Lcom/jetbrains/dotCover/RiderDotCoverService;", "getService", "()Lcom/jetbrains/dotCover/RiderDotCoverService;", "riderSettingsFacade", "Lcom/jetbrains/rider/test/facades/settings/RiderBackendSettingsApiFacade;", "getRiderSettingsFacade", "()Lcom/jetbrains/rider/test/facades/settings/RiderBackendSettingsApiFacade;", "log", "", "message", "", "close", "myFirstSnapshot", "Lcom/jetbrains/rider/model/RdDotCoverSnapshot;", "getMyFirstSnapshot", "()Lcom/jetbrains/rider/model/RdDotCoverSnapshot;", "firstSnapshot", "getFirstSnapshot", "isSnapshotExist", "", "()Z", "waitForCoverageTree", "timeout", "Ljava/time/Duration;", "waitForNoCoverageTree", "getCoverageTreeFromSnapshot", "Ljavax/swing/JTree;", "compareCoverageTreeWithGold", "goldFile", "Ljava/io/File;", "goldSuffix", "tree", "withSelection", "excludeSelectedNodesFromCoverageTree", "coverageTree", "nodes", "", "(Ljavax/swing/JTree;[Ljava/lang/String;)V", "excludeAllNodesExceptSelectFromCoverageTree", "canResetExcludedNodes", "getCanResetExcludedNodes", "resetExcludedNodes", "selectTargetFrameworkFilter", "targetFramework", "Lcom/jetbrains/rider/test/scriptingApi/RiderDotCoverScriptingFacade$TargetFramework;", "unselectTargetFrameworkFilter", "dumpTargetFrameworksList", "stream", "Ljava/io/PrintStream;", "findDotCoverTargetFrameworkMoniker", "Lcom/jetbrains/rider/model/RdDotCoverTargetFrameworkMoniker;", "executeInCoverageTree", "T", "Lcom/jetbrains/rider/actions/base/RiderAnAction;", "waitDataSliceTypeFeature", "chooseDataSliceType", "type", "Lcom/jetbrains/rider/model/RdDotCoverDataSliceType;", "setFlattenNamespaces", "enable", "setHighlightCode", "compareTextWithDotCoverHighlightersWithGold", "editor", "Lcom/intellij/openapi/editor/Editor;", "compareDotCoverLineHighlightersWithGold", "getDotCoverHighlighters", "", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "isDotCoverHighlighter", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "isDotCoverMarker", "isDotCoverFullLineHighlighter", "isDotCoverSuccessfulTestMarker", "isDotCoverFailedTestMarker", "isDotCoverUncoveredTestMarker", "isDotCoverCoveredTestMarker", "waitForDotCoverHighlighters", "markers", "", "fullLine", "waitForDotCoverHighlightersTestResults", "success", "failed", "covered", "uncovered", "waitForDotCoverMarkersShape", "line", "zigZag", "dots", "waitForDotCoverMarkersFaded", "count", "markerShape", "Lcom/jetbrains/rider/model/RdDotCoverLineMarkerShape;", "getMarkerShape", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;)Lcom/jetbrains/rider/model/RdDotCoverLineMarkerShape;", "faded", "getFaded", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;)Z", "dropSnapshotInCoverageTree", "navigateFromEditor", "waitForTotal", "coveragePercent", "totalStatements", "", "uncoveredStatements", "(Ljava/lang/Integer;Ljava/lang/Long;Ljava/lang/Long;Ljava/time/Duration;Ljava/io/File;Ljava/lang/String;)V", "waitForNodePresented", "nodeName", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Long;Ljava/lang/Long;Ljava/time/Duration;Ljava/io/File;Ljava/lang/String;)V", "waitForNodeDisappeared", "waitForTreeAsyncUpdateFinished", "waitForTreeCondition", "predicates", "Lcom/jetbrains/rider/test/scriptingApi/CoverageTreePredicate;", "executeCoverageToolWindowAction", "coverageToolWindowAction", "Lcom/jetbrains/rider/test/scriptingApi/CoverageToolWindowActions;", "confirmDialog", "searchInCoverageTree", "query", "resetFilters", "addExcludedAssemblyFilter", "excludedAssembly", "addExcludedAttributeFilter", "excludedAttribute", "enableLogging", "enabled", "setHighlightingType", "Lcom/jetbrains/rider/test/scriptingApi/HighlightingType;", "setShapedMarkers", "setConsiderUnitTestResultsInHighlightingColors", "selectCoverageTreeNodesByName", "nodeNames", "expand", "(Ljavax/swing/JTree;[Ljava/lang/String;Z)V", "setContinuousTestingMode", "mode", "Lcom/jetbrains/rider/test/scriptingApi/ContinuousTestingMode;", "toggleContinuousTesting", "enableContinuousTesting", "disableContinuousTesting", "triggerContinuousTesting", "Companion", "TargetFramework", "intellij.rider.test.framework"})
@SourceDebugExtension(value={"SMAP\nScriptingAPI.DotCover.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptingAPI.DotCover.kt\ncom/jetbrains/rider/test/scriptingApi/RiderDotCoverScriptingFacade\n+ 2 ScriptingAPI.UnitTesting.kt\ncom/jetbrains/rider/test/scriptingApi/RiderUnitTestScriptingFacade\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,564:1\n154#1,2:565\n156#1:571\n154#1,2:572\n156#1:578\n135#2,4:567\n135#2,4:574\n135#2,4:583\n1869#3,2:579\n230#3,2:581\n1869#3,2:587\n1869#3,2:592\n1869#3,2:594\n1788#3,4:596\n1788#3,4:600\n1788#3,4:604\n1788#3,4:608\n1788#3,4:612\n1788#3,4:616\n1788#3,4:620\n1788#3,4:624\n1788#3,4:628\n1788#3,4:632\n1869#3,2:636\n1740#3,3:638\n3919#4:589\n4434#4,2:590\n*S KotlinDebug\n*F\n+ 1 ScriptingAPI.DotCover.kt\ncom/jetbrains/rider/test/scriptingApi/RiderDotCoverScriptingFacade\n*L\n105#1:565,2\n105#1:571\n108#1:572,2\n108#1:578\n105#1:567,4\n108#1:574,4\n155#1:583,4\n135#1:579,2\n144#1:581,2\n200#1:587,2\n354#1:592,2\n204#1:594,2\n242#1:596,4\n243#1:600,4\n253#1:604,4\n254#1:608,4\n255#1:612,4\n256#1:616,4\n266#1:620,4\n267#1:624,4\n268#1:628,4\n277#1:632,4\n346#1:636,2\n357#1:638,3\n216#1:589\n216#1:590,2\n*E\n"})
public final class RiderDotCoverScriptingFacade {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final RiderUnitTestScriptingFacade unitTestScriptingFacade;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final RdUnitTestHost host;
    @NotNull
    private final RiderDotCoverService service;
    @NotNull
    private final RiderBackendSettingsApiFacade riderSettingsFacade;
    @NotNull
    private static final Duration defaultTimeout = RiderUnitTestScriptingFacade.Companion.getDefaultTimeout();

    public RiderDotCoverScriptingFacade(@NotNull Project project2, @NotNull RiderUnitTestScriptingFacade unitTestScriptingFacade) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)unitTestScriptingFacade, (String)"unitTestScriptingFacade");
        this.project = project2;
        this.unitTestScriptingFacade = unitTestScriptingFacade;
        this.lifetime = this.unitTestScriptingFacade.getLifetime();
        this.host = this.unitTestScriptingFacade.getHost();
        this.service = RiderDotCoverService.Companion.getInstance(this.project);
        this.riderSettingsFacade = new RiderBackendSettingsApiFacade();
        RiderDotCoverDataConstantProvider.Companion.enterPseudoToolWindowActivatedMode();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final RdUnitTestHost getHost() {
        return this.host;
    }

    @NotNull
    public final RiderDotCoverService getService() {
        return this.service;
    }

    @NotNull
    public final RiderBackendSettingsApiFacade getRiderSettingsFacade() {
        return this.riderSettingsFacade;
    }

    public final void log(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        TestFrameworkBaseKt.getFrameworkLogger().info("@" + message);
    }

    public final void close() {
        RiderDotCoverDataConstantProvider.Companion.exitPseudoToolWindowActivatedMode();
    }

    private final RdDotCoverSnapshot getMyFirstSnapshot() {
        Map.Entry entry = CollectionExKt.firstOrNull((Map)((Map)this.service.getWorkspaces()));
        return entry != null && (entry = (RdDotCoverWorkspace)entry.getValue()) != null && (entry = entry.getSnapshot()) != null ? (RdDotCoverSnapshot)entry.getValue() : null;
    }

    @NotNull
    public final RdDotCoverSnapshot getFirstSnapshot() {
        RdDotCoverSnapshot rdDotCoverSnapshot = this.getMyFirstSnapshot();
        Intrinsics.checkNotNull((Object)rdDotCoverSnapshot);
        return rdDotCoverSnapshot;
    }

    public final boolean isSnapshotExist() {
        return this.getMyFirstSnapshot() != null;
    }

    public final void waitForCoverageTree(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        ExtensionsKt.waitAndPump((Duration)timeout, () -> RiderDotCoverScriptingFacade.waitForCoverageTree$lambda$0(this), () -> RiderDotCoverScriptingFacade.waitForCoverageTree$lambda$1(timeout));
    }

    public static /* synthetic */ void waitForCoverageTree$default(RiderDotCoverScriptingFacade riderDotCoverScriptingFacade, Duration duration, int n, Object object) {
        if ((n & 1) != 0) {
            duration = defaultTimeout;
        }
        riderDotCoverScriptingFacade.waitForCoverageTree(duration);
    }

    public final void waitForNoCoverageTree(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        ExtensionsKt.waitAndPump((Duration)timeout, () -> RiderDotCoverScriptingFacade.waitForNoCoverageTree$lambda$0(this), () -> RiderDotCoverScriptingFacade.waitForNoCoverageTree$lambda$1(timeout));
    }

    public static /* synthetic */ void waitForNoCoverageTree$default(RiderDotCoverScriptingFacade riderDotCoverScriptingFacade, Duration duration, int n, Object object) {
        if ((n & 1) != 0) {
            duration = defaultTimeout;
        }
        riderDotCoverScriptingFacade.waitForNoCoverageTree(duration);
    }

    @NotNull
    public final JTree getCoverageTreeFromSnapshot() {
        this.log("Getting coverage tree from snapshot");
        RdDotCoverSnapshot snapshot = this.getFirstSnapshot();
        RiderDotCoverCoverageTreeTable coverageTreeTable = RiderDotCoverCoverageTreeTable.Companion.create(this.lifetime, snapshot, this.project);
        TreeTableTree treeTableTree = coverageTreeTable.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)treeTableTree, (String)"getTree(...)");
        return (JTree)treeTableTree;
    }

    public final void compareCoverageTreeWithGold(@NotNull File goldFile, @NotNull String goldSuffix, @NotNull JTree tree, boolean withSelection) {
        Intrinsics.checkNotNullParameter((Object)goldFile, (String)"goldFile");
        Intrinsics.checkNotNullParameter((Object)goldSuffix, (String)"goldSuffix");
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        this.log("Comparing coverage tree with gold");
        GoldFilesHelperKt.executeWithGold((File)goldFile, (String)goldSuffix, arg_0 -> RiderDotCoverScriptingFacade.compareCoverageTreeWithGold$lambda$0(tree, withSelection, arg_0));
    }

    public static /* synthetic */ void compareCoverageTreeWithGold$default(RiderDotCoverScriptingFacade riderDotCoverScriptingFacade, File file, String string, JTree jTree, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        if ((n & 4) != 0) {
            jTree = riderDotCoverScriptingFacade.getCoverageTreeFromSnapshot();
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        riderDotCoverScriptingFacade.compareCoverageTreeWithGold(file, string, jTree, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void excludeSelectedNodesFromCoverageTree(@NotNull JTree coverageTree, String ... nodes) {
        void coverageTree$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)coverageTree, (String)"coverageTree");
        Intrinsics.checkNotNullParameter((Object)nodes, (String)"nodes");
        RiderDotCoverScriptingFacade riderDotCoverScriptingFacade = this;
        JTree jTree = coverageTree;
        String[] nodes$iv = nodes;
        boolean $i$f$executeInCoverageTree = false;
        RiderDotCoverScriptingFacade.selectCoverageTreeNodesByName$default((RiderDotCoverScriptingFacade)this_$iv, (JTree)coverageTree$iv, nodes$iv, false, 4, null);
        RiderUnitTestScriptingFacade this_$iv$iv = this_$iv.unitTestScriptingFacade;
        boolean $i$f$execute$intellij_rider_test_framework = false;
        String string = Reflection.getOrCreateKotlinClass(RiderDotCoverCoverageTreeExcludeNodesAction.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        String actionId$iv$iv = string;
        this_$iv$iv.log("Execute action '" + actionId$iv$iv + "'");
        DataContext dataContext2 = DataManager.getInstance().getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        ScriptingAPI_Actions_BaseKt.executeAction((String)actionId$iv$iv, (DataContext)dataContext2, (boolean)PatchEngineRegistryKt.isTypingSessionEnabled());
    }

    /*
     * WARNING - void declaration
     */
    public final void excludeAllNodesExceptSelectFromCoverageTree(@NotNull JTree coverageTree, String ... nodes) {
        void coverageTree$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)coverageTree, (String)"coverageTree");
        Intrinsics.checkNotNullParameter((Object)nodes, (String)"nodes");
        RiderDotCoverScriptingFacade riderDotCoverScriptingFacade = this;
        JTree jTree = coverageTree;
        String[] nodes$iv = nodes;
        boolean $i$f$executeInCoverageTree = false;
        RiderDotCoverScriptingFacade.selectCoverageTreeNodesByName$default((RiderDotCoverScriptingFacade)this_$iv, (JTree)coverageTree$iv, nodes$iv, false, 4, null);
        RiderUnitTestScriptingFacade this_$iv$iv = this_$iv.unitTestScriptingFacade;
        boolean $i$f$execute$intellij_rider_test_framework = false;
        String string = Reflection.getOrCreateKotlinClass(RiderDotCoverCoverageTreeExcludeAllNodesExceptSelectedAction.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        String actionId$iv$iv = string;
        this_$iv$iv.log("Execute action '" + actionId$iv$iv + "'");
        DataContext dataContext2 = DataManager.getInstance().getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        ScriptingAPI_Actions_BaseKt.executeAction((String)actionId$iv$iv, (DataContext)dataContext2, (boolean)PatchEngineRegistryKt.isTypingSessionEnabled());
    }

    public final boolean getCanResetExcludedNodes() {
        return (Boolean)com.jetbrains.rd.util.reactive.InterfacesKt.valueOrDefault((IOptProperty)this.getFirstSnapshot().getManualFilter().getCanResetExcludedNodes(), (Object)false);
    }

    public final void resetExcludedNodes() {
        this.log("Reset excluded nodes");
        ShouldAssertsKt.shouldBeTrue((boolean)this.getCanResetExcludedNodes(), (String)"snapshot.filter.canResetExcludedNodes is true");
        this.getFirstSnapshot().getManualFilter().getResetExcludedNodes().fire((Object)Unit.INSTANCE);
    }

    public final void selectTargetFrameworkFilter(@NotNull TargetFramework targetFramework) {
        Intrinsics.checkNotNullParameter((Object)((Object)targetFramework), (String)"targetFramework");
        this.log("Select '" + targetFramework.getPresentation() + "' in target framework filter");
        this.getFirstSnapshot().getTargetFrameworkFilter().getSelect().fire((Object)this.findDotCoverTargetFrameworkMoniker(targetFramework));
    }

    public final void unselectTargetFrameworkFilter(@NotNull TargetFramework targetFramework) {
        Intrinsics.checkNotNullParameter((Object)((Object)targetFramework), (String)"targetFramework");
        this.log("Unselect '" + targetFramework.getPresentation() + "' in target framework filter");
        this.getFirstSnapshot().getTargetFrameworkFilter().getUnselect().fire((Object)this.findDotCoverTargetFrameworkMoniker(targetFramework));
    }

    public final void dumpTargetFrameworksList(@NotNull PrintStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        RdDotCoverTargetFrameworkFilter targetFrameworkFilter = this.getFirstSnapshot().getTargetFrameworkFilter();
        ((Appendable)stream).append((CharSequence)targetFrameworkFilter.getText().getValueOrNull()).append('\n');
        List selectedFrameworks = BeGetterExtensionsKt.valueOrEmpty((IOptProperty)targetFrameworkFilter.getSelectedTargetFrameworks());
        Iterable $this$forEach$iv = BeGetterExtensionsKt.valueOrEmpty((IOptProperty)targetFrameworkFilter.getAllTargetFrameworks());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RdDotCoverTargetFrameworkMoniker it = (RdDotCoverTargetFrameworkMoniker)element$iv;
            boolean bl = false;
            ((Appendable)stream).append(" " + (selectedFrameworks.contains(it) ? "+" : "-") + " " + it.getPresentation()).append('\n');
        }
        ((Appendable)stream).append(StringsKt.repeat((CharSequence)"=", (int)30)).append('\n');
        ((Appendable)stream).append('\n');
    }

    private final RdDotCoverTargetFrameworkMoniker findDotCoverTargetFrameworkMoniker(TargetFramework targetFramework) {
        Object element$iv2;
        block1: {
            Iterable $this$first$iv = BeGetterExtensionsKt.valueOrEmpty((IOptProperty)this.getFirstSnapshot().getTargetFrameworkFilter().getAllTargetFrameworks());
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                RdDotCoverTargetFrameworkMoniker it = (RdDotCoverTargetFrameworkMoniker)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getPresentation(), (Object)targetFramework.getPresentation())) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (RdDotCoverTargetFrameworkMoniker)element$iv2;
    }

    private final /* synthetic */ <T extends RiderAnAction> void executeInCoverageTree(JTree coverageTree, String[] nodes) {
        boolean $i$f$executeInCoverageTree = false;
        RiderDotCoverScriptingFacade.selectCoverageTreeNodesByName$default(this, coverageTree, nodes, false, 4, null);
        RiderUnitTestScriptingFacade this_$iv = this.unitTestScriptingFacade;
        boolean $i$f$execute$intellij_rider_test_framework = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        String string = Reflection.getOrCreateKotlinClass(RiderAnAction.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        String actionId$iv = string;
        this_$iv.log("Execute action '" + actionId$iv + "'");
        DataContext dataContext2 = DataManager.getInstance().getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        ScriptingAPI_Actions_BaseKt.executeAction((String)actionId$iv, (DataContext)dataContext2, (boolean)PatchEngineRegistryKt.isTypingSessionEnabled());
    }

    public final void waitDataSliceTypeFeature() {
        this.log("Wait data slice type feature for solution coverage browser");
        ExtensionsKt.waitAndPump$default((Duration)defaultTimeout, () -> RiderDotCoverScriptingFacade.waitDataSliceTypeFeature$lambda$0(this), null, (int)4, null);
    }

    public final void chooseDataSliceType(@NotNull RdDotCoverDataSliceType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.log("Choose data slice type '" + type + "':'" + DataSliceTypeExtensionsKt.getDisplayName((RdDotCoverDataSliceType)type) + "'");
        this.service.getSolutionCoverageBrowser().getChangeDataSliceType().fire((Object)type);
        ExtensionsKt.waitAndPump$default((Duration)defaultTimeout, () -> RiderDotCoverScriptingFacade.chooseDataSliceType$lambda$0(type, this), null, (int)4, null);
    }

    public final void setFlattenNamespaces(boolean enable) {
        if (Intrinsics.areEqual((Object)this.getFirstSnapshot().getConfiguration().getFlattenNamespaces().getValueOrNull(), (Object)enable)) {
            this.log("Flatten namespace option already " + (enable ? "enabled" : "disabled"));
            return;
        }
        this.log((enable ? "Enable" : "Disable") + " flatten namespaces option in coverage tree");
        this.getFirstSnapshot().getConfiguration().getFlattenNamespaces().set((Object)enable);
    }

    public final void setHighlightCode(boolean enable) {
        if (Intrinsics.areEqual((Object)this.getFirstSnapshot().getConfiguration().getHighlightingEnabled().getValueOrNull(), (Object)enable)) {
            this.log("Highlight code option already " + (enable ? "enabled" : "disabled"));
            return;
        }
        this.log((enable ? "Enable" : "Disable") + " highlight code option in coverage tree");
        this.getFirstSnapshot().getConfiguration().getHighlightingEnabled().set((Object)enable);
    }

    public final void compareTextWithDotCoverHighlightersWithGold(@NotNull Editor editor, @NotNull File goldFile, @NotNull String goldSuffix) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)goldFile, (String)"goldFile");
        Intrinsics.checkNotNullParameter((Object)goldSuffix, (String)"goldSuffix");
        GoldFilesHelperKt.executeWithGold((File)goldFile, (String)goldSuffix, arg_0 -> RiderDotCoverScriptingFacade.compareTextWithDotCoverHighlightersWithGold$lambda$0(editor, this, arg_0));
    }

    public static /* synthetic */ void compareTextWithDotCoverHighlightersWithGold$default(RiderDotCoverScriptingFacade riderDotCoverScriptingFacade, Editor editor, File file, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = "";
        }
        riderDotCoverScriptingFacade.compareTextWithDotCoverHighlightersWithGold(editor, file, string);
    }

    public final void compareDotCoverLineHighlightersWithGold(@NotNull Editor editor, @NotNull File goldFile, @NotNull String goldSuffix) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)goldFile, (String)"goldFile");
        Intrinsics.checkNotNullParameter((Object)goldSuffix, (String)"goldSuffix");
        List<RangeHighlighterEx> dotCoverLineHighlighters = this.getDotCoverHighlighters(editor);
        TreeSet<RangeHighlighterEx> tooltips = new TreeSet<RangeHighlighterEx>((arg_0, arg_1) -> RiderDotCoverScriptingFacade.compareDotCoverLineHighlightersWithGold$lambda$1(RiderDotCoverScriptingFacade::compareDotCoverLineHighlightersWithGold$lambda$0, arg_0, arg_1));
        Iterable $this$forEach$iv = dotCoverLineHighlighters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RangeHighlighterEx it = (RangeHighlighterEx)element$iv;
            boolean bl = false;
            tooltips.add(it);
        }
        GoldFilesHelperKt.executeWithGold((File)goldFile, (String)goldSuffix, arg_0 -> RiderDotCoverScriptingFacade.compareDotCoverLineHighlightersWithGold$lambda$3(tooltips, arg_0));
    }

    public static /* synthetic */ void compareDotCoverLineHighlightersWithGold$default(RiderDotCoverScriptingFacade riderDotCoverScriptingFacade, Editor editor, File file, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = "";
        }
        riderDotCoverScriptingFacade.compareDotCoverLineHighlightersWithGold(editor, file, string);
    }

    /*
     * WARNING - void declaration
     */
    private final List<RangeHighlighterEx> getDotCoverHighlighters(Editor editor) {
        void $this$filterTo$iv$iv;
        RangeHighlighterEx[] $this$filter$iv = ScriptingApi_HighlightersKt.getMarkupAdapter(editor).getAllHighlighters();
        boolean $i$f$filter = false;
        RangeHighlighterEx[] rangeHighlighterExArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            RangeHighlighter p0 = (RangeHighlighter)element$iv$iv;
            boolean bl = false;
            if (!this.isDotCoverHighlighter(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isDotCoverHighlighter(RangeHighlighter highlighter) {
        return StringsKt.startsWith$default((String)HighlightersUtilKt.getBackendAttributeIdOrThrow((RangeHighlighter)highlighter), (String)"dotCover", (boolean)false, (int)2, null);
    }

    private final boolean isDotCoverMarker(RangeHighlighter highlighter) {
        return this.isDotCoverHighlighter(highlighter) && StringsKt.contains$default((CharSequence)HighlightersUtilKt.getBackendAttributeIdOrThrow((RangeHighlighter)highlighter), (CharSequence)"Marker", (boolean)false, (int)2, null);
    }

    private final boolean isDotCoverFullLineHighlighter(RangeHighlighter highlighter) {
        return this.isDotCoverHighlighter(highlighter) && StringsKt.contains$default((CharSequence)HighlightersUtilKt.getBackendAttributeIdOrThrow((RangeHighlighter)highlighter), (CharSequence)"Highlighter", (boolean)false, (int)2, null);
    }

    private final boolean isDotCoverSuccessfulTestMarker(RangeHighlighter highlighter) {
        return this.isDotCoverHighlighter(highlighter) && StringsKt.contains$default((CharSequence)HighlightersUtilKt.getBackendAttributeIdOrThrow((RangeHighlighter)highlighter), (CharSequence)"Successful", (boolean)false, (int)2, null);
    }

    private final boolean isDotCoverFailedTestMarker(RangeHighlighter highlighter) {
        return this.isDotCoverHighlighter(highlighter) && StringsKt.contains$default((CharSequence)HighlightersUtilKt.getBackendAttributeIdOrThrow((RangeHighlighter)highlighter), (CharSequence)"Failed", (boolean)false, (int)2, null);
    }

    private final boolean isDotCoverUncoveredTestMarker(RangeHighlighter highlighter) {
        return this.isDotCoverHighlighter(highlighter) && StringsKt.contains$default((CharSequence)HighlightersUtilKt.getBackendAttributeIdOrThrow((RangeHighlighter)highlighter), (CharSequence)"Uncovered", (boolean)false, (int)2, null);
    }

    private final boolean isDotCoverCoveredTestMarker(RangeHighlighter highlighter) {
        return this.isDotCoverHighlighter(highlighter) && StringsKt.contains$default((CharSequence)HighlightersUtilKt.getBackendAttributeIdOrThrow((RangeHighlighter)highlighter), (CharSequence)"Covered", (boolean)false, (int)2, null);
    }

    public final void waitForDotCoverHighlighters(@NotNull Editor editor, int markers, int fullLine) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        ExtensionsKt.waitAndPump((Duration)defaultTimeout, () -> RiderDotCoverScriptingFacade.waitForDotCoverHighlighters$lambda$0(this, editor, markers, fullLine), () -> RiderDotCoverScriptingFacade.waitForDotCoverHighlighters$lambda$1(markers, fullLine, this, editor));
    }

    public final void waitForDotCoverHighlightersTestResults(@NotNull Editor editor, int success, int failed, int covered, int uncovered) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        ExtensionsKt.waitAndPump((Duration)defaultTimeout, () -> RiderDotCoverScriptingFacade.waitForDotCoverHighlightersTestResults$lambda$0(this, editor, success, failed, covered, uncovered), () -> RiderDotCoverScriptingFacade.waitForDotCoverHighlightersTestResults$lambda$1(success, failed, covered, uncovered, this, editor));
    }

    public final void waitForDotCoverMarkersShape(@NotNull Editor editor, int line, int zigZag, int dots) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        ExtensionsKt.waitAndPump((Duration)defaultTimeout, () -> RiderDotCoverScriptingFacade.waitForDotCoverMarkersShape$lambda$0(this, editor, line, zigZag, dots), () -> RiderDotCoverScriptingFacade.waitForDotCoverMarkersShape$lambda$1(line, zigZag, dots, this, editor));
    }

    public final void waitForDotCoverMarkersFaded(@NotNull Editor editor, int count) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        ExtensionsKt.waitAndPump((Duration)defaultTimeout, () -> RiderDotCoverScriptingFacade.waitForDotCoverMarkersFaded$lambda$0(this, editor, count), () -> RiderDotCoverScriptingFacade.waitForDotCoverMarkersFaded$lambda$1(count, this, editor));
    }

    private final RdDotCoverLineMarkerShape getMarkerShape(RangeHighlighter $this$markerShape) {
        LineMarkerRenderer lineMarkerRenderer = $this$markerShape.getLineMarkerRenderer();
        Intrinsics.checkNotNull((Object)lineMarkerRenderer, (String)"null cannot be cast to non-null type com.jetbrains.dotCover.ui.lineMarkers.RiderDotCoverActiveLineMarkerRenderer");
        return ((RiderDotCoverActiveLineMarkerRenderer)lineMarkerRenderer).getMarkerShape();
    }

    private final boolean getFaded(RangeHighlighter $this$faded) {
        LineMarkerRenderer lineMarkerRenderer = $this$faded.getLineMarkerRenderer();
        Intrinsics.checkNotNull((Object)lineMarkerRenderer, (String)"null cannot be cast to non-null type com.jetbrains.dotCover.ui.lineMarkers.RiderDotCoverActiveLineMarkerRenderer");
        return ((RiderDotCoverActiveLineMarkerRenderer)lineMarkerRenderer).getFaded();
    }

    public final void dropSnapshotInCoverageTree() {
        this.log("Drop coverage tree snapshot");
        this.executeCoverageToolWindowAction(CoverageToolWindowActions.DropSnapshot, true);
        RiderDotCoverScriptingFacade.waitForNoCoverageTree$default(this, null, 1, null);
    }

    public final void navigateFromEditor() {
        this.log("Navigating from editor");
        RiderDotCoverScriptingFacade.executeCoverageToolWindowAction$default(this, CoverageToolWindowActions.NavigateFromEditor, false, 2, null);
    }

    public final void waitForTotal(@Nullable Integer coveragePercent, @Nullable Long totalStatements, @Nullable Long uncoveredStatements, @NotNull Duration timeout, @Nullable File goldFile, @NotNull String goldSuffix) {
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter((Object)goldSuffix, (String)"goldSuffix");
        this.waitForNodePresented("Total", coveragePercent, totalStatements, uncoveredStatements, timeout, goldFile, goldSuffix);
    }

    public static /* synthetic */ void waitForTotal$default(RiderDotCoverScriptingFacade riderDotCoverScriptingFacade, Integer n, Long l, Long l2, Duration duration, File file, String string, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        if ((n2 & 2) != 0) {
            l = null;
        }
        if ((n2 & 4) != 0) {
            l2 = null;
        }
        if ((n2 & 8) != 0) {
            duration = defaultTimeout;
        }
        if ((n2 & 0x10) != 0) {
            file = null;
        }
        if ((n2 & 0x20) != 0) {
            string = "";
        }
        riderDotCoverScriptingFacade.waitForTotal(n, l, l2, duration, file, string);
    }

    public final void waitForNodePresented(@NotNull String nodeName, @Nullable Integer coveragePercent, @Nullable Long totalStatements, @Nullable Long uncoveredStatements, @NotNull Duration timeout, @Nullable File goldFile, @NotNull String goldSuffix) {
        Intrinsics.checkNotNullParameter((Object)nodeName, (String)"nodeName");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter((Object)goldSuffix, (String)"goldSuffix");
        this.waitForTreeCondition(CollectionsKt.listOf((Object)new CoverageNodePredicate(nodeName, coveragePercent, totalStatements, uncoveredStatements)), timeout, goldFile, goldSuffix);
    }

    public static /* synthetic */ void waitForNodePresented$default(RiderDotCoverScriptingFacade riderDotCoverScriptingFacade, String string, Integer n, Long l, Long l2, Duration duration, File file, String string2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        if ((n2 & 4) != 0) {
            l = null;
        }
        if ((n2 & 8) != 0) {
            l2 = null;
        }
        if ((n2 & 0x10) != 0) {
            duration = defaultTimeout;
        }
        if ((n2 & 0x20) != 0) {
            file = null;
        }
        if ((n2 & 0x40) != 0) {
            string2 = "";
        }
        riderDotCoverScriptingFacade.waitForNodePresented(string, n, l, l2, duration, file, string2);
    }

    public final void waitForNodeDisappeared(@NotNull String nodeName, @NotNull Duration timeout, @Nullable File goldFile, @NotNull String goldSuffix) {
        Intrinsics.checkNotNullParameter((Object)nodeName, (String)"nodeName");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter((Object)goldSuffix, (String)"goldSuffix");
        this.waitForTreeCondition(CollectionsKt.listOf((Object)new NoCoverageNodePredicate(nodeName)), timeout, goldFile, goldSuffix);
    }

    public static /* synthetic */ void waitForNodeDisappeared$default(RiderDotCoverScriptingFacade riderDotCoverScriptingFacade, String string, Duration duration, File file, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            duration = defaultTimeout;
        }
        if ((n & 4) != 0) {
            file = null;
        }
        if ((n & 8) != 0) {
            string2 = "";
        }
        riderDotCoverScriptingFacade.waitForNodeDisappeared(string, duration, file, string2);
    }

    public final void waitForTreeAsyncUpdateFinished() {
        RdDotCoverCoverageTreeViewModel coverageTreeModel = this.getFirstSnapshot().getCoverageTree();
        this.log("Start waiting for tree async update finished");
        ExtensionsKt.callSynchronously$default((IRdCall)((IRdCall)coverageTreeModel.getWaitForAsyncUpdateFinished()), (Object)Unit.INSTANCE, (IProtocol)InterfacesKt.getProtocolOrThrow((IRdDynamic)((IRdDynamic)coverageTreeModel)), null, null, null, (int)28, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitForTreeCondition(@NotNull List<? extends CoverageTreePredicate> predicates, @NotNull Duration timeout, @Nullable File goldFile, @NotNull String goldSuffix) {
        Intrinsics.checkNotNullParameter(predicates, (String)"predicates");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter((Object)goldSuffix, (String)"goldSuffix");
        JTree coverageTree = this.getCoverageTreeFromSnapshot();
        Function0 failMessage = () -> RiderDotCoverScriptingFacade.waitForTreeCondition$lambda$0(predicates, coverageTree);
        try {
            this.waitForTreeAsyncUpdateFinished();
            StringBuilder message = new StringBuilder().append("Waiting for following conditions in coverage tree: ").append('\n');
            Iterable $this$forEach$iv = predicates;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CoverageTreePredicate it = (CoverageTreePredicate)element$iv;
                boolean bl = false;
                if (it.getMessage() == null) continue;
                message.append(" " + it.getMessage()).append('\n');
            }
            String string = message.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            this.log(string);
            ExtensionsKt.waitAndPump((Duration)timeout, () -> RiderDotCoverScriptingFacade.waitForTreeCondition$lambda$2(predicates, coverageTree), (Function0)failMessage);
            this.waitForTreeAsyncUpdateFinished();
        }
        catch (Exception e) {
            Object object = failMessage.invoke();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invoke(...)");
            this.log((String)object);
            throw e;
        }
        finally {
            if (goldFile != null) {
                RiderDotCoverScriptingFacade.compareCoverageTreeWithGold$default(this, goldFile, goldSuffix, coverageTree, false, 8, null);
            }
        }
    }

    public static /* synthetic */ void waitForTreeCondition$default(RiderDotCoverScriptingFacade riderDotCoverScriptingFacade, List list, Duration duration, File file, String string, int n, Object object) {
        if ((n & 2) != 0) {
            duration = defaultTimeout;
        }
        if ((n & 4) != 0) {
            file = null;
        }
        if ((n & 8) != 0) {
            string = "";
        }
        riderDotCoverScriptingFacade.waitForTreeCondition(list, duration, file, string);
    }

    private final void executeCoverageToolWindowAction(CoverageToolWindowActions coverageToolWindowAction, boolean confirmDialog) {
        this.log("Execute coverage tool window action: " + Reflection.getOrCreateKotlinClass(((Object)((Object)coverageToolWindowAction)).getClass()).getSimpleName());
        if (confirmDialog) {
            TestDialogManager.setTestDialog((TestDialog)TestDialog.OK);
        }
        String actionId = ScriptingAPI_DotCoverKt.access$getCoverageToolBarActionId(coverageToolWindowAction);
        ScriptingAPIKt.executeAction(actionId);
    }

    static /* synthetic */ void executeCoverageToolWindowAction$default(RiderDotCoverScriptingFacade riderDotCoverScriptingFacade, CoverageToolWindowActions coverageToolWindowActions, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        riderDotCoverScriptingFacade.executeCoverageToolWindowAction(coverageToolWindowActions, bl);
    }

    public final void searchInCoverageTree(@NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        RdDotCoverCoverageTreeSearch treeSearch = this.getFirstSnapshot().getSearch();
        this.log("Search '" + query + "' in coverage tree");
        treeSearch.getSearchQuery().set((Object)query);
        this.log("Waiting for search results");
        ExtensionsKt.waitAndPump((Duration)defaultTimeout, () -> RiderDotCoverScriptingFacade.searchInCoverageTree$lambda$0(treeSearch), RiderDotCoverScriptingFacade::searchInCoverageTree$lambda$1);
        this.log("Search finished");
    }

    public final void resetFilters() {
        this.service.getSettingsHost().getResetFilters().fire((Object)Unit.INSTANCE);
    }

    public final void addExcludedAssemblyFilter(@NotNull String excludedAssembly) {
        Intrinsics.checkNotNullParameter((Object)excludedAssembly, (String)"excludedAssembly");
        this.service.getSettingsHost().getAddExcludedAssemblyFilter().fire((Object)excludedAssembly);
    }

    public final void addExcludedAttributeFilter(@NotNull String excludedAttribute) {
        Intrinsics.checkNotNullParameter((Object)excludedAttribute, (String)"excludedAttribute");
        this.service.getSettingsHost().getAddExcludedAttributeFilter().fire((Object)excludedAttribute);
    }

    public final void enableLogging(boolean enabled) {
        ScriptingAPI_Settings_BaseKt.setReSharperBoolSetting((BackendSettingsApiFacade)((BackendSettingsApiFacade)this.riderSettingsFacade), (String)"dotCover/Diagnostics/EnableWorkspaceHostLogging/@EntryValue", (boolean)enabled, (Project)this.project);
        this.riderSettingsFacade.setReSharperSetting("dotCover/Diagnostics/CoreLogPreferencesString/@EntryValue", enabled ? "Detailed" : "", this.project);
    }

    public final void setHighlightingType(@NotNull HighlightingType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.riderSettingsFacade.setReSharperSetting("dotCover/Editor/HighlightingMode/@EntryValue", type.getSetting(), this.project);
    }

    public final void setShapedMarkers(boolean enabled) {
        ScriptingAPI_Settings_BaseKt.setReSharperBoolSetting((BackendSettingsApiFacade)((BackendSettingsApiFacade)this.riderSettingsFacade), (String)"dotCover/Editor/UseShapedMarkers/@EntryValue", (boolean)enabled, (Project)this.project);
    }

    public final void setConsiderUnitTestResultsInHighlightingColors(boolean enabled) {
        ScriptingAPI_Settings_BaseKt.setReSharperBoolSetting((BackendSettingsApiFacade)((BackendSettingsApiFacade)this.riderSettingsFacade), (String)"dotCover/Editor/ConsiderUnitTestResultsInHighlightingColors/@EntryValue", (boolean)enabled, (Project)this.project);
    }

    private final void selectCoverageTreeNodesByName(JTree tree, String[] nodeNames, boolean expand) {
        this.log("Selecting nodes: " + ArraysKt.joinToString$default((Object[])nodeNames, (CharSequence)", ", (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)56, null) + " in coverage tree");
        Set nodeNamesSet = ArraysKt.toSet((Object[])nodeNames);
        if (expand) {
            ScriptingAPI_UnitTestingKt.expandTree(tree);
        }
        ScriptingAPI_DotCoverKt.walkCoverageTree$default(tree, null, null, (arg_0, arg_1, arg_2) -> RiderDotCoverScriptingFacade.selectCoverageTreeNodesByName$lambda$0(nodeNamesSet, arg_0, arg_1, arg_2), 6, null);
    }

    static /* synthetic */ void selectCoverageTreeNodesByName$default(RiderDotCoverScriptingFacade riderDotCoverScriptingFacade, JTree jTree, String[] stringArray, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        riderDotCoverScriptingFacade.selectCoverageTreeNodesByName(jTree, stringArray, bl);
    }

    public final void setContinuousTestingMode(@NotNull ContinuousTestingMode mode) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.log("Set continuous testing mode '" + mode + "'");
        BackendSettingsApiFacade.setReSharperSetting$default((BackendSettingsApiFacade)((BackendSettingsApiFacade)this.riderSettingsFacade), (String)"dotCover/ContinuousTesting/RunModeString", (String)mode.getValue(), null, (int)4, null);
    }

    public final void toggleContinuousTesting(boolean enabled) {
        this.log("toggleContinuousTesting:");
        this.unitTestScriptingFacade.activateExplorer();
        DataContext dataContext2 = DataManager.getInstance().getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        DataContext parentContext = dataContext2;
        DataContext dataContext3 = SimpleDataContext.builder().setParent(parentContext).add(CoverageIndicatorWidget.Companion.getContinuousTestingEnabled(), (Object)enabled).build();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext3, (String)"build(...)");
        DataContext dataContext4 = dataContext3;
        ScriptingAPI_Actions_BaseKt.executeAction((String)"RiderDotCoverToggleContinuousTesting", (DataContext)dataContext4);
    }

    public static /* synthetic */ void toggleContinuousTesting$default(RiderDotCoverScriptingFacade riderDotCoverScriptingFacade, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        riderDotCoverScriptingFacade.toggleContinuousTesting(bl);
    }

    public final void enableContinuousTesting() {
        RdDotCoverCoverageIndicatorStateType ctState = (RdDotCoverCoverageIndicatorStateType)com.jetbrains.rd.util.reactive.InterfacesKt.valueOrDefault((IOptProperty)this.service.getStatusBarIndicatorHost().getIndicatorState(), (Object)RdDotCoverCoverageIndicatorStateType.Normal);
        if (ctState == RdDotCoverCoverageIndicatorStateType.Normal) {
            RiderDotCoverScriptingFacade.toggleContinuousTesting$default(this, false, 1, null);
        }
    }

    public final void disableContinuousTesting() {
        RdDotCoverCoverageIndicatorStateType ctState = (RdDotCoverCoverageIndicatorStateType)com.jetbrains.rd.util.reactive.InterfacesKt.valueOrDefault((IOptProperty)this.service.getStatusBarIndicatorHost().getIndicatorState(), (Object)RdDotCoverCoverageIndicatorStateType.Normal);
        if (ctState != RdDotCoverCoverageIndicatorStateType.Normal) {
            RiderDotCoverScriptingFacade.toggleContinuousTesting$default(this, false, 1, null);
        }
    }

    public final void triggerContinuousTesting() {
        this.log("Trigger Continuous Testing:");
        DataContext dataContext2 = DataManager.getInstance().getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        ScriptingAPI_Actions_BaseKt.executeAction((String)"RiderDotCoverTriggerContinuousTestingAction", (DataContext)dataContext2);
    }

    private static final boolean waitForCoverageTree$lambda$0(RiderDotCoverScriptingFacade this$0) {
        return this$0.isSnapshotExist();
    }

    private static final String waitForCoverageTree$lambda$1(Duration $timeout) {
        return "Coverage tree didn't appear after " + $timeout + " seconds";
    }

    private static final boolean waitForNoCoverageTree$lambda$0(RiderDotCoverScriptingFacade this$0) {
        return !this$0.isSnapshotExist();
    }

    private static final String waitForNoCoverageTree$lambda$1(Duration $timeout) {
        return "Coverage tree hasn't disappeared after " + $timeout + " seconds";
    }

    private static final Unit compareCoverageTreeWithGold$lambda$0(JTree $tree, boolean $withSelection, PrintStream printStream) {
        Intrinsics.checkNotNullParameter((Object)printStream, (String)"printStream");
        ((Appendable)printStream).append(ScriptingAPI_UnitTestingKt.dumpTreeToString($tree, $withSelection)).append('\n');
        return Unit.INSTANCE;
    }

    private static final boolean waitDataSliceTypeFeature$lambda$0(RiderDotCoverScriptingFacade this$0) {
        return (Boolean)com.jetbrains.rd.util.reactive.InterfacesKt.valueOrDefault((IOptProperty)this$0.service.getSolutionCoverageBrowser().isDataSliceTypeAvailable(), (Object)false);
    }

    private static final boolean chooseDataSliceType$lambda$0(RdDotCoverDataSliceType $type, RiderDotCoverScriptingFacade this$0) {
        return $type == com.jetbrains.rd.util.reactive.InterfacesKt.valueOrDefault((IOptProperty)this$0.service.getSolutionCoverageBrowser().getSelectedDataSliceType(), (Object)RdDotCoverDataSliceType.AllTests);
    }

    private static final Unit compareTextWithDotCoverHighlightersWithGold$lambda$0(Editor $editor, RiderDotCoverScriptingFacade this$0, PrintStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        ScriptingApi_HighlightersKt.dumpHighlightersTree($editor, (Function1<? super RangeHighlighter, Boolean>)((Function1)new Function1<RangeHighlighter, Boolean>((Object)this$0){

            public final Boolean invoke(RangeHighlighter p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RiderDotCoverScriptingFacade.access$isDotCoverHighlighter((RiderDotCoverScriptingFacade)this.receiver, p0);
            }
        }), (Function1<? super RangeHighlighter, String>)((Function1)RiderDotCoverScriptingFacade::compareTextWithDotCoverHighlightersWithGold$lambda$0$0), stream);
        return Unit.INSTANCE;
    }

    private static final String compareTextWithDotCoverHighlightersWithGold$lambda$0$0(RangeHighlighter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ScriptingApi_HighlightersKt.printTag(it);
    }

    private static final int compareDotCoverLineHighlightersWithGold$lambda$0(RangeHighlighter f, RangeHighlighter s) {
        Intrinsics.checkNotNull((Object)f);
        TextRange textRange = RangeMarkersKt.getAsTextRange((RangeMarker)((RangeMarker)f));
        Intrinsics.checkNotNull((Object)textRange);
        int n = textRange.getStartOffset();
        Intrinsics.checkNotNull((Object)s);
        TextRange textRange2 = RangeMarkersKt.getAsTextRange((RangeMarker)((RangeMarker)s));
        Intrinsics.checkNotNull((Object)textRange2);
        return Intrinsics.compare((int)n, (int)textRange2.getStartOffset());
    }

    private static final int compareDotCoverLineHighlightersWithGold$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final Unit compareDotCoverLineHighlightersWithGold$lambda$3(TreeSet $tooltips, PrintStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Iterable $this$forEach$iv = $tooltips;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RangeHighlighter it = (RangeHighlighter)element$iv;
            boolean bl = false;
            LineMarkerRenderer lineMarkerRenderer = it.getLineMarkerRenderer();
            Intrinsics.checkNotNull((Object)lineMarkerRenderer, (String)"null cannot be cast to non-null type com.jetbrains.dotCover.ui.lineMarkers.RiderDotCoverActiveLineMarkerRenderer");
            RiderDotCoverActiveLineMarkerRenderer lineMarkerRenderer2 = (RiderDotCoverActiveLineMarkerRenderer)lineMarkerRenderer;
            String string = lineMarkerRenderer2.getTooltipText();
            if (string == null) {
                string = "";
            }
            String tooltipHtmlText = string;
            CharSequence charSequence = tooltipHtmlText;
            Regex regex = new Regex("(<.*?>|\\(.*?\\))");
            String string2 = "";
            String tooltipText = regex.replace(charSequence, string2);
            ((Appendable)stream).append(RangeMarkersKt.getAsTextRange((RangeMarker)((RangeMarker)it)) + ": " + tooltipText).append('\n');
            ((Appendable)stream).append(" Faded: " + lineMarkerRenderer2.getFaded()).append('\n');
            ((Appendable)stream).append(" Shape: " + lineMarkerRenderer2.getMarkerShape()).append('\n');
        }
        return Unit.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean waitForDotCoverHighlighters$lambda$0(RiderDotCoverScriptingFacade this$0, Editor $editor, int $markers, int $fullLine) {
        int n;
        RangeHighlighter p0;
        int count$iv;
        int n2;
        List<RangeHighlighterEx> dotCoverHighlighters = this$0.getDotCoverHighlighters($editor);
        Iterable $this$count$iv = dotCoverHighlighters;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n2 = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                p0 = (RangeHighlighter)element$iv;
                boolean bl = false;
                if (!this$0.isDotCoverMarker(p0) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        if (n2 != $markers) return false;
        $this$count$iv = dotCoverHighlighters;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                p0 = (RangeHighlighter)element$iv;
                boolean bl = false;
                if (!this$0.isDotCoverFullLineHighlighter(p0) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        if (n != $fullLine) return false;
        return true;
    }

    private static final String waitForDotCoverHighlighters$lambda$1(int $markers, int $fullLine, RiderDotCoverScriptingFacade this$0, Editor $editor) {
        return "Expected: " + $markers + " markers, " + $fullLine + " full line\nActual:\n " + CollectionsKt.joinToString$default((Iterable)this$0.getDotCoverHighlighters($editor), (CharSequence)"\n ", null, null, (int)0, null, RiderDotCoverScriptingFacade::waitForDotCoverHighlighters$lambda$1$0, (int)30, null);
    }

    private static final CharSequence waitForDotCoverHighlighters$lambda$1$0(RangeHighlighterEx it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return HighlightersUtilKt.getBackendAttributeIdOrThrow((RangeHighlighter)((RangeHighlighter)it));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean waitForDotCoverHighlightersTestResults$lambda$0(RiderDotCoverScriptingFacade this$0, Editor $editor, int $success, int $failed, int $covered, int $uncovered) {
        int n;
        int n2;
        int n3;
        RangeHighlighter p0;
        int count$iv;
        int n4;
        List<RangeHighlighterEx> dotCoverHighlighters = this$0.getDotCoverHighlighters($editor);
        Iterable $this$count$iv = dotCoverHighlighters;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n4 = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                p0 = (RangeHighlighter)element$iv;
                boolean bl = false;
                if (!this$0.isDotCoverSuccessfulTestMarker(p0) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n4 = count$iv;
        }
        if (n4 != $success) return false;
        $this$count$iv = dotCoverHighlighters;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n3 = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                p0 = (RangeHighlighter)element$iv;
                boolean bl = false;
                if (!this$0.isDotCoverFailedTestMarker(p0) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n3 = count$iv;
        }
        if (n3 != $failed) return false;
        $this$count$iv = dotCoverHighlighters;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n2 = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                p0 = (RangeHighlighter)element$iv;
                boolean bl = false;
                if (!this$0.isDotCoverCoveredTestMarker(p0) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        if (n2 != $covered) return false;
        $this$count$iv = dotCoverHighlighters;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                p0 = (RangeHighlighter)element$iv;
                boolean bl = false;
                if (!this$0.isDotCoverUncoveredTestMarker(p0) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        if (n != $uncovered) return false;
        return true;
    }

    private static final String waitForDotCoverHighlightersTestResults$lambda$1(int $success, int $failed, int $covered, int $uncovered, RiderDotCoverScriptingFacade this$0, Editor $editor) {
        return "Expected: " + $success + " successful, " + $failed + " failed, " + $covered + " covered, " + $uncovered + " uncovered \nActual:\n " + CollectionsKt.joinToString$default((Iterable)this$0.getDotCoverHighlighters($editor), (CharSequence)"\n ", null, null, (int)0, null, RiderDotCoverScriptingFacade::waitForDotCoverHighlightersTestResults$lambda$1$0, (int)30, null);
    }

    private static final CharSequence waitForDotCoverHighlightersTestResults$lambda$1$0(RangeHighlighterEx it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return HighlightersUtilKt.getBackendAttributeIdOrThrow((RangeHighlighter)((RangeHighlighter)it));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean waitForDotCoverMarkersShape$lambda$0(RiderDotCoverScriptingFacade this$0, Editor $editor, int $line, int $zigZag, int $dots) {
        int n;
        int n2;
        RangeHighlighterEx it;
        int count$iv;
        int n3;
        List<RangeHighlighterEx> dotCoverHighlighters = this$0.getDotCoverHighlighters($editor);
        Iterable $this$count$iv = dotCoverHighlighters;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n3 = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (RangeHighlighterEx)element$iv;
                boolean bl = false;
                if (!(this$0.getMarkerShape((RangeHighlighter)it) == RdDotCoverLineMarkerShape.line) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n3 = count$iv;
        }
        if (n3 != $line) return false;
        $this$count$iv = dotCoverHighlighters;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n2 = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (RangeHighlighterEx)element$iv;
                boolean bl = false;
                if (!(this$0.getMarkerShape((RangeHighlighter)it) == RdDotCoverLineMarkerShape.zigZag) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        if (n2 != $zigZag) return false;
        $this$count$iv = dotCoverHighlighters;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (RangeHighlighterEx)element$iv;
                boolean bl = false;
                if (!(this$0.getMarkerShape((RangeHighlighter)it) == RdDotCoverLineMarkerShape.dots) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        if (n != $dots) return false;
        return true;
    }

    private static final String waitForDotCoverMarkersShape$lambda$1(int $line, int $zigZag, int $dots, RiderDotCoverScriptingFacade this$0, Editor $editor) {
        return "Expected: " + $line + " lines, " + $zigZag + " zigZag, " + $dots + " dots\nHighlighters:\n " + CollectionsKt.joinToString$default((Iterable)this$0.getDotCoverHighlighters($editor), (CharSequence)"\n ", null, null, (int)0, null, arg_0 -> RiderDotCoverScriptingFacade.waitForDotCoverMarkersShape$lambda$1$0(this$0, arg_0), (int)30, null);
    }

    private static final CharSequence waitForDotCoverMarkersShape$lambda$1$0(RiderDotCoverScriptingFacade this$0, RangeHighlighterEx it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return HighlightersUtilKt.getBackendAttributeIdOrThrow((RangeHighlighter)((RangeHighlighter)it)) + " " + this$0.getMarkerShape((RangeHighlighter)it);
    }

    private static final boolean waitForDotCoverMarkersFaded$lambda$0(RiderDotCoverScriptingFacade this$0, Editor $editor, int $count) {
        int n;
        Iterable $this$count$iv = this$0.getDotCoverHighlighters($editor);
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                RangeHighlighterEx it = (RangeHighlighterEx)element$iv;
                boolean bl = false;
                if (!this$0.getFaded((RangeHighlighter)it) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n == $count;
    }

    private static final String waitForDotCoverMarkersFaded$lambda$1(int $count, RiderDotCoverScriptingFacade this$0, Editor $editor) {
        return "Expected: " + $count + " faded\nHighlighters:\n " + CollectionsKt.joinToString$default((Iterable)this$0.getDotCoverHighlighters($editor), (CharSequence)"\n ", null, null, (int)0, null, arg_0 -> RiderDotCoverScriptingFacade.waitForDotCoverMarkersFaded$lambda$1$0(this$0, arg_0), (int)30, null);
    }

    private static final CharSequence waitForDotCoverMarkersFaded$lambda$1$0(RiderDotCoverScriptingFacade this$0, RangeHighlighterEx it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return HighlightersUtilKt.getBackendAttributeIdOrThrow((RangeHighlighter)((RangeHighlighter)it)) + " Faded:" + this$0.getFaded((RangeHighlighter)it);
    }

    private static final String waitForTreeCondition$lambda$0(List $predicates, JTree $coverageTree) {
        StringBuilder sb = new StringBuilder().append("Some conditions are false in coverage tree: ").append('\n');
        Iterable $this$forEach$iv = $predicates;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CoverageTreePredicate it = (CoverageTreePredicate)element$iv;
            boolean bl = false;
            if (it.getMessage() == null) continue;
            sb.append(" " + it.getMessage() + " - " + it.test($coverageTree)).append('\n');
        }
        return sb.toString();
    }

    private static final boolean waitForTreeCondition$lambda$2(List $predicates, JTree $coverageTree) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = $predicates;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    CoverageTreePredicate it = (CoverageTreePredicate)element$iv;
                    boolean bl2 = false;
                    if (it.test($coverageTree)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean searchInCoverageTree$lambda$0(RdDotCoverCoverageTreeSearch $treeSearch) {
        return !Intrinsics.areEqual((Object)$treeSearch.getInProgress().getValueOrNull(), (Object)true);
    }

    private static final String searchInCoverageTree$lambda$1() {
        return "Search is still in progress";
    }

    private static final Unit selectCoverageTreeNodesByName$lambda$0(Set $nodeNamesSet, JTree $this$walkCoverageTree, RiderDotCoverCoverageTreeNode node, TreePath path) {
        Intrinsics.checkNotNullParameter((Object)$this$walkCoverageTree, (String)"$this$walkCoverageTree");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if ($nodeNamesSet.contains(node.getPresentableName())) {
            $this$walkCoverageTree.addSelectionPath(path);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$isDotCoverHighlighter(RiderDotCoverScriptingFacade $this, RangeHighlighter highlighter) {
        return $this.isDotCoverHighlighter(highlighter);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/test/scriptingApi/RiderDotCoverScriptingFacade$Companion;", "", "<init>", "()V", "defaultTimeout", "Ljava/time/Duration;", "getDefaultTimeout", "()Ljava/time/Duration;", "intellij.rider.test.framework"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Duration getDefaultTimeout() {
            return defaultTimeout;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/test/scriptingApi/RiderDotCoverScriptingFacade$TargetFramework;", "", "presentation", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getPresentation", "()Ljava/lang/String;", "NET_CORE_APP_31", "NET_50", "NET_60", "NET_80", "intellij.rider.test.framework"})
    public static final class TargetFramework
    extends Enum<TargetFramework> {
        @NotNull
        private final String presentation;
        public static final /* enum */ TargetFramework NET_CORE_APP_31 = new TargetFramework(".NETCoreApp 3.1");
        public static final /* enum */ TargetFramework NET_50 = new TargetFramework(".NET 5.0");
        public static final /* enum */ TargetFramework NET_60 = new TargetFramework(".NET 6.0");
        public static final /* enum */ TargetFramework NET_80 = new TargetFramework(".NET 8.0");
        private static final /* synthetic */ TargetFramework[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private TargetFramework(String presentation) {
            this.presentation = presentation;
        }

        @NotNull
        public final String getPresentation() {
            return this.presentation;
        }

        public static TargetFramework[] values() {
            return (TargetFramework[])$VALUES.clone();
        }

        public static TargetFramework valueOf(String value) {
            return Enum.valueOf(TargetFramework.class, value);
        }

        @NotNull
        public static EnumEntries<TargetFramework> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = targetFrameworkArray = new TargetFramework[]{TargetFramework.NET_CORE_APP_31, TargetFramework.NET_50, TargetFramework.NET_60, TargetFramework.NET_80};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

