/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.impl.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SelfReference
implements PsiReference {
    private final XmlAttributeValue myValue;
    private final PsiElement myTarget;
    private final int myStartOffset;

    public SelfReference(XmlAttribute element, PsiElement target, int startOffset) {
        this.myTarget = target;
        this.myValue = element.getValueElement();
        this.myStartOffset = startOffset;
    }

    SelfReference(XmlAttribute element, PsiElement target) {
        this(element, target, 0);
    }

    @NotNull
    public PsiElement getElement() {
        XmlAttributeValue xmlAttributeValue = this.myValue;
        if (xmlAttributeValue == null) {
            SelfReference.$$$reportNull$$$0(0);
        }
        return xmlAttributeValue;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = TextRange.from((int)(1 + this.myStartOffset), (int)(this.myValue.getTextLength() - (2 + this.myStartOffset)));
        if (textRange == null) {
            SelfReference.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    @Nullable
    public PsiElement resolve() {
        return this.myValue.isValid() ? this.myTarget : null;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myValue.getText();
        if (string == null) {
            SelfReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return this.myValue;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            SelfReference.$$$reportNull$$$0(3);
        }
        return this.myValue;
    }

    public boolean isReferenceTo(PsiElement element) {
        return false;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            SelfReference.$$$reportNull$$$0(4);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }

    public static SelfReference create(XmlAttribute element, PsiElement target) {
        if (element.getValue().contains(":")) {
            return new SelfReference(element, target, element.getValue().indexOf(58) + 1);
        }
        return new SelfReference(element, target);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/impl/references/SelfReference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/impl/references/SelfReference";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

