/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.common.artifact;

import com.microsoft.alm.common.exceptions.MalformedArtifactIDException;
import com.microsoft.alm.common.exceptions.MalformedURIException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class ArtifactID {
    protected static final String VSTFS_PREFIX = "vstfs:///";
    protected static final String URI_SEPARATOR = "/";
    protected static final String URL_ENCODING = "UTF-8";
    protected final String tool;
    protected final String artifactType;
    protected final String toolSpecificId;

    public ArtifactID(String tool, String artifactType, String toolSpecificId) {
        this.tool = tool;
        this.artifactType = artifactType;
        this.toolSpecificId = toolSpecificId;
    }

    public ArtifactID(String uri) {
        String[] parts = ArtifactID.decodeURI(uri);
        if (parts == null) {
            throw new MalformedURIException(String.format("The URI was not able to be decoded: %s", uri));
        }
        this.tool = parts[0];
        this.artifactType = parts[1];
        this.toolSpecificId = parts[2];
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ArtifactID) {
            ArtifactID other = (ArtifactID)obj;
            return (this.tool == null ? other.tool == null : this.tool.equals(other.tool)) && (this.artifactType == null ? other.artifactType == null : this.artifactType.equals(other.artifactType)) && (this.toolSpecificId == null ? other.toolSpecificId == null : this.toolSpecificId.equals(other.toolSpecificId));
        }
        return false;
    }

    public int hashCode() {
        return (this.tool == null ? 0 : this.tool.hashCode()) + (this.artifactType == null ? 0 : this.artifactType.hashCode()) + (this.toolSpecificId == null ? 0 : this.toolSpecificId.hashCode());
    }

    public static void checkURIIsWellFormed(String uri) {
        String[] parts = ArtifactID.decodeURI(uri);
        if (parts == null) {
            throw new MalformedURIException(String.format("The URI was not able to be decoded: %s", uri));
        }
    }

    public String getTool() {
        return this.tool;
    }

    public String getArtifactType() {
        return this.artifactType;
    }

    public String getToolSpecificID() {
        return this.toolSpecificId;
    }

    public String encodeURI() {
        if (!this.isWellFormed()) {
            throw new MalformedArtifactIDException(this);
        }
        StringBuffer uri = new StringBuffer();
        try {
            uri.append(VSTFS_PREFIX);
            uri.append(URLEncoder.encode(this.tool, URL_ENCODING));
            uri.append(URI_SEPARATOR);
            uri.append(URLEncoder.encode(this.artifactType, URL_ENCODING));
            uri.append(URI_SEPARATOR);
            uri.append(URLEncoder.encode(this.toolSpecificId, URL_ENCODING));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return uri.toString();
    }

    public boolean isWellFormed() {
        return ArtifactID.isToolWellFormed(this.tool) && ArtifactID.isArtifactTypeWellFormed(this.artifactType) && ArtifactID.isToolSpecificIDWellFormed(this.toolSpecificId);
    }

    private static boolean isToolSpecificIDWellFormed(String toolSpecificId) {
        return !ArtifactID.isNullOrEmpty(toolSpecificId);
    }

    private static boolean isArtifactTypeWellFormed(String artifactType) {
        if (ArtifactID.isNullOrEmpty(artifactType)) {
            return false;
        }
        return artifactType.indexOf(URI_SEPARATOR) == -1;
    }

    private static boolean isToolWellFormed(String tool) {
        if (ArtifactID.isNullOrEmpty(tool)) {
            return false;
        }
        return tool.indexOf(92) == -1 && tool.indexOf(URI_SEPARATOR) == -1 && tool.indexOf(46) == -1;
    }

    private static boolean isNullOrEmpty(String input) {
        return input == null || input.trim().length() == 0;
    }

    private static String[] decodeURI(String uri) {
        if (uri == null) {
            return null;
        }
        String trimmedInput = uri.trim();
        if (!trimmedInput.startsWith(VSTFS_PREFIX)) {
            return null;
        }
        String inputWithoutPrefix = trimmedInput.substring(VSTFS_PREFIX.length());
        String[] parts = inputWithoutPrefix.split(URI_SEPARATOR);
        if (parts.length != 3) {
            return null;
        }
        String tool = null;
        String artifactType = null;
        String toolSpecificId = null;
        try {
            tool = URLDecoder.decode(parts[0], URL_ENCODING);
            artifactType = URLDecoder.decode(parts[1], URL_ENCODING);
            toolSpecificId = URLDecoder.decode(parts[2], URL_ENCODING);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        if (!(ArtifactID.isToolWellFormed(tool) && ArtifactID.isArtifactTypeWellFormed(artifactType) && ArtifactID.isToolSpecificIDWellFormed(toolSpecificId))) {
            return null;
        }
        return new String[]{tool, artifactType, toolSpecificId};
    }
}

