/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.common.utils;

import com.sun.jna.Platform;

public final class FileHelper {
    public static final boolean[] VALID_NTFS_FILE_NAME_CHAR_TABLE = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, false, true, false, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true};
    private static final String[] RESERVED_NAMES_LENGTH3 = new String[]{"CON", "PRN", "AUX", "NUL"};
    private static final String FORCE_HONOR_CASE_SYSPROP = "com.microsoft.tfs.util.FileHelpers.force-honor-case";
    private static final String FORCE_IGNORE_CASE_SYSPROP = "com.microsoft.tfs.util.FileHelpers.force-ignore-case";
    private static boolean fileSystemIgnoresCase = System.getProperty("com.microsoft.tfs.util.FileHelpers.force-ignore-case") != null ? true : (System.getProperty("com.microsoft.tfs.util.FileHelpers.force-honor-case") != null ? false : Platform.isWindows() || Platform.isMac());

    public static boolean doesFileSystemIgnoreCase() {
        return fileSystemIgnoresCase;
    }

    public static boolean isReservedName(String name) {
        String firstThree;
        if (name.length() == 4 && Character.isDigit(name.charAt(3)) && name.charAt(3) != '0' && ((firstThree = name.substring(0, 3)).equalsIgnoreCase("LPT") || firstThree.equalsIgnoreCase("COM"))) {
            return true;
        }
        if (name.length() == 3) {
            for (int i = 0; i < RESERVED_NAMES_LENGTH3.length; ++i) {
                if (!name.equalsIgnoreCase(RESERVED_NAMES_LENGTH3[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isValidNTFSFileNameCharacter(char c) {
        if (c > '\u007f') {
            return true;
        }
        return VALID_NTFS_FILE_NAME_CHAR_TABLE[c];
    }
}

