/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.css.CssIdSelector;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.less.psi.LESSMixin;
import org.jetbrains.plugins.less.psi.LESSVariableDeclaration;

public class LESSUtil {
    private static final InsertHandler<LookupElement> INSERT_COLON_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(InsertionContext context, LookupElement lookupElement) {
            Editor editor = context.getEditor();
            if (context.getCompletionChar() == ':') {
                context.setAddCompletionChar(false);
            }
            if (!LESSUtil.isStringAtCaret(editor, ":")) {
                LESSUtil.insertStringAtCaret(editor, context.getProject(), ": ");
                editor.getCaretModel().moveCaretRelatively(0, 0, false, false, true);
            } else if (LESSUtil.isStringAtCaret(editor, ": ")) {
                editor.getCaretModel().moveCaretRelatively(2, 0, false, false, true);
            } else {
                editor.getCaretModel().moveCaretRelatively(1, 0, false, false, true);
            }
        }
    };
    private static final int IMPORTED_ELEMENT_PRIORITY = 1;
    private static final int MIXIN_PRIORITY = 5;
    private static final int VARIABLE_PRIORITY = 8;
    private static final int NAMED_PARAMETER_PRIORITY = 12;
    private static final int ARGUMENTS_PRIORITY = 25;

    public static boolean isMixinMatchesWithInvocation(@NotNull LESSMixin mixin, @Nullable PsiElement invocation, String invocationNamespace) {
        PsiFile parent;
        if (mixin == null) {
            LESSUtil.$$$reportNull$$$0(0);
        }
        if (invocation == null) {
            return false;
        }
        Object object = parent = mixin.getContainingFile() == invocation.getContainingFile() ? PsiTreeUtil.findCommonParent((PsiElement)invocation, (PsiElement)mixin) : mixin.getContainingFile();
        while (parent != null) {
            String namespace = mixin.getNamespaceInContext((PsiElement)parent);
            if (namespace != null && namespace.equalsIgnoreCase(invocationNamespace)) {
                return true;
            }
            parent = PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{PsiFile.class, CssRuleset.class, LESSMixin.class});
        }
        return false;
    }

    @NotNull
    public static String getNamespaceForSelector(@Nullable CssSelector selector, CssSelectorSuffix currentSuffix) {
        if (selector != null) {
            int untilIndex = currentSuffix.getTextRange().getStartOffset() - selector.getTextRange().getStartOffset();
            String text = selector.getText();
            String cssSelectorText = text.length() > untilIndex ? text.substring(0, untilIndex) : text;
            int lastIndexOfGT = cssSelectorText.lastIndexOf(62);
            if (lastIndexOfGT > -1) {
                String string = cssSelectorText.substring(0, lastIndexOfGT).trim().replaceAll(" ", "");
                if (string == null) {
                    LESSUtil.$$$reportNull$$$0(1);
                }
                return string;
            }
        }
        if ("" == null) {
            LESSUtil.$$$reportNull$$$0(2);
        }
        return "";
    }

    @NotNull
    public static String getSelectorPrefix(CssSelectorSuffix cssSelectorSuffix) {
        String string = cssSelectorSuffix instanceof CssIdSelector ? "#" : ".";
        if (string == null) {
            LESSUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static LookupElement createMixinLookupItem(LESSMixin mixin, boolean validResult) {
        ItemPresentation itemPresentation = mixin.getPresentation();
        String tailText = validResult ? mixin.getParametersString() : mixin.getParametersString() + " implicitly imported";
        int priority = validResult ? 6 : 5;
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.createWithSmartPointer((String)mixin.getName(), (PsiElement)mixin).withIcon(itemPresentation.getIcon(false)).withBoldness(validResult).withTailText(tailText, true).withInsertHandler((InsertHandler)(mixin.hasParameters() ? ParenthesesInsertHandler.WITH_PARAMETERS : null)).withTypeText(itemPresentation.getLocationString(), true), (double)priority);
        if (lookupElement == null) {
            LESSUtil.$$$reportNull$$$0(4);
        }
        return lookupElement;
    }

    @NotNull
    public static LookupElement createVariableLookupItem(LESSVariableDeclaration declaration, boolean validResult) {
        ItemPresentation itemPresentation = declaration.getPresentation();
        String tailText = validResult ? "" : " implicitly imported";
        int priority = validResult ? 9 : 8;
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.createWithSmartPointer((String)declaration.getName(), (PsiElement)declaration).withIcon(itemPresentation.getIcon(false)).withBoldness(validResult).withTailText(tailText, true).withTypeText(itemPresentation.getLocationString(), true), (double)priority);
        if (lookupElement == null) {
            LESSUtil.$$$reportNull$$$0(5);
        }
        return lookupElement;
    }

    @NotNull
    public static LookupElement createNamedParameterLookupItem(@NotNull LESSVariableDeclaration declaration, @NotNull LESSMixin argumentOwner, boolean validResult) {
        if (declaration == null) {
            LESSUtil.$$$reportNull$$$0(6);
        }
        if (argumentOwner == null) {
            LESSUtil.$$$reportNull$$$0(7);
        }
        ItemPresentation itemPresentation = declaration.getPresentation();
        String tailText = validResult ? "" : " implicitly imported";
        int priority = validResult ? 13 : 12;
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.createWithIcon((PsiNamedElement)declaration).withIcon(AllIcons.Nodes.Parameter).withInsertHandler(INSERT_COLON_INSERT_HANDLER).withBoldness(validResult).withTailText(tailText, true).withTypeText(argumentOwner.getName() + argumentOwner.getParametersString() + " " + itemPresentation.getLocationString(), true), (double)priority);
        if (lookupElement == null) {
            LESSUtil.$$$reportNull$$$0(8);
        }
        return lookupElement;
    }

    @NotNull
    public static LookupElement createArgumentsLookupItem(LESSMixin mixin) {
        ItemPresentation mixinPresentation = mixin.getPresentation();
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)"arguments").withIcon(AllIcons.Nodes.Variable).withTailText(" from mixin '" + mixin.getName() + "'", true).withBoldness(true).withTypeText(mixinPresentation.getLocationString(), true), (double)25.0);
        if (lookupElement == null) {
            LESSUtil.$$$reportNull$$$0(9);
        }
        return lookupElement;
    }

    public static boolean isStringAtCaret(@NotNull Editor editor, @NotNull String string) {
        if (editor == null) {
            LESSUtil.$$$reportNull$$$0(10);
        }
        if (string == null) {
            LESSUtil.$$$reportNull$$$0(11);
        }
        int startOffset = editor.getCaretModel().getOffset();
        String fileText = editor.getDocument().getText();
        if (fileText.length() < startOffset + string.length()) {
            return false;
        }
        return fileText.substring(startOffset, startOffset + string.length()).equals(string);
    }

    public static void insertStringAtCaret(@NotNull Editor editor, Project project, String string) {
        if (editor == null) {
            LESSUtil.$$$reportNull$$$0(12);
        }
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)string);
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mixin";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/less/LESSUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentOwner";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/less/LESSUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceForSelector";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectorPrefix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createMixinLookupItem";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createVariableLookupItem";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createNamedParameterLookupItem";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createArgumentsLookupItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isMixinMatchesWithInvocation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createNamedParameterLookupItem";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isStringAtCaret";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "insertStringAtCaret";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

