/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.completion.provider;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.less.psi.impl.LessImportType;

public class LessImportTypeCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static final InsertHandler<LookupElement> OUR_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(InsertionContext context, LookupElement item) {
            Editor editor = context.getEditor();
            Project project = context.getProject();
            if (LessImportTypeCompletionProvider.moveCaretOnChar(editor, ',')) {
                LessImportTypeCompletionProvider.typeCharOrMoveCaret(editor, project, ' ');
            }
        }
    };

    private static void typeCharOrMoveCaret(@NotNull Editor editor, @NotNull Project project, char c) {
        if (editor == null) {
            LessImportTypeCompletionProvider.$$$reportNull$$$0(0);
        }
        if (project == null) {
            LessImportTypeCompletionProvider.$$$reportNull$$$0(1);
        }
        if (!LessImportTypeCompletionProvider.isCharAtCaret(editor, c)) {
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)String.valueOf(c));
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        } else {
            editor.getCaretModel().moveToOffset(editor.getCaretModel().getOffset() + 1);
        }
    }

    private static boolean moveCaretOnChar(@NotNull Editor editor, char c) {
        if (editor == null) {
            LessImportTypeCompletionProvider.$$$reportNull$$$0(2);
        }
        if (LessImportTypeCompletionProvider.isCharAtCaret(editor, c)) {
            editor.getCaretModel().moveToOffset(editor.getCaretModel().getOffset() + 1);
            return true;
        }
        return false;
    }

    private static boolean isCharAtCaret(@NotNull Editor editor, char c) {
        if (editor == null) {
            LessImportTypeCompletionProvider.$$$reportNull$$$0(3);
        }
        int startOffset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        return document.getTextLength() > startOffset && document.getCharsSequence().charAt(startOffset) == c;
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            LessImportTypeCompletionProvider.$$$reportNull$$$0(4);
        }
        if (result == null) {
            LessImportTypeCompletionProvider.$$$reportNull$$$0(5);
        }
        for (String importType : LessImportType.KNOWN_IMPORT_TYPES) {
            result.addElement((LookupElement)LookupElementBuilder.create((String)importType).withInsertHandler(OUR_INSERT_HANDLER));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/less/completion/provider/LessImportTypeCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "typeCharOrMoveCaret";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "moveCaretOnChar";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isCharAtCaret";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

