/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.helpers;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;

public class Guid {
    public static final UUID Empty = UUID.fromString("00000000-0000-0000-0000-000000000000");

    public static UUID fromBytes(byte[] b) {
        ByteBuffer source = ByteBuffer.wrap(b);
        ByteBuffer target = ByteBuffer.allocate(16).order(ByteOrder.LITTLE_ENDIAN).putInt(source.getInt()).putShort(source.getShort()).putShort(source.getShort()).order(ByteOrder.BIG_ENDIAN).putLong(source.getLong());
        target.rewind();
        return new UUID(target.getLong(), target.getLong());
    }

    public static byte[] toBytes(UUID value) {
        ByteBuffer bytes = ByteBuffer.allocate(16);
        long mostSignificantBits = value.getMostSignificantBits();
        int upperMsb = (int)(mostSignificantBits >> 32);
        bytes.putInt(Integer.reverseBytes(upperMsb));
        int lowerMsb = (int)(mostSignificantBits & 0xFFFFFFFFFFFFFFFFL);
        short firstLowerMsb = (short)(lowerMsb >> 16);
        bytes.putShort(Short.reverseBytes(firstLowerMsb));
        short secondLowerMsb = (short)(lowerMsb & 0xFFFF);
        bytes.putShort(Short.reverseBytes(secondLowerMsb));
        bytes.putLong(value.getLeastSignificantBits());
        return bytes.array();
    }

    public static boolean tryParse(String input, AtomicReference<UUID> result) {
        if (input == null) {
            return false;
        }
        try {
            result.set(UUID.fromString(input));
            return true;
        }
        catch (IllegalArgumentException ignored) {
            return false;
        }
    }
}

