/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.dockerFile;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerRunConfigurationCreator;
import com.intellij.docker.deploymentSource.DockerFileDeploymentSourceType;
import com.intellij.docker.deploymentSource.DockerSingletonDeploymentSourceType;
import com.intellij.docker.dockerFile.DockerPsiFile;
import com.intellij.docker.dockerFile.parser.psi.DockerPsiCommand;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.plugins.docker.dockerFile.lexer.DockerTokenTypes;
import com.intellij.plugins.docker.dockerFile.parser.psi.DockerFileFromCommand;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import icons.DockerIcons;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerFileRunLineMarkerProvider
implements LineMarkerProvider {
    @Nullable
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement psi) {
        ASTNode node;
        if (psi == null) {
            DockerFileRunLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if ((node = psi.getNode()) == null) {
            return null;
        }
        if (node.getElementType() != DockerTokenTypes.FROM) {
            return null;
        }
        if (!(psi.getContainingFile() instanceof DockerPsiFile)) {
            return null;
        }
        DockerPsiCommand command = (DockerPsiCommand)PsiTreeUtil.getParentOfType((PsiElement)psi, DockerPsiCommand.class);
        if (command == null || DockerFileRunLineMarkerProvider.findPreviousFromCommand(command) != null) {
            return null;
        }
        final DockerPsiFile dockerFile = (DockerPsiFile)psi.getContainingFile();
        return new LineMarkerInfo<PsiElement>(psi, psi.getTextRange(), AllIcons.RunConfigurations.TestState.Run_run, 11, DockerFileRunLineMarkerProvider::computeTooltip, null, GutterIconRenderer.Alignment.CENTER){

            @NotNull
            public GutterIconRenderer createGutterRenderer() {
                LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement> lineMarkerGutterIconRenderer = new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>((LineMarkerInfo)this){

                    public AnAction getClickAction() {
                        return null;
                    }

                    public boolean isNavigateAction() {
                        return true;
                    }

                    @Nullable
                    public ActionGroup getPopupMenuActions() {
                        return DockerFileRunLineMarkerProvider.computePopup(dockerFile);
                    }
                };
                if (lineMarkerGutterIconRenderer == null) {
                    1.$$$reportNull$$$0(0);
                }
                return lineMarkerGutterIconRenderer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/dockerFile/DockerFileRunLineMarkerProvider$1", "createGutterRenderer"));
            }
        };
    }

    @Nullable
    private static DockerFileFromCommand findPreviousFromCommand(@NotNull DockerPsiCommand command) {
        if (command == null) {
            DockerFileRunLineMarkerProvider.$$$reportNull$$$0(1);
        }
        for (PsiElement cur = command.getPrevSibling(); cur != null; cur = cur.getPrevSibling()) {
            if (!(cur instanceof DockerFileFromCommand)) continue;
            return (DockerFileFromCommand)cur;
        }
        return null;
    }

    private static ActionGroup computePopup(@NotNull DockerPsiFile dockerFile) {
        if (dockerFile == null) {
            DockerFileRunLineMarkerProvider.$$$reportNull$$$0(2);
        }
        Project project = dockerFile.getProject();
        DockerRunConfigurationCreator helper = new DockerRunConfigurationCreator(project);
        VirtualFile sourceFile = dockerFile.getVirtualFile();
        assert (sourceFile != null) : "no virtual file for psi file : " + (Object)((Object)dockerFile);
        List<DockerRunConfig> foundConfigs = DockerRunConfig.dockerConfigsFor((PsiFile)dockerFile, DockerFileDeploymentSourceType.getInstance());
        LinkedList<AnAction> knownsGroup = new LinkedList<AnAction>();
        for (DockerRunConfig nextFound : foundConfigs) {
            knownsGroup.add(new RunExistingRunConfig(helper, nextFound));
            knownsGroup.add(new BuildExistingRunConfig(helper, nextFound));
            knownsGroup.add(new EditExistingRunConfig(helper, nextFound));
        }
        Set foundServerNames = foundConfigs.stream().map(dockerRC -> dockerRC.getConfig().getServerName()).filter(Objects::nonNull).collect(Collectors.toSet());
        LinkedList<AnAction> unknownsGroup = new LinkedList<AnAction>();
        List<RemoteServer<DockerCloudConfiguration>> allAccounts = DockerFileRunLineMarkerProvider.listAllDockerAccounts();
        if (allAccounts.isEmpty()) {
            unknownsGroup.add(new ConfigureAutoDetectedRunConfig(helper, sourceFile));
        } else {
            for (RemoteServer<DockerCloudConfiguration> nextDocker : allAccounts) {
                if (foundServerNames.contains(nextDocker.getName())) continue;
                unknownsGroup.add(new FireAsTemporaryRunConfigAction(helper, sourceFile, nextDocker, false));
                unknownsGroup.add(new FireAsTemporaryRunConfigAction(helper, sourceFile, nextDocker, true));
            }
        }
        if (knownsGroup.isEmpty() && unknownsGroup.isEmpty()) {
            return null;
        }
        return DockerFileRunLineMarkerProvider.createPopup(knownsGroup, unknownsGroup);
    }

    private static ActionGroup createPopup(List<AnAction> existingRunConfigsActions, List<AnAction> newRunConfigActions) {
        DefaultActionGroup result = new DefaultActionGroup();
        for (AnAction next : existingRunConfigsActions) {
            result.addAction(next);
        }
        if (!existingRunConfigsActions.isEmpty() || !newRunConfigActions.isEmpty()) {
            result.addAction((AnAction)new Separator());
        }
        for (AnAction next : newRunConfigActions) {
            result.addAction(next);
        }
        return result;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            DockerFileRunLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (result == null) {
            DockerFileRunLineMarkerProvider.$$$reportNull$$$0(4);
        }
    }

    private static List<RemoteServer<DockerCloudConfiguration>> listAllDockerAccounts() {
        return RemoteServersManager.getInstance().getServers((ServerType)DockerCloudType.getInstance());
    }

    private static String computeTooltip(@NotNull PsiElement from) {
        if (from == null) {
            DockerFileRunLineMarkerProvider.$$$reportNull$$$0(5);
        }
        return DockerBundle.getText((String)"DockerFileRunLineMarkerProvider.tooltip", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/dockerFile/DockerFileRunLineMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineMarkerInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findPreviousFromCommand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "computePopup";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "collectSlowLineMarkers";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "computeTooltip";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DockerRunConfig {
        private final RunnerAndConfigurationSettings mySettings;
        private final DeployToServerRunConfiguration<DockerCloudConfiguration, DockerDeploymentConfiguration> myConfig;

        @Nullable
        public static DockerRunConfig wrapIfDocker(@NotNull RunnerAndConfigurationSettings settings) {
            if (settings == null) {
                DockerRunConfig.$$$reportNull$$$0(0);
            }
            if (!(settings.getConfiguration() instanceof DeployToServerRunConfiguration)) {
                return null;
            }
            DeployToServerRunConfiguration config = (DeployToServerRunConfiguration)settings.getConfiguration();
            if (config.getServerType() != DockerCloudType.getInstance()) {
                return null;
            }
            return new DockerRunConfig(settings, config);
        }

        @NotNull
        public static List<DockerRunConfig> dockerConfigsFor(@NotNull PsiFile psiFile, @NotNull DeploymentSourceType<?> expectedType) {
            if (psiFile == null) {
                DockerRunConfig.$$$reportNull$$$0(1);
            }
            if (expectedType == null) {
                DockerRunConfig.$$$reportNull$$$0(2);
            }
            RunManager runManager = RunManager.getInstance((Project)psiFile.getProject());
            List<DockerRunConfig> list = runManager.getAllSettings().stream().map(DockerRunConfig::wrapIfDocker).filter(Objects::nonNull).filter(wrapper -> {
                if (expectedType == null) {
                    DockerRunConfig.$$$reportNull$$$0(10);
                }
                return wrapper.hasDeploymentSourceOfType(expectedType);
            }).filter(wrapper -> {
                if (psiFile == null) {
                    DockerRunConfig.$$$reportNull$$$0(9);
                }
                return wrapper.isForVirtualFile(psiFile.getVirtualFile());
            }).collect(Collectors.toList());
            if (list == null) {
                DockerRunConfig.$$$reportNull$$$0(3);
            }
            return list;
        }

        private DockerRunConfig(@NotNull RunnerAndConfigurationSettings settings, @NotNull DeployToServerRunConfiguration<?, ?> config) {
            if (settings == null) {
                DockerRunConfig.$$$reportNull$$$0(4);
            }
            if (config == null) {
                DockerRunConfig.$$$reportNull$$$0(5);
            }
            this.mySettings = settings;
            this.myConfig = config;
        }

        @NotNull
        public RunnerAndConfigurationSettings getSettings() {
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.mySettings;
            if (runnerAndConfigurationSettings == null) {
                DockerRunConfig.$$$reportNull$$$0(6);
            }
            return runnerAndConfigurationSettings;
        }

        @NotNull
        public DeployToServerRunConfiguration<DockerCloudConfiguration, DockerDeploymentConfiguration> getConfig() {
            DeployToServerRunConfiguration<DockerCloudConfiguration, DockerDeploymentConfiguration> deployToServerRunConfiguration = this.myConfig;
            if (deployToServerRunConfiguration == null) {
                DockerRunConfig.$$$reportNull$$$0(7);
            }
            return deployToServerRunConfiguration;
        }

        public void setBuildOnly(boolean buildOnly) {
            ((DockerDeploymentConfiguration)this.getConfig().getDeploymentConfiguration()).setBuildOnly(buildOnly);
        }

        public boolean hasDeploymentSourceOfType(@NotNull DeploymentSourceType<?> expectedType) {
            if (expectedType == null) {
                DockerRunConfig.$$$reportNull$$$0(8);
            }
            return Optional.ofNullable(this.myConfig.getDeploymentSource()).map(DeploymentSource::getType).map(expectedType::equals).orElse(false);
        }

        public boolean isForVirtualFile(@Nullable VirtualFile file) {
            return file != null && DockerDeploymentConfiguration.ProjectAwareHelper.isForSameFile((Project)this.myConfig.getProject(), (DockerDeploymentConfiguration)((DockerDeploymentConfiguration)this.myConfig.getDeploymentConfiguration()), (VirtualFile)file);
        }

        public String getRunConfigName() {
            return this.mySettings.getName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 2: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expectedType";
                    break;
                }
                case 3: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/dockerFile/DockerFileRunLineMarkerProvider$DockerRunConfig";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/dockerFile/DockerFileRunLineMarkerProvider$DockerRunConfig";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "dockerConfigsFor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSettings";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfig";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "wrapIfDocker";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "dockerConfigsFor";
                    break;
                }
                case 3: 
                case 6: 
                case 7: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "hasDeploymentSourceOfType";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$dockerConfigsFor$1";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$dockerConfigsFor$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class FireAsTemporaryRunConfigAction
    extends RunConfigActionBase {
        @NotNull
        private final VirtualFile mySourceFile;
        @NotNull
        private final RemoteServer<DockerCloudConfiguration> myDocker;
        private final boolean myBuildOnly;

        public FireAsTemporaryRunConfigAction(@NotNull DockerRunConfigurationCreator helper, @NotNull VirtualFile sourceFile, @NotNull RemoteServer<DockerCloudConfiguration> docker, boolean buildOnly) {
            if (helper == null) {
                FireAsTemporaryRunConfigAction.$$$reportNull$$$0(0);
            }
            if (sourceFile == null) {
                FireAsTemporaryRunConfigAction.$$$reportNull$$$0(1);
            }
            if (docker == null) {
                FireAsTemporaryRunConfigAction.$$$reportNull$$$0(2);
            }
            super(helper);
            this.mySourceFile = sourceFile;
            this.myDocker = docker;
            this.myBuildOnly = buildOnly;
            String text = buildOnly ? DockerBundle.getText((String)"DockerFileRunLineMarkerProvider.BuildAsTemporaryRunConfig.text", (Object[])new Object[]{docker.getName()}) : DockerBundle.getText((String)"DockerFileRunLineMarkerProvider.RunAsTemporaryRunConfig.text", (Object[])new Object[]{docker.getName()});
            this.getTemplatePresentation().setText(text);
            this.getTemplatePresentation().setIcon(this.myBuildOnly ? null : DockerIcons.Docker);
        }

        public void actionPerformed(AnActionEvent e) {
            RunnerAndConfigurationSettings runConfig = this.getHelper().createConfiguration((DockerSingletonDeploymentSourceType)DockerFileDeploymentSourceType.getInstance(), this.mySourceFile, this.myDocker);
            DockerRunConfig dockerRunConfig = DockerRunConfig.wrapIfDocker(runConfig);
            assert (dockerRunConfig != null);
            dockerRunConfig.setBuildOnly(this.myBuildOnly);
            this.getHelper().rememberConfiguration(runConfig);
            this.getHelper().executeConfiguration(runConfig);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sourceFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "docker";
                    break;
                }
            }
            objectArray[1] = "com/intellij/docker/dockerFile/DockerFileRunLineMarkerProvider$FireAsTemporaryRunConfigAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ConfigureAutoDetectedRunConfig
    extends RunConfigActionBase {
        private final VirtualFile mySourceFile;

        public ConfigureAutoDetectedRunConfig(@NotNull DockerRunConfigurationCreator helper, @NotNull VirtualFile sourceFile) {
            if (helper == null) {
                ConfigureAutoDetectedRunConfig.$$$reportNull$$$0(0);
            }
            if (sourceFile == null) {
                ConfigureAutoDetectedRunConfig.$$$reportNull$$$0(1);
            }
            super(helper);
            this.mySourceFile = sourceFile;
            this.getTemplatePresentation().setText(DockerBundle.getText((String)"DockerFileRunLineMarkerProvider.ConfigureAutoDetectedRunConfig.text", (Object[])new Object[0]));
            this.getTemplatePresentation().setIcon(DockerIcons.Docker);
        }

        public void actionPerformed(AnActionEvent e) {
            RunnerAndConfigurationSettings runConfig = this.getHelper().createConfiguration((DockerSingletonDeploymentSourceType)DockerFileDeploymentSourceType.getInstance(), this.mySourceFile, null);
            this.getHelper().rememberConfiguration(runConfig);
            this.getHelper().openForEditingAndExecute(runConfig, DockerBundle.getText((String)"DockerFileRunLineMarkerProvider.ConfigureAutoDetectedRunConfig.dialogTitle", (Object[])new Object[0]));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sourceFile";
                    break;
                }
            }
            objectArray[1] = "com/intellij/docker/dockerFile/DockerFileRunLineMarkerProvider$ConfigureAutoDetectedRunConfig";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class EditExistingRunConfig
    extends RunConfigActionBase {
        @NotNull
        private final DockerRunConfig myWrapper;

        public EditExistingRunConfig(@NotNull DockerRunConfigurationCreator helper, @NotNull DockerRunConfig wrapper) {
            if (helper == null) {
                EditExistingRunConfig.$$$reportNull$$$0(0);
            }
            if (wrapper == null) {
                EditExistingRunConfig.$$$reportNull$$$0(1);
            }
            super(helper);
            this.myWrapper = wrapper;
            this.getTemplatePresentation().setText(DockerBundle.getText((String)"DockerFileRunLineMarkerProvider.EditExistingRunConfig.text", (Object[])new Object[]{this.myWrapper.getRunConfigName()}));
            this.getTemplatePresentation().setIcon(AllIcons.Actions.EditSource);
        }

        public void actionPerformed(AnActionEvent e) {
            this.getHelper().openForEditingAndExecute(this.myWrapper.getSettings(), DockerBundle.getText((String)"DockerFileRunLineMarkerProvider.EditExistingRunConfig.dialogTitle", (Object[])new Object[0]));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "wrapper";
                    break;
                }
            }
            objectArray[1] = "com/intellij/docker/dockerFile/DockerFileRunLineMarkerProvider$EditExistingRunConfig";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class BuildExistingRunConfig
    extends RunConfigActionBase {
        @NotNull
        private final DockerRunConfig myWrapper;

        public BuildExistingRunConfig(@NotNull DockerRunConfigurationCreator helper, @NotNull DockerRunConfig wrapper) {
            if (helper == null) {
                BuildExistingRunConfig.$$$reportNull$$$0(0);
            }
            if (wrapper == null) {
                BuildExistingRunConfig.$$$reportNull$$$0(1);
            }
            super(helper);
            this.myWrapper = wrapper;
            this.getTemplatePresentation().setText(DockerBundle.getText((String)"DockerFileRunLineMarkerProvider.BuildExistingRunConfig.text", (Object[])new Object[]{this.myWrapper.getRunConfigName()}));
        }

        public void actionPerformed(AnActionEvent e) {
            this.myWrapper.setBuildOnly(true);
            this.getHelper().executeConfiguration(this.myWrapper.getSettings());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "wrapper";
                    break;
                }
            }
            objectArray[1] = "com/intellij/docker/dockerFile/DockerFileRunLineMarkerProvider$BuildExistingRunConfig";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class RunExistingRunConfig
    extends RunConfigActionBase {
        @NotNull
        private final DockerRunConfig myWrapper;

        public RunExistingRunConfig(@NotNull DockerRunConfigurationCreator helper, @NotNull DockerRunConfig wrapper) {
            if (helper == null) {
                RunExistingRunConfig.$$$reportNull$$$0(0);
            }
            if (wrapper == null) {
                RunExistingRunConfig.$$$reportNull$$$0(1);
            }
            super(helper);
            this.myWrapper = wrapper;
            this.getTemplatePresentation().setText(DockerBundle.getText((String)"DockerFileRunLineMarkerProvider.RunExistingRunConfig.text", (Object[])new Object[]{this.myWrapper.getRunConfigName()}));
            this.getTemplatePresentation().setIcon(AllIcons.RunConfigurations.TestState.Run);
        }

        public void actionPerformed(AnActionEvent e) {
            this.myWrapper.setBuildOnly(false);
            this.getHelper().executeConfiguration(this.myWrapper.getSettings());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "wrapper";
                    break;
                }
            }
            objectArray[1] = "com/intellij/docker/dockerFile/DockerFileRunLineMarkerProvider$RunExistingRunConfig";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class RunConfigActionBase
    extends AnAction {
        private final DockerRunConfigurationCreator myHelper;

        public RunConfigActionBase(@NotNull DockerRunConfigurationCreator helper) {
            if (helper == null) {
                RunConfigActionBase.$$$reportNull$$$0(0);
            }
            this.myHelper = helper;
        }

        @NotNull
        protected DockerRunConfigurationCreator getHelper() {
            DockerRunConfigurationCreator dockerRunConfigurationCreator = this.myHelper;
            if (dockerRunConfigurationCreator == null) {
                RunConfigActionBase.$$$reportNull$$$0(1);
            }
            return dockerRunConfigurationCreator;
        }

        @NotNull
        protected Project getProject() {
            Project project = this.myHelper.getProject();
            if (project == null) {
                RunConfigActionBase.$$$reportNull$$$0(2);
            }
            return project;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/dockerFile/DockerFileRunLineMarkerProvider$RunConfigActionBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/dockerFile/DockerFileRunLineMarkerProvider$RunConfigActionBase";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHelper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

