/*
 * Decompiled with CFR 0.152.
 */
package testng_listener_teamcity_service_messages.jetbrains.buildServer.agent.ideaRunner;

import java.io.PrintStream;
import java.util.Date;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.agent.TestOutputLogger;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.agent.impl.TestOutputCollector;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.DefaultServiceMessageVisitor;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.MessageWithAttributes;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.TestFinished;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.TestStarted;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.TestStdErr;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.TestStdOut;

public class ServiceMessageReporter {
    private final PrintStream myOs;
    private final TestOutputCollector myOutCollector;
    private final TestOutputCollector myErrCollector;
    private final String myFlowId = System.getenv().get("TEAMCITY_PROCESS_FLOW_ID");

    public ServiceMessageReporter(PrintStream os, PrintStream err) {
        this.myOs = os;
        TestOutputLogger testOutputLogger = new TestOutputLogger(){

            public void testStdOut(String testName, String flowId, String output) {
                TestStdOut testStdOut = new TestStdOut(testName, output);
                testStdOut.addTag("tc:parseServiceMessagesInside");
                ServiceMessageReporter.this.reportTestMessage(testStdOut);
            }

            public void testStdErr(String testName, String flowId, String error) {
                TestStdErr testStdErr = new TestStdErr(testName, error);
                testStdErr.addTag("tc:parseServiceMessagesInside");
                ServiceMessageReporter.this.reportTestMessage(testStdErr);
            }
        };
        this.myOutCollector = new TestOutputCollector(testOutputLogger, os, true);
        this.myErrCollector = new TestOutputCollector(testOutputLogger, err, false);
    }

    public void reportTestMessage(MessageWithAttributes message) {
        message.setTimestamp(new Date());
        this.report(message);
    }

    public void report(ServiceMessage message) {
        final boolean[] processed = new boolean[1];
        if (this.myFlowId != null) {
            message.setFlowId(this.myFlowId);
        }
        message.visit(new DefaultServiceMessageVisitor(){

            public void visitTestStarted(TestStarted testStarted) {
                ServiceMessageReporter.this.myOs.println(testStarted.asString());
                ServiceMessageReporter.this.myOutCollector.testStarted(testStarted.getTestName(), testStarted.getFlowId());
                ServiceMessageReporter.this.myErrCollector.testStarted(testStarted.getTestName(), testStarted.getFlowId());
                processed[0] = true;
            }

            public void visitTestFinished(TestFinished testFinished) {
                ServiceMessageReporter.this.myOutCollector.testFinished();
                ServiceMessageReporter.this.myErrCollector.testFinished();
                ServiceMessageReporter.this.myOs.println(testFinished.asString());
                processed[0] = true;
            }
        });
        if (!processed[0]) {
            this.myOs.println(message.asString());
            this.myOs.flush();
        }
    }
}

