/*
 * Decompiled with CFR 0.152.
 */
package testng_listener_teamcity_service_messages.jetbrains.buildServer.agent.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.agent.TestOutputLogger;

public class TestOutputCollector
implements Serializable {
    private final PrintStream myPrintStream;
    private final PrintStream mySavedStream;
    private final Stack mySavedStreams = new Stack();
    private final boolean myIsOutput;
    private final Map myThreadToTest = new HashMap();
    private final TestOutputLogger myLogger;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection tests() {
        Map map = this.myThreadToTest;
        synchronized (map) {
            return new ArrayList(this.myThreadToTest.values());
        }
    }

    public TestOutputCollector(TestOutputLogger logger, PrintStream savedStream, boolean isOutput) {
        this.myLogger = logger;
        this.myPrintStream = new SpecialPrintStream();
        this.mySavedStream = savedStream;
        this.myIsOutput = isOutput;
    }

    public PrintStream getSavedStreamOrPop() {
        if (this.mySavedStreams.isEmpty()) {
            return this.mySavedStream;
        }
        if (!$assertionsDisabled && this.mySavedStreams.peek().equals(this.mySavedStream)) {
            throw new AssertionError();
        }
        return (PrintStream)this.mySavedStreams.pop();
    }

    private PrintStream getLastNonDefaultSavedStream() {
        if (this.mySavedStreams.isEmpty()) {
            return null;
        }
        if (!$assertionsDisabled && this.mySavedStreams.peek().equals(this.mySavedStream)) {
            throw new AssertionError();
        }
        return (PrintStream)this.mySavedStreams.peek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStarted(String testName, String flowId) {
        Map map = this.myThreadToTest;
        synchronized (map) {
            this.myThreadToTest.put(Thread.currentThread(), new TestOutput(testName, flowId));
        }
        if (this.myIsOutput) {
            PrintStream out = System.out;
            out.flush();
            if (!out.getClass().getName().equals(SpecialPrintStream.class.getName())) {
                if (!out.equals(this.mySavedStream)) {
                    this.mySavedStreams.push(out);
                }
                System.setOut(this.myPrintStream);
            }
        } else {
            PrintStream err = System.err;
            err.flush();
            if (!err.getClass().getName().equals(SpecialPrintStream.class.getName())) {
                if (!err.equals(this.mySavedStream)) {
                    this.mySavedStreams.push(err);
                }
                System.setErr(this.myPrintStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFinished() {
        try {
            TestOutput currentTest = this.getCurrentTestOutput();
            if (currentTest != null) {
                System.out.flush();
                System.err.flush();
                this.myPrintStream.flush();
                currentTest.flushIfNeeded(true);
            }
        }
        finally {
            Map map = this.myThreadToTest;
            synchronized (map) {
                this.myThreadToTest.remove(Thread.currentThread());
            }
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void reset() {
        Map map = this.myThreadToTest;
        synchronized (map) {
            if (this.myThreadToTest.isEmpty()) {
                if (this.myIsOutput) {
                    System.setOut(this.getSavedStreamOrPop());
                } else {
                    System.setErr(this.getSavedStreamOrPop());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestOutput getCurrentTestOutput() {
        Map map = this.myThreadToTest;
        synchronized (map) {
            return (TestOutput)this.myThreadToTest.get(Thread.currentThread());
        }
    }

    static {
        $assertionsDisabled = !TestOutputCollector.class.desiredAssertionStatus();
    }

    private class SpecialOutputStream
    extends OutputStream {
        private SpecialOutputStream() {
        }

        public void write(int b) throws IOException {
            Iterator iterator = TestOutputCollector.this.tests().iterator();
            while (iterator.hasNext()) {
                TestOutput testOutput = (TestOutput)iterator.next();
                testOutput.write(b);
            }
            PrintStream stream = TestOutputCollector.this.getLastNonDefaultSavedStream();
            if (stream != null) {
                stream.write(b);
            }
        }

        public void write(byte[] b) throws IOException {
            Iterator iterator = TestOutputCollector.this.tests().iterator();
            while (iterator.hasNext()) {
                TestOutput testOutput = (TestOutput)iterator.next();
                testOutput.write(b);
            }
            PrintStream stream = TestOutputCollector.this.getLastNonDefaultSavedStream();
            if (stream != null) {
                stream.write(b);
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            Iterator iterator = TestOutputCollector.this.tests().iterator();
            while (iterator.hasNext()) {
                TestOutput testOutput = (TestOutput)iterator.next();
                testOutput.write(b, off, len);
            }
            PrintStream stream = TestOutputCollector.this.getLastNonDefaultSavedStream();
            if (stream != null) {
                stream.write(b, off, len);
            }
        }

        public void flush() throws IOException {
            Iterator iterator = TestOutputCollector.this.tests().iterator();
            while (iterator.hasNext()) {
                TestOutput testOutput = (TestOutput)iterator.next();
                testOutput.flush();
            }
            PrintStream stream = TestOutputCollector.this.getLastNonDefaultSavedStream();
            if (stream != null) {
                stream.flush();
            }
        }
    }

    private class SpecialPrintStream
    extends PrintStream {
        public SpecialPrintStream() {
            super(new SpecialOutputStream());
        }
    }

    private class TestOutput
    extends OutputStream {
        private final String myTestName;
        private final ByteArrayOutputStream myStream;
        private final String myFlowId;

        private TestOutput(String testName, String flowId) {
            this.myTestName = testName;
            this.myFlowId = flowId;
            this.myStream = new ByteArrayOutputStream(){

                public synchronized void reset() {
                    if (this.count > 1024) {
                        this.buf = new byte[1024];
                    }
                    super.reset();
                }
            };
        }

        public synchronized void write(int b) throws IOException {
            this.myStream.write(b);
            this.flushIfNeeded(false);
        }

        public synchronized void write(byte[] b) throws IOException {
            this.myStream.write(b);
            this.flushIfNeeded(false);
        }

        public synchronized void write(byte[] b, int off, int len) throws IOException {
            this.myStream.write(b, off, len);
            this.flushIfNeeded(false);
        }

        public void flush() throws IOException {
            this.flushIfNeeded(true);
        }

        public synchronized void flushIfNeeded(boolean force) {
            if (this.myStream.size() > 1024 || force && this.myStream.size() > 0) {
                String out = this.myStream.toString();
                this.myStream.reset();
                if (TestOutputCollector.this.myIsOutput) {
                    TestOutputCollector.this.myLogger.testStdOut(this.myTestName, this.myFlowId, out);
                } else {
                    TestOutputCollector.this.myLogger.testStdErr(this.myTestName, this.myFlowId, out);
                }
            }
        }
    }
}

